/*
 * Decompiled with CFR 0.152.
 */
package com.khorn.terraincontrol.util.minecraftTypes;

import java.util.HashMap;
import java.util.Map;

public enum MobNames {
    BAT("Bat", "bat"),
    BLAZE("Blaze", "blaze"),
    CAVESPIDER("CaveSpider", "cavespider"),
    CHICKEN("Chicken", "chicken"),
    COW("Cow", "cow"),
    CREEPER("Creeper", "creeper"),
    ENTITYHORSE("EntityHorse", "horse"),
    ENDERDRAGON("EnderDragon", "enderdragon"),
    ENDERMAN("Enderman", "enderman"),
    ENDERMITE("Endermite", "endermite"),
    GHAST("Ghast", "ghast"),
    GIANT("Giant", "giant", "giantzombie", "zombiegiant"),
    GUARDIAN("Guardian", "guardian"),
    LAVASLIME("LavaSlime", "magmaslime", "lavaslime", "magmacube"),
    MUSHROOMCOW("MushroomCow", "mushroomcow", "mooshroom"),
    OZELOT("Ozelot", "ozelot", "ocelot"),
    PIG("Pig", "pig"),
    PIGZOMBIE("PigZombie", "pigzombie", "zombiepigman"),
    POLARBEAR("PolarBear", "polarbear"),
    RABBIT("Rabbit", "rabbit"),
    SHEEP("Sheep", "sheep"),
    SHULKER("Shulker", "shulker"),
    SILVERFISH("Silverfish", "silverfish"),
    SKELETON("Skeleton", "skeleton"),
    SLIME("Slime", "slime"),
    SNOWMAN("SnowMan", "snowman"),
    SPIDER("Spider", "spider"),
    SQUID("Squid", "squid"),
    VILLAGER("Villager", "villager"),
    VILLAGERGOLEM("VillagerGolem", "villagergolem", "irongolem"),
    WITCH("Witch", "witch"),
    WITHERBOSS("WitherBoss", "witherboss", "wither"),
    WOLF("Wolf", "wolf"),
    ZOMBIE("Zombie", "zombie");

    private static Map<String, String> mobAliases;
    private String[] aliases;
    private String internalMinecraftName;

    public static String toInternalName(String alias) {
        for (String key : mobAliases.keySet()) {
            if (!key.toLowerCase().trim().replace("entity", "").replace("_", "").equals(alias.toLowerCase().trim().replace("entity", "").replace("_", ""))) continue;
            return mobAliases.get(key);
        }
        return alias;
    }

    private static void register(String internalMinecraftName, String ... aliases) {
        for (String alias : aliases) {
            mobAliases.put(alias, internalMinecraftName);
        }
    }

    private MobNames(String internalMinecraftName, String ... aliases) {
        this.internalMinecraftName = internalMinecraftName;
        this.aliases = aliases;
    }

    public String getInternalName() {
        return this.internalMinecraftName;
    }

    static {
        mobAliases = new HashMap<String, String>();
        for (MobNames alt : MobNames.values()) {
            MobNames.register(alt.internalMinecraftName, alt.aliases);
        }
    }
}

