/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg;

public class BiomeIds {
    private final int generationId;
    private final int savedId;

    public BiomeIds(int id) {
        this.generationId = id;
        this.savedId = id;
    }

    public BiomeIds(int generationId, int savedId) {
        this.generationId = generationId;
        this.savedId = savedId;
    }

    public boolean isVirtual() {
        return this.savedId != this.generationId && this.generationId > 255;
    }

    public int getSavedId() {
        return this.savedId;
    }

    public int getGenerationId() {
        return this.generationId;
    }

    public String toString() {
        if (this.isVirtual()) {
            return this.generationId + " (gen), " + this.savedId + " (saved)";
        }
        return Integer.toString(this.savedId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.savedId;
        result = 31 * result + this.generationId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BiomeIds)) {
            return false;
        }
        BiomeIds other = (BiomeIds)obj;
        if (this.savedId != other.savedId) {
            return false;
        }
        return this.generationId == other.generationId;
    }
}

