/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.BiomeIds;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.bukkit.OTGBiomeBase;
import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.configuration.BiomeConfig;
import net.minecraft.server.v1_11_R1.BiomeBase;
import net.minecraft.server.v1_11_R1.BlockPosition;

public class BukkitBiome
implements LocalBiome {
    private final BiomeBase biomeBase;
    private final boolean isCustom;
    private final BiomeIds biomeIds;
    private final BiomeConfig biomeConfig;

    public static BukkitBiome forVanillaBiome(BiomeConfig biomeConfig, BiomeBase biome) {
        return new BukkitBiome(biomeConfig, biome);
    }

    public static BukkitBiome forCustomBiome(BiomeConfig biomeConfig, BiomeIds biomeIds) {
        return new BukkitBiome(biomeConfig, OTGBiomeBase.createInstance(biomeConfig, biomeIds));
    }

    protected BukkitBiome(BiomeConfig biomeConfig, BiomeBase biome) {
        this.biomeBase = biome;
        int savedBiomeId = BiomeBase.a((BiomeBase)this.biomeBase);
        this.biomeIds = new BiomeIds(WorldHelper.getGenerationId(this.biomeBase), savedBiomeId);
        this.biomeConfig = biomeConfig;
        this.isCustom = biome instanceof OTGBiomeBase;
    }

    @Override
    public boolean isCustom() {
        return this.isCustom;
    }

    public BiomeBase getHandle() {
        return this.biomeBase;
    }

    @Override
    public String getName() {
        return this.biomeConfig.getName();
    }

    @Override
    public BiomeIds getIds() {
        return this.biomeIds;
    }

    @Override
    public float getTemperatureAt(int x, int y, int z) {
        return this.biomeBase.a(new BlockPosition(x, y, z));
    }

    @Override
    public BiomeConfig getBiomeConfig() {
        return this.biomeConfig;
    }

    public String toString() {
        return this.getName();
    }
}

