/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.BiomeIds;
import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.BukkitMaterialData;
import com.pg85.otg.bukkit.util.EnumHelper;
import com.pg85.otg.bukkit.util.MobSpawnGroupHelper;
import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.WeightedMobSpawnGroup;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.helpers.StringHelper;
import java.util.List;
import net.minecraft.server.v1_11_R1.BiomeBase;
import net.minecraft.server.v1_11_R1.MinecraftKey;
import org.bukkit.block.Biome;

public class OTGBiomeBase
extends BiomeBase {
    private static final int MAX_TC_BIOME_ID = 1023;
    public final int generationId;

    public static OTGBiomeBase createInstance(BiomeConfig biomeConfig, BiomeIds biomeIds) {
        OTGBiomeBase customBiome = new OTGBiomeBase(biomeConfig, biomeIds);
        String biomeNameWithoutSpaces = StringHelper.toComputerFriendlyName(biomeConfig.getName());
        MinecraftKey biomeKey = new MinecraftKey("OpenTerrainGenerator", biomeNameWithoutSpaces);
        int savedBiomeId = biomeIds.getSavedId();
        if (BiomeBase.getBiome((int)1023) == null) {
            BiomeBase.REGISTRY_ID.a(1023, (Object)new MinecraftKey("OpenTerrainGenerator", "null"), (Object)new OTGBiomeBase(biomeConfig, new BiomeIds(1023, 1023)));
        }
        if (biomeIds.isVirtual()) {
            BiomeBase existingBiome = BiomeBase.getBiome((int)savedBiomeId);
            if (existingBiome == null) {
                BiomeBase.REGISTRY_ID.a(savedBiomeId, (Object)biomeKey, (Object)customBiome);
                OTG.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
            } else {
                MinecraftKey existingBiomeKey = (MinecraftKey)BiomeBase.REGISTRY_ID.b((Object)existingBiome);
                BiomeBase.REGISTRY_ID.a(savedBiomeId, (Object)biomeKey, (Object)customBiome);
                BiomeBase.REGISTRY_ID.a(savedBiomeId, (Object)existingBiomeKey, (Object)existingBiome);
                OTG.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
            }
        } else {
            BiomeBase.REGISTRY_ID.a(savedBiomeId, (Object)biomeKey, (Object)customBiome);
            OTG.log(LogMarker.TRACE, ",{},{},{}", biomeConfig.getName(), savedBiomeId, biomeIds.getGenerationId());
        }
        try {
            Biome.valueOf((String)biomeNameWithoutSpaces.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            EnumHelper.addEnum(Biome.class, biomeNameWithoutSpaces.toUpperCase(), new Class[0], new Object[0]);
        }
        int registeredSavedId = WorldHelper.getSavedId(customBiome);
        if (registeredSavedId != savedBiomeId) {
            throw new AssertionError((Object)("Biome " + biomeConfig.getName() + " is not properly registered: got id " + registeredSavedId + ", should be " + savedBiomeId));
        }
        OTGBiomeBase.checkRegistry();
        return customBiome;
    }

    private static void checkRegistry() {
        for (int i = 168; i >= 0; --i) {
            BiomeBase biome = OTGBiomeBase.getBiome((int)i);
            if (biome != null && biome instanceof OTGBiomeBase && ((OTGBiomeBase)biome).generationId != i) {
                throw new AssertionError((Object)("Biome ID #" + i + " returns custom biome #" + ((OTGBiomeBase)biome).generationId + " instead of its own."));
            }
        }
    }

    private OTGBiomeBase(BiomeConfig biomeConfig, BiomeIds biomeIds) {
        super((BiomeBase.a)new BiomeBase_a(biomeConfig.getName(), biomeConfig));
        this.generationId = biomeIds.getGenerationId();
        if (this.getHumidity() != biomeConfig.biomeWetness) {
            throw new AssertionError((Object)"Biome temperature mismatch");
        }
        this.r = ((BukkitMaterialData)biomeConfig.surfaceBlock).internalBlock();
        this.s = ((BukkitMaterialData)biomeConfig.groundBlock).internalBlock();
        this.addMobs(this.u, biomeConfig.spawnMonsters);
        this.addMobs(this.v, biomeConfig.spawnCreatures);
        this.addMobs(this.w, biomeConfig.spawnWaterCreatures);
        this.addMobs(this.x, biomeConfig.spawnAmbientCreatures);
    }

    protected void addMobs(List<BiomeBase.BiomeMeta> internalList, List<WeightedMobSpawnGroup> configList) {
        internalList.clear();
        internalList.addAll(MobSpawnGroupHelper.toMinecraftlist(configList));
    }

    private static class BiomeBase_a
    extends BiomeBase.a {
        public BiomeBase_a(String name, BiomeConfig biomeConfig) {
            super(name);
            float adjustedTemperature = biomeConfig.biomeTemperature;
            if ((double)adjustedTemperature >= 0.1 && (double)adjustedTemperature <= 0.2) {
                adjustedTemperature = (double)adjustedTemperature >= 1.5 ? 0.2f : 0.1f;
            }
            this.c(biomeConfig.biomeHeight);
            this.d(biomeConfig.biomeVolatility);
            this.a(adjustedTemperature);
            this.b(biomeConfig.biomeWetness);
            if ((double)biomeConfig.biomeWetness <= 1.0E-4) {
                this.a();
            }
            if (biomeConfig.biomeTemperature <= 0.15f) {
                this.b();
            }
        }
    }
}

