/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.BukkitEngine;
import com.pg85.otg.bukkit.BukkitWorld;
import com.pg85.otg.bukkit.commands.OTGCommandExecutor;
import com.pg85.otg.bukkit.events.OTGListener;
import com.pg85.otg.bukkit.generator.BukkitVanillaBiomeGenerator;
import com.pg85.otg.bukkit.generator.OTGChunkGenerator;
import com.pg85.otg.bukkit.generator.structures.OTGRareBuildingGen;
import com.pg85.otg.bukkit.generator.structures.OTGVillageGen;
import com.pg85.otg.bukkit.metrics.BukkitMetricsHelper;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.logging.LogMarker;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.server.v1_11_R1.WorldGenFactory;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class OTGPlugin
extends JavaPlugin {
    public OTGListener listener;
    public OTGCommandExecutor commandExecutor;
    public boolean cleanupOnDisable = false;
    public final HashMap<String, BukkitWorld> worlds = new HashMap();
    private final HashMap<String, BukkitWorld> notInitedWorlds = new HashMap();

    public void onDisable() {
        if (this.cleanupOnDisable) {
            for (BukkitWorld world : this.worlds.values()) {
                world.disable();
            }
            this.worlds.clear();
            OTG.stopEngine();
        }
    }

    public void onEnable() {
        OTG.setEngine(new BukkitEngine(this));
        if (!Bukkit.getWorlds().isEmpty() && !this.cleanupOnDisable) {
            OTG.log(LogMarker.FATAL, Arrays.asList("The server was just /reloaded! Open Terrain Generator has problems handling this, ", "as old parts from before the reload have not been cleaned up. ", "Unexpected things may happen! Please restart the server! ", "In the future, instead of /reloading, please restart the server, ", "or reload a plugin using it's built-in command (like /otg reload), ", "or use a plugin managing plugin that can reload one plugin at a time."));
            this.setEnabled(false);
        } else {
            OTG.getBiomeModeManager().register("Default", BukkitVanillaBiomeGenerator.class);
            try {
                Method registerStructure = WorldGenFactory.class.getDeclaredMethod("b", Class.class, String.class);
                registerStructure.setAccessible(true);
                registerStructure.invoke(null, OTGRareBuildingGen.RareBuildingStart.class, "OTGTemple");
                registerStructure.invoke(null, OTGVillageGen.VillageStart.class, "OTGVillage");
            }
            catch (Exception e) {
                OTG.log(LogMarker.FATAL, "Failed to register structures:", new Object[0]);
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
            this.commandExecutor = new OTGCommandExecutor(this);
            this.listener = new OTGListener(this);
            Bukkit.getMessenger().registerOutgoingPluginChannel((Plugin)this, "OpenTerrainGenerator");
            OTG.log(LogMarker.INFO, "Global objects loaded, waiting for worlds to load", new Object[0]);
            new BukkitMetricsHelper(this);
        }
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        return this.commandExecutor.onCommand(sender, command, label, args);
    }

    public ChunkGenerator getDefaultWorldGenerator(String worldName, String id) {
        if (worldName.isEmpty()) {
            OTG.log(LogMarker.TRACE, "Ignoring empty world name. Is some generator plugin checking if \"OpenTerrainGenerator\" is a valid world name?", new Object[0]);
            return new OTGChunkGenerator(this);
        }
        BukkitWorld world = this.worlds.get(worldName);
        if (world != null) {
            OTG.log(LogMarker.TRACE, "Already enabled for ''{}''", worldName);
            return world.getChunkGenerator();
        }
        OTG.log(LogMarker.TRACE, "Starting to enable world ''{}''...", worldName);
        BukkitWorld localWorld = new BukkitWorld(worldName);
        File baseFolder = this.getWorldSettingsFolder(worldName);
        ServerConfigProvider configs = new ServerConfigProvider(baseFolder, localWorld);
        localWorld.setSettings(configs);
        this.notInitedWorlds.put(worldName, localWorld);
        OTGChunkGenerator generator = null;
        switch (configs.getWorldConfig().ModeTerrain) {
            case Normal: 
            case TerrainTest: 
            case OldGenerator: 
            case NotGenerate: {
                generator = new OTGChunkGenerator(this);
                break;
            }
        }
        localWorld.setChunkGenerator(generator);
        return generator;
    }

    public File getWorldSettingsFolder(String worldName) {
        File baseFolder = new File(this.getDataFolder(), "worlds" + File.separator + worldName);
        if (!baseFolder.exists() && !baseFolder.mkdirs()) {
            OTG.log(LogMarker.FATAL, "Can't create folder ", baseFolder.getName());
        }
        return baseFolder;
    }

    public void onWorldInit(World world) {
        if (this.notInitedWorlds.containsKey(world.getName())) {
            BukkitWorld bukkitWorld = this.notInitedWorlds.remove(world.getName());
            bukkitWorld.enable(world);
            this.worlds.put(world.getName(), bukkitWorld);
            OTG.log(LogMarker.INFO, "World {} is now enabled!", bukkitWorld.getName());
        }
    }

    public void onWorldUnload(World world) {
        if (this.notInitedWorlds.containsKey(world.getName())) {
            this.notInitedWorlds.remove(world.getName());
        }
        if (this.worlds.containsKey(world.getName())) {
            this.worlds.get(world.getName()).disable();
            this.worlds.remove(world.getName());
        }
        OTG.log(LogMarker.INFO, "World {} is now unloaded!", world.getName());
    }
}

