/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.commands;

import com.pg85.otg.bukkit.OTGPlugin;
import com.pg85.otg.bukkit.commands.BaseCommand;
import com.pg85.otg.bukkit.commands.BiomeCommand;
import com.pg85.otg.bukkit.commands.CheckCommand;
import com.pg85.otg.bukkit.commands.HelpCommand;
import com.pg85.otg.bukkit.commands.MapCommand;
import com.pg85.otg.bukkit.commands.ReloadCommand;
import com.pg85.otg.bukkit.commands.SpawnCommand;
import com.pg85.otg.bukkit.commands.TPCommand;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;

public class OTGCommandExecutor
implements CommandExecutor {
    protected final OTGPlugin plugin;
    protected HashMap<String, BaseCommand> commandHashMap = new HashMap();
    protected HelpCommand helpCommand;

    public OTGCommandExecutor(OTGPlugin plugin) {
        this.plugin = plugin;
        this.helpCommand = new HelpCommand(plugin);
        this.RegisterCommands();
    }

    public boolean onCommand(CommandSender commandSender, Command command, String s, String[] strings) {
        ArrayList<String> arg = new ArrayList<String>(Arrays.asList(strings));
        BaseCommand cmd = this.helpCommand;
        if (!arg.isEmpty() && this.commandHashMap.containsKey(arg.get(0))) {
            cmd = this.commandHashMap.get(arg.get(0));
            arg.remove(0);
        }
        if (!commandSender.hasPermission(cmd.perm)) {
            commandSender.sendMessage(ChatColor.RED.toString() + "You don't have permission to " + cmd.getHelp() + "!");
            return true;
        }
        return cmd.onCommand(commandSender, arg);
    }

    private void RegisterCommands() {
        this.AddCommand(new ReloadCommand(this.plugin));
        this.AddCommand(new CheckCommand(this.plugin));
        this.AddCommand(new TPCommand(this.plugin));
        this.AddCommand(new BiomeCommand(this.plugin));
        this.AddCommand(new SpawnCommand(this.plugin));
        this.AddCommand(new MapCommand(this.plugin));
        this.AddCommand(this.helpCommand);
    }

    private void AddCommand(BaseCommand command) {
        this.commandHashMap.put(command.name, command);
    }
}

