/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator;

import com.google.common.base.Preconditions;
import com.pg85.otg.bukkit.BukkitWorld;
import com.pg85.otg.bukkit.generator.OTGChunkGenerator;
import com.pg85.otg.configuration.WorldConfig;
import java.util.List;
import net.minecraft.server.v1_11_R1.BiomeBase;
import net.minecraft.server.v1_11_R1.BlockPosition;
import net.minecraft.server.v1_11_R1.EnumCreatureType;
import net.minecraft.server.v1_11_R1.World;
import org.bukkit.craftbukkit.v1_11_R1.generator.CustomChunkGenerator;
import org.bukkit.generator.ChunkGenerator;

public class OTGInternalChunkGenerator
extends CustomChunkGenerator {
    private final BukkitWorld localWorld;

    public OTGInternalChunkGenerator(BukkitWorld world, ChunkGenerator generator) {
        super(world.getWorld(), world.getSeed(), generator);
        Preconditions.checkArgument((boolean)(generator instanceof OTGChunkGenerator), (Object)"Generator must be of the plugin");
        this.localWorld = world;
    }

    public List<BiomeBase.BiomeMeta> getMobsFor(EnumCreatureType type, BlockPosition position) {
        WorldConfig worldConfig = this.localWorld.getConfigs().getWorldConfig();
        BiomeBase biomebase = this.localWorld.getWorld().getBiome(position);
        if (type == EnumCreatureType.MONSTER && worldConfig.rareBuildingsEnabled && this.localWorld.rareBuildingGen.isWitchHutAt(position)) {
            return this.localWorld.rareBuildingGen.getWitchHutMobs();
        }
        if (type == EnumCreatureType.MONSTER && worldConfig.oceanMonumentsEnabled && this.localWorld.oceanMonumentGen.a(this.localWorld.getWorld(), position)) {
            return this.localWorld.oceanMonumentGen.getMobs();
        }
        return biomebase.getMobs(type);
    }

    public BlockPosition findNearestMapFeature(World mcWorld, String type, BlockPosition position, boolean bool) {
        WorldConfig worldConfig = this.localWorld.getConfigs().getWorldConfig();
        if (type.equals("Mansion")) {
            if (worldConfig.woodLandMansionsEnabled) {
                return this.localWorld.mansionGen.getNearestGeneratedFeature(mcWorld, position, bool);
            }
        } else if (type.equals("Mineshaft")) {
            if (worldConfig.mineshaftsEnabled) {
                return this.localWorld.mineshaftGen.getNearestGeneratedFeature(mcWorld, position, bool);
            }
        } else if (type.equals("Fortress")) {
            if (worldConfig.netherFortressesEnabled) {
                return this.localWorld.netherFortressGen.getNearestGeneratedFeature(mcWorld, position, bool);
            }
        } else if (type.equals("Monument")) {
            if (worldConfig.oceanMonumentsEnabled) {
                return this.localWorld.oceanMonumentGen.getNearestGeneratedFeature(mcWorld, position, bool);
            }
        } else if (type.equals("OTGTemple")) {
            if (worldConfig.rareBuildingsEnabled) {
                return this.localWorld.rareBuildingGen.getNearestGeneratedFeature(mcWorld, position, bool);
            }
        } else if (type.equals("Stronghold")) {
            if (worldConfig.strongholdsEnabled) {
                return this.localWorld.strongholdGen.getNearestGeneratedFeature(mcWorld, position, bool);
            }
        } else if (type.equals("OTGVillage") && worldConfig.villagesEnabled) {
            return this.localWorld.villageGen.getNearestGeneratedFeature(mcWorld, position, bool);
        }
        return null;
    }
}

