/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator.structures;

import com.google.common.base.Preconditions;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.bukkit.BukkitWorld;
import com.pg85.otg.generator.SpawnableObject;
import com.pg85.otg.util.Rotation;
import java.util.Random;
import net.minecraft.server.v1_11_R1.BlockPosition;
import net.minecraft.server.v1_11_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_11_R1.DefinedStructure;
import net.minecraft.server.v1_11_R1.DefinedStructureInfo;
import net.minecraft.server.v1_11_R1.EnumBlockRotation;
import net.minecraft.server.v1_11_R1.World;

public final class MojangStructurePart
implements SpawnableObject {
    private final DefinedStructure spawnObject;
    private final String name;

    public MojangStructurePart(String name, DefinedStructure spawnObject) {
        Preconditions.checkNotNull((Object)name, (Object)"name");
        Preconditions.checkNotNull((Object)spawnObject, (Object)"spawnObject");
        this.name = name;
        this.spawnObject = spawnObject;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        World worldMc = ((BukkitWorld)world).getWorld();
        BlockPosition blockPos = new BlockPosition(x, y, z);
        EnumBlockRotation rotationMc = this.toMinecraftRotation(rotation);
        DefinedStructureInfo spawnSettings = new DefinedStructureInfo().a(rotationMc).a(new ChunkCoordIntPair(blockPos)).a(random);
        this.spawnObject.a(worldMc, blockPos, spawnSettings, 4);
        return true;
    }

    private EnumBlockRotation toMinecraftRotation(Rotation rotation) {
        switch (rotation) {
            case EAST: {
                return EnumBlockRotation.CLOCKWISE_90;
            }
            case NORTH: {
                return EnumBlockRotation.NONE;
            }
            case SOUTH: {
                return EnumBlockRotation.CLOCKWISE_180;
            }
            case WEST: {
                return EnumBlockRotation.COUNTERCLOCKWISE_90;
            }
        }
        throw new IllegalArgumentException("Unknown rotation: " + (Object)((Object)rotation));
    }

    @Override
    public String getName() {
        return this.name;
    }
}

