/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit.generator.structures;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.bukkit.BukkitBiome;
import com.pg85.otg.bukkit.util.WorldHelper;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.logging.LogMarker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.v1_11_R1.BiomeBase;
import net.minecraft.server.v1_11_R1.BlockPosition;
import net.minecraft.server.v1_11_R1.NBTTagCompound;
import net.minecraft.server.v1_11_R1.StructureGenerator;
import net.minecraft.server.v1_11_R1.StructurePiece;
import net.minecraft.server.v1_11_R1.StructureStart;
import net.minecraft.server.v1_11_R1.World;
import net.minecraft.server.v1_11_R1.WorldGenVillagePieces;

public class OTGVillageGen
extends StructureGenerator {
    public List<BiomeBase> villageSpawnBiomes;
    private int size;
    private int distance;
    private int minimumDistance;

    public OTGVillageGen(ServerConfigProvider configs) {
        this.size = configs.getWorldConfig().villageSize;
        this.distance = configs.getWorldConfig().villageDistance;
        this.minimumDistance = 8;
        this.villageSpawnBiomes = new ArrayList<BiomeBase>();
        for (LocalBiome biome : configs.getBiomeArray()) {
            if (biome == null || biome.getBiomeConfig().villageType == BiomeConfig.VillageType.disabled) continue;
            this.villageSpawnBiomes.add(((BukkitBiome)biome).getHandle());
        }
    }

    public BlockPosition getNearestGeneratedFeature(World world, BlockPosition blockposition, boolean flag) {
        this.g = world;
        return OTGVillageGen.a((World)world, (StructureGenerator)this, (BlockPosition)blockposition, (int)this.distance, (int)this.minimumDistance, (int)10387312, (boolean)false, (int)100, (boolean)flag);
    }

    protected boolean a(int chunkX, int chunkZ) {
        boolean flag;
        int k = chunkX;
        int l = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.distance - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.distance - 1;
        }
        int i1 = chunkX / this.distance;
        int j1 = chunkZ / this.distance;
        Random random = this.g.a(i1, j1, 10387312);
        i1 *= this.distance;
        j1 *= this.distance;
        return k == (i1 += random.nextInt(this.distance - this.minimumDistance)) && l == (j1 += random.nextInt(this.distance - this.minimumDistance)) && (flag = this.g.getWorldChunkManager().a(k * 16 + 8, l * 16 + 8, 0, this.villageSpawnBiomes));
    }

    protected StructureStart b(int chunkX, int chunkZ) {
        return new VillageStart(this.g, this.f, chunkX, chunkZ, this.size);
    }

    public String a() {
        return "OTGVillage";
    }

    public static class VillageStart
    extends StructureStart {
        private boolean hasMoreThanTwoComponents = false;

        public VillageStart(World world, Random random, int chunkX, int chunkZ, int size) {
            int componentCount;
            List villagePieces = WorldGenVillagePieces.a((Random)random, (int)size);
            int startX = (chunkX << 4) + 2;
            int startZ = (chunkZ << 4) + 2;
            WorldGenVillagePieces.WorldGenVillageStartPiece startPiece = new WorldGenVillagePieces.WorldGenVillageStartPiece(world.getWorldChunkManager(), 0, random, startX, startZ, villagePieces, size);
            LocalWorld worldTC = WorldHelper.toLocalWorld(world);
            LocalBiome biome = worldTC.getBiome(startX, startZ);
            if (biome != null) {
                this.changeVillageType(startPiece, biome.getBiomeConfig().villageType == BiomeConfig.VillageType.wood ? 0 : (biome.getBiomeConfig().villageType == BiomeConfig.VillageType.sandstone ? 1 : (biome.getBiomeConfig().villageType == BiomeConfig.VillageType.savanna ? 2 : (biome.getBiomeConfig().villageType == BiomeConfig.VillageType.taiga ? 3 : 0))));
            }
            this.a.add(startPiece);
            startPiece.a((StructurePiece)startPiece, this.a, random);
            List arraylist1 = startPiece.f;
            List arraylist2 = startPiece.e;
            while (!arraylist1.isEmpty() || !arraylist2.isEmpty()) {
                StructurePiece structurepiece;
                if (arraylist1.isEmpty()) {
                    componentCount = random.nextInt(arraylist2.size());
                    structurepiece = (StructurePiece)arraylist2.remove(componentCount);
                    structurepiece.a((StructurePiece)startPiece, this.a, random);
                    continue;
                }
                componentCount = random.nextInt(arraylist1.size());
                structurepiece = (StructurePiece)arraylist1.remove(componentCount);
                structurepiece.a((StructurePiece)startPiece, this.a, random);
            }
            this.d();
            componentCount = 0;
            for (Object anA : this.a) {
                StructurePiece structurepiece1 = (StructurePiece)anA;
                if (structurepiece1 instanceof WorldGenVillagePieces.WorldGenVillageRoadPiece) continue;
                ++componentCount;
            }
            this.hasMoreThanTwoComponents = componentCount > 2;
        }

        public VillageStart() {
        }

        private void changeVillageType(WorldGenVillagePieces.WorldGenVillageStartPiece subject, int villageType) {
            Class villageClass = WorldGenVillagePieces.WorldGenVillageStartPiece.class.getSuperclass().getSuperclass();
            for (Field field : villageClass.getDeclaredFields()) {
                String fieldName = field.getName();
                if (!fieldName.equals("structureType") && !fieldName.equals("h")) continue;
                try {
                    field.setAccessible(true);
                    field.setInt(subject, villageType);
                    break;
                }
                catch (Exception e) {
                    OTG.log(LogMarker.FATAL, "Cannot make village a sandstone village!", new Object[0]);
                    OTG.printStackTrace(LogMarker.FATAL, e);
                }
            }
        }

        public boolean a() {
            return this.hasMoreThanTwoComponents;
        }

        public void a(NBTTagCompound nbttagcompound) {
            super.a(nbttagcompound);
            nbttagcompound.setBoolean("Valid", this.hasMoreThanTwoComponents);
        }

        public void b(NBTTagCompound nbttagcompound) {
            super.b(nbttagcompound);
            this.hasMoreThanTwoComponents = nbttagcompound.getBoolean("Valid");
        }
    }
}

