/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.configuration.standard.StandardBiomeTemplate;

public class BiomeLoadInstruction {
    private final String name;
    private final int generationId;
    private final StandardBiomeTemplate biomeTemplate;

    public BiomeLoadInstruction(String name, int generationId, StandardBiomeTemplate biomeTemplate) {
        if (name == null || biomeTemplate == null) {
            throw new IllegalArgumentException("Parameters cannot be null (name: " + name + ", generationId: " + generationId + ",biomeTemplate: " + biomeTemplate + ")");
        }
        this.name = name;
        this.generationId = generationId;
        this.biomeTemplate = biomeTemplate;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.biomeTemplate.hashCode();
        result = 31 * result + this.generationId;
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BiomeLoadInstruction)) {
            return false;
        }
        BiomeLoadInstruction other = (BiomeLoadInstruction)obj;
        if (!this.biomeTemplate.equals(other.biomeTemplate)) {
            return false;
        }
        if (this.generationId != other.generationId) {
            return false;
        }
        return this.name.equals(other.name);
    }

    public String getBiomeName() {
        return this.name;
    }

    public StandardBiomeTemplate getBiomeTemplate() {
        return this.biomeTemplate;
    }

    public int getGenerationId() {
        return this.generationId;
    }
}

