/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.configuration.BiomeGroup;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.ErroredFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.AboveWaterGen;
import com.pg85.otg.generator.resource.BoulderGen;
import com.pg85.otg.generator.resource.CactusGen;
import com.pg85.otg.generator.resource.CustomObjectGen;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.generator.resource.DungeonGen;
import com.pg85.otg.generator.resource.FossilGen;
import com.pg85.otg.generator.resource.GrassGen;
import com.pg85.otg.generator.resource.IceSpikeGen;
import com.pg85.otg.generator.resource.LiquidGen;
import com.pg85.otg.generator.resource.OreGen;
import com.pg85.otg.generator.resource.PlantGen;
import com.pg85.otg.generator.resource.ReedGen;
import com.pg85.otg.generator.resource.SaplingGen;
import com.pg85.otg.generator.resource.SmallLakeGen;
import com.pg85.otg.generator.resource.SurfacePatchGen;
import com.pg85.otg.generator.resource.TreeGen;
import com.pg85.otg.generator.resource.UnderWaterOreGen;
import com.pg85.otg.generator.resource.UndergroundLakeGen;
import com.pg85.otg.generator.resource.VeinGen;
import com.pg85.otg.generator.resource.VinesGen;
import com.pg85.otg.generator.resource.WellGen;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConfigFunctionsManager {
    private Map<String, Class<? extends ConfigFunction<?>>> configFunctions = new HashMap();

    public ConfigFunctionsManager() {
        this.registerConfigFunction("BiomeGroup", BiomeGroup.class);
        this.registerConfigFunction("AboveWaterRes", AboveWaterGen.class);
        this.registerConfigFunction("Boulder", BoulderGen.class);
        this.registerConfigFunction("Cactus", CactusGen.class);
        this.registerConfigFunction("CustomObject", CustomObjectGen.class);
        this.registerConfigFunction("CustomStructure", CustomStructureGen.class);
        this.registerConfigFunction("Dungeon", DungeonGen.class);
        this.registerConfigFunction("Grass", GrassGen.class);
        this.registerConfigFunction("Fossil", FossilGen.class);
        this.registerConfigFunction("IceSpike", IceSpikeGen.class);
        this.registerConfigFunction("Liquid", LiquidGen.class);
        this.registerConfigFunction("Ore", OreGen.class);
        this.registerConfigFunction("Plant", PlantGen.class);
        this.registerConfigFunction("Reed", ReedGen.class);
        this.registerConfigFunction("Sapling", SaplingGen.class);
        this.registerConfigFunction("SmallLake", SmallLakeGen.class);
        this.registerConfigFunction("SurfacePatch", SurfacePatchGen.class);
        this.registerConfigFunction("Tree", TreeGen.class);
        this.registerConfigFunction("UndergroundLake", UndergroundLakeGen.class);
        this.registerConfigFunction("UnderWaterOre", UnderWaterOreGen.class);
        this.registerConfigFunction("Vein", VeinGen.class);
        this.registerConfigFunction("Vines", VinesGen.class);
        this.registerConfigFunction("Well", WellGen.class);
    }

    public void registerConfigFunction(String name, Class<? extends ConfigFunction<?>> value) {
        this.configFunctions.put(name.toLowerCase(), value);
    }

    public <T> ConfigFunction<T> getConfigFunction(String name, T holder, List<String> args) {
        Class<ConfigFunction<?>> clazz = this.configFunctions.get(name.toLowerCase());
        if (clazz == null) {
            return new ErroredFunction<T>(name, holder, args, "Resource type " + name + " not found");
        }
        try {
            Constructor<ConfigFunction<?>> constructor = clazz.getConstructor(holder.getClass(), List.class);
            return constructor.newInstance(holder, args);
        }
        catch (NoSuchMethodException e1) {
            return null;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof InvalidConfigException) {
                return new ErroredFunction<T>(name, holder, args, cause.getMessage());
            }
            throw new RuntimeException(e);
        }
    }
}

