/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.configuration.ConfigFile;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public final class ConfigToNetworkSender {
    public static void writeConfigsToStream(ConfigProvider configProvider, DataOutput stream, boolean isSinglePlayer) throws IOException {
        WorldConfig worldConfig = configProvider.getWorldConfig();
        LocalBiome[] biomes = configProvider.getBiomeArray();
        ConfigFile.writeStringToStream(stream, worldConfig.getName());
        stream.writeInt(worldConfig.WorldFog);
        stream.writeInt(worldConfig.WorldNightFog);
        stream.writeInt(worldConfig.waterLevelMax);
        ConfigFile.writeStringToStream(stream, worldConfig.commandBlockOutput);
        ConfigFile.writeStringToStream(stream, worldConfig.disableElytraMovementCheck);
        ConfigFile.writeStringToStream(stream, worldConfig.doDaylightCycle);
        ConfigFile.writeStringToStream(stream, worldConfig.doEntityDrops);
        ConfigFile.writeStringToStream(stream, worldConfig.doFireTick);
        ConfigFile.writeStringToStream(stream, worldConfig.doMobLoot);
        ConfigFile.writeStringToStream(stream, worldConfig.doMobSpawning);
        ConfigFile.writeStringToStream(stream, worldConfig.doTileDrops);
        ConfigFile.writeStringToStream(stream, worldConfig.doWeatherCycle);
        ConfigFile.writeStringToStream(stream, worldConfig.keepInventory);
        ConfigFile.writeStringToStream(stream, worldConfig.logAdminCommands);
        ConfigFile.writeStringToStream(stream, worldConfig.maxEntityCramming);
        ConfigFile.writeStringToStream(stream, worldConfig.mobGriefing);
        ConfigFile.writeStringToStream(stream, worldConfig.naturalRegeneration);
        ConfigFile.writeStringToStream(stream, worldConfig.randomTickSpeed);
        ConfigFile.writeStringToStream(stream, worldConfig.reducedDebugInfo);
        ConfigFile.writeStringToStream(stream, worldConfig.sendCommandFeedback);
        ConfigFile.writeStringToStream(stream, worldConfig.showDeathMessages);
        ConfigFile.writeStringToStream(stream, worldConfig.spawnRadius);
        ConfigFile.writeStringToStream(stream, worldConfig.spectatorsGenerateChunks);
        ConfigFile.writeStringToStream(stream, worldConfig.welcomeMessage);
        ConfigFile.writeStringToStream(stream, worldConfig.departMessage);
        stream.writeBoolean(worldConfig.hasSkyLight);
        stream.writeBoolean(worldConfig.isSurfaceWorld);
        stream.writeBoolean(worldConfig.canRespawnHere);
        stream.writeBoolean(worldConfig.doesWaterVaporize);
        stream.writeBoolean(worldConfig.doesXZShowFog);
        stream.writeBoolean(worldConfig.useCustomFogColor);
        stream.writeDouble(worldConfig.fogColorRed);
        stream.writeDouble(worldConfig.fogColorGreen);
        stream.writeDouble(worldConfig.fogColorBlue);
        stream.writeBoolean(worldConfig.isSkyColored);
        stream.writeInt(worldConfig.cloudHeight);
        stream.writeBoolean(worldConfig.canDoLightning);
        stream.writeBoolean(worldConfig.canDoRainSnowIce);
        stream.writeBoolean(worldConfig.isNightWorld);
        stream.writeDouble(worldConfig.voidFogYFactor);
        stream.writeBoolean(worldConfig.shouldMapSpin);
        stream.writeBoolean(worldConfig.canDropChunk);
        stream.writeInt(worldConfig.respawnDimension);
        stream.writeInt(worldConfig.movementFactor);
        ConfigFile.writeStringToStream(stream, worldConfig.itemsToAddOnJoinDimension);
        ConfigFile.writeStringToStream(stream, worldConfig.itemsToRemoveOnJoinDimension);
        ConfigFile.writeStringToStream(stream, worldConfig.itemsToAddOnLeaveDimension);
        ConfigFile.writeStringToStream(stream, worldConfig.itemsToRemoveOnLeaveDimension);
        ConfigFile.writeStringToStream(stream, worldConfig.itemsToAddOnRespawn);
        stream.writeBoolean(worldConfig.spawnPointSet);
        stream.writeInt(worldConfig.spawnPointX);
        stream.writeInt(worldConfig.spawnPointY);
        stream.writeInt(worldConfig.spawnPointZ);
        stream.writeBoolean(worldConfig.playersCanBreakBlocks);
        stream.writeBoolean(worldConfig.explosionsCanBreakBlocks);
        stream.writeBoolean(worldConfig.playersCanPlaceBlocks);
        ArrayList<LocalBiome> nonVirtualBiomes = new ArrayList<LocalBiome>();
        ArrayList<LocalBiome> nonVirtualCustomBiomes = new ArrayList<LocalBiome>();
        for (LocalBiome biome : biomes) {
            if (biome == null || biome.getIds().isVirtual()) continue;
            nonVirtualBiomes.add(biome);
            if (!biome.isCustom()) continue;
            nonVirtualCustomBiomes.add(biome);
        }
        stream.writeInt(nonVirtualCustomBiomes.size());
        for (LocalBiome biome : nonVirtualCustomBiomes) {
            ConfigFile.writeStringToStream(stream, biome.getName());
            stream.writeInt(biome.getIds().getSavedId());
        }
        stream.writeInt(nonVirtualBiomes.size());
        for (LocalBiome biome : nonVirtualBiomes) {
            if (biome == null) {
                throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
            }
            stream.writeInt(biome.getIds().getSavedId());
            biome.getBiomeConfig().writeToStream(stream, isSinglePlayer);
        }
    }
}

