/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.io;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.io.RawSettingValue;
import com.pg85.otg.configuration.io.SettingsMap;
import com.pg85.otg.logging.LogMarker;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collection;

public final class FileSettingsWriter {
    private final File file;
    private final boolean writeComments;

    public static final void writeToFile(SettingsMap config, File file, WorldConfig.ConfigMode configMode) {
        if (configMode == WorldConfig.ConfigMode.WriteDisable) {
            return;
        }
        boolean writeComments = configMode != WorldConfig.ConfigMode.WriteWithoutComments;
        FileSettingsWriter writer = new FileSettingsWriter(file, writeComments);
        try {
            writer.write(config);
        }
        catch (IOException e) {
            FileSettingsWriter.logIOError(e, file);
        }
    }

    private static void logIOError(IOException e, File file) {
        OTG.log(LogMarker.ERROR, "Failed to write to file {}", file);
        OTG.printStackTrace(LogMarker.ERROR, e);
    }

    public FileSettingsWriter(File file, boolean writeComments) {
        this.file = file;
        this.writeComments = writeComments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(SettingsMap settingsMap) throws IOException {
        BufferedWriter writer = null;
        try {
            File directory = this.file.getParentFile();
            if (!directory.exists() && !directory.mkdirs()) {
                throw new IOException("Could not create directory '" + this.file.getParentFile() + "'");
            }
            writer = new BufferedWriter(new FileWriter(this.file));
            for (RawSettingValue entry : settingsMap.getRawSettings()) {
                this.writeEntry(writer, entry);
            }
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void writeEntry(BufferedWriter writer, RawSettingValue value) throws IOException {
        switch (value.getType()) {
            case BIG_TITLE: {
                this.bigTitle(writer, value.getRawValue());
                this.comments(writer, value.getComments());
                break;
            }
            case SMALL_TITLE: {
                this.smallTitle(writer, value.getRawValue());
                this.comments(writer, value.getComments());
                break;
            }
            case PLAIN_SETTING: {
                this.comments(writer, value.getComments());
                writer.write(value.getRawValue());
                writer.newLine();
                writer.newLine();
                break;
            }
            default: {
                this.comments(writer, value.getComments());
                writer.write(value.getRawValue());
                writer.newLine();
            }
        }
    }

    private void bigTitle(BufferedWriter writer, String title) throws IOException {
        writer.newLine();
        writer.write("#######################################################################");
        writer.newLine();
        writer.write("# +-----------------------------------------------------------------+ #");
        writer.newLine();
        StringBuilder builder = new StringBuilder(title);
        builder.insert(0, ' ');
        builder.append(' ');
        boolean flag = true;
        while (builder.length() < 65) {
            if (flag) {
                builder.insert(0, ' ');
            } else {
                builder.append(' ');
            }
            flag = !flag;
        }
        writer.write("# |" + builder.toString() + "| #");
        writer.newLine();
        writer.write("# +-----------------------------------------------------------------+ #");
        writer.newLine();
        writer.write("#######################################################################");
        writer.newLine();
        writer.newLine();
    }

    private void comments(BufferedWriter writer, Collection<String> comments) throws IOException {
        if (!this.writeComments) {
            return;
        }
        for (String comment : comments) {
            this.comment(writer, comment);
        }
    }

    private void comment(BufferedWriter writer, String comment) throws IOException {
        if (!this.writeComments) {
            return;
        }
        if (comment.length() > 0) {
            writer.write("# " + comment);
        }
        writer.newLine();
    }

    private void smallTitle(BufferedWriter writer, String title) throws IOException {
        int titleLength = title.length();
        StringBuilder rowBuilder = new StringBuilder(titleLength + 4);
        for (int i = 0; i < titleLength + 4; ++i) {
            rowBuilder.append('#');
        }
        writer.write(rowBuilder.toString());
        writer.newLine();
        writer.write("# " + title + " #");
        writer.newLine();
        writer.write(rowBuilder.toString());
        writer.newLine();
        writer.newLine();
    }
}

