/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.configuration.io;

import com.pg85.otg.configuration.settingType.Setting;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class RawSettingValue {
    private final List<String> comments;
    private final int line;
    private final String value;
    private final ValueType valueType;

    public static RawSettingValue create(ValueType valueType, String settingValue) {
        if (settingValue == null || valueType == null) {
            throw new NullPointerException();
        }
        return new RawSettingValue(settingValue, valueType, -1, Collections.<String>emptyList());
    }

    public static <S> RawSettingValue ofPlainSetting(Setting<S> setting, S value) {
        return RawSettingValue.ofPlainSetting(setting.getName(), setting.write(value));
    }

    public static <S> RawSettingValue ofPlainSetting(String settingName, String value) {
        return RawSettingValue.create(ValueType.PLAIN_SETTING, settingName + ": " + value);
    }

    private RawSettingValue(String value, ValueType valueType, int line, List<String> comments) {
        this.value = value;
        this.valueType = valueType;
        this.line = line;
        this.comments = comments;
    }

    public List<String> getComments() {
        return this.comments;
    }

    public int getLineNumber() {
        return this.line;
    }

    public String getRawValue() {
        return this.value;
    }

    public ValueType getType() {
        return this.valueType;
    }

    public RawSettingValue withComments(String ... comments) {
        if (comments.length == 0 && this.comments.isEmpty()) {
            return this;
        }
        List<String> commentsList = Collections.unmodifiableList(Arrays.asList(comments));
        return new RawSettingValue(this.value, this.valueType, this.line, commentsList);
    }

    public RawSettingValue withLineNumber(int lineNumber) {
        if (lineNumber <= 0) {
            throw new IllegalArgumentException("Invalid line number: " + lineNumber);
        }
        return new RawSettingValue(this.value, this.valueType, lineNumber, this.comments);
    }

    public static enum ValueType {
        PLAIN_SETTING,
        FUNCTION,
        BIG_TITLE,
        SMALL_TITLE;

    }
}

