/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectStructure;
import com.pg85.otg.customobjects.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.StructuredCustomObject;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.BoundingBox;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import java.util.Random;

public class CustomObjectCoordinate {
    public boolean isSpawned;
    public boolean isBranch;
    public int branchDepth;
    public boolean isRequiredBranch;
    public boolean isWeightedBranch;
    public String branchGroup;
    String BO3Name;
    String StartBO3Name;
    public LocalWorld World;
    private transient CustomObject object;
    Rotation rotation;
    int x;
    int y;
    int z;

    public final int getChunkX() {
        return MathHelper.floor((double)this.x / 16.0);
    }

    public final int getChunkZ() {
        return MathHelper.floor((double)this.z / 16.0);
    }

    public CustomObjectCoordinate(LocalWorld world, CustomObject object, String customObjectName, Rotation rotation, int x, int y, int z, boolean isBranch, int branchDepth, boolean isRequiredBranch, boolean isWeightedBranch, String branchGroup) {
        this.World = world;
        String string = object != null ? object.getName() : (this.BO3Name = customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        if (object != null && ((BO3)object).getSettings() == null) {
            throw new RuntimeException();
        }
        this.object = object;
        this.rotation = rotation != null ? rotation : Rotation.NORTH;
        this.x = x;
        this.y = y;
        if (y >= 256) {
            throw new RuntimeException();
        }
        this.z = z;
        this.isBranch = isBranch;
        this.branchDepth = branchDepth;
        this.isRequiredBranch = isRequiredBranch;
        this.isWeightedBranch = isWeightedBranch;
        this.branchGroup = branchGroup;
    }

    public CustomObject getObject() {
        if (this.object == null) {
            if (this.World == null) {
                throw new RuntimeException();
            }
            this.object = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.BO3Name, this.World.getName());
            if (this.object == null) {
                OTG.log(LogMarker.ERROR, "Could not find BO2/BO3 " + this.BO3Name + " in GlobalObjects or WorldObjects directory.", new Object[0]);
            }
            String string = this.BO3Name = this.object != null ? this.object.getName() : this.BO3Name;
            if (this.object != null && ((BO3)this.object).getSettings() == null) {
                throw new RuntimeException();
            }
            return this.object;
        }
        return this.object;
    }

    public boolean spawnWithChecks(ChunkCoordinate chunkCoord, LocalWorld world, Random random, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly) {
        if (this.getObject() == null) {
            throw new RuntimeException();
        }
        if (this.getObject() instanceof BO3) {
            return ((BO3)this.getObject()).trySpawnAt(world, random, this.rotation, chunkCoord, this.x, this.y, this.z, replaceAbove, replaceBelow, replaceWithBiomeBlocks, replaceWithSurfaceBlock, replaceWithGroundBlock, spawnUnderWater, waterLevel, isStructureAtSpawn, doReplaceAboveBelowOnly);
        }
        throw new RuntimeException();
    }

    public StructuredCustomObject getStructuredObject() {
        return (StructuredCustomObject)this.getObject();
    }

    public CustomObjectCoordinate(LocalWorld world, CustomObject object, String customObjectName, Rotation rotation, int x, int y, int z) {
        this.World = world;
        this.object = object;
        String string = object != null ? object.getName() : (this.BO3Name = customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        if (this.BO3Name == null) {
            throw new RuntimeException();
        }
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Rotation getRotation() {
        return this.rotation;
    }

    boolean spawnWithChecks(CustomObjectStructure structure, LocalWorld world, StructurePartSpawnHeight height, Random random) {
        return ((BO3)this.object).trySpawnAt(false, structure, world, random, this.rotation, this.x, height.getCorrectY(world, this.x, this.y, this.z), this.z);
    }

    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof CustomObjectCoordinate)) {
            return false;
        }
        CustomObjectCoordinate otherCoord = (CustomObjectCoordinate)otherObject;
        if (otherCoord.x != this.x) {
            return false;
        }
        if (otherCoord.y != this.y) {
            return false;
        }
        if (otherCoord.z != this.z) {
            return false;
        }
        if (!otherCoord.rotation.equals((Object)this.rotation)) {
            return false;
        }
        return otherCoord.object.getName().equals(this.object.getName());
    }

    public int hashCode() {
        return this.x >> 13 ^ this.y >> 7 ^ this.z ^ this.object.getName().hashCode() ^ this.rotation.toString().hashCode();
    }

    public ChunkCoordinate getPopulatingChunk() {
        CustomObject object = this.getObject();
        if (object == null) {
            return null;
        }
        BoundingBox box = object.getBoundingBox(this.rotation);
        int centerX = this.x + box.getMinX() + box.getWidth() / 2;
        int centerZ = this.z + box.getMinZ() + box.getDepth() / 2;
        return ChunkCoordinate.getPopulatingChunk(centerX, centerZ);
    }

    public static CustomObjectCoordinate getRotatedCoord(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        if (rotations < 0) {
            throw new RuntimeException();
        }
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = rotatedZ;
            newZ = -rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new CustomObjectCoordinate(null, null, null, newRotation, rotatedX, y, rotatedZ, false, 0, false, false, null);
    }

    public static CustomObjectCoordinate getRotatedBO3Coords(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        if (rotations < 0) {
            throw new RuntimeException();
        }
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = rotatedZ - 1;
            newZ = -rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new CustomObjectCoordinate(null, null, null, newRotation, rotatedX, y, rotatedZ, false, 0, false, false, null);
    }

    public static CustomObjectCoordinate getRotatedBO3CoordsJustified(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        if (rotations < 0) {
            throw new RuntimeException();
        }
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = 15 - rotatedZ;
            newZ = rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new CustomObjectCoordinate(null, null, null, newRotation, rotatedX, y, rotatedZ, false, 0, false, false, null);
    }

    public static CustomObjectCoordinate getRotatedSmoothingCoords(int x, int y, int z, Rotation newRotation) {
        int newX = 0;
        int newY = 0;
        int newZ = 0;
        int rotations = 0;
        if (newRotation == Rotation.WEST) {
            rotations = 1;
        } else if (newRotation == Rotation.SOUTH) {
            rotations = 2;
        } else if (newRotation == Rotation.EAST) {
            rotations = 3;
        }
        if (rotations == 0) {
            newX = x;
            newZ = z;
        }
        if (rotations == 1) {
            newX = z;
            newZ = -x + 15;
        }
        if (rotations == 2) {
            newX = -x + 15;
            newZ = -z + 15;
        }
        if (rotations == 3) {
            newX = -z + 15;
            newZ = x;
        }
        newY = y;
        return new CustomObjectCoordinate(null, null, null, newRotation, newX, newY, newZ, false, 0, false, false, null);
    }
}

