/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.CustomObjectStructure;
import com.pg85.otg.customobjects.StructuredCustomObject;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.ModDataFunction;
import com.pg85.otg.customobjects.bo3.ParticleFunction;
import com.pg85.otg.customobjects.bo3.SpawnerFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.helpers.RandomHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Stack;

public class CustomObjectStructureCache {
    public Map<ChunkCoordinate, CustomObjectStructure> worldInfoChunks;
    public Map<String, Stack<ChunkCoordinate>> spawnedStructures;
    public HashMap<ChunkCoordinate, ArrayList<String>> structuresPerChunk;
    public Map<ChunkCoordinate, CustomObjectStructure> structureCache;
    private LocalWorld world;
    public boolean processing = false;

    public CustomObjectStructureCache(LocalWorld world) {
        this.world = world;
        this.structureCache = new HashMap<ChunkCoordinate, CustomObjectStructure>();
        this.spawnedStructures = new HashMap<String, Stack<ChunkCoordinate>>();
        this.worldInfoChunks = new HashMap<ChunkCoordinate, CustomObjectStructure>();
        this.structuresPerChunk = new HashMap();
        this.LoadStructureCache();
    }

    public void reload(LocalWorld world) {
        this.world = world;
        this.structureCache.clear();
    }

    public CustomObjectStructure getStructureStart(int chunkX, int chunkZ) {
        CustomObjectCoordinate customObject;
        if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
            throw new RuntimeException();
        }
        ChunkCoordinate coord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        CustomObjectStructure structureStart = this.structureCache.get(coord);
        if (this.structureCache.size() > 400) {
            this.structureCache.clear();
        }
        if (structureStart != null) {
            return structureStart;
        }
        Random random = RandomHelper.getRandomForCoords(chunkX ^ 2, (chunkZ + 1) * 2, this.world.getSeed());
        BiomeConfig biomeConfig = this.world.getBiome(chunkX * 16 + 15, chunkZ * 16 + 15).getBiomeConfig();
        CustomStructureGen structureGen = biomeConfig.structureGen;
        if (structureGen != null && (customObject = structureGen.getRandomObjectCoordinate(this.world, random, chunkX, chunkZ)) != null) {
            structureStart = new CustomObjectStructure(this.world, customObject);
            this.structureCache.put(coord, structureStart);
            return structureStart;
        }
        return null;
    }

    public void PlotStructures(ChunkCoordinate chunkCoord, boolean spawningStructureAtSpawn) {
        if (!this.processing) {
            this.processing = true;
            if (!this.world.IsInsidePregeneratedRegion(chunkCoord, true) && this.world.IsInsideWorldBorder(chunkCoord, false) && !this.structureCache.containsKey(chunkCoord)) {
                LocalBiome biome = this.world.getBiome(chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 8);
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                ArrayList<CustomStructureGen> customStructureGens = new ArrayList<CustomStructureGen>();
                for (ConfigFunction<BiomeConfig> res : biomeConfig.resourceSequence) {
                    if (!(res instanceof CustomStructureGen)) continue;
                    customStructureGens.add((CustomStructureGen)res);
                }
                if (customStructureGens.size() > 0) {
                    Random random = new Random();
                    HashMap<StructuredCustomObject, Double> structuredCustomObjects = new HashMap<StructuredCustomObject, Double>();
                    for (CustomStructureGen structureGen : customStructureGens) {
                        int i = 0;
                        for (StructuredCustomObject structure : structureGen.getObjects(this.world.getName())) {
                            if (structure != null && ((BO3)structure).getSettings().isOTGPlus) {
                                structuredCustomObjects.put(structure, structureGen.objectChances.get(i));
                                ++i;
                                continue;
                            }
                            if (structure == null || ((BO3)structure).getSettings().isOTGPlus || !OTG.getPluginConfig().SpawnLog) continue;
                            OTG.log(LogMarker.WARN, "Tried to spawn non-OTG+ enabled BO3 as CustomStructure in a OTG+ enabled world. BO3: " + ((BO3)structure).getSettings().getName(), new Object[0]);
                        }
                    }
                    if (structuredCustomObjects.size() > 0) {
                        Object[] topLeftAndLowerRightChunkCoordinates = null;
                        CustomObjectCoordinate structureCoord = null;
                        CustomObjectStructure structureStart2 = null;
                        ArrayList<Object[]> BO3sBySize = new ArrayList<Object[]>();
                        ArrayList<String> structuresToSpawn1 = new ArrayList<String>();
                        if (spawningStructureAtSpawn) {
                            for (Map.Entry bo3AndRarity : structuredCustomObjects.entrySet()) {
                                if (((BO3)bo3AndRarity.getKey()).isInvalidConfig || !((BO3)bo3AndRarity.getKey()).getSettings().isSpawnPoint) continue;
                                structuresToSpawn1.add(((StructuredCustomObject)bo3AndRarity.getKey()).getName());
                                structureCoord = new CustomObjectCoordinate(this.world, (CustomObject)bo3AndRarity.getKey(), null, Rotation.NORTH, chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ(), false, 0, false, false, null);
                                structureStart2 = new CustomObjectStructure(this.world, structureCoord, false, false);
                                try {
                                    topLeftAndLowerRightChunkCoordinates = structureStart2.GetMinimumSize();
                                    double BO3size = Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[0] - -((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue()) * Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[1] - -((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue());
                                    BO3sBySize.add(new Object[]{bo3AndRarity.getKey(), topLeftAndLowerRightChunkCoordinates, BO3size, bo3AndRarity.getValue()});
                                }
                                catch (InvalidConfigException e) {
                                    ((BO3)bo3AndRarity.getKey()).isInvalidConfig = true;
                                }
                            }
                        }
                        if (!spawningStructureAtSpawn || BO3sBySize.size() == 0) {
                            for (Map.Entry bo3AndRarity : structuredCustomObjects.entrySet()) {
                                if (((BO3)bo3AndRarity.getKey()).isInvalidConfig || (int)Math.round((Double)bo3AndRarity.getValue()) <= 0 || !this.IsBO3AllowedToSpawnAt(chunkCoord, (BO3)bo3AndRarity.getKey())) continue;
                                structuresToSpawn1.add(((StructuredCustomObject)bo3AndRarity.getKey()).getName());
                                structureCoord = new CustomObjectCoordinate(this.world, (CustomObject)bo3AndRarity.getKey(), null, Rotation.NORTH, chunkCoord.getBlockX(), 0, chunkCoord.getBlockZ(), false, 0, false, false, null);
                                structureStart2 = new CustomObjectStructure(this.world, structureCoord, false, false);
                                try {
                                    topLeftAndLowerRightChunkCoordinates = structureStart2.GetMinimumSize();
                                    double BO3size = Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[0] - -((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue()) * Math.abs((Integer)topLeftAndLowerRightChunkCoordinates[1] - -((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue());
                                    int insertAtIndex = BO3sBySize.size();
                                    int i = 0;
                                    for (Object[] entry : BO3sBySize) {
                                        if (((BO3)bo3AndRarity.getKey()).getSettings().timesSpawned < ((BO3)entry[0]).getSettings().timesSpawned || BO3size > (Double)entry[2] && ((BO3)bo3AndRarity.getKey()).getSettings().timesSpawned == ((BO3)entry[0]).getSettings().timesSpawned) {
                                            insertAtIndex = i;
                                            break;
                                        }
                                        ++i;
                                    }
                                    BO3sBySize.add(insertAtIndex, new Object[]{bo3AndRarity.getKey(), topLeftAndLowerRightChunkCoordinates, BO3size, bo3AndRarity.getValue()});
                                }
                                catch (InvalidConfigException e) {
                                    ((BO3)bo3AndRarity.getKey()).isInvalidConfig = true;
                                }
                            }
                        }
                        if (BO3sBySize.size() > 0) {
                            int pass = 1;
                            Object[] currentStructureSpawning = BO3sBySize.size() > 0 ? (spawningStructureAtSpawn ? (Object[])BO3sBySize.get(random.nextInt(BO3sBySize.size())) : (Object[])BO3sBySize.get(0)) : null;
                            int left = 0;
                            int right = 0;
                            int top = 0;
                            int bottom = 0;
                            int areaSizeX = 0;
                            int areaSizeZ = 0;
                            int structureSizeX = 0;
                            int structureSizeZ = 0;
                            int maxPass = 4;
                            while (pass <= maxPass && currentStructureSpawning != null) {
                                int i;
                                boolean bFound;
                                boolean spawned = false;
                                topLeftAndLowerRightChunkCoordinates = (Object[])currentStructureSpawning[1];
                                structureSizeX = (Integer)topLeftAndLowerRightChunkCoordinates[1] + (Integer)topLeftAndLowerRightChunkCoordinates[3] + 1;
                                structureSizeZ = (Integer)topLeftAndLowerRightChunkCoordinates[0] + (Integer)topLeftAndLowerRightChunkCoordinates[2] + 1;
                                if ((int)Math.round((Double)currentStructureSpawning[3]) > 0 || spawningStructureAtSpawn && ((BO3)currentStructureSpawning[0]).getSettings().isSpawnPoint) {
                                    left = 0;
                                    right = 0;
                                    top = 0;
                                    bottom = 0;
                                    boolean leftEdgeFound = false;
                                    boolean rightEdgeFound = false;
                                    boolean topEdgeFound = false;
                                    boolean bottomEdgeFound = false;
                                    if (pass == 1) {
                                        topEdgeFound = true;
                                        rightEdgeFound = true;
                                    }
                                    if (pass == 2) {
                                        topEdgeFound = true;
                                        leftEdgeFound = true;
                                    }
                                    if (pass == 3) {
                                        bottomEdgeFound = true;
                                        rightEdgeFound = true;
                                    }
                                    if (pass == 4) {
                                        bottomEdgeFound = true;
                                        leftEdgeFound = true;
                                    }
                                    boolean passHandled = false;
                                    int j = 0;
                                    if (!spawningStructureAtSpawn) {
                                        while (!(leftEdgeFound && rightEdgeFound && topEdgeFound && bottomEdgeFound)) {
                                            int i2;
                                            ArrayList<String> structuresToSpawn;
                                            BiomeConfig biomeConfig3;
                                            LocalBiome biome3;
                                            ArrayList<String> biomeStructures;
                                            boolean canSpawnHere;
                                            ++j;
                                            if (right >= structureSizeX - 1 || left >= structureSizeX - 1 || right + left + 1 >= structureSizeX) {
                                                rightEdgeFound = true;
                                            }
                                            if (!rightEdgeFound) {
                                                for (int i22 = -top; i22 <= bottom; ++i22) {
                                                    canSpawnHere = false;
                                                    if (!this.world.IsInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i22), true) && this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i22), true)) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i22));
                                                        if (biomeStructures == null) {
                                                            biome3 = this.world.getBiome((chunkCoord.getChunkX() + j) * 16 + 8, (chunkCoord.getChunkZ() + i22) * 16 + 8);
                                                            if (!biome3.getName().equals(biome.getName())) {
                                                                biomeConfig3 = biome3.getBiomeConfig();
                                                                structuresToSpawn = new ArrayList<String>();
                                                                for (ConfigFunction configFunction : biomeConfig3.resourceSequence) {
                                                                    if (!(configFunction instanceof CustomStructureGen)) continue;
                                                                    for (String bo3Name : ((CustomStructureGen)configFunction).objectNames) {
                                                                        structuresToSpawn.add(bo3Name);
                                                                    }
                                                                }
                                                                biomeStructures = structuresToSpawn;
                                                            } else {
                                                                canSpawnHere = true;
                                                                biomeStructures = structuresToSpawn1;
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i22), biomeStructures);
                                                        }
                                                        for (String string : biomeStructures) {
                                                            if (!string.equals(((BO3)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + j, chunkCoord.getChunkZ() + i22));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    rightEdgeFound = true;
                                                }
                                                if (!rightEdgeFound) {
                                                    ++right;
                                                }
                                            }
                                            if (right >= structureSizeX - 1 || left >= structureSizeX - 1 || right + left + 1 >= structureSizeX) {
                                                leftEdgeFound = true;
                                            }
                                            if (!leftEdgeFound) {
                                                for (i2 = -top; i2 <= bottom; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!this.world.IsInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2), true) && this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2), true)) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2));
                                                        if (biomeStructures == null) {
                                                            biome3 = this.world.getBiome((chunkCoord.getChunkX() - j) * 16 + 8, (chunkCoord.getChunkZ() + i2) * 16 + 8);
                                                            if (!biome3.getName().equals(biome.getName())) {
                                                                biomeConfig3 = biome3.getBiomeConfig();
                                                                structuresToSpawn = new ArrayList();
                                                                for (ConfigFunction configFunction : biomeConfig3.resourceSequence) {
                                                                    if (!(configFunction instanceof CustomStructureGen)) continue;
                                                                    for (String bo3Name : ((CustomStructureGen)configFunction).objectNames) {
                                                                        structuresToSpawn.add(bo3Name);
                                                                    }
                                                                }
                                                                biomeStructures = structuresToSpawn;
                                                            } else {
                                                                canSpawnHere = true;
                                                                biomeStructures = structuresToSpawn1;
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2), biomeStructures);
                                                        }
                                                        for (String string : biomeStructures) {
                                                            if (!string.equals(((BO3)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() - j, chunkCoord.getChunkZ() + i2));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    leftEdgeFound = true;
                                                }
                                                if (!leftEdgeFound) {
                                                    ++left;
                                                }
                                            }
                                            if (bottom >= structureSizeZ - 1 || top >= structureSizeZ - 1 || bottom + top + 1 >= structureSizeZ) {
                                                bottomEdgeFound = true;
                                            }
                                            if (!bottomEdgeFound) {
                                                for (i2 = -left; i2 <= right; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!this.world.IsInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j), true) && this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j), true)) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j));
                                                        if (biomeStructures == null) {
                                                            biome3 = this.world.getBiome((chunkCoord.getChunkX() + i2) * 16 + 8, (chunkCoord.getChunkZ() + j) * 16 + 8);
                                                            if (!biome3.getName().equals(biome.getName())) {
                                                                biomeConfig3 = biome3.getBiomeConfig();
                                                                structuresToSpawn = new ArrayList();
                                                                for (ConfigFunction configFunction : biomeConfig3.resourceSequence) {
                                                                    if (!(configFunction instanceof CustomStructureGen)) continue;
                                                                    for (String bo3Name : ((CustomStructureGen)configFunction).objectNames) {
                                                                        structuresToSpawn.add(bo3Name);
                                                                    }
                                                                }
                                                                biomeStructures = structuresToSpawn;
                                                            } else {
                                                                canSpawnHere = true;
                                                                biomeStructures = structuresToSpawn1;
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j), biomeStructures);
                                                        }
                                                        for (String string : biomeStructures) {
                                                            if (!string.equals(((BO3)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() + j));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    bottomEdgeFound = true;
                                                }
                                                if (!bottomEdgeFound) {
                                                    ++bottom;
                                                }
                                            }
                                            if (top >= structureSizeZ - 1 || bottom >= structureSizeZ - 1 || bottom + top >= structureSizeZ + 1) {
                                                topEdgeFound = true;
                                            }
                                            if (!topEdgeFound) {
                                                for (i2 = -left; i2 <= right; ++i2) {
                                                    canSpawnHere = false;
                                                    if (!this.world.IsInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j), true) && this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j), true)) {
                                                        biomeStructures = this.structuresPerChunk.get(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j));
                                                        if (biomeStructures == null) {
                                                            biome3 = this.world.getBiome((chunkCoord.getChunkX() + i2) * 16 + 8, (chunkCoord.getChunkZ() - j) * 16 + 8);
                                                            if (!biome3.getName().equals(biome.getName())) {
                                                                biomeConfig3 = biome3.getBiomeConfig();
                                                                structuresToSpawn = new ArrayList();
                                                                for (ConfigFunction configFunction : biomeConfig3.resourceSequence) {
                                                                    if (!(configFunction instanceof CustomStructureGen)) continue;
                                                                    for (String bo3Name : ((CustomStructureGen)configFunction).objectNames) {
                                                                        structuresToSpawn.add(bo3Name);
                                                                    }
                                                                }
                                                                biomeStructures = structuresToSpawn;
                                                            } else {
                                                                canSpawnHere = true;
                                                                biomeStructures = structuresToSpawn1;
                                                            }
                                                            this.structuresPerChunk.put(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j), biomeStructures);
                                                        }
                                                        for (String string : biomeStructures) {
                                                            if (!string.equals(((BO3)currentStructureSpawning[0]).getName())) continue;
                                                            canSpawnHere = true;
                                                            break;
                                                        }
                                                    } else {
                                                        this.structuresPerChunk.remove(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + i2, chunkCoord.getChunkZ() - j));
                                                    }
                                                    if (canSpawnHere) continue;
                                                    topEdgeFound = true;
                                                }
                                                if (!topEdgeFound) {
                                                    ++top;
                                                }
                                            }
                                            if (passHandled) continue;
                                            if (pass == 1 && bottomEdgeFound && leftEdgeFound) {
                                                passHandled = true;
                                                j = 0;
                                                topEdgeFound = false;
                                                rightEdgeFound = false;
                                            }
                                            if (pass == 2 && bottomEdgeFound && rightEdgeFound) {
                                                passHandled = true;
                                                j = 0;
                                                topEdgeFound = false;
                                                leftEdgeFound = false;
                                            }
                                            if (pass == 3 && topEdgeFound && leftEdgeFound) {
                                                passHandled = true;
                                                j = 0;
                                                bottomEdgeFound = false;
                                                rightEdgeFound = false;
                                            }
                                            if (pass != 4 || !topEdgeFound || !rightEdgeFound) continue;
                                            passHandled = true;
                                            j = 0;
                                            bottomEdgeFound = false;
                                            leftEdgeFound = false;
                                        }
                                    } else {
                                        left = (int)Math.ceil((double)((Integer)topLeftAndLowerRightChunkCoordinates[3] + (Integer)topLeftAndLowerRightChunkCoordinates[1]) / 2.0);
                                        right = (int)Math.floor((double)((Integer)topLeftAndLowerRightChunkCoordinates[3] + (Integer)topLeftAndLowerRightChunkCoordinates[1]) / 2.0);
                                        top = (int)Math.ceil((double)((Integer)topLeftAndLowerRightChunkCoordinates[0] + (Integer)topLeftAndLowerRightChunkCoordinates[2]) / 2.0);
                                        bottom = (int)Math.floor((double)((Integer)topLeftAndLowerRightChunkCoordinates[0] + (Integer)topLeftAndLowerRightChunkCoordinates[2]) / 2.0);
                                        if (this.world.GetWorldSession().getWorldBorderRadius() > 0 && (this.world.GetWorldSession().getWorldBorderRadius() < left || this.world.GetWorldSession().getWorldBorderRadius() < right || this.world.GetWorldSession().getWorldBorderRadius() < top || this.world.GetWorldSession().getWorldBorderRadius() < bottom)) {
                                            left = 0;
                                            right = 0;
                                            top = 0;
                                            bottom = 0;
                                        }
                                    }
                                    areaSizeX = left + right + 1;
                                    areaSizeZ = top + bottom + 1;
                                    if (structureSizeX <= areaSizeX && structureSizeZ <= areaSizeZ) {
                                        int spawnCoordX = 0;
                                        int spawnCoordZ = 0;
                                        if (pass == 1) {
                                            spawnCoordX = chunkCoord.getChunkX() - (left > 0 && left - (Integer)topLeftAndLowerRightChunkCoordinates[3] > (Integer)topLeftAndLowerRightChunkCoordinates[1] ? structureSizeX - 1 : left) + (Integer)topLeftAndLowerRightChunkCoordinates[3];
                                            spawnCoordZ = chunkCoord.getChunkZ() + (bottom > 0 && bottom - (Integer)topLeftAndLowerRightChunkCoordinates[2] > (Integer)topLeftAndLowerRightChunkCoordinates[0] ? structureSizeZ - 1 : bottom) - (Integer)topLeftAndLowerRightChunkCoordinates[2];
                                        }
                                        if (pass == 2) {
                                            spawnCoordX = chunkCoord.getChunkX() + (right > 0 && right - (Integer)topLeftAndLowerRightChunkCoordinates[1] > (Integer)topLeftAndLowerRightChunkCoordinates[3] ? structureSizeX - 1 : right) - (Integer)topLeftAndLowerRightChunkCoordinates[1];
                                            spawnCoordZ = chunkCoord.getChunkZ() + (bottom > 0 && bottom - (Integer)topLeftAndLowerRightChunkCoordinates[2] > (Integer)topLeftAndLowerRightChunkCoordinates[0] ? structureSizeZ - 1 : bottom) - (Integer)topLeftAndLowerRightChunkCoordinates[2];
                                        }
                                        if (pass == 3) {
                                            spawnCoordX = chunkCoord.getChunkX() - (left > 0 && left - (Integer)topLeftAndLowerRightChunkCoordinates[3] > (Integer)topLeftAndLowerRightChunkCoordinates[1] ? structureSizeX - 1 : left) + (Integer)topLeftAndLowerRightChunkCoordinates[3];
                                            spawnCoordZ = chunkCoord.getChunkZ() - (top > 0 && top - (Integer)topLeftAndLowerRightChunkCoordinates[0] > (Integer)topLeftAndLowerRightChunkCoordinates[2] ? structureSizeZ - 1 : top) + (Integer)topLeftAndLowerRightChunkCoordinates[0];
                                        }
                                        if (pass == 4) {
                                            spawnCoordX = chunkCoord.getChunkX() + (right > 0 && right - (Integer)topLeftAndLowerRightChunkCoordinates[1] > (Integer)topLeftAndLowerRightChunkCoordinates[3] ? structureSizeX - 1 : right) - (Integer)topLeftAndLowerRightChunkCoordinates[1];
                                            spawnCoordZ = chunkCoord.getChunkZ() - (top > 0 && top - (Integer)topLeftAndLowerRightChunkCoordinates[0] > (Integer)topLeftAndLowerRightChunkCoordinates[2] ? structureSizeZ - 1 : top) + (Integer)topLeftAndLowerRightChunkCoordinates[0];
                                        }
                                        if (this.IsBO3AllowedToSpawnAt(ChunkCoordinate.fromChunkCoords((int)Math.round((double)spawnCoordX - (double)((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[1]).intValue() / 2.0), (int)Math.round((double)spawnCoordZ - (double)((Integer)topLeftAndLowerRightChunkCoordinates[0]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue() / 2.0)), (BO3)currentStructureSpawning[0])) {
                                            structureCoord = new CustomObjectCoordinate(this.world, (BO3)currentStructureSpawning[0], null, Rotation.NORTH, spawnCoordX * 16, 0, spawnCoordZ * 16, false, 0, false, false, null);
                                            structureStart2 = new CustomObjectStructure(this.world, structureCoord, true, spawningStructureAtSpawn);
                                            if (structureStart2.IsSpawned) {
                                                this.structureCache.put(chunkCoord, structureStart2);
                                                this.structuresPerChunk.put(chunkCoord, new ArrayList());
                                                this.worldInfoChunks.put(chunkCoord, structureStart2);
                                                ++((BO3)structureCoord.getObject()).getSettings().timesSpawned;
                                                if (OTG.getPluginConfig().SpawnLog) {
                                                    OTG.log(LogMarker.INFO, "Plotted structure " + structureCoord.getObject().getName() + " at chunk X" + spawnCoordX + " Z" + spawnCoordZ + " (" + spawnCoordX * 16 + " 100 " + spawnCoordZ * 16 + ")", new Object[0]);
                                                }
                                                if (((BO3)currentStructureSpawning[0]).getSettings().frequency > 0 || ((BO3)currentStructureSpawning[0]).getSettings().bo3Group.length() > 0) {
                                                    String string = ((BO3)currentStructureSpawning[0]).getName() + ";" + ((BO3)currentStructureSpawning[0]).getSettings().bo3Group;
                                                    if (this.spawnedStructures.containsKey(string)) {
                                                        this.spawnedStructures.get(string).add(ChunkCoordinate.fromChunkCoords(spawnCoordX, spawnCoordZ));
                                                    } else {
                                                        Stack<ChunkCoordinate> chunks = new Stack<ChunkCoordinate>();
                                                        chunks.add(ChunkCoordinate.fromChunkCoords((int)Math.round((double)spawnCoordX - (double)((Integer)topLeftAndLowerRightChunkCoordinates[3]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[1]).intValue() / 2.0), (int)Math.round((double)spawnCoordZ - (double)((Integer)topLeftAndLowerRightChunkCoordinates[0]).intValue() / 2.0 + (double)((Integer)topLeftAndLowerRightChunkCoordinates[2]).intValue() / 2.0)));
                                                        this.spawnedStructures.put(string, chunks);
                                                    }
                                                }
                                                spawned = true;
                                                random = new Random();
                                            }
                                            if (spawned) {
                                                break;
                                            }
                                        }
                                    }
                                } else {
                                    pass = maxPass;
                                }
                                if (!spawned) {
                                    if (++pass <= maxPass) continue;
                                    if (BO3sBySize.size() == 1) {
                                        this.structureCache.put(chunkCoord, new CustomObjectStructure(this.world, null, false, false));
                                        continue;
                                    }
                                    bFound = false;
                                    i = 0;
                                    for (Object[] nextStructure : BO3sBySize) {
                                        if (bFound) {
                                            BO3sBySize.remove(currentStructureSpawning);
                                            currentStructureSpawning = nextStructure;
                                            break;
                                        }
                                        if (nextStructure == currentStructureSpawning) {
                                            if (i == BO3sBySize.size() - 1) {
                                                BO3sBySize.remove(currentStructureSpawning);
                                                currentStructureSpawning = (Object[])BO3sBySize.get(0);
                                                break;
                                            }
                                            bFound = true;
                                        }
                                        ++i;
                                    }
                                    pass = 1;
                                    continue;
                                }
                                bFound = false;
                                i = 0;
                                for (Object[] nextStructure : BO3sBySize) {
                                    if (bFound) {
                                        currentStructureSpawning = nextStructure;
                                        break;
                                    }
                                    if (nextStructure == currentStructureSpawning) {
                                        if (i == BO3sBySize.size() - 1) {
                                            currentStructureSpawning = (Object[])BO3sBySize.get(0);
                                            break;
                                        }
                                        bFound = true;
                                    }
                                    ++i;
                                }
                                pass = 1;
                            }
                        } else {
                            this.structureCache.put(chunkCoord, new CustomObjectStructure(this.world, null, false, false));
                        }
                    } else {
                        this.structureCache.put(chunkCoord, new CustomObjectStructure(this.world, null, false, false));
                    }
                } else {
                    this.structureCache.put(chunkCoord, new CustomObjectStructure(this.world, null, false, false));
                }
            }
        } else {
            OTG.log(LogMarker.ERROR, "Illegal double spawn detected, aborting...", new Object[0]);
            throw new RuntimeException();
        }
        this.processing = false;
        this.structuresPerChunk.put(chunkCoord, new ArrayList());
    }

    private boolean IsBO3AllowedToSpawnAt(ChunkCoordinate chunkCoord, BO3 BO3ToSpawn) {
        int radius = BO3ToSpawn.getSettings().frequency;
        String bO3NameAndGroupString = BO3ToSpawn.getName() + ";" + BO3ToSpawn.getSettings().bo3Group;
        String[] groupStrings = BO3ToSpawn.getSettings().bo3Group.trim().length() > 0 ? BO3ToSpawn.getSettings().bo3Group.split(",") : null;
        ArrayList<String> groupNames = new ArrayList<String>();
        ArrayList<Integer> groupFrequencies = new ArrayList<Integer>();
        if (groupStrings != null && groupStrings.length > 0) {
            for (int i = 0; i < groupStrings.length; ++i) {
                String[] groupString;
                String[] stringArray = groupString = groupStrings[i].trim().length() > 0 ? groupStrings[i].split(":") : null;
                if (groupString == null || groupString.length != 2) continue;
                groupNames.add(groupString[0].trim());
                groupFrequencies.add(Integer.parseInt(groupString[1].trim()));
            }
        }
        if (radius > 0 || groupNames.size() > 0) {
            float distanceBetweenStructures = 0.0f;
            for (String key : this.spawnedStructures.keySet()) {
                String[] spawnedStructureGroupStrings;
                if (radius > 0 && key.equals(bO3NameAndGroupString)) {
                    ArrayList spawnedCoords = new ArrayList();
                    spawnedCoords.addAll(this.spawnedStructures.get(key));
                    for (ChunkCoordinate cachedChunk : spawnedCoords) {
                        radius = BO3ToSpawn.getSettings().frequency;
                        distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(chunkCoord.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(chunkCoord.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                        if (!(distanceBetweenStructures <= (float)radius)) continue;
                        return false;
                    }
                }
                if (groupNames.size() <= 0) continue;
                ArrayList<String> spawnedStructureGroupNames = new ArrayList<String>();
                ArrayList<Integer> spawnedStructureGroupFrequencies = new ArrayList<Integer>();
                String[] spawnedStructureNameAndGroupString = key.split(";");
                if (spawnedStructureNameAndGroupString.length > 1 && (spawnedStructureGroupStrings = spawnedStructureNameAndGroupString[1].split(",")).length > 0) {
                    for (int i = 0; i < spawnedStructureGroupStrings.length; ++i) {
                        String[] spawnedStructureGroupString;
                        String[] stringArray = spawnedStructureGroupString = spawnedStructureGroupStrings[i].trim().length() > 0 ? spawnedStructureGroupStrings[i].split(":") : null;
                        if (spawnedStructureGroupString == null || spawnedStructureGroupString.length != 2) continue;
                        spawnedStructureGroupNames.add(spawnedStructureGroupString[0].trim());
                        spawnedStructureGroupFrequencies.add(Integer.parseInt(spawnedStructureGroupString[1].trim()));
                    }
                }
                if (spawnedStructureGroupNames.size() <= 0) continue;
                for (int i = 0; i < groupNames.size(); ++i) {
                    for (int j = 0; j < spawnedStructureGroupNames.size(); ++j) {
                        if (!((String)groupNames.get(i)).equals(spawnedStructureGroupNames.get(j))) continue;
                        for (ChunkCoordinate cachedChunk : this.spawnedStructures.get(key)) {
                            radius = (Integer)groupFrequencies.get(i) >= (Integer)spawnedStructureGroupFrequencies.get(j) ? (Integer)groupFrequencies.get(i) : (Integer)spawnedStructureGroupFrequencies.get(j);
                            distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(chunkCoord.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(chunkCoord.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                            if (!(distanceBetweenStructures <= (float)radius)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }

    public void CompressCache() {
        OTG.log(LogMarker.INFO, "Compressing structure-cache and pre-generator data", new Object[0]);
        int structuresRemoved = 0;
        HashMap<ChunkCoordinate, CustomObjectStructure> newStructureCache = new HashMap<ChunkCoordinate, CustomObjectStructure>();
        for (Map.Entry<ChunkCoordinate, CustomObjectStructure> cachedChunk : this.structureCache.entrySet()) {
            if (!this.world.IsInsidePregeneratedRegion(cachedChunk.getKey(), true)) {
                newStructureCache.put(cachedChunk.getKey(), cachedChunk.getValue());
                continue;
            }
            ++structuresRemoved;
            if (cachedChunk.getValue() == null) continue;
            OTG.log(LogMarker.INFO, "Running " + this.world.GetWorldSession().getPreGeneratorIsRunning() + " L" + this.world.GetWorldSession().getPregeneratedBorderLeft() + " R" + this.world.GetWorldSession().getPregeneratedBorderRight() + " T" + this.world.GetWorldSession().getPregeneratedBorderTop() + " B" + this.world.GetWorldSession().getPregeneratedBorderBottom(), new Object[0]);
            OTG.log(LogMarker.INFO, "Error at Chunk X" + cachedChunk.getKey().getChunkX() + " Z" + cachedChunk.getKey().getChunkZ() + ". " + (!this.structureCache.containsKey(cachedChunk.getKey()) ? (this.world.IsInsidePregeneratedRegion(cachedChunk.getKey(), true) ? "Inside pregenned region" : "Not plotted") : (this.structureCache.get(cachedChunk.getKey()) == null ? "Plotted and spawned" : (this.structureCache.get((Object)cachedChunk.getKey()).Start != null ? this.structureCache.get((Object)cachedChunk.getKey()).Start.BO3Name : "Trees"))), new Object[0]);
            throw new RuntimeException();
        }
        this.structureCache = newStructureCache;
        OTG.log(LogMarker.INFO, "Removed " + structuresRemoved + " cached chunks", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveToDisk() {
        Object object;
        block10: {
            OTG.log(LogMarker.INFO, "Saving structure data", new Object[0]);
            int i = 0;
            long starTime = System.currentTimeMillis();
            do {
                object = this.world.getObjectSpawner().lockingObject;
                synchronized (object) {
                    if (!this.world.getObjectSpawner().populating) {
                        this.world.getObjectSpawner().saving = true;
                        break block10;
                    }
                }
                if (i == 0 || i == 100) {
                    OTG.log(LogMarker.INFO, "SaveToDisk waiting on Populate. Although other mods could be causing this and there may not be any problem, this can potentially cause an endless loop!", new Object[0]);
                    i = 0;
                }
                ++i;
            } while (System.currentTimeMillis() - starTime <= 300000L);
            OTG.log(LogMarker.INFO, "SaveToDisk waited on populate longer than 300 seconds, something went wrong!", new Object[0]);
            throw new RuntimeException();
        }
        if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
            this.CompressCache();
        }
        this.SaveStructureCache();
        object = this.world.getObjectSpawner().lockingObject;
        synchronized (object) {
            this.world.getObjectSpawner().saveRequired = false;
            this.world.getObjectSpawner().saving = false;
        }
    }

    private void SaveStructureCache() {
        OTG.log(LogMarker.INFO, "Saving structures and pre-generator data", new Object[0]);
        HashMap<ChunkCoordinate, CustomObjectStructure> worldInfoChunksToSave = new HashMap<ChunkCoordinate, CustomObjectStructure>();
        for (Map.Entry<ChunkCoordinate, CustomObjectStructure> cachedChunk : this.worldInfoChunks.entrySet()) {
            if (cachedChunk.getValue() != null) {
                worldInfoChunksToSave.put(cachedChunk.getKey(), cachedChunk.getValue());
                continue;
            }
            throw new RuntimeException();
        }
        this.SaveStructuresFile(worldInfoChunksToSave);
        for (Map.Entry<ChunkCoordinate, CustomObjectStructure> cachedChunk : this.worldInfoChunks.entrySet()) {
            if (cachedChunk.getValue() == null) continue;
            cachedChunk.getValue().saveRequired = false;
        }
        if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
            ArrayList<ChunkCoordinate> nullChunks = new ArrayList<ChunkCoordinate>();
            for (Map.Entry<ChunkCoordinate, CustomObjectStructure> cachedChunk : this.structureCache.entrySet()) {
                if (cachedChunk.getValue() != null || this.world.IsInsidePregeneratedRegion(cachedChunk.getKey(), true)) continue;
                nullChunks.add(cachedChunk.getKey());
            }
            this.SaveChunksFile(nullChunks, "NullChunks.txt");
            this.SaveChunksMapFile(this.spawnedStructures, "SpawnedStructures.txt");
        }
        OTG.log(LogMarker.INFO, "Saving done", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveStructuresFile(Map<ChunkCoordinate, CustomObjectStructure> structures) {
        int dimensionId = this.world.getDimensionId();
        File occupiedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + "StructureData.txt");
        if (occupiedChunksFile.exists()) {
            occupiedChunksFile.delete();
        }
        StringBuilder stringbuilder = new StringBuilder();
        if (structures.size() > 0) {
            stringbuilder.append("[");
            for (Map.Entry<ChunkCoordinate, CustomObjectStructure> entry : structures.entrySet()) {
                ChunkCoordinate key;
                boolean added;
                ChunkCoordinate chunkCoord = entry.getKey();
                CustomObjectStructure structure = entry.getValue();
                if (stringbuilder.length() > 1) {
                    stringbuilder.append(" ");
                }
                if (structure.Start != null) {
                    stringbuilder.append("[" + entry.getKey().getChunkX() + "," + entry.getKey().getChunkZ() + "][" + structure.Start.BO3Name + "," + structure.Start.rotation.toString() + "," + structure.Start.getX() + "," + structure.Start.getY() + "," + structure.Start.getZ() + "]");
                } else {
                    stringbuilder.append("[" + entry.getKey().getChunkX() + "," + entry.getKey().getChunkZ() + "][Null structure]");
                }
                stringbuilder.append("[");
                if (structure.ObjectsToSpawn.entrySet().size() > 0 && chunkCoord.getChunkX() == structure.Start.getChunkX() && chunkCoord.getChunkZ() == structure.Start.getChunkZ()) {
                    added = false;
                    for (Map.Entry<ChunkCoordinate, Stack<CustomObjectCoordinate>> objectToSpawn : structure.ObjectsToSpawn.entrySet()) {
                        if (added) {
                            stringbuilder.append(";");
                        }
                        key = objectToSpawn.getKey();
                        stringbuilder.append(key.getChunkX() + "," + key.getChunkZ());
                        added = true;
                        Stack<CustomObjectCoordinate> coords = objectToSpawn.getValue();
                        for (CustomObjectCoordinate coord : coords) {
                            stringbuilder.append("," + coord.BO3Name + "," + coord.rotation.toString() + "," + coord.getX() + "," + coord.getY() + "," + coord.getZ());
                        }
                    }
                }
                stringbuilder.append("][");
                if (structure.SmoothingAreasToSpawn.entrySet().size() > 0 && chunkCoord.getChunkX() == structure.Start.getChunkX() && chunkCoord.getChunkZ() == structure.Start.getChunkZ()) {
                    added = false;
                    for (Map.Entry<ChunkCoordinate, ArrayList<Object[]>> smoothingAreaToSpawn : structure.SmoothingAreasToSpawn.entrySet()) {
                        if (added) {
                            stringbuilder.append(";");
                        }
                        key = smoothingAreaToSpawn.getKey();
                        stringbuilder.append(key.getChunkX() + "," + key.getChunkZ());
                        added = true;
                        ArrayList<Object[]> coords2 = smoothingAreaToSpawn.getValue();
                        for (Object[] coord : coords2) {
                            String append = ":";
                            for (int i = 0; i < coord.length; ++i) {
                                append = append.length() == 1 ? append + coord[i] : append + "," + coord[i];
                            }
                            stringbuilder.append(append);
                        }
                    }
                }
                stringbuilder.append("][");
                if (structure.modData.size() > 0 && chunkCoord.getChunkX() == structure.Start.getChunkX() && chunkCoord.getChunkZ() == structure.Start.getChunkZ()) {
                    added = false;
                    for (ModDataFunction modData : structure.modData) {
                        if (added) {
                            stringbuilder.append(":");
                        }
                        stringbuilder.append(modData.x + "," + modData.y + "," + modData.z + "," + modData.modId.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + modData.modData.replace(":", "&#58;").replace(" ", "&nbsp;"));
                        added = true;
                    }
                }
                stringbuilder.append("][");
                if (structure.spawnerData.size() > 0 && chunkCoord.getChunkX() == structure.Start.getChunkX() && chunkCoord.getChunkZ() == structure.Start.getChunkZ()) {
                    added = false;
                    for (SpawnerFunction spawnerData : structure.spawnerData) {
                        if (added) {
                            stringbuilder.append(":");
                        }
                        stringbuilder.append(spawnerData.x + "," + spawnerData.y + "," + spawnerData.z + "," + spawnerData.mobName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + spawnerData.originalnbtFileName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + spawnerData.nbtFileName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + spawnerData.groupSize + "," + spawnerData.interval + "," + spawnerData.spawnChance + "," + spawnerData.maxCount + "," + spawnerData.despawnTime + "," + spawnerData.velocityX + "," + spawnerData.velocityY + "," + spawnerData.velocityZ + "," + spawnerData.velocityXSet + "," + spawnerData.velocityYSet + "," + spawnerData.velocityZSet + "," + spawnerData.yaw + "," + spawnerData.pitch);
                        added = true;
                    }
                }
                stringbuilder.append("][");
                if (structure.particleData.size() > 0 && chunkCoord.getChunkX() == structure.Start.getChunkX() && chunkCoord.getChunkZ() == structure.Start.getChunkZ()) {
                    added = false;
                    for (ParticleFunction particleData : structure.particleData) {
                        if (added) {
                            stringbuilder.append(":");
                        }
                        stringbuilder.append(particleData.x + "," + particleData.y + "," + particleData.z + "," + particleData.particleName.replace(":", "&#58;").replace(" ", "&nbsp;") + "," + particleData.interval + "," + particleData.velocityX + "," + particleData.velocityY + "," + particleData.velocityZ + "," + particleData.velocityXSet + "," + particleData.velocityYSet + "," + particleData.velocityZSet);
                        added = true;
                    }
                }
                stringbuilder.append("]");
            }
            stringbuilder.append("]");
            BufferedWriter writer = null;
            try {
                if (occupiedChunksFile.exists()) {
                    occupiedChunksFile.delete();
                }
                occupiedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(occupiedChunksFile));
                writer.write(stringbuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void LoadStructureCache() {
        OTG.log(LogMarker.INFO, "Loading structures and pre-generator data", new Object[0]);
        int structuresLoaded = 0;
        Map<ChunkCoordinate, CustomObjectStructure> loadedStructures = this.LoadStructuresFile();
        for (Map.Entry<ChunkCoordinate, CustomObjectStructure> loadedStructure : loadedStructures.entrySet()) {
            ++structuresLoaded;
            if (loadedStructure == null) {
                throw new RuntimeException();
            }
            this.worldInfoChunks.put(loadedStructure.getKey(), loadedStructure.getValue());
            if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
                if (!this.world.IsInsidePregeneratedRegion(loadedStructure.getKey(), true) && !this.structureCache.containsKey(loadedStructure.getKey())) {
                    this.structureCache.put(loadedStructure.getKey(), loadedStructure.getValue());
                }
                for (ChunkCoordinate chunkCoord : loadedStructure.getValue().ObjectsToSpawn.keySet()) {
                    if (!this.world.IsInsidePregeneratedRegion(chunkCoord, true)) {
                        this.structureCache.put(chunkCoord, loadedStructure.getValue());
                        continue;
                    }
                    throw new RuntimeException();
                }
                for (ChunkCoordinate chunkCoord : loadedStructure.getValue().SmoothingAreasToSpawn.keySet()) {
                    if (!this.world.IsInsidePregeneratedRegion(chunkCoord, true)) {
                        this.structureCache.put(chunkCoord, loadedStructure.getValue());
                        continue;
                    }
                    throw new RuntimeException();
                }
            }
            for (ModDataFunction modDataFunc : loadedStructure.getValue().modData) {
                this.worldInfoChunks.put(ChunkCoordinate.fromBlockCoords(modDataFunc.x, modDataFunc.z), loadedStructure.getValue());
            }
            for (SpawnerFunction spawnerFunc : loadedStructure.getValue().spawnerData) {
                this.worldInfoChunks.put(ChunkCoordinate.fromBlockCoords(spawnerFunc.x, spawnerFunc.z), loadedStructure.getValue());
            }
            for (ParticleFunction particleFunc : loadedStructure.getValue().particleData) {
                this.worldInfoChunks.put(ChunkCoordinate.fromBlockCoords(particleFunc.x, particleFunc.z), loadedStructure.getValue());
            }
        }
        OTG.log(LogMarker.INFO, "Loaded " + structuresLoaded + " structure chunks", new Object[0]);
        if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
            ArrayList<ChunkCoordinate> nullChunks = this.LoadChunksFile("NullChunks.txt");
            for (ChunkCoordinate chunkCoord : nullChunks) {
                this.structureCache.remove(chunkCoord);
                if (!this.world.IsInsidePregeneratedRegion(chunkCoord, true)) {
                    this.structureCache.put(chunkCoord, null);
                    continue;
                }
                OTG.log(LogMarker.INFO, "Running " + this.world.GetWorldSession().getPreGeneratorIsRunning() + " L" + this.world.GetWorldSession().getPregeneratedBorderLeft() + " R" + this.world.GetWorldSession().getPregeneratedBorderRight() + " T" + this.world.GetWorldSession().getPregeneratedBorderTop() + " B" + this.world.GetWorldSession().getPregeneratedBorderBottom(), new Object[0]);
                OTG.log(LogMarker.INFO, "Error at Chunk X" + chunkCoord.getChunkX() + " Z" + chunkCoord.getChunkZ(), new Object[0]);
                throw new RuntimeException();
            }
            this.spawnedStructures = this.LoadChunksMapFile("SpawnedStructures.txt");
            for (ChunkCoordinate chunkCoord : this.structureCache.keySet()) {
                this.structuresPerChunk.put(chunkCoord, new ArrayList());
            }
            if (loadedStructures.size() > 0 || nullChunks.size() > 0 || this.spawnedStructures.size() > 0) {
                this.world.getObjectSpawner().StructurePlottedAtSpawn = true;
            }
        }
        OTG.log(LogMarker.INFO, "Loading done", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<ChunkCoordinate, CustomObjectStructure> LoadStructuresFile() {
        HashMap<ChunkCoordinate, CustomObjectStructure> structuresFile = new HashMap<ChunkCoordinate, CustomObjectStructure>();
        int dimensionId = this.world.getDimensionId();
        File occupiedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + "StructureData.txt");
        StringBuilder stringbuilder = new StringBuilder();
        if (occupiedChunksFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(occupiedChunksFile));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        } else {
            return structuresFile;
        }
        String[] structuresString = stringbuilder.toString().substring(1, stringbuilder.length() - 1).split(" ");
        for (int i = 0; i < structuresString.length; ++i) {
            String[] structureStringArray = structuresString[i].substring(1, structuresString[i].length() - 1).split("\\]\\[");
            String structureString = structureStringArray[1];
            int minY = 0;
            CustomObjectCoordinate structureStart = null;
            HashMap<ChunkCoordinate, Stack<CustomObjectCoordinate>> ObjectsToSpawn = new HashMap<ChunkCoordinate, Stack<CustomObjectCoordinate>>();
            HashMap<ChunkCoordinate, ArrayList<Object[]>> SmoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<Object[]>>();
            HashSet<ModDataFunction> ModData = new HashSet<ModDataFunction>();
            HashSet<SpawnerFunction> SpawnerData = new HashSet<SpawnerFunction>();
            HashSet<ParticleFunction> ParticleData = new HashSet<ParticleFunction>();
            String[] chunkCoordString = structureStringArray[0].split(",");
            int chunkX = Integer.parseInt(chunkCoordString[0]);
            int chunkZ = Integer.parseInt(chunkCoordString[1]);
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
            if (!structureString.equals("Null structure")) {
                ChunkCoordinate chunk;
                String[] objectAsString;
                structureStart = new CustomObjectCoordinate(this.world, null, null, null, 0, 0, 0, false, 0, false, false, null);
                stringbuilder = null;
                String[] structureStartString = structureStringArray[1].split(",");
                String[] objectsToSpawnString = new String[]{};
                if (structureStringArray.length > 2 && !structureStringArray[2].equals("")) {
                    objectsToSpawnString = structureStringArray[2].split(";");
                }
                String[] smoothingAreasToSpawnString = new String[]{};
                if (structureStringArray.length > 3 && !structureStringArray[3].equals("")) {
                    smoothingAreasToSpawnString = structureStringArray[3].split(";");
                }
                String[] modDataString = new String[]{};
                if (structureStringArray.length > 4 && !structureStringArray[4].equals("")) {
                    modDataString = structureStringArray[4].split(":");
                }
                String[] spawnerDataString = new String[]{};
                if (structureStringArray.length > 5 && !structureStringArray[5].equals("")) {
                    spawnerDataString = structureStringArray[5].split(":");
                }
                String[] particleDataString = new String[]{};
                if (structureStringArray.length > 6 && !structureStringArray[6].equals("")) {
                    particleDataString = structureStringArray[6].split(":");
                }
                structureStart.BO3Name = structureStartString[0];
                structureStart.rotation = Rotation.FromString(structureStartString[1]);
                structureStart.x = Integer.parseInt(structureStartString[2]);
                structureStart.y = Integer.parseInt(structureStartString[3]);
                structureStart.z = Integer.parseInt(structureStartString[4]);
                for (String objectToSpawn : objectsToSpawnString) {
                    objectAsString = objectToSpawn.split(",");
                    chunk = ChunkCoordinate.fromChunkCoords(Integer.parseInt(objectAsString[0]), Integer.parseInt(objectAsString[1]));
                    Stack<CustomObjectCoordinate> coords = new Stack<CustomObjectCoordinate>();
                    for (int j = 2; j < objectAsString.length; j += 5) {
                        CustomObjectCoordinate coord = new CustomObjectCoordinate(this.world, null, null, null, 0, 0, 0, false, 0, false, false, null);
                        coord.BO3Name = objectAsString[j];
                        coord.rotation = Rotation.FromString(objectAsString[j + 1]);
                        coord.x = Integer.parseInt(objectAsString[j + 2]);
                        coord.y = Integer.parseInt(objectAsString[j + 3]);
                        coord.z = Integer.parseInt(objectAsString[j + 4]);
                        coords.add(coord);
                    }
                    ObjectsToSpawn.put(chunk, coords);
                }
                for (String smoothingAreaToSpawn : smoothingAreasToSpawnString) {
                    objectAsString = smoothingAreaToSpawn.split(":");
                    chunk = ChunkCoordinate.fromChunkCoords(Integer.parseInt(objectAsString[0].split(",")[0]), Integer.parseInt(objectAsString[0].split(",")[1]));
                    ArrayList<Object[]> coords2 = new ArrayList<Object[]>();
                    for (String objectArray : objectAsString) {
                        if (objectArray == objectAsString[0]) continue;
                        ArrayList<Integer> objects = new ArrayList<Integer>();
                        for (String object : objectArray.split(",")) {
                            objects.add(Integer.parseInt(object));
                        }
                        coords2.add(objects.toArray());
                    }
                    SmoothingAreasToSpawn.put(chunk, coords2);
                }
                for (String modData : modDataString) {
                    objectAsString = modData.split(",");
                    for (int j = 0; j < objectAsString.length; j += 5) {
                        ModDataFunction modDataFunction = new ModDataFunction();
                        modDataFunction.x = Integer.parseInt(objectAsString[j]);
                        modDataFunction.y = Integer.parseInt(objectAsString[j + 1]);
                        modDataFunction.z = Integer.parseInt(objectAsString[j + 2]);
                        modDataFunction.modId = objectAsString[j + 3].replace("&#58;", ":").replace("&nbsp;", " ");
                        modDataFunction.modData = objectAsString[j + 4].replace("&#58;", ":").replace("&nbsp;", " ");
                        ModData.add(modDataFunction);
                    }
                }
                for (String spawnerData : spawnerDataString) {
                    objectAsString = spawnerData.split(",");
                    for (int j = 0; j < objectAsString.length; j += 19) {
                        SpawnerFunction spawnerFunction = new SpawnerFunction();
                        spawnerFunction.x = Integer.parseInt(objectAsString[j]);
                        spawnerFunction.y = Integer.parseInt(objectAsString[j + 1]);
                        spawnerFunction.z = Integer.parseInt(objectAsString[j + 2]);
                        spawnerFunction.mobName = objectAsString[j + 3].replace("&#58;", ":").replace("&nbsp;", " ");
                        spawnerFunction.originalnbtFileName = objectAsString[j + 4].replace("&#58;", ":").replace("&nbsp;", " ");
                        spawnerFunction.nbtFileName = objectAsString[j + 5].replace("&#58;", ":").replace("&nbsp;", " ");
                        spawnerFunction.groupSize = Integer.parseInt(objectAsString[j + 6]);
                        spawnerFunction.interval = Integer.parseInt(objectAsString[j + 7]);
                        spawnerFunction.spawnChance = Integer.parseInt(objectAsString[j + 8]);
                        spawnerFunction.maxCount = Integer.parseInt(objectAsString[j + 9]);
                        spawnerFunction.despawnTime = Integer.parseInt(objectAsString[j + 10]);
                        spawnerFunction.velocityX = Double.parseDouble(objectAsString[j + 11]);
                        spawnerFunction.velocityY = Double.parseDouble(objectAsString[j + 12]);
                        spawnerFunction.velocityZ = Double.parseDouble(objectAsString[j + 13]);
                        spawnerFunction.velocityXSet = Boolean.parseBoolean(objectAsString[j + 14]);
                        spawnerFunction.velocityYSet = Boolean.parseBoolean(objectAsString[j + 15]);
                        spawnerFunction.velocityZSet = Boolean.parseBoolean(objectAsString[j + 16]);
                        spawnerFunction.yaw = Float.parseFloat(objectAsString[j + 17]);
                        spawnerFunction.pitch = Float.parseFloat(objectAsString[j + 18]);
                        SpawnerData.add(spawnerFunction);
                    }
                }
                for (String particleData : particleDataString) {
                    objectAsString = particleData.split(",");
                    for (int j = 0; j < objectAsString.length; j += 11) {
                        ParticleFunction particleFunction = new ParticleFunction();
                        particleFunction.x = Integer.parseInt(objectAsString[j]);
                        particleFunction.y = Integer.parseInt(objectAsString[j + 1]);
                        particleFunction.z = Integer.parseInt(objectAsString[j + 2]);
                        particleFunction.particleName = objectAsString[j + 3].replace("&#58;", ":").replace("&nbsp;", " ");
                        particleFunction.interval = Double.parseDouble(objectAsString[j + 4]);
                        particleFunction.velocityX = Double.parseDouble(objectAsString[j + 5]);
                        particleFunction.velocityY = Double.parseDouble(objectAsString[j + 6]);
                        particleFunction.velocityZ = Double.parseDouble(objectAsString[j + 7]);
                        particleFunction.velocityXSet = Boolean.parseBoolean(objectAsString[j + 8]);
                        particleFunction.velocityYSet = Boolean.parseBoolean(objectAsString[j + 9]);
                        particleFunction.velocityZSet = Boolean.parseBoolean(objectAsString[j + 10]);
                        ParticleData.add(particleFunction);
                    }
                }
            }
            CustomObjectStructure structure = this.world.getConfigs().getWorldConfig().IsOTGPlus ? new CustomObjectStructure(this.world, structureStart, ObjectsToSpawn, SmoothingAreasToSpawn, minY) : new CustomObjectStructure(structureStart);
            structure.startChunkBlockChecksDone = true;
            structure.saveRequired = false;
            structure.modData = ModData;
            structure.spawnerData = SpawnerData;
            structure.particleData = ParticleData;
            structuresFile.put(chunkCoord, structure);
        }
        return structuresFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SaveChunksFile(ArrayList<ChunkCoordinate> chunks, String fileName) {
        int dimensionId = this.world.getDimensionId();
        File occupiedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + fileName);
        if (occupiedChunksFile.exists()) {
            occupiedChunksFile.delete();
        }
        if (chunks.size() > 0) {
            StringBuilder stringbuilder = new StringBuilder();
            for (ChunkCoordinate chunkCoord : chunks) {
                if (stringbuilder.length() > 0) {
                    stringbuilder.append("," + chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ());
                    continue;
                }
                stringbuilder.append(chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ());
            }
            BufferedWriter writer = null;
            try {
                occupiedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(occupiedChunksFile));
                writer.write(stringbuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ChunkCoordinate> LoadChunksFile(String fileName) {
        int dimensionId = this.world.getDimensionId();
        File occupiedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + fileName);
        StringBuilder stringbuilder = new StringBuilder();
        String[] occupiedChunkCoords = new String[]{};
        if (occupiedChunksFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(occupiedChunksFile));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        occupiedChunkCoords = stringbuilder.toString().split(",");
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<ChunkCoordinate> chunks = new ArrayList<ChunkCoordinate>();
        if (occupiedChunkCoords.length > 0) {
            for (int i = 0; i < occupiedChunkCoords.length; i += 2) {
                chunks.add(ChunkCoordinate.fromChunkCoords(Integer.parseInt(occupiedChunkCoords[i]), Integer.parseInt(occupiedChunkCoords[i + 1])));
            }
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void SaveChunksMapFile(Map<String, Stack<ChunkCoordinate>> chunksMap, String fileName) {
        int dimensionId = this.world.getDimensionId();
        File occupiedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + fileName);
        if (occupiedChunksFile.exists()) {
            occupiedChunksFile.delete();
        }
        if (chunksMap.size() > 0) {
            StringBuilder stringbuilder = new StringBuilder();
            for (Map.Entry<String, Stack<ChunkCoordinate>> entry : chunksMap.entrySet()) {
                if (stringbuilder.length() == 0) {
                    stringbuilder.append(entry.getKey().replace(",", "\\"));
                } else {
                    stringbuilder.append("/" + entry.getKey().replace(",", "\\"));
                }
                for (ChunkCoordinate chunkCoord : entry.getValue()) {
                    stringbuilder.append("," + chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ());
                }
            }
            BufferedWriter writer = null;
            try {
                occupiedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(occupiedChunksFile));
                writer.write(stringbuilder.toString());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Stack<ChunkCoordinate>> LoadChunksMapFile(String fileName) {
        int dimensionId = this.world.getDimensionId();
        File occupiedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + fileName);
        HashMap<String, Stack<ChunkCoordinate>> chunks = new HashMap<String, Stack<ChunkCoordinate>>();
        StringBuilder stringbuilder = new StringBuilder();
        String[] occupiedChunks = new String[]{};
        if (occupiedChunksFile.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new FileReader(occupiedChunksFile));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        occupiedChunks = stringbuilder.toString().split("/");
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        String[] occupiedChunkCoords = new String[]{};
        for (String entry : occupiedChunks) {
            occupiedChunkCoords = entry.split(",");
            String key = occupiedChunkCoords[0].replace("\\", ",");
            Stack<ChunkCoordinate> value = new Stack<ChunkCoordinate>();
            if (occupiedChunkCoords.length > 0) {
                for (int i = 1; i < occupiedChunkCoords.length; i += 2) {
                    value.add(ChunkCoordinate.fromChunkCoords(Integer.parseInt(occupiedChunkCoords[i]), Integer.parseInt(occupiedChunkCoords[i + 1])));
                }
            }
            chunks.put(key, value);
        }
        return chunks;
    }
}

