/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo2;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.CustomObjectConfigFile;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.SettingsWriterOTGPlus;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo2.BO2Settings;
import com.pg85.otg.customobjects.bo2.ObjectCoordinate;
import com.pg85.otg.util.BoundingBox;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.MaterialSet;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class BO2
extends CustomObjectConfigFile
implements CustomObject {
    public ObjectCoordinate[][] data = new ObjectCoordinate[4][];
    public BO2[] groupObjects = null;
    public List<String> spawnInBiome;
    public String version;
    public MaterialSet spawnOnBlockType;
    public MaterialSet collisionBlockType;
    public boolean spawnWater;
    public boolean spawnLava;
    public boolean spawnAboveGround;
    public boolean spawnUnderGround;
    public boolean spawnSunlight;
    public boolean spawnDarkness;
    public boolean underFill;
    public boolean randomRotation;
    public boolean dig;
    public boolean tree;
    public boolean branch;
    public boolean diggingBranch;
    public boolean needsFoundation;
    public int rarity;
    public double collisionPercentage;
    public int spawnElevationMin;
    public int spawnElevationMax;
    public int groupFrequencyMin;
    public int groupFrequencyMax;
    public int groupSeparationMin;
    public int groupSeparationMax;
    public List<String> groupId;
    public int branchLimit;

    private void setBlock(LocalWorld world, int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean isStructureAtSpawn) {
        LocalMaterialData targetBlock;
        HashMap<DefaultMaterial, LocalMaterialData> blocksToReplace = world.getConfigs().getWorldConfig().getReplaceBlocksDict();
        if (blocksToReplace != null && blocksToReplace.size() > 0 && (targetBlock = blocksToReplace.get(material)) != null) {
            material = targetBlock;
        }
        world.setBlock(x, y, z, material, metaDataTag, false);
    }

    public BO2(SettingsReaderOTGPlus reader) {
        super(reader);
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
        this.enable();
    }

    private void enable() {
        this.readConfigSettings();
        this.correctSettings();
    }

    @Override
    public CustomObject applySettings(SettingsReaderOTGPlus extraSettings) {
        extraSettings.setFallbackReader(this.reader);
        BO2 bo2WithSettings = new BO2(extraSettings);
        bo2WithSettings.enable();
        return bo2WithSettings;
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.tree;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.randomRotation;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        ObjectCoordinate[] data;
        for (ObjectCoordinate point : data = this.data[rotation.getRotationId()]) {
            if (world.isNullOrAir(x + point.x, y + point.y, z + point.z, false)) {
                this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false);
                continue;
            }
            if (!this.dig) continue;
            this.setBlock(world, x + point.x, y + point.y, z + point.z, point.material, null, false);
        }
        return true;
    }

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        throw new RuntimeException();
    }

    private boolean canSpawnAt(LocalWorld world, Rotation rotation, int x, int y, int z) {
        int checkLight;
        LocalMaterialData checkBlock;
        if (y < 0 || y >= 256) {
            return false;
        }
        if (y < this.spawnElevationMin || y > this.spawnElevationMax) {
            return false;
        }
        if (!this.spawnOnBlockType.contains(world.getMaterial(x, y - 1, z, false))) {
            return false;
        }
        if (this.needsFoundation && world.isNullOrAir(x, y - 5, z, false)) {
            return false;
        }
        LocalMaterialData localMaterialData = checkBlock = !this.spawnWater || !this.spawnLava ? world.getMaterial(x, y + 2, z, false) : null;
        if (!this.spawnWater && (checkBlock.equals((Object)DefaultMaterial.WATER) || checkBlock.equals((Object)DefaultMaterial.STATIONARY_WATER))) {
            return false;
        }
        if (!this.spawnLava && (checkBlock.equals((Object)DefaultMaterial.LAVA) || checkBlock.equals((Object)DefaultMaterial.STATIONARY_LAVA))) {
            return false;
        }
        int n = checkLight = !this.spawnSunlight || !this.spawnDarkness ? world.getLightLevel(x, y + 2, z) : 0;
        if (!this.spawnSunlight && checkLight > 8) {
            return false;
        }
        if (!this.spawnDarkness && checkLight < 9) {
            return false;
        }
        ObjectCoordinate[] objData = this.data[rotation.getRotationId()];
        HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
        for (ObjectCoordinate point : objData) {
            if (y + point.y < 0 || y + point.y >= 256) {
                return false;
            }
            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x + point.x, z + point.z);
            if (loadedChunks.contains(chunkCoord)) continue;
            if (!world.isLoaded(x + point.x, y + point.y, z + point.z)) {
                return false;
            }
            loadedChunks.add(chunkCoord);
        }
        if ((int)this.collisionPercentage >= 100) {
            throw new RuntimeException();
        }
        if (!this.dig && (int)this.collisionPercentage < 100) {
            int faultCounter = 0;
            int maxBlocksOutsideSourceBlock = (int)Math.ceil((double)objData.length * (this.collisionPercentage / 100.0));
            for (ObjectCoordinate point : objData) {
                if (!this.collisionBlockType.contains(world.getMaterial(x + point.x, y + point.y, z + point.z, false)) || ++faultCounter <= maxBlocksOutsideSourceBlock) continue;
                return false;
            }
        }
        return OTG.fireCanCustomObjectSpawnEvent(this, world, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        return this.spawn(world, random, x, z);
    }

    protected boolean spawn(LocalWorld world, Random random, int x, int z) {
        Rotation rotation;
        int y;
        if (this.spawnAboveGround) {
            y = world.getSolidHeight(x, z);
        } else if (this.spawnUnderGround) {
            int solidHeight = world.getSolidHeight(x, z);
            if (solidHeight < 1 || solidHeight <= this.spawnElevationMin) {
                return false;
            }
            if (solidHeight > this.spawnElevationMax) {
                solidHeight = this.spawnElevationMax;
            }
            y = random.nextInt(solidHeight - this.spawnElevationMin) + this.spawnElevationMin;
        } else {
            y = world.getHighestBlockYAt(x, z);
        }
        if (y < 0) {
            return false;
        }
        Rotation rotation2 = rotation = this.randomRotation ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        if (!this.canSpawnAt(world, rotation, x, y, z)) {
            return false;
        }
        boolean objectSpawned = this.spawnForced(world, random, rotation, x, y, z);
        return objectSpawned;
    }

    @Override
    public boolean process(LocalWorld world, Random rand, ChunkCoordinate chunkCoord) {
        if (this.branch) {
            return false;
        }
        int randomRoll = rand.nextInt(100);
        boolean objectSpawned = false;
        for (int ObjectRarity = this.rarity; randomRoll < ObjectRarity; ObjectRarity -= 100) {
            int x = chunkCoord.getBlockX() + rand.nextInt(16);
            int z = chunkCoord.getBlockZ() + rand.nextInt(16);
            objectSpawned = this.spawn(world, rand, x, z);
        }
        return objectSpawned;
    }

    @Override
    protected void writeConfigSettings(SettingsWriterOTGPlus writer) throws IOException {
    }

    @Override
    protected void readConfigSettings() {
        this.version = this.readSettings(BO2Settings.VERSION);
        this.spawnOnBlockType = this.readSettings(BO2Settings.SPAWN_ON_BLOCK_TYPE);
        this.collisionBlockType = this.readSettings(BO2Settings.COLLISTION_BLOCK_TYPE);
        this.spawnInBiome = this.readSettings(BO2Settings.SPAWN_IN_BIOME);
        this.spawnSunlight = this.readSettings(BO2Settings.SPAWN_SUNLIGHT);
        this.spawnDarkness = this.readSettings(BO2Settings.SPAWN_DARKNESS);
        this.spawnWater = this.readSettings(BO2Settings.SPAWN_WATER);
        this.spawnLava = this.readSettings(BO2Settings.SPAWN_LAVA);
        this.spawnAboveGround = this.readSettings(BO2Settings.SPAWN_ABOVE_GROUND);
        this.spawnUnderGround = this.readSettings(BO2Settings.SPAWN_UNDER_GROUND);
        this.underFill = this.readSettings(BO2Settings.UNDER_FILL);
        this.randomRotation = this.readSettings(BO2Settings.RANDON_ROTATION);
        this.dig = this.readSettings(BO2Settings.DIG);
        this.tree = this.readSettings(BO2Settings.TREE);
        this.branch = this.readSettings(BO2Settings.BRANCH);
        this.diggingBranch = this.readSettings(BO2Settings.DIGGING_BRANCH);
        this.needsFoundation = this.readSettings(BO2Settings.NEEDS_FOUNDATION);
        this.rarity = this.readSettings(BO2Settings.RARITY);
        this.collisionPercentage = this.readSettings(BO2Settings.COLLISION_PERCENTAGE);
        this.spawnElevationMin = this.readSettings(BO2Settings.SPAWN_ELEVATION_MIN);
        this.spawnElevationMax = this.readSettings(BO2Settings.SPAWN_ELEVATION_MAX);
        this.groupFrequencyMin = this.readSettings(BO2Settings.GROUP_FREQUENCY_MIN);
        this.groupFrequencyMax = this.readSettings(BO2Settings.GROUP_FREQUENCY_MAX);
        this.groupSeparationMin = this.readSettings(BO2Settings.GROUP_SEPERATION_MIN);
        this.groupSeparationMax = this.readSettings(BO2Settings.GROUP_SEPERATION_MAX);
        this.groupId = this.readSettings(BO2Settings.GROUP_ID);
        this.branchLimit = this.readSettings(BO2Settings.BRANCH_LIMIT);
        this.readCoordinates();
    }

    @Override
    protected void correctSettings() {
    }

    @Override
    protected void renameOldSettings() {
    }

    private void readCoordinates() {
        ArrayList<ObjectCoordinate> coordinates = new ArrayList<ObjectCoordinate>();
        for (Map.Entry<String, String> line : this.reader.getRawSettings()) {
            ObjectCoordinate buffer = ObjectCoordinate.getCoordinateFromString(line.getKey(), line.getValue());
            if (buffer == null) continue;
            coordinates.add(buffer);
        }
        this.data[0] = new ObjectCoordinate[coordinates.size()];
        this.data[1] = new ObjectCoordinate[coordinates.size()];
        this.data[2] = new ObjectCoordinate[coordinates.size()];
        this.data[3] = new ObjectCoordinate[coordinates.size()];
        for (int i = 0; i < coordinates.size(); ++i) {
            ObjectCoordinate coordinate;
            this.data[0][i] = coordinate = (ObjectCoordinate)coordinates.get(i);
            this.data[1][i] = coordinate = coordinate.Rotate();
            this.data[2][i] = coordinate = coordinate.Rotate();
            this.data[3][i] = coordinate = coordinate.Rotate();
        }
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return this.spawnInBiome.contains(biome.getName()) || this.spawnInBiome.contains("All");
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return BoundingBox.newEmptyBox();
    }

    @Override
    public int getMaxBranchDepth() {
        return 0;
    }
}

