/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.configuration.io.FileSettingsReaderOTGPlus;
import com.pg85.otg.configuration.io.FileSettingsWriterOTGPlus;
import com.pg85.otg.configuration.io.SettingsReaderOTGPlus;
import com.pg85.otg.customobjects.Branch;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.CustomObjectStructure;
import com.pg85.otg.customobjects.ObjectExtrusionHelper;
import com.pg85.otg.customobjects.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.StructuredCustomObject;
import com.pg85.otg.customobjects.bo3.BO3Check;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo3.BlockFunction;
import com.pg85.otg.customobjects.bo3.EntityFunction;
import com.pg85.otg.customobjects.bo3.ModDataFunction;
import com.pg85.otg.customobjects.bo3.ParticleFunction;
import com.pg85.otg.customobjects.bo3.RandomBlockFunction;
import com.pg85.otg.customobjects.bo3.SpawnerFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.surface.MesaSurfaceGenerator;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.BoundingBox;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.NamedBinaryTag;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.helpers.RandomHelper;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;

public class BO3
implements StructuredCustomObject {
    public boolean isInvalidConfig;
    boolean measured = false;
    int minX = Integer.MAX_VALUE;
    int maxX = Integer.MIN_VALUE;
    int minZ = Integer.MAX_VALUE;
    int maxZ = Integer.MIN_VALUE;
    boolean isCollidable = false;
    public boolean is32x32 = false;
    public static HashMap<ChunkCoordinate, LocalMaterialData> originalTopBlocks = new HashMap();
    private BO3Config settings;
    private final String name;
    private final File file;

    public boolean isCollidable() {
        this.measure();
        return this.isCollidable;
    }

    public BO3(BO3 oldObject, SettingsReaderOTGPlus extraSettings) {
        try {
            this.settings = new BO3Config(extraSettings, null);
        }
        catch (InvalidConfigException e) {
            e.printStackTrace();
        }
        this.settings.inheritBO3 = oldObject.getName();
        this.name = this.settings.getName();
        this.file = this.settings.getFile();
    }

    @Override
    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return this.trySpawnAt(false, null, world, random, rotation, x, y, z);
    }

    /*
     * WARNING - void declaration
     */
    public boolean trySpawnAt(boolean skipChecks, CustomObjectStructure structure, LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        EntityFunction[] entityDataInObject;
        SpawnerFunction[] spawnerDataInObject;
        ModDataFunction[] modDataFunctionArray;
        void var17_27;
        if (!skipChecks) {
            BO3Check[] checks;
            if (y < 0 || y >= 256) {
                return false;
            }
            if (y < this.settings.minHeight || y > this.settings.maxHeight) {
                return false;
            }
            for (BO3Check check : checks = this.settings.bo3Checks[rotation.getRotationId()]) {
                if (!check.preventsSpawn(world, x + check.x, y + check.y, z + check.z)) continue;
                return false;
            }
        }
        BlockFunction[] blocks = this.settings.blocks[rotation.getRotationId()];
        if (!skipChecks) {
            HashSet<ChunkCoordinate> loadedChunks = new HashSet<ChunkCoordinate>();
            for (BlockFunction blockFunction : blocks) {
                if (y + blockFunction.y < 0 || y + blockFunction.y >= 256) {
                    return false;
                }
                ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x + blockFunction.x, z + blockFunction.z);
                if (loadedChunks.contains(chunkCoord)) continue;
                if (!world.isLoaded(x + blockFunction.x, y + blockFunction.y, z + blockFunction.z)) {
                    return false;
                }
                loadedChunks.add(chunkCoord);
            }
        }
        ArrayList<BlockFunction> blocksToSpawn = new ArrayList<BlockFunction>();
        ObjectExtrusionHelper oeh = new ObjectExtrusionHelper(this.settings.extrudeMode, this.settings.extrudeThroughBlocks);
        HashSet<ChunkCoordinate> chunks = new HashSet<ChunkCoordinate>();
        int blocksOutsideSourceBlock = 0;
        int maxBlocksOutsideSourceBlock = (int)Math.ceil((double)blocks.length * ((double)this.settings.maxPercentageOutsideSourceBlock / 100.0));
        BlockFunction[] blockFunctionArray = blocks;
        int n = blockFunctionArray.length;
        boolean bl = false;
        while (var17_27 < n) {
            BlockFunction blockFunction = blockFunctionArray[var17_27];
            if (!skipChecks && (this.settings.maxPercentageOutsideSourceBlock < 100 && blocksOutsideSourceBlock <= maxBlocksOutsideSourceBlock || this.settings.outsideSourceBlock == BO3Settings.OutsideSourceBlock.dontPlace) && !this.settings.sourceBlocks.contains(world.getMaterial(x + blockFunction.x, y + blockFunction.y, z + blockFunction.z, this.settings.isOTGPlus))) {
                if (++blocksOutsideSourceBlock > maxBlocksOutsideSourceBlock) {
                    return false;
                }
                if (this.settings.outsideSourceBlock == BO3Settings.OutsideSourceBlock.placeAnyway) {
                    chunks.add(ChunkCoordinate.fromBlockCoords(x + blockFunction.x, z + blockFunction.z));
                    blocksToSpawn.add(blockFunction);
                }
            } else {
                chunks.add(ChunkCoordinate.fromBlockCoords(x + blockFunction.x, z + blockFunction.z));
                blocksToSpawn.add(blockFunction);
            }
            if (blockFunction instanceof BlockFunction) {
                oeh.addBlock(blockFunction);
            }
            ++var17_27;
        }
        if (!skipChecks && !OTG.fireCanCustomObjectSpawnEvent(this, world, x, y, z)) {
            return false;
        }
        HashSet<ChunkCoordinate> hashSet = new HashSet<ChunkCoordinate>();
        for (BlockFunction blockFunction : blocksToSpawn) {
            blockFunction.spawn(world, random, x + blockFunction.x, y + blockFunction.y, z + blockFunction.z, false);
        }
        oeh.extrude(world, random, x, y, z);
        HashSet<ModDataFunction> newModDataInObject = new HashSet<ModDataFunction>();
        for (ModDataFunction modData : modDataFunctionArray = this.settings.modDataFunctions[rotation.getRotationId()]) {
            ModDataFunction newModData = new ModDataFunction();
            newModData.y = y + modData.y;
            newModData.x = x + modData.x;
            newModData.z = z + modData.z;
            newModData.modData = modData.modData;
            newModData.modId = modData.modId;
            newModDataInObject.add(newModData);
            chunks.add(ChunkCoordinate.fromBlockCoords(newModData.x, newModData.z));
            hashSet.add(ChunkCoordinate.fromBlockCoords(newModData.x, newModData.z));
        }
        HashSet<SpawnerFunction> hashSet2 = new HashSet<SpawnerFunction>();
        for (SpawnerFunction spawnerData : spawnerDataInObject = this.settings.spawnerFunctions[rotation.getRotationId()]) {
            SpawnerFunction newSpawnerData = new SpawnerFunction();
            newSpawnerData.y = y + spawnerData.y;
            newSpawnerData.x = x + spawnerData.x;
            newSpawnerData.z = z + spawnerData.z;
            newSpawnerData.mobName = spawnerData.mobName;
            newSpawnerData.originalnbtFileName = spawnerData.originalnbtFileName;
            newSpawnerData.nbtFileName = spawnerData.nbtFileName;
            newSpawnerData.groupSize = spawnerData.groupSize;
            newSpawnerData.interval = spawnerData.interval;
            newSpawnerData.spawnChance = spawnerData.spawnChance;
            newSpawnerData.maxCount = spawnerData.maxCount;
            newSpawnerData.despawnTime = spawnerData.despawnTime;
            newSpawnerData.velocityX = spawnerData.velocityX;
            newSpawnerData.velocityY = spawnerData.velocityY;
            newSpawnerData.velocityZ = spawnerData.velocityZ;
            newSpawnerData.velocityXSet = spawnerData.velocityXSet;
            newSpawnerData.velocityYSet = spawnerData.velocityYSet;
            newSpawnerData.velocityZSet = spawnerData.velocityZSet;
            newSpawnerData.yaw = spawnerData.yaw;
            newSpawnerData.pitch = spawnerData.pitch;
            hashSet2.add(newSpawnerData);
            chunks.add(ChunkCoordinate.fromBlockCoords(newSpawnerData.x, newSpawnerData.z));
            hashSet.add(ChunkCoordinate.fromBlockCoords(newSpawnerData.x, newSpawnerData.z));
        }
        HashSet<ParticleFunction> newParticleDataInObject = new HashSet<ParticleFunction>();
        ParticleFunction[] particleDataInObject = this.settings.particleFunctions[rotation.getRotationId()];
        for (ParticleFunction particleData : particleDataInObject) {
            ParticleFunction newParticleData = new ParticleFunction();
            newParticleData.y = y + particleData.y;
            newParticleData.x = x + particleData.x;
            newParticleData.z = z + particleData.z;
            newParticleData.particleName = particleData.particleName;
            newParticleData.interval = particleData.interval;
            newParticleData.velocityX = particleData.velocityX;
            newParticleData.velocityY = particleData.velocityY;
            newParticleData.velocityZ = particleData.velocityZ;
            newParticleData.velocityXSet = particleData.velocityXSet;
            newParticleData.velocityYSet = particleData.velocityYSet;
            newParticleData.velocityZSet = particleData.velocityZSet;
            newParticleDataInObject.add(newParticleData);
            chunks.add(ChunkCoordinate.fromBlockCoords(newParticleData.x, newParticleData.z));
            hashSet.add(ChunkCoordinate.fromBlockCoords(newParticleData.x, newParticleData.z));
        }
        if (structure != null) {
            structure.modData.addAll(newModDataInObject);
            structure.particleData.addAll(newParticleDataInObject);
            structure.spawnerData.addAll(hashSet2);
            for (ChunkCoordinate structureCoord : chunks) {
                if (world.getStructureCache().worldInfoChunks.containsKey(structureCoord)) {
                    CustomObjectStructure existingObject = world.getStructureCache().worldInfoChunks.get(structureCoord);
                    structure.modData.addAll(existingObject.modData);
                    structure.particleData.addAll(existingObject.particleData);
                    structure.spawnerData.addAll(existingObject.spawnerData);
                }
                world.getStructureCache().worldInfoChunks.put(structureCoord, structure);
            }
        } else {
            CustomObjectStructure placeHolderStructure = new CustomObjectStructure(new CustomObjectCoordinate(world, this, this.getName(), Rotation.NORTH, x, 0, z));
            placeHolderStructure.modData.addAll(newModDataInObject);
            placeHolderStructure.particleData.addAll(newParticleDataInObject);
            placeHolderStructure.spawnerData.addAll(hashSet2);
            for (ChunkCoordinate structureCoord : hashSet) {
                if (world.getStructureCache().worldInfoChunks.containsKey(structureCoord)) {
                    CustomObjectStructure existingObject = world.getStructureCache().worldInfoChunks.get(structureCoord);
                    existingObject.modData.addAll(placeHolderStructure.modData);
                    existingObject.particleData.addAll(placeHolderStructure.particleData);
                    existingObject.spawnerData.addAll(placeHolderStructure.spawnerData);
                    continue;
                }
                world.getStructureCache().worldInfoChunks.put(structureCoord, placeHolderStructure);
            }
        }
        for (EntityFunction entity : entityDataInObject = this.settings.entityFunctions[rotation.getRotationId()]) {
            EntityFunction newEntityData = new EntityFunction();
            newEntityData.y = y + entity.y;
            newEntityData.x = x + entity.x;
            newEntityData.z = z + entity.z;
            newEntityData.mobName = entity.mobName;
            newEntityData.groupSize = entity.groupSize;
            newEntityData.nameTagOrNBTFileName = entity.nameTagOrNBTFileName;
            newEntityData.originalNameTagOrNBTFileName = entity.originalNameTagOrNBTFileName;
            world.SpawnEntity(newEntityData);
        }
        return true;
    }

    public boolean trySpawnAt(LocalWorld world, Random random, Rotation rotation, ChunkCoordinate chunkCoord, int x, int y, int z, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly) {
        if (this.settings.isOTGPlus) {
            if (!this.measure()) {
                return false;
            }
            return this.spawnForcedOTGPlus(world, random, rotation, chunkCoord, x, y, z, replaceAbove, replaceBelow, replaceWithBiomeBlocks, replaceWithSurfaceBlock, replaceWithGroundBlock, spawnUnderWater, waterLevel, isStructureAtSpawn, doReplaceAboveBelowOnly);
        }
        throw new RuntimeException();
    }

    private boolean measure() {
        if (!this.measured) {
            for (BlockFunction block : this.settings.getBlocks()) {
                this.isCollidable = true;
                if (block.x < this.minX) {
                    this.minX = block.x;
                }
                if (block.x > this.maxX) {
                    this.maxX = block.x;
                }
                if (block.z < this.minZ) {
                    this.minZ = block.z;
                }
                if (block.z <= this.maxZ) continue;
                this.maxZ = block.z;
            }
            if (this.minX == Integer.MAX_VALUE) {
                this.minX = -8;
            }
            if (this.maxX == Integer.MIN_VALUE) {
                this.maxX = -8;
            }
            if (this.minZ == Integer.MAX_VALUE) {
                this.minZ = -7;
            }
            if (this.maxZ == Integer.MIN_VALUE) {
                this.maxZ = -7;
            }
            this.measured = true;
            if (Math.abs(this.minX - this.maxX) > 31 || Math.abs(this.minZ - this.maxZ) > 31) {
                OTG.log(LogMarker.INFO, "BO3 was too large to spawn (> 32x32) " + this.getName() + " XSize " + (Math.abs(this.minX - this.maxX) + 1) + " ZSize " + (Math.abs(this.minZ - this.maxZ) + 1) + ". Convert it to a branching BO3 and add it using CustomStructure()", new Object[0]);
                return false;
            }
            if (Math.abs(this.minX - this.maxX) > 15 || Math.abs(this.minZ - this.maxZ) > 15) {
                this.is32x32 = true;
            }
        }
        return true;
    }

    public boolean spawnForcedOTGPlus(LocalWorld world, Random random, Rotation rotation, ChunkCoordinate chunkCoord, int x, int y, int z, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly) {
        if (!this.measured) {
            throw new RuntimeException();
        }
        LocalMaterialData replaceBelowMaterial = null;
        LocalMaterialData replaceAboveMaterial = null;
        LocalMaterialData bo3SurfaceBlock = null;
        LocalMaterialData bo3GroundBlock = null;
        LocalMaterialData airMaterial = null;
        airMaterial = OTG.toLocalMaterialData(DefaultMaterial.AIR, 0);
        if (this.settings == null) {
            OTG.log(LogMarker.INFO, "Settings was null for BO3 " + this.getName() + ". This should not be happening, please contact the developer.", new Object[0]);
            throw new RuntimeException();
        }
        try {
            bo3SurfaceBlock = replaceWithSurfaceBlock != null && replaceWithSurfaceBlock.length() > 0 ? OTG.readMaterial(replaceWithSurfaceBlock) : OTG.readMaterial("GRASS");
        }
        catch (InvalidConfigException e1) {
            bo3SurfaceBlock = OTG.toLocalMaterialData(DefaultMaterial.GRASS, 0);
            OTG.log(LogMarker.INFO, "Value " + replaceWithSurfaceBlock + " for replaceWithSurfaceBlock in BO3 " + this.getName() + " was not recognised. Using GRASS instead.", new Object[0]);
        }
        try {
            bo3GroundBlock = replaceWithGroundBlock != null && replaceWithGroundBlock.length() > 0 ? OTG.readMaterial(replaceWithGroundBlock) : OTG.readMaterial("DIRT");
        }
        catch (InvalidConfigException e1) {
            bo3GroundBlock = OTG.toLocalMaterialData(DefaultMaterial.DIRT, 0);
            OTG.log(LogMarker.INFO, "Value " + replaceWithGroundBlock + " for replaceWithGroundBlock in BO3 " + this.getName() + " was not recognised. Using DIRT instead.", new Object[0]);
        }
        try {
            replaceBelowMaterial = this.settings.replaceBelow != null && this.settings.replaceBelow.toLowerCase().equals("none") ? null : (replaceBelow != null && replaceBelow.length() > 0 ? OTG.readMaterial(replaceBelow) : null);
        }
        catch (InvalidConfigException e1) {
            replaceBelowMaterial = OTG.toLocalMaterialData(DefaultMaterial.DIRT, 0);
            OTG.log(LogMarker.INFO, "Value " + this.settings.replaceBelow + " for replaceBelow in BO3 " + this.getName() + " was not recognised. Using DIRT instead.", new Object[0]);
        }
        try {
            replaceAboveMaterial = this.settings.replaceAbove != null && this.settings.replaceAbove.toLowerCase().equals("none") ? null : (replaceAbove != null && replaceAbove.length() > 0 ? OTG.readMaterial(replaceAbove) : null);
        }
        catch (InvalidConfigException e1) {
            replaceAboveMaterial = OTG.toLocalMaterialData(DefaultMaterial.AIR, 0);
            OTG.log(LogMarker.INFO, "Value " + this.settings.replaceAbove + " for replaceAbove in BO3 " + this.getName() + " was not recognised. Using AIR instead.", new Object[0]);
        }
        boolean isOnBiomeBorder = false;
        LocalBiome biome = null;
        LocalBiome biome2 = null;
        LocalBiome biome3 = null;
        LocalBiome biome4 = null;
        BiomeConfig biomeConfig = null;
        LocalMaterialData biomeSurfaceBlock = null;
        LocalMaterialData biomeGroundBlock = null;
        if (replaceWithBiomeBlocks) {
            biome = world.getBiome(x, z);
            biome2 = world.getBiome(x + 15, z);
            biome3 = world.getBiome(x, z + 15);
            biome4 = world.getBiome(x + 15, z + 15);
            if (biome != biome2 || biome != biome3 || biome != biome4) {
                isOnBiomeBorder = true;
            }
            biomeConfig = biome.getBiomeConfig();
            biomeSurfaceBlock = biomeConfig.surfaceBlock;
            if (biomeSurfaceBlock == null) {
                biomeSurfaceBlock = OTG.toLocalMaterialData(DefaultMaterial.GRASS, 0);
            }
            if ((biomeGroundBlock = biomeConfig.groundBlock) == null) {
                biomeGroundBlock = OTG.toLocalMaterialData(DefaultMaterial.DIRT, 0);
            }
            if (biomeSurfaceBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                biomeSurfaceBlock = OTG.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
            }
            if (biomeGroundBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                biomeGroundBlock = OTG.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
            }
        }
        ArrayList<Object[]> coordsAboveDone = new ArrayList<Object[]>();
        ArrayList<Object[]> coordsBelowDone = new ArrayList<Object[]>();
        BlockFunction blockToQueueForSpawn = new BlockFunction();
        boolean outOfBounds = false;
        long startTime = System.currentTimeMillis();
        for (BlockFunction block : this.settings.getBlocks()) {
            boolean bFound;
            LocalMaterialData sourceBlockMaterial;
            if (block instanceof RandomBlockFunction) {
                for (int i = 0; i < ((RandomBlockFunction)block).blockCount; ++i) {
                    if (random.nextInt(100) >= ((RandomBlockFunction)block).blockChances[i]) continue;
                    block.metaDataName = ((RandomBlockFunction)block).metaDataNames[i];
                    block.metaDataTag = ((RandomBlockFunction)block).metaDataTags[i];
                    block.material = ((RandomBlockFunction)block).blocks[i];
                    break;
                }
            }
            if (block.material == null || block.material.toDefaultMaterial() == DefaultMaterial.UNKNOWN_BLOCK) continue;
            if (rotation != Rotation.NORTH) {
                boolean bFound2;
                BlockFunction newBlock = new BlockFunction();
                int rotations = 0;
                if (rotation == Rotation.WEST) {
                    rotations = 1;
                } else if (rotation == Rotation.SOUTH) {
                    rotations = 2;
                } else if (rotation == Rotation.EAST) {
                    rotations = 3;
                }
                if (rotations == 0) {
                    newBlock.x = block.x;
                    newBlock.z = block.z;
                }
                if (rotations == 1) {
                    newBlock.x = block.z;
                    newBlock.z = -block.x + (this.is32x32 ? 31 : 15);
                    newBlock.material = block.material.rotate();
                }
                if (rotations == 2) {
                    newBlock.x = -block.x + (this.is32x32 ? 31 : 15);
                    newBlock.z = -block.z + (this.is32x32 ? 31 : 15);
                    newBlock.material = block.material.rotate();
                    newBlock.material = newBlock.material.rotate();
                }
                if (rotations == 3) {
                    newBlock.x = -block.z + (this.is32x32 ? 31 : 15);
                    newBlock.z = block.x;
                    newBlock.material = block.material.rotate();
                    newBlock.material = newBlock.material.rotate();
                    newBlock.material = newBlock.material.rotate();
                }
                newBlock.y = block.y;
                newBlock.metaDataName = block.metaDataName;
                newBlock.metaDataTag = block.metaDataTag;
                if (!originalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(x + newBlock.x, z + newBlock.z))) {
                    int highestBlockY = world.getHighestBlockYAt(x + newBlock.x, z + newBlock.z, true, true, false, false);
                    if (highestBlockY <= 0) {
                        highestBlockY = 1;
                    }
                    if (highestBlockY >= 256) {
                        highestBlockY = 255;
                    }
                    originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(x + newBlock.x, z + newBlock.z), world.getMaterial(x + newBlock.x, highestBlockY, z + newBlock.z, this.settings.isOTGPlus));
                }
                if (replaceAboveMaterial != null && doReplaceAboveBelowOnly) {
                    bFound2 = false;
                    for (Object[] coords : coordsAboveDone) {
                        if ((Integer)coords[0] != x + newBlock.x || (Integer)coords[1] != z + newBlock.z) continue;
                        bFound2 = true;
                        break;
                    }
                    if (!bFound2) {
                        coordsAboveDone.add(new Object[]{x + newBlock.x, z + newBlock.z});
                        int highestBlockToReplace = world.getHighestBlockYAt(x + newBlock.x, z + newBlock.z, true, true, false, false);
                        for (int blockY = y + newBlock.y + 1; blockY <= highestBlockToReplace && blockY > y + newBlock.y; ++blockY) {
                            blockToQueueForSpawn = new BlockFunction();
                            blockToQueueForSpawn.material = spawnUnderWater && blockY >= waterLevel ? airMaterial : replaceAboveMaterial;
                            blockToQueueForSpawn.x = x + newBlock.x;
                            blockToQueueForSpawn.y = blockY;
                            blockToQueueForSpawn.z = z + newBlock.z;
                            blockToQueueForSpawn.metaDataName = block.metaDataName;
                            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                            sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, this.settings.isOTGPlus);
                            if (sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
                            ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                            if (chunkCoord.equals(destChunk)) {
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                                continue;
                            }
                            outOfBounds = true;
                        }
                    }
                }
                if (replaceBelowMaterial != null && block.y == 0 && !block.material.isAir() && doReplaceAboveBelowOnly) {
                    bFound2 = false;
                    for (Object[] coords : coordsBelowDone) {
                        if ((Integer)coords[0] != x + newBlock.x || (Integer)coords[1] != z + newBlock.z) continue;
                        bFound2 = true;
                        break;
                    }
                    if (!bFound2) {
                        coordsBelowDone.add(new Object[]{x + newBlock.x, z + newBlock.z});
                        for (int blockY = y + newBlock.y - 1; blockY > 0; --blockY) {
                            if (blockY >= 256) continue;
                            blockToQueueForSpawn = new BlockFunction();
                            blockToQueueForSpawn.x = x + newBlock.x;
                            blockToQueueForSpawn.y = blockY;
                            blockToQueueForSpawn.z = z + newBlock.z;
                            blockToQueueForSpawn.material = replaceBelowMaterial;
                            blockToQueueForSpawn.metaDataName = block.metaDataName;
                            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                            sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, this.settings.isOTGPlus);
                            if (!sourceBlockMaterial.isSolid() && !sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                                ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                                if (chunkCoord.equals(destChunk)) {
                                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                                    continue;
                                }
                                outOfBounds = true;
                                continue;
                            }
                            if (sourceBlockMaterial.isSolid()) break;
                        }
                    }
                }
                if (y + newBlock.y <= 0 || y + newBlock.y >= 256 || doReplaceAboveBelowOnly) continue;
                blockToQueueForSpawn = new BlockFunction();
                blockToQueueForSpawn.x = x + newBlock.x;
                blockToQueueForSpawn.y = y + newBlock.y;
                blockToQueueForSpawn.z = z + newBlock.z;
                blockToQueueForSpawn.material = newBlock.material;
                blockToQueueForSpawn.metaDataName = block.metaDataName;
                blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, this.settings.isOTGPlus);
                if (replaceWithBiomeBlocks) {
                    LocalMaterialData customBlockData;
                    if (isOnBiomeBorder) {
                        biome = world.getBiome(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                        biomeConfig = biome.getBiomeConfig();
                        biomeSurfaceBlock = biomeConfig.surfaceBlock;
                        if (biomeSurfaceBlock == null) {
                            biomeSurfaceBlock = OTG.toLocalMaterialData(DefaultMaterial.GRASS, 0);
                        }
                        if ((biomeGroundBlock = biomeConfig.groundBlock) == null) {
                            biomeGroundBlock = OTG.toLocalMaterialData(DefaultMaterial.DIRT, 0);
                        }
                        if (biomeSurfaceBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                            biomeSurfaceBlock = OTG.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                        }
                        if (biomeGroundBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                            biomeGroundBlock = OTG.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                        }
                    }
                    if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3GroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3GroundBlock.getBlockData()) {
                        blockToQueueForSpawn.material = biomeGroundBlock;
                    } else if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3SurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3SurfaceBlock.getBlockData()) {
                        blockToQueueForSpawn.material = biomeSurfaceBlock;
                        LocalMaterialData originalSurfaceBlock = originalTopBlocks.get(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z));
                        if (originalSurfaceBlock != null && originalSurfaceBlock.toDefaultMaterial() != DefaultMaterial.UNKNOWN_BLOCK && !originalSurfaceBlock.isLiquid() && !originalSurfaceBlock.isAir()) {
                            blockToQueueForSpawn.material = originalSurfaceBlock;
                        }
                    }
                    if (biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeGroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeGroundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeSurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeSurfaceBlock.getBlockData()) && (customBlockData = ((MesaSurfaceGenerator)biomeConfig.surfaceAndGroundControl).getCustomBlockData(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z)) != null) {
                        blockToQueueForSpawn.material = customBlockData;
                    }
                }
                if (spawnUnderWater && blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)DefaultMaterial.TORCH) && sourceBlockMaterial.isLiquid() || sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
                ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                if (chunkCoord.equals(destChunk)) {
                    this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                    continue;
                }
                outOfBounds = true;
                continue;
            }
            if (replaceAboveMaterial != null && doReplaceAboveBelowOnly) {
                bFound = false;
                for (Object[] coords : coordsAboveDone) {
                    if ((Integer)coords[0] != x + block.x || (Integer)coords[1] != z + block.z) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    coordsAboveDone.add(new Object[]{x + block.x, z + block.z});
                    int heighestBlockToReplace = world.getHighestBlockYAt(x + block.x, z + block.z, true, true, false, false);
                    for (int blockY = y + block.y + 1; blockY <= heighestBlockToReplace && blockY > y + block.y; ++blockY) {
                        blockToQueueForSpawn = new BlockFunction();
                        blockToQueueForSpawn.material = spawnUnderWater && blockY >= waterLevel ? airMaterial : replaceAboveMaterial;
                        blockToQueueForSpawn.x = x + block.x;
                        blockToQueueForSpawn.y = blockY;
                        blockToQueueForSpawn.z = z + block.z;
                        blockToQueueForSpawn.metaDataName = block.metaDataName;
                        blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                        sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, this.settings.isOTGPlus);
                        if (!originalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z))) {
                            int highestBlockY = world.getHighestBlockYAt(blockToQueueForSpawn.x, blockToQueueForSpawn.z, true, true, false, false);
                            if (highestBlockY <= 0) {
                                highestBlockY = 1;
                            }
                            if (highestBlockY >= 256) {
                                highestBlockY = 255;
                            }
                            originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), world.getMaterial(blockToQueueForSpawn.x, highestBlockY, blockToQueueForSpawn.z, this.settings.isOTGPlus));
                        }
                        if (sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
                        ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                        if (chunkCoord.equals(destChunk)) {
                            this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                            continue;
                        }
                        outOfBounds = true;
                    }
                }
            }
            if (replaceBelowMaterial != null && block.y == 0 && !block.material.isAir() && doReplaceAboveBelowOnly) {
                bFound = false;
                for (Object[] coords : coordsBelowDone) {
                    if ((Integer)coords[0] != x + block.x || (Integer)coords[1] != z + block.z) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    coordsBelowDone.add(new Object[]{x + block.x, z + block.z});
                    for (int blockY = y + block.y - 1; blockY > 0; --blockY) {
                        if (blockY >= 256) continue;
                        blockToQueueForSpawn = new BlockFunction();
                        blockToQueueForSpawn.x = x + block.x;
                        blockToQueueForSpawn.y = blockY;
                        blockToQueueForSpawn.z = z + block.z;
                        blockToQueueForSpawn.material = replaceBelowMaterial;
                        blockToQueueForSpawn.metaDataName = block.metaDataName;
                        blockToQueueForSpawn.metaDataTag = block.metaDataTag;
                        sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, this.settings.isOTGPlus);
                        if (!originalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z))) {
                            int highestBlockY = world.getHighestBlockYAt(blockToQueueForSpawn.x, blockToQueueForSpawn.z, true, true, false, false);
                            if (highestBlockY <= 0) {
                                highestBlockY = 1;
                            }
                            if (highestBlockY >= 256) {
                                highestBlockY = 255;
                            }
                            originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), world.getMaterial(blockToQueueForSpawn.x, highestBlockY, blockToQueueForSpawn.z, this.settings.isOTGPlus));
                        }
                        if (!sourceBlockMaterial.isSolid() && !sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) || sourceBlockMaterial.getBlockData() != blockToQueueForSpawn.material.getBlockData()) {
                            ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                            if (chunkCoord.equals(destChunk)) {
                                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                                continue;
                            }
                            outOfBounds = true;
                            continue;
                        }
                        if (sourceBlockMaterial.isSolid()) break;
                    }
                }
            }
            if (y + block.y <= 0 || y + block.y >= 256 || doReplaceAboveBelowOnly) continue;
            blockToQueueForSpawn = new BlockFunction();
            blockToQueueForSpawn.x = x + block.x;
            blockToQueueForSpawn.y = y + block.y;
            blockToQueueForSpawn.z = z + block.z;
            blockToQueueForSpawn.material = block.material;
            blockToQueueForSpawn.metaDataName = block.metaDataName;
            blockToQueueForSpawn.metaDataTag = block.metaDataTag;
            sourceBlockMaterial = world.getMaterial(blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, this.settings.isOTGPlus);
            if (!originalTopBlocks.containsKey(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z))) {
                int highestBlockY = world.getHighestBlockYAt(blockToQueueForSpawn.x, blockToQueueForSpawn.z, true, true, false, false);
                if (highestBlockY > 0) {
                    originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), world.getMaterial(blockToQueueForSpawn.x, highestBlockY, blockToQueueForSpawn.z, this.settings.isOTGPlus));
                } else {
                    originalTopBlocks.put(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z), null);
                }
            }
            if (replaceWithBiomeBlocks) {
                LocalMaterialData customBlockData;
                if (isOnBiomeBorder) {
                    biome = world.getBiome(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
                    biomeConfig = biome.getBiomeConfig();
                    biomeSurfaceBlock = biomeConfig.surfaceBlock;
                    if (biomeSurfaceBlock == null) {
                        biomeSurfaceBlock = bo3SurfaceBlock;
                    }
                    if ((biomeGroundBlock = biomeConfig.groundBlock) == null) {
                        biomeGroundBlock = bo3GroundBlock;
                    }
                    if (biomeSurfaceBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                        biomeSurfaceBlock = OTG.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                    }
                    if (biomeGroundBlock.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW)) {
                        biomeGroundBlock = OTG.toLocalMaterialData(DefaultMaterial.SNOW_BLOCK, 0);
                    }
                }
                if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3GroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3GroundBlock.getBlockData()) {
                    blockToQueueForSpawn.material = biomeGroundBlock;
                } else if (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)bo3SurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == bo3SurfaceBlock.getBlockData()) {
                    blockToQueueForSpawn.material = biomeSurfaceBlock;
                    LocalMaterialData originalSurfaceBlock = originalTopBlocks.get(ChunkCoordinate.fromChunkCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z));
                    if (originalSurfaceBlock != null && originalSurfaceBlock.toDefaultMaterial() != DefaultMaterial.UNKNOWN_BLOCK && !originalSurfaceBlock.isLiquid() && !originalSurfaceBlock.isAir()) {
                        blockToQueueForSpawn.material = originalSurfaceBlock;
                    }
                }
                if (biomeConfig.surfaceAndGroundControl != null && biomeConfig.surfaceAndGroundControl instanceof MesaSurfaceGenerator && (blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeGroundBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeGroundBlock.getBlockData() || blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)biomeSurfaceBlock.toDefaultMaterial()) && blockToQueueForSpawn.material.getBlockData() == biomeSurfaceBlock.getBlockData()) && (customBlockData = biomeConfig.surfaceAndGroundControl.getCustomBlockData(world, biomeConfig, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z)) != null) {
                    blockToQueueForSpawn.material = customBlockData;
                }
            }
            if (spawnUnderWater && blockToQueueForSpawn.material.toDefaultMaterial().equals((Object)DefaultMaterial.TORCH) && sourceBlockMaterial.isLiquid() || sourceBlockMaterial.toDefaultMaterial().equals((Object)blockToQueueForSpawn.material.toDefaultMaterial()) && sourceBlockMaterial.getBlockData() == blockToQueueForSpawn.material.getBlockData()) continue;
            ChunkCoordinate destChunk = ChunkCoordinate.fromBlockCoords(blockToQueueForSpawn.x, blockToQueueForSpawn.z);
            if (chunkCoord.equals(destChunk)) {
                this.setBlock(world, blockToQueueForSpawn.x, blockToQueueForSpawn.y, blockToQueueForSpawn.z, blockToQueueForSpawn.material, blockToQueueForSpawn.metaDataTag, isStructureAtSpawn);
                continue;
            }
            outOfBounds = true;
        }
        if (outOfBounds) {
            OTG.log(LogMarker.WARN, "BO3 " + this.getName() + " tried to spawn blocks outside of the chunk being populated, the blocks have been ignored. This can happen if a BO3 is not sliced into 16x16 pieces or has branches positioned in such a way that they cross a chunk border. OTG is more strict than TC in how branching BO3's used as CustomStructures() should be designed, BO3 creators have to design their BO3's and position their branches so that they fit neatly into a 16x16 grid. Hopefully in a future release OTG can be made to automatically slice branching structures instead of forcing the BO3 creator to do it.", new Object[0]);
        }
        if (OTG.getPluginConfig().SpawnLog && System.currentTimeMillis() - startTime > 50L) {
            OTG.log(LogMarker.WARN, "Warning: Spawning BO3 " + this.getName() + " took " + (System.currentTimeMillis() - startTime) + " Ms.", new Object[0]);
        }
        return true;
    }

    private void setBlock(LocalWorld world, int x, int y, int z, LocalMaterialData material, NamedBinaryTag metaDataTag, boolean isStructureAtSpawn) {
        DefaultMaterial worldMaterial;
        LocalMaterialData targetBlock;
        HashMap<DefaultMaterial, LocalMaterialData> blocksToReplace = world.getConfigs().getWorldConfig().getReplaceBlocksDict();
        if (blocksToReplace != null && blocksToReplace.size() > 0 && (targetBlock = blocksToReplace.get((Object)material.toDefaultMaterial())) != null) {
            material = targetBlock;
        }
        if (OTG.getPluginConfig().DeveloperMode && ((worldMaterial = world.getMaterial(x, y, z, false).toDefaultMaterial()) == DefaultMaterial.GOLD_BLOCK || worldMaterial == DefaultMaterial.IRON_BLOCK || worldMaterial == DefaultMaterial.REDSTONE_BLOCK || worldMaterial == DefaultMaterial.DIAMOND_BLOCK || worldMaterial == DefaultMaterial.LAPIS_BLOCK || worldMaterial == DefaultMaterial.COAL_BLOCK || worldMaterial == DefaultMaterial.QUARTZ_BLOCK || worldMaterial == DefaultMaterial.EMERALD_BLOCK)) {
            if (material.toDefaultMaterial() == DefaultMaterial.GOLD_BLOCK || material.toDefaultMaterial() == DefaultMaterial.IRON_BLOCK || material.toDefaultMaterial() == DefaultMaterial.REDSTONE_BLOCK || material.toDefaultMaterial() == DefaultMaterial.DIAMOND_BLOCK || material.toDefaultMaterial() == DefaultMaterial.LAPIS_BLOCK || material.toDefaultMaterial() == DefaultMaterial.COAL_BLOCK || material.toDefaultMaterial() == DefaultMaterial.QUARTZ_BLOCK || material.toDefaultMaterial() == DefaultMaterial.EMERALD_BLOCK) {
                world.setBlock(x, y, z, OTG.toLocalMaterialData(DefaultMaterial.GLOWSTONE, 0), null, true);
            }
            return;
        }
        world.setBlock(x, y, z, material, metaDataTag, true);
    }

    public BO3(String name, File file) {
        this.name = name;
        this.file = file;
    }

    @Override
    public void onEnable(Map<String, CustomObject> otherObjectsInDirectory) {
        try {
            this.settings = new BO3Config(new FileSettingsReaderOTGPlus(this.name, this.file), otherObjectsInDirectory);
            if (this.settings.settingsMode != WorldConfig.ConfigMode.WriteDisable) {
                FileSettingsWriterOTGPlus.writeToFile(this.settings, this.settings.settingsMode);
            }
        }
        catch (InvalidConfigException ex) {
            this.isInvalidConfig = true;
        }
        if (this.settings != null && this.settings.isOTGPlus) {
            this.settings.blocks = null;
            this.settings.bo3Checks = null;
            this.settings.branches = null;
            this.settings.boundingBoxes = null;
            this.settings.entityFunctions = null;
            this.settings.particleFunctions = null;
            this.settings.modDataFunctions = null;
            this.settings.spawnerFunctions = null;
        }
    }

    public int getOffsetAndVariance(Random random, int offset, int variance) {
        if (variance == 0) {
            return offset;
        }
        variance = variance < 0 ? -random.nextInt(MathHelper.abs(variance) + 1) : random.nextInt(variance + 1);
        return MathHelper.clamp(offset + variance, 0, 256);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public BO3Config getSettings() {
        return this.settings;
    }

    @Override
    public boolean canSpawnAsTree() {
        return this.settings.tree;
    }

    @Override
    public boolean canSpawnAsObject() {
        return true;
    }

    @Override
    public boolean canRotateRandomly() {
        return this.settings.rotateRandomly;
    }

    @Override
    public boolean spawnForced(LocalWorld world, Random random, Rotation rotation, int x, int y, int z) {
        return this.trySpawnAt(true, null, world, random, rotation, x, y, z);
    }

    @Override
    public boolean spawnAsTree(LocalWorld world, Random random, int x, int z) {
        return this.spawn(world, random, x, z);
    }

    protected boolean spawn(LocalWorld world, Random random, int x, int z) {
        Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
        int y = 0;
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
            int n = y = this.settings.minHeight == this.settings.maxHeight ? this.settings.minHeight : RandomHelper.numberInRange(random, this.settings.minHeight, this.settings.maxHeight);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
            y = world.getHighestBlockYAt(x, z);
        }
        if (this.settings.spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
            y = world.getSolidHeight(x, z);
        }
        return this.trySpawnAt(world, random, rotation, x, y += this.getOffsetAndVariance(random, this.settings.spawnHeightOffset, this.settings.spawnHeightVariance), z);
    }

    @Override
    public boolean process(LocalWorld world, Random random, ChunkCoordinate chunkCoord) {
        boolean atLeastOneObjectHasSpawned = false;
        int chunkMiddleX = chunkCoord.getBlockXCenter();
        int chunkMiddleZ = chunkCoord.getBlockZCenter();
        for (int i = 0; i < this.settings.frequency; ++i) {
            int z;
            int x;
            if (!(this.settings.rarity > random.nextDouble() * 100.0) || !this.spawn(world, random, x = chunkMiddleX + random.nextInt(16), z = chunkMiddleZ + random.nextInt(16))) continue;
            atLeastOneObjectHasSpawned = true;
        }
        return atLeastOneObjectHasSpawned;
    }

    @Override
    public CustomObject applySettings(SettingsReaderOTGPlus extraSettings) {
        extraSettings.setFallbackReader(this.settings.reader);
        return new BO3(this, extraSettings);
    }

    @Override
    public boolean hasPreferenceToSpawnIn(LocalBiome biome) {
        return !this.settings.excludedBiomes.contains("All") && !this.settings.excludedBiomes.contains("all") && !this.settings.excludedBiomes.contains(biome.getName());
    }

    @Override
    public boolean hasBranches() {
        if (this.settings.isOTGPlus) {
            return this.settings.getbranches().length != 0;
        }
        return this.settings.branches[0].length != 0;
    }

    @Override
    public Branch[] getBranches(Rotation rotation) {
        if (this.settings.isOTGPlus) {
            throw new RuntimeException();
        }
        return this.settings.branches[rotation.getRotationId()];
    }

    @Override
    public Branch[] getBranches() {
        return this.settings.getbranches();
    }

    @Override
    public CustomObjectCoordinate makeCustomObjectCoordinate(LocalWorld world, Random random, int chunkX, int chunkZ) {
        if (this.settings.isOTGPlus) {
            if (OTG.getPluginConfig().SpawnLog) {
                OTG.log(LogMarker.WARN, "Tried to spawn a OTG+ enabled BO3 as CustomStructure in a non-OTG+ enabled world. BO3: " + this.settings.getName(), new Object[0]);
            }
            return null;
        }
        if (this.settings.rarity > random.nextDouble() * 100.0) {
            Rotation rotation = this.settings.rotateRandomly ? Rotation.getRandomRotation(random) : Rotation.NORTH;
            int height = RandomHelper.numberInRange(random, this.settings.minHeight, this.settings.maxHeight);
            return new CustomObjectCoordinate(world, this, this.getName(), rotation, chunkX * 16 + 8 + random.nextInt(16), height, chunkZ * 16 + 8 + random.nextInt(16));
        }
        return null;
    }

    @Override
    public StructurePartSpawnHeight getStructurePartSpawnHeight() {
        return this.settings.spawnHeight.toStructurePartSpawnHeight();
    }

    @Override
    public BoundingBox getBoundingBox(Rotation rotation) {
        return this.settings.boundingBoxes[rotation.getRotationId()];
    }

    @Override
    public int getMaxBranchDepth() {
        return this.settings.maxBranchDepth;
    }
}

