/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.CustomObjectCoordinate;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BO3Function;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.Rotation;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public class EntityFunction
extends BO3Function {
    public int x;
    public int y;
    public int z;
    public String mobName = "";
    public int groupSize = 1;
    public String nameTagOrNBTFileName = "";
    public String originalNameTagOrNBTFileName = "";
    public String nameTag = "";
    private String metaDataTag;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(5, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.mobName = args.get(3);
        this.groupSize = this.readInt(args.get(4), 0, Integer.MAX_VALUE);
        if (args.size() > 5) {
            this.originalNameTagOrNBTFileName = args.get(5);
        }
        if (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.toLowerCase().trim().endsWith(".txt")) {
            this.nameTagOrNBTFileName = ((BO3Config)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalNameTagOrNBTFileName;
        }
    }

    @Override
    public String makeString() {
        return "Entity(" + this.x + ',' + this.y + ',' + this.z + ',' + this.mobName + ',' + this.groupSize + (this.originalNameTagOrNBTFileName != null && this.originalNameTagOrNBTFileName.length() > 0 ? ',' + this.originalNameTagOrNBTFileName : "") + ')';
    }

    @Override
    public EntityFunction rotate() {
        EntityFunction rotatedBlock = new EntityFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.mobName = this.mobName;
        rotatedBlock.groupSize = this.groupSize;
        rotatedBlock.originalNameTagOrNBTFileName = this.originalNameTagOrNBTFileName;
        rotatedBlock.nameTagOrNBTFileName = this.nameTagOrNBTFileName;
        return rotatedBlock;
    }

    public EntityFunction rotate(Rotation rotation) {
        EntityFunction rotatedBlock = new EntityFunction();
        CustomObjectCoordinate rotatedCoords = CustomObjectCoordinate.getRotatedBO3CoordsJustified(this.x, this.y, this.z, rotation);
        rotatedBlock.x = rotatedCoords.getX();
        rotatedBlock.y = rotatedCoords.getY();
        rotatedBlock.z = rotatedCoords.getZ();
        rotatedBlock.mobName = this.mobName;
        rotatedBlock.groupSize = this.groupSize;
        rotatedBlock.originalNameTagOrNBTFileName = this.originalNameTagOrNBTFileName;
        rotatedBlock.nameTagOrNBTFileName = this.nameTagOrNBTFileName;
        return rotatedBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetaData() {
        if (this.nameTagOrNBTFileName != null && this.nameTagOrNBTFileName.length() > 0 && this.metaDataTag == null) {
            File metaDataFile = new File(this.nameTagOrNBTFileName);
            StringBuilder stringbuilder = new StringBuilder();
            if (metaDataFile.exists()) {
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(metaDataFile));
                    try {
                        String line = reader.readLine();
                        while (line != null) {
                            stringbuilder.append(line);
                            line = reader.readLine();
                        }
                    }
                    finally {
                        reader.close();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            this.metaDataTag = stringbuilder.toString();
        }
        return this.metaDataTag;
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        EntityFunction block = (EntityFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.mobName.equalsIgnoreCase(this.mobName) && block.groupSize == this.groupSize && block.originalNameTagOrNBTFileName == this.originalNameTagOrNBTFileName;
    }
}

