/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.CustomObjectConfigFunction;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.BlockFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.SpawnableObject;
import com.pg85.otg.util.Rotation;
import com.pg85.otg.util.minecraftTypes.DefaultStructurePart;
import java.util.List;
import java.util.Random;

public class MinecraftObjectFunction
extends BlockFunction {
    public DefaultStructurePart structurePart;
    public Rotation rotation = Rotation.NORTH;

    public MinecraftObjectFunction() {
    }

    public MinecraftObjectFunction(BO3Config config, List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.structurePart = DefaultStructurePart.getDefaultStructurePart(args.get(3));
    }

    @Override
    public String makeString() {
        return "MinecraftObject(" + this.x + ',' + this.y + ',' + this.z + ',' + (Object)((Object)this.structurePart) + ')';
    }

    @Override
    public MinecraftObjectFunction rotate() {
        MinecraftObjectFunction rotatedBlock = new MinecraftObjectFunction();
        rotatedBlock.x = this.z;
        rotatedBlock.y = this.y;
        rotatedBlock.z = -this.x;
        rotatedBlock.rotation = this.rotation.next();
        return rotatedBlock;
    }

    @Override
    public void spawn(LocalWorld world, Random random, int x, int y, int z, boolean allowOutsidePopulatingArea) {
        SpawnableObject object = world.getMojangStructurePart(this.structurePart.getPath());
        object.spawnForced(world, random, this.rotation, x, y, z);
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<BO3Config> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        MinecraftObjectFunction block = (MinecraftObjectFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z;
    }
}

