/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.OTGEngine;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.ForgeLogger;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.ForgeWorldSession;
import com.pg85.otg.forge.WorldLoader;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.io.File;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.DimensionManager;

public class ForgeEngine
extends OTGEngine {
    protected WorldLoader worldLoader;
    protected Map<ResourceLocation, Biome> biomeMap;

    public void onSave(World world) {
        ForgeWorld forgeWorld = (ForgeWorld)this.getWorld(world);
        if (forgeWorld != null && forgeWorld.getObjectSpawner().saveRequired && !forgeWorld.GetWorldSession().getPreGeneratorIsRunning()) {
            forgeWorld.getStructureCache().SaveToDisk();
        }
    }

    public void ProcessPregeneratorTick() {
        for (LocalWorld world : this.getAllWorlds()) {
            ((ForgeWorldSession)world.GetWorldSession()).getPregenerator().ProcessTick();
        }
    }

    public ForgeEngine(WorldLoader worldLoader) {
        super(new ForgeLogger());
        this.worldLoader = worldLoader;
    }

    public void registerForgeBiome(int id, ResourceLocation resourceLocation, Biome biome) {
        OTG.log(LogMarker.TRACE, "Registering biome " + resourceLocation.toString(), new Object[0]);
        Biome.field_185377_q.field_82596_a.put(resourceLocation, biome);
        Biome.field_185377_q.field_148759_a.func_186814_a((Object)biome, id);
        Biome.field_185377_q.field_148758_b.put(biome, resourceLocation);
    }

    public void unRegisterForgeBiome(ResourceLocation resourceLocation) {
        int biomeId;
        OTG.log(LogMarker.TRACE, "Unregistering biome " + resourceLocation.toString(), new Object[0]);
        Biome biome = (Biome)Biome.field_185377_q.field_82596_a.get(resourceLocation);
        BitSet biomeRegistryAvailabiltyMap = ((ForgeEngine)OTG.getEngine()).worldLoader.getBiomeRegistryAvailabiltyMap();
        try {
            biomeId = Biome.func_185362_a((Biome)biome);
            if (Biome.func_185357_a((int)biomeId) == biome) {
                biomeRegistryAvailabiltyMap.set(biomeId, false);
            }
        }
        catch (IndexOutOfBoundsException ex) {
            OTG.log(LogMarker.ERROR, "Could not unregister " + biome.func_185359_l(), new Object[0]);
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        biomeId = Biome.field_185377_q.func_148757_b((Object)biome);
        Biome.field_185377_q.field_82596_a.remove(resourceLocation);
        if (Biome.field_185377_q.func_148754_a(biomeId) == biome) {
            Biome.field_185377_q.field_148759_a.func_186814_a(null, biomeId);
        }
        Biome.field_185377_q.field_148758_b.remove(biome);
    }

    public WorldLoader getWorldLoader() {
        return this.worldLoader;
    }

    public boolean getCartographerEnabled() {
        ForgeWorld world = this.getOverWorld();
        return world == null ? false : world.getConfigs().getWorldConfig().Cartographer;
    }

    public ForgeWorld getOverWorld() {
        ArrayList<LocalWorld> allWorlds = this.getAllWorlds();
        for (LocalWorld world : allWorlds) {
            if (((ForgeWorld)world).getWorld() == null || ((ForgeWorld)world).getWorld().field_73011_w == null || ((ForgeWorld)world).getWorld().field_73011_w.getDimension() != 0) continue;
            return (ForgeWorld)world;
        }
        return null;
    }

    public ForgeWorld getWorldByDimId(int dimensionId) {
        ForgeWorld forgeWorld;
        if (dimensionId == 0) {
            forgeWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
        } else {
            DimensionType dimType = DimensionManager.getProviderType((int)dimensionId);
            forgeWorld = (ForgeWorld)OTG.getWorld(dimType.func_186065_b());
        }
        return forgeWorld;
    }

    public LocalWorld getWorld(World world) {
        if (world.field_73011_w.getDimension() == 0) {
            return ((ForgeEngine)OTG.getEngine()).getOverWorld();
        }
        if (world.field_73011_w.getDimension() > 1 && world.field_73011_w.func_186058_p().func_186067_c() != null && world.field_73011_w.func_186058_p().func_186067_c().equals("OTG")) {
            ForgeWorld localWorld = this.worldLoader.getWorld(world.field_73011_w.func_186058_p().func_186065_b());
            if (localWorld == null) {
                return this.worldLoader.getUnloadedWorld(world.field_73011_w.func_186058_p().func_186065_b());
            }
            return this.worldLoader.getWorld(world.field_73011_w.func_186058_p().func_186065_b());
        }
        ForgeWorld localWorld = this.worldLoader.getWorld(world.func_72912_H().func_76065_j());
        if (localWorld == null) {
            return this.worldLoader.getUnloadedWorld(world.func_72912_H().func_76065_j());
        }
        return localWorld;
    }

    @Override
    public LocalWorld getWorld(String name) {
        return this.worldLoader.getWorld(name);
    }

    @Override
    public LocalWorld getUnloadedWorld(String name) {
        return this.worldLoader.getUnloadedWorld(name);
    }

    public ArrayList<ForgeWorld> getUnloadedWorlds() {
        return this.worldLoader.getUnloadedWorlds();
    }

    @Override
    public ArrayList<LocalWorld> getAllWorlds() {
        return this.worldLoader.getAllWorlds();
    }

    @Override
    public File getTCDataFolder() {
        return this.worldLoader.getConfigsFolder();
    }

    @Override
    public File getGlobalObjectsDirectory() {
        return new File(this.getTCDataFolder(), "GlobalObjects");
    }

    @Override
    public LocalMaterialData readMaterial(String input) throws InvalidConfigException {
        return ForgeMaterialData.ofString(input);
    }

    @Override
    public LocalMaterialData toLocalMaterialData(DefaultMaterial defaultMaterial, int blockData) {
        return ForgeMaterialData.ofDefaultMaterial(defaultMaterial, blockData);
    }
}

