/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.configuration.WeightedMobSpawnGroup;
import com.pg85.otg.configuration.standard.MojangSettings;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import java.util.List;
import net.minecraft.world.biome.Biome;

public final class ForgeMojangSettings
implements MojangSettings {
    private final Biome biomeBase;

    public static MojangSettings fromId(int biomeId) {
        Biome baseBiome = Biome.func_150568_d((int)biomeId);
        if (baseBiome != null) {
            return ForgeMojangSettings.fromBiomeBase(baseBiome);
        }
        return ForgeMojangSettings.fromBiomeBase(ForgeWorld.vanillaBiomes[biomeId]);
    }

    public static MojangSettings fromBiomeBase(Biome biomeBase) {
        return new ForgeMojangSettings(biomeBase);
    }

    private ForgeMojangSettings(Biome biomeBase) {
        this.biomeBase = biomeBase;
    }

    @Override
    public float getTemperature() {
        return this.biomeBase.func_185353_n();
    }

    @Override
    public float getWetness() {
        return this.biomeBase.func_76727_i();
    }

    @Override
    public float getSurfaceHeight() {
        return this.biomeBase.func_185355_j();
    }

    @Override
    public float getSurfaceVolatility() {
        return this.biomeBase.func_185360_m();
    }

    @Override
    public LocalMaterialData getSurfaceBlock() {
        return ForgeMaterialData.ofMinecraftBlockState(this.biomeBase.field_76752_A);
    }

    @Override
    public LocalMaterialData getGroundBlock() {
        return ForgeMaterialData.ofMinecraftBlockState(this.biomeBase.field_76753_B);
    }

    @Override
    public List<WeightedMobSpawnGroup> getMobSpawnGroup(MojangSettings.EntityCategory entityCategory) {
        return MobSpawnGroupHelper.getListFromMinecraftBiome(this.biomeBase, entityCategory);
    }
}

