/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.google.common.base.Function;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.events.EventPriority;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGWorldType;
import com.pg85.otg.forge.WorldLoader;
import com.pg85.otg.forge.client.events.ClientNetworkEventListener;
import com.pg85.otg.forge.client.events.ClientTickHandler;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.WorldProviderOTG;
import com.pg85.otg.forge.events.BiomeColorsListener;
import com.pg85.otg.forge.events.BlockTracker;
import com.pg85.otg.forge.events.ChunkEventListener;
import com.pg85.otg.forge.events.EntityTravelToDimensionListener;
import com.pg85.otg.forge.events.KeyBoardEventListener;
import com.pg85.otg.forge.events.OTGCommandHandler;
import com.pg85.otg.forge.events.OTGToForgeEventConverter;
import com.pg85.otg.forge.events.PlayerTracker;
import com.pg85.otg.forge.events.RightClickBlockListener;
import com.pg85.otg.forge.events.SaplingListener;
import com.pg85.otg.forge.events.SaveServerHandler;
import com.pg85.otg.forge.events.ServerEventListener;
import com.pg85.otg.forge.events.UnloadServerHandler;
import com.pg85.otg.forge.events.WorldListener;
import com.pg85.otg.forge.generator.Cartographer;
import com.pg85.otg.forge.generator.ForgeVanillaBiomeGenerator;
import com.pg85.otg.forge.generator.structure.OTGRareBuildingStart;
import com.pg85.otg.forge.generator.structure.OTGVillageStart;
import com.pg85.otg.forge.gui.GuiHandler;
import com.pg85.otg.forge.network.CommonProxy;
import com.pg85.otg.forge.network.PacketDispatcher;
import com.pg85.otg.logging.LogMarker;
import java.io.File;
import net.minecraft.command.ICommand;
import net.minecraft.init.Blocks;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraft.world.storage.WorldInfo;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLFingerprintViolationEvent;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.network.FMLEventChannel;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;

@Mod(modid="openterraingenerator", name="Open Terrain Generator", version="v9", certificateFingerprint="e9f7847a78c5342af5b0a9e04e5abc0b554d69e0", acceptedMinecraftVersions="[1.11.2]")
public class OTGPlugin {
    public static final String MOD_ID = "openterraingenerator";
    @SidedProxy(clientSide="com.pg85.otg.forge.network.ClientProxy", serverSide="com.pg85.otg.forge.network.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="OTG")
    public static OTGPlugin instance;
    private WorldLoader worldLoader;
    public static OTGWorldType txWorldType;

    public OTGPlugin() {
        OTG.isForge = true;
    }

    @Mod.EventHandler
    public void onFingerprintViolation(FMLFingerprintViolationEvent event) {
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        File configsDir = new File(Loader.instance().getConfigDir(), "OpenTerrainGenerator");
        this.worldLoader = new WorldLoader(configsDir);
        MinecraftForge.EVENT_BUS.register((Object)new WorldListener());
        txWorldType = new OTGWorldType(this.worldLoader);
        ForgeEngine engine = new ForgeEngine(this.worldLoader);
        OTG.setEngine(engine);
        engine.getBiomeModeManager().register("Default", ForgeVanillaBiomeGenerator.class);
        MapGenStructureIO.func_143034_b(OTGRareBuildingStart.class, (String)"OTGTemple");
        MapGenStructureIO.func_143034_b(OTGVillageStart.class, (String)"OTGVillage");
        if (event.getSide() == Side.CLIENT) {
            ClientNetworkEventListener networkHandler = new ClientNetworkEventListener(this.worldLoader);
            FMLEventChannel eventDrivenChannel = NetworkRegistry.INSTANCE.newEventDrivenChannel("OpenTerrainGenerator");
            eventDrivenChannel.register((Object)networkHandler);
            MinecraftForge.EVENT_BUS.register((Object)networkHandler);
        }
        PacketDispatcher.registerPackets();
        MinecraftForge.EVENT_BUS.register((Object)new PlayerTracker());
        MinecraftForge.EVENT_BUS.register((Object)new BlockTracker());
        SaplingListener saplingListener = new SaplingListener();
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)saplingListener);
        MinecraftForge.EVENT_BUS.register((Object)saplingListener);
        MinecraftForge.EVENT_BUS.register((Object)new SaveServerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new UnloadServerHandler());
        Function<Biome, BiomeConfig> getBiomeConfig = new Function<Biome, BiomeConfig>(){

            public BiomeConfig apply(Biome input) {
                LocalBiome biome = null;
                try {
                    biome = OTG.getBiomeAllWorlds(input.func_185359_l());
                }
                catch (BiomeNotFoundException biomeNotFoundException) {
                    // empty catch block
                }
                if (biome == null) {
                    return null;
                }
                return biome.getBiomeConfig();
            }
        };
        MinecraftForge.EVENT_BUS.register((Object)new BiomeColorsListener(getBiomeConfig));
        MinecraftForge.EVENT_BUS.register((Object)new ServerEventListener());
        MinecraftForge.EVENT_BUS.register((Object)new ClientTickHandler());
        MinecraftForge.EVENT_BUS.register((Object)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)new KeyBoardEventListener());
        engine.registerEventHandler(new OTGToForgeEventConverter(), EventPriority.CANCELABLE);
        MinecraftForge.EVENT_BUS.register((Object)new RightClickBlockListener());
        MinecraftForge.EVENT_BUS.register((Object)new EntityTravelToDimensionListener());
        MinecraftForge.EVENT_BUS.register((Object)new ChunkEventListener());
        Blocks.field_150353_l.func_149713_g(255);
        DimensionType.OVERWORLD.field_186077_g = WorldProviderOTG.class;
        DimensionType.OVERWORLD.field_186076_f = "OTG";
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new OTGCommandHandler());
        WorldServer overWorld = DimensionManager.getWorld((int)0);
        if (overWorld.func_72912_H().func_82571_y().equals("OpenTerrainGenerator") && !(overWorld.func_72912_H().func_76067_t() instanceof OTGWorldType)) {
            ISaveHandler isavehandler = overWorld.func_72860_G();
            WorldInfo worldInfo = isavehandler.func_75757_d();
            if (worldInfo != null) {
                overWorld.func_72912_H().func_76085_a((WorldType)txWorldType);
                worldInfo.func_76085_a((WorldType)txWorldType);
                isavehandler.func_75761_a(worldInfo);
            }
            throw new RuntimeException("OTG has detected that you are loading an OTG world that has been used without OTG installed. OTG has fixed and saved the world data, you can now restart the game and enter the world.");
        }
        if (overWorld.func_72912_H().func_82571_y().equals("OpenTerrainGenerator") && !overWorld.field_72995_K) {
            OTGDimensionManager.ReAddTCDims();
            OTGDimensionManager.LoadCustomDimensionData();
            Cartographer.CreateCartographerDimension();
            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld((World)overWorld);
            if (forgeWorld == null) {
                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld((World)overWorld);
            }
            WorldConfig worldConfig = forgeWorld.getConfigs().getWorldConfig();
            for (String dimName : worldConfig.Dimensions) {
                if (OTGDimensionManager.isDimensionNameRegistered(dimName)) continue;
                File worldConfigFile = new File(OTG.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds/" + dimName + "/WorldConfig.ini");
                if (!worldConfigFile.exists()) {
                    OTG.log(LogMarker.ERROR, "Could not create dimension \"" + dimName + "\", mods/OpenTerrainGenerator/worlds/" + dimName + " could not be found or does not contain a WorldConfig.ini file.", new Object[0]);
                    continue;
                }
                OTGDimensionManager.createDimension(dimName, false, true, false);
            }
            OTGDimensionManager.SaveDimensionData();
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        proxy.preInit(e);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }
}

