/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.WorldLoader;
import com.pg85.otg.forge.generator.ForgeVanillaBiomeGenerator;
import com.pg85.otg.forge.generator.OTGBiomeProvider;
import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.util.helpers.ReflectionHelper;
import java.io.File;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class OTGWorldType
extends WorldType {
    public final WorldLoader worldLoader;

    public OTGWorldType(WorldLoader worldLoader) {
        super("OTG");
        this.worldLoader = worldLoader;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_151357_h() {
        return true;
    }

    public BiomeProvider getBiomeProvider(World mcWorld) {
        if (mcWorld.field_72995_K) {
            return super.getBiomeProvider(mcWorld);
        }
        File worldDirectory = new File(OTG.getEngine().getTCDataFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName());
        if (!worldDirectory.exists()) {
            System.out.println("OpenTerrainGenerator: settings does not exist, creating defaults");
            if (!worldDirectory.mkdirs()) {
                System.out.println("OpenTerrainGenerator: cant create folder " + worldDirectory.getAbsolutePath());
            }
        }
        File worldObjectsDir = new File(OTG.getEngine().getTCDataFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName() + File.separator + "WorldObjects");
        worldObjectsDir.mkdirs();
        File worldBiomesDir = new File(OTG.getEngine().getTCDataFolder(), "worlds" + File.separator + mcWorld.func_72860_G().func_75765_b().getName() + File.separator + "WorldBiomes");
        worldBiomesDir.mkdirs();
        ForgeWorld world = this.worldLoader.getOrCreateForgeWorld(mcWorld);
        if (world == null) {
            return super.getBiomeProvider(mcWorld);
        }
        Class<? extends BiomeGenerator> biomeGenClass = world.getConfigs().getWorldConfig().biomeMode;
        BiomeGenerator biomeGenerator = OTG.getBiomeModeManager().createCached(biomeGenClass, world);
        BiomeProvider biomeProvider = this.createBiomeProvider(world, biomeGenerator);
        world.setBiomeGenerator(biomeGenerator);
        return biomeProvider;
    }

    private BiomeProvider createBiomeProvider(ForgeWorld world, BiomeGenerator biomeGenerator) {
        BiomeProvider biomeProvider;
        World mcWorld = world.getWorld();
        if (biomeGenerator instanceof ForgeVanillaBiomeGenerator) {
            biomeProvider = mcWorld.field_73011_w.func_177499_m();
            ((ForgeVanillaBiomeGenerator)biomeGenerator).setBiomeProvider(biomeProvider);
        } else {
            biomeProvider = new OTGBiomeProvider(world, biomeGenerator);
            ReflectionHelper.setValueInFieldOfType(mcWorld.field_73011_w, BiomeProvider.class, biomeProvider);
        }
        return biomeProvider;
    }

    public IChunkGenerator getChunkGenerator(World mcWorld, String generatorOptions) {
        ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
        if (world != null && world.getConfigs().getWorldConfig().ModeTerrain != WorldConfig.TerrainMode.Default) {
            return world.getChunkGenerator();
        }
        return super.getChunkGenerator(mcWorld, generatorOptions);
    }

    public int getMinimumSpawnHeight(World mcWorld) {
        ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
        if (world == null) {
            return 64;
        }
        return world.getConfigs().getWorldConfig().waterLevelMax;
    }
}

