/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ClientConfigProvider;
import com.pg85.otg.configuration.ConfigFile;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.forge.ForgeBiome;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGWorldType;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.WorldProviderOTG;
import com.pg85.otg.forge.gui.GuiHandler;
import com.pg85.otg.forge.gui.OTGGuiCreateWorld;
import com.pg85.otg.forge.gui.OTGGuiWorldSelection;
import com.pg85.otg.forge.util.WorldHelper;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.minecraftTypes.DefaultBiome;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.init.Biomes;
import net.minecraft.util.IntIdentityHashBiMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class WorldLoader {
    private final File configsDir;
    private final HashMap<String, ForgeWorld> worlds = new HashMap();
    private final HashMap<String, ForgeWorld> unloadedWorlds = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LocalWorld> getAllLoadedWorlds() {
        ArrayList<LocalWorld> allWorlds = new ArrayList<LocalWorld>();
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            allWorlds.addAll(this.worlds.values());
        }
        return allWorlds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<LocalWorld> getAllWorlds() {
        ArrayList<LocalWorld> allWorlds = new ArrayList<LocalWorld>();
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                allWorlds.addAll(this.worlds.values());
                allWorlds.addAll(this.unloadedWorlds.values());
            }
        }
        return allWorlds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ForgeWorld> getUnloadedWorlds() {
        ArrayList<ForgeWorld> unloadedWorldsClone = new ArrayList<ForgeWorld>();
        HashMap<String, ForgeWorld> hashMap = this.unloadedWorlds;
        synchronized (hashMap) {
            unloadedWorldsClone.addAll(this.unloadedWorlds.values());
        }
        return unloadedWorldsClone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isWorldUnloaded(String worldName) {
        boolean isLoaded = false;
        boolean isUnloaded = false;
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                isLoaded = this.worlds.containsKey(worldName);
                isUnloaded = this.unloadedWorlds.containsKey(worldName);
            }
        }
        return !isLoaded && isUnloaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveUnloadedWorld(String worldName) {
        HashMap<String, ForgeWorld> hashMap = this.unloadedWorlds;
        synchronized (hashMap) {
            ForgeWorld forgeWorld = this.unloadedWorlds.get(worldName);
            if (forgeWorld != null) {
                forgeWorld.DeleteWorldSessionData();
                this.unloadedWorlds.remove(worldName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void RemoveLoadedWorld(String worldName) {
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            ForgeWorld forgeWorld = this.worlds.get(worldName);
            if (forgeWorld != null) {
                forgeWorld.DeleteWorldSessionData();
                this.worlds.remove(worldName);
            }
        }
    }

    WorldLoader(File configsDir) {
        File dataFolder;
        try {
            Field minecraftDir = Loader.class.getDeclaredField("minecraftDir");
            minecraftDir.setAccessible(true);
            dataFolder = new File((File)minecraftDir.get(null), "mods" + File.separator + "OpenTerrainGenerator");
        }
        catch (Throwable e) {
            dataFolder = new File("mods" + File.separator + "OpenTerrainGenerator");
            System.out.println("Could not reflect the Minecraft directory, save location may be unpredicatble.");
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        this.configsDir = dataFolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeWorld getUnloadedWorld(String name) {
        ForgeWorld forgeWorld = null;
        HashMap<String, ForgeWorld> hashMap = this.unloadedWorlds;
        synchronized (hashMap) {
            forgeWorld = this.unloadedWorlds.get(name);
        }
        return forgeWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ForgeWorld getWorld(String name) {
        if (name == null) {
            return null;
        }
        if (name.equals("Overworld")) {
            return ((ForgeEngine)OTG.getEngine()).getOverWorld();
        }
        ForgeWorld forgeWorld = null;
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            forgeWorld = this.worlds.get(name);
        }
        return forgeWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigUnique(String name) {
        boolean bFound = false;
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                LocalBiome bc;
                for (ForgeWorld world : this.worlds.values()) {
                    bc = world.getBiomeByNameOrNull(name);
                    if (bc == null) continue;
                    if (bFound) {
                        return false;
                    }
                    bFound = true;
                }
                for (ForgeWorld world : this.unloadedWorlds.values()) {
                    bc = world.getBiomeByNameOrNull(name);
                    if (bc == null) continue;
                    if (bFound) {
                        return false;
                    }
                    bFound = true;
                }
            }
        }
        return true;
    }

    public File getConfigsFolder() {
        return this.configsDir;
    }

    protected File getWorldDir(String worldName) {
        return new File(this.configsDir, "worlds/" + worldName);
    }

    public void onServerStopped() {
        this.unloadAllWorlds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadAllWorlds() {
        ArrayList<ForgeWorld> worldsToRemove = new ArrayList<ForgeWorld>();
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                for (ForgeWorld world : this.worlds.values()) {
                    if (world == null) continue;
                    worldsToRemove.add(world);
                }
                for (ForgeWorld worldToRemove : worldsToRemove) {
                    OTG.log(LogMarker.INFO, "Unloading world \"{}\"...", worldToRemove.getName());
                    worldToRemove.unRegisterBiomes();
                    this.worlds.remove(worldToRemove.getName());
                }
                HashMap<String, ForgeWorld> hashMap3 = this.unloadedWorlds;
                synchronized (hashMap3) {
                    this.unloadedWorlds.clear();
                }
            }
        }
    }

    public void unloadWorld(World world, boolean unRegisterBiomes) {
        this.unloadWorld((ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(world), unRegisterBiomes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadWorld(ForgeWorld world, boolean unRegisterBiomes) {
        OTG.log(LogMarker.INFO, "Unloading world \"{}\"...", world.getName());
        ForgeWorld loadedWorld = this.worlds.get(world.getName());
        if (loadedWorld != null) {
            HashMap<String, ForgeWorld> hashMap = this.worlds;
            synchronized (hashMap) {
                HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
                synchronized (hashMap2) {
                    this.unloadedWorlds.put(world.getName(), this.worlds.get(world.getName()));
                    this.worlds.remove(world.getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ForgeWorld getOrCreateForgeWorld(World mcWorld) {
        if (!(mcWorld.func_72912_H().func_76067_t() instanceof OTGWorldType)) {
            throw new RuntimeException("Whatever it is you're trying to do, we didn't write any code for it (sorry). Please contact Team OTG about this crash.");
        }
        String worldName = WorldHelper.getName(mcWorld);
        boolean isMainWorld = mcWorld.field_73011_w.getDimension() == 0;
        File worldConfigsFolder = this.getWorldDir(worldName);
        if (!worldConfigsFolder.exists()) {
            return null;
        }
        ForgeWorld world = this.getWorld(worldName);
        if (world == null) {
            world = new ForgeWorld(worldName, isMainWorld);
            ServerConfigProvider config = null;
            if (config == null) {
                OTG.log(LogMarker.INFO, "Loading configs for world \"{}\"..", world.getName());
                config = new ServerConfigProvider(worldConfigsFolder, world);
                if (isMainWorld) {
                    try {
                        this.applyWorldCreationMenuSettings(config);
                    }
                    catch (NoSuchMethodError noSuchMethodError) {
                        // empty catch block
                    }
                }
                Iterator iterator = Biome.field_185377_q.field_82596_a.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry mapEntry = iterator.next();
                    Biome biome = (Biome)mapEntry.getValue();
                    int biomeId = Biome.func_185362_a((Biome)biome);
                    if (biomeId != 1023) continue;
                    iterator.remove();
                }
                IntIdentityHashBiMap underlyingIntegerMap = new IntIdentityHashBiMap(256);
                for (Biome biome : Biome.field_185377_q.field_148759_a) {
                    int biomeId = Biome.func_185362_a((Biome)biome);
                    if (biomeId == 1023) continue;
                    underlyingIntegerMap.func_186814_a((Object)biome, biomeId);
                }
                Biome.field_185377_q.field_148759_a = underlyingIntegerMap;
            }
            world.provideConfigs(config);
            if (world != null && world.getWorld() == null) {
                world.provideWorldInstance((WorldServer)mcWorld);
            }
            HashMap<String, ForgeWorld> hashMap = this.worlds;
            synchronized (hashMap) {
                HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
                synchronized (hashMap2) {
                    this.worlds.put(worldName, world);
                    this.unloadedWorlds.remove(worldName);
                }
            }
        }
        return world;
    }

    @SideOnly(value=Side.CLIENT)
    private void applyWorldCreationMenuSettings(ServerConfigProvider config) {
        if (GuiHandler.lastGuiOpened.equals(OTGGuiCreateWorld.class) || GuiHandler.lastGuiOpened.equals(GuiYesNo.class) && GuiHandler.askModCompatContinue) {
            config.getWorldConfig().PreGenerationRadius = GuiHandler.PregenerationRadius;
            config.getWorldConfig().WorldBorderRadius = GuiHandler.WorldBorderRadius;
            config.saveWorldConfig();
        } else if (GuiHandler.lastGuiOpened.equals(OTGGuiWorldSelection.class)) {
            GuiHandler.PregenerationRadius = config.getWorldConfig().PreGenerationRadius;
            GuiHandler.WorldBorderRadius = config.getWorldConfig().WorldBorderRadius;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearBiomeDictionary(ForgeWorld world) {
        Set hellTypesSet = BiomeDictionary.getTypes((Biome)Biomes.field_76778_j);
        Set skyTypesSet = BiomeDictionary.getTypes((Biome)Biomes.field_76779_k);
        BiomeDictionary.Type[] hellTypes = hellTypesSet.toArray(new BiomeDictionary.Type[hellTypesSet.size()]);
        BiomeDictionary.Type[] skyTypes = skyTypesSet.toArray(new BiomeDictionary.Type[skyTypesSet.size()]);
        HashMap typesToRestore = new HashMap();
        for (Map.Entry entry : Biome.field_185377_q.field_82596_a.entrySet()) {
            String string = ((ResourceLocation)entry.getKey()).func_110624_b();
            if (string.startsWith("minecraft") && !string.startsWith("openterraingenerator") || typesToRestore.containsKey(entry.getValue())) continue;
            typesToRestore.put(entry.getValue(), ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)entry.getValue()) ? BiomeDictionary.getTypes((Biome)((Biome)entry.getValue())) : new HashSet());
        }
        if (world != null) {
            Iterator iterator = this.worlds;
            synchronized (iterator) {
                for (LocalWorld localWorld : this.worlds.values()) {
                    if (localWorld == world) continue;
                    for (LocalBiome localBiome : ((ForgeWorld)localWorld).biomeNames.values()) {
                        if (typesToRestore.containsKey(((ForgeBiome)localBiome).biomeBase)) continue;
                        typesToRestore.put(((ForgeBiome)localBiome).biomeBase, ForgeRegistries.BIOMES.containsValue((IForgeRegistryEntry)((ForgeBiome)localBiome).biomeBase) ? BiomeDictionary.getTypes((Biome)((ForgeBiome)localBiome).biomeBase) : new HashSet());
                    }
                }
            }
        }
        try {
            Class<?> fieldClass;
            Field[] declaredfields;
            Field[] fieldArray = declaredfields = BiomeDictionary.class.getDeclaredFields();
            int n = fieldArray.length;
            for (int i = 0; i < n; ++i) {
                Field field = fieldArray[i];
                fieldClass = field.getType();
                if (!fieldClass.equals(Map.class)) continue;
                field.setAccessible(true);
                HashMap biomeRegistryAvailabiltyMap = (HashMap)field.get(BiomeDictionary.class);
                biomeRegistryAvailabiltyMap.clear();
            }
            for (Field field : declaredfields = BiomeDictionary.Type.class.getDeclaredFields()) {
                fieldClass = field.getType();
                if (!fieldClass.equals(Map.class)) continue;
                field.setAccessible(true);
                HashMap byName = (HashMap)field.get(BiomeDictionary.class);
                for (BiomeDictionary.Type type : byName.values()) {
                    Field[] typeDeclaredfields;
                    for (Field typeField : typeDeclaredfields = BiomeDictionary.Type.class.getDeclaredFields()) {
                        Class<?> typeFieldClass = typeField.getType();
                        if (!typeFieldClass.equals(Set.class)) continue;
                        typeField.setAccessible(true);
                        Set biomes = (Set)typeField.get(type);
                        try {
                            biomes.clear();
                        }
                        catch (UnsupportedOperationException unsupportedOperationException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        BiomeDictionary.addTypes((Biome)Biomes.field_76778_j, (BiomeDictionary.Type[])hellTypes);
        BiomeDictionary.addTypes((Biome)Biomes.field_76779_k, (BiomeDictionary.Type[])skyTypes);
        for (Map.Entry entry : typesToRestore.entrySet()) {
            BiomeDictionary.addTypes((Biome)((Biome)entry.getKey()), (BiomeDictionary.Type[])((Set)entry.getValue()).toArray(new BiomeDictionary.Type[((Set)entry.getValue()).size()]));
        }
    }

    public void unRegisterDefaultBiomes() {
        for (DefaultBiome defaultBiome : DefaultBiome.values()) {
            if (defaultBiome.Name.equals("The Void") || defaultBiome.Name.equals("Hell") || defaultBiome.Name.equals("Sky")) continue;
            ResourceLocation registryKey = ForgeWorld.vanillaResouceLocations.get(defaultBiome.Id);
            ((ForgeEngine)OTG.getEngine()).unRegisterForgeBiome(registryKey);
        }
    }

    public void unRegisterTCBiomes() {
        BitSet biomeRegistryAvailabiltyMap = this.getBiomeRegistryAvailabiltyMap();
        for (Map.Entry biome : Biome.field_185377_q.field_82596_a.entrySet()) {
            if (!((ResourceLocation)biome.getKey()).func_110624_b().equals("OpenTerrainGenerator") && !((ResourceLocation)biome.getKey()).func_110624_b().equals("minecraft") || ((Biome)biome.getValue()).func_185359_l().equals("The End") || ((Biome)biome.getValue()).func_185359_l().equals("The Void") || ((Biome)biome.getValue()).func_185359_l().equals("Hell") || ((Biome)biome.getValue()).func_185359_l().equals("Sky")) continue;
            OTG.log(LogMarker.TRACE, "Unregistering " + ((Biome)biome.getValue()).func_185359_l(), new Object[0]);
            int biomeId = Biome.func_185362_a((Biome)((Biome)biome.getValue()));
            if (biome != Biome.func_150568_d((int)biomeId)) continue;
            biomeRegistryAvailabiltyMap.set(biomeId, false);
        }
    }

    public BitSet getBiomeRegistryAvailabiltyMap() {
        BitSet biomeRegistryAvailabiltyMap = null;
        try {
            Field[] fields;
            for (Field field : fields = Biome.field_185377_q.getClass().getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(BitSet.class)) continue;
                field.setAccessible(true);
                biomeRegistryAvailabiltyMap = (BitSet)field.get(Biome.field_185377_q);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return biomeRegistryAvailabiltyMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void registerClientWorldBukkit(WorldClient mcWorld, DataInputStream wrappedStream) throws IOException {
        ForgeWorld world = new ForgeWorld(ConfigFile.readStringFromStream(wrappedStream), mcWorld.field_73011_w.getDimension() == 0);
        ClientConfigProvider configs = new ClientConfigProvider(wrappedStream, world, Minecraft.func_71410_x().func_71356_B());
        world.provideClientConfigsBukkit(mcWorld, configs);
        HashMap<String, ForgeWorld> hashMap = this.worlds;
        synchronized (hashMap) {
            HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
            synchronized (hashMap2) {
                this.worlds.put(world.getName(), world);
                this.unloadedWorlds.remove(world.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    public void registerClientWorld(DataInputStream wrappedStream) throws IOException {
        int worldCount = wrappedStream.readInt();
        HashMap<Integer, String> dimsToRemove = OTGDimensionManager.GetAllOTGDimensions();
        boolean isSinglePlayer = Minecraft.func_71410_x().func_71356_B();
        for (int i = 0; i < worldCount; ++i) {
            int dimensionId = wrappedStream.readInt();
            Integer integerToRemove = 0;
            boolean bFound = false;
            for (Map.Entry<Integer, String> dimToRemove : dimsToRemove.entrySet()) {
                if (dimToRemove.getKey() != dimensionId) continue;
                bFound = true;
                integerToRemove = dimToRemove.getKey();
            }
            if (bFound) {
                dimsToRemove.remove(integerToRemove);
            }
            String worldName = ConfigFile.readStringFromStream(wrappedStream);
            ForgeWorld overWorld = null;
            if (i == 0 && (overWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldName)) == null) {
                overWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldName);
            }
            if (i == 0 && overWorld == null || !DimensionManager.isDimensionRegistered((int)dimensionId)) {
                if (i != 0) {
                    OTGDimensionManager.registerDimension(dimensionId, DimensionType.register((String)worldName, (String)"OTG", (int)dimensionId, WorldProviderOTG.class, (boolean)false));
                }
                ForgeWorld world = new ForgeWorld(worldName, dimensionId == 0);
                world.clientDimensionId = dimensionId;
                ClientConfigProvider configs = new ClientConfigProvider(wrappedStream, world, isSinglePlayer);
                world.provideClientConfigs(configs);
                HashMap<String, ForgeWorld> hashMap = this.worlds;
                synchronized (hashMap) {
                    HashMap<String, ForgeWorld> hashMap2 = this.unloadedWorlds;
                    synchronized (hashMap2) {
                        this.worlds.put(world.getName(), world);
                        this.unloadedWorlds.remove(world.getName());
                    }
                }
            }
            new ClientConfigProvider(wrappedStream, new ForgeWorld(), isSinglePlayer);
        }
        for (Map.Entry<Integer, String> removedDim : dimsToRemove.entrySet()) {
            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(removedDim.getValue());
            if (forgeWorld == null) {
                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(removedDim.getValue());
            }
            OTGDimensionManager.DeleteDimension(removedDim.getKey(), forgeWorld, Minecraft.func_71410_x().field_71439_g.func_184102_h(), false);
        }
    }
}

