/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.dimensions;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.generator.Cartographer;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPortal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.DimensionType;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class OTGBlockPortal {
    public static boolean trySpawnPortal(World worldIn, BlockPos pos, boolean isQuartz) {
        boolean isCartographerPortal;
        boolean cartographerEnabled = ((ForgeEngine)OTG.getEngine()).getCartographerEnabled();
        boolean bFound = false;
        boolean bFoundOtherThanCartographer = false;
        for (int i = 2; i < 1024; ++i) {
            DimensionType dimensionType;
            if (!DimensionManager.isDimensionRegistered((int)i) || (dimensionType = DimensionManager.getProviderType((int)i)).func_186067_c() == null || !dimensionType.func_186067_c().equals("OTG")) continue;
            bFound = true;
            if (!cartographerEnabled) break;
            if (i == Cartographer.CartographerDimension) continue;
            bFoundOtherThanCartographer = true;
            break;
        }
        if (!bFound) {
            return false;
        }
        IBlockState blockState = worldIn.func_180495_p(pos);
        BlockPos firstSolidBlockPos = new BlockPos((Vec3i)pos);
        while (!blockState.func_185904_a().func_76220_a() && firstSolidBlockPos.func_177956_o() > 0) {
            firstSolidBlockPos = new BlockPos(firstSolidBlockPos.func_177958_n(), firstSolidBlockPos.func_177956_o() - 1, firstSolidBlockPos.func_177952_p());
            blockState = worldIn.func_180495_p(firstSolidBlockPos);
        }
        boolean bl = isCartographerPortal = blockState.func_177230_c() == Blocks.field_150371_ca && (byte)blockState.func_177230_c().func_176201_c(blockState) == 1;
        if (!(!cartographerEnabled && bFound || !cartographerEnabled || bFoundOtherThanCartographer || isCartographerPortal)) {
            return false;
        }
        Size blockportal$size = new Size(worldIn, pos, EnumFacing.Axis.X, isQuartz);
        if (blockportal$size.isValid() && blockportal$size.portalBlockCount == 0) {
            blockportal$size.placePortalBlocks();
            return true;
        }
        Size blockportal$size1 = new Size(worldIn, pos, EnumFacing.Axis.Z, isQuartz);
        if (blockportal$size1.isValid() && blockportal$size1.portalBlockCount == 0) {
            blockportal$size1.placePortalBlocks();
            return true;
        }
        return false;
    }

    public static void placeInExistingPortal(int dimensionId, BlockPos pos) {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        WorldServer worldServerInstance = mcServer.func_71218_a(dimensionId);
        Long2ObjectMap destinationCoordinateCache = null;
        Teleporter _this = worldServerInstance.func_85176_s();
        try {
            Field[] fields;
            for (Field field : fields = _this.getClass().getDeclaredFields()) {
                Class<?> fieldClass = field.getType();
                if (!fieldClass.equals(Long2ObjectMap.class)) continue;
                field.setAccessible(true);
                destinationCoordinateCache = (Long2ObjectMap)field.get(_this);
                break;
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        int j = MathHelper.func_76141_d((float)pos.func_177958_n());
        int k = MathHelper.func_76141_d((float)pos.func_177952_p());
        long l = ChunkPos.func_77272_a((int)j, (int)k);
        if (destinationCoordinateCache.containsKey(l)) {
            Teleporter.PortalPosition teleporter$portalposition = (Teleporter.PortalPosition)destinationCoordinateCache.get(l);
            teleporter$portalposition.field_85087_d = worldServerInstance.func_82737_E();
        } else {
            Teleporter teleporter = _this;
            teleporter.getClass();
            destinationCoordinateCache.put(l, (Object)new Teleporter.PortalPosition(teleporter, pos, worldServerInstance.func_82737_E()));
        }
    }

    public static class Size {
        private final World world;
        private final EnumFacing.Axis axis;
        private final EnumFacing rightDir;
        private final EnumFacing leftDir;
        private int portalBlockCount;
        private BlockPos bottomLeft;
        private int height;
        private int width;

        public Size(World worldIn, BlockPos p_i45694_2_, EnumFacing.Axis p_i45694_3_, boolean isQuartz) {
            this.world = worldIn;
            this.axis = p_i45694_3_;
            if (p_i45694_3_ == EnumFacing.Axis.X) {
                this.leftDir = EnumFacing.EAST;
                this.rightDir = EnumFacing.WEST;
            } else {
                this.leftDir = EnumFacing.NORTH;
                this.rightDir = EnumFacing.SOUTH;
            }
            BlockPos blockpos = p_i45694_2_;
            while (p_i45694_2_.func_177956_o() > blockpos.func_177956_o() - 21 && p_i45694_2_.func_177956_o() > 0 && this.isEmptyBlock(worldIn.func_180495_p(p_i45694_2_.func_177977_b()).func_177230_c())) {
                p_i45694_2_ = p_i45694_2_.func_177977_b();
            }
            ArrayList<LocalWorld> forgeWorlds = ((ForgeEngine)OTG.getEngine()).getAllWorlds();
            for (LocalWorld localWorld : forgeWorlds) {
                ForgeWorld forgeWorld = (ForgeWorld)localWorld;
                ArrayList<LocalMaterialData> portalMaterials = forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials;
                if (this.world.field_73011_w.getDimension() == forgeWorld.getWorld().field_73011_w.getDimension() && this.world.field_73011_w.getDimension() == 0) continue;
                int i = this.getDistanceUntilEdge(portalMaterials, p_i45694_2_, this.leftDir, isQuartz) - 1;
                if (i >= 0) {
                    this.bottomLeft = p_i45694_2_.func_177967_a(this.leftDir, i);
                    this.width = this.getDistanceUntilEdge(portalMaterials, this.bottomLeft, this.rightDir, isQuartz);
                    if (this.width < 2 || this.width > 21) {
                        this.bottomLeft = null;
                        this.width = 0;
                    }
                }
                if (this.bottomLeft != null) {
                    this.height = this.calculatePortalHeight(portalMaterials, isQuartz);
                }
                if (this.height <= 0 || this.width <= 0) continue;
                return;
            }
        }

        protected int getDistanceUntilEdge(ArrayList<LocalMaterialData> portalMaterials, BlockPos p_180120_1_, EnumFacing p_180120_2_, boolean isQuartz) {
            Block block;
            int i;
            for (i = 0; i < 22; ++i) {
                BlockPos blockpos = p_180120_1_.func_177967_a(p_180120_2_, i);
                block = this.world.func_180495_p(blockpos).func_177230_c();
                IBlockState blockStateDown = this.world.func_180495_p(blockpos.func_177977_b());
                Block blockDown = blockStateDown.func_177230_c();
                ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockStateDown);
                boolean isPortalMaterial = false;
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                    isPortalMaterial = true;
                }
                if (!this.isEmptyBlock(block) || !isQuartz && blockDown != Blocks.field_150343_Z || isQuartz && !isPortalMaterial) break;
            }
            IBlockState blockState = this.world.func_180495_p(p_180120_1_.func_177967_a(p_180120_2_, i));
            block = blockState.func_177230_c();
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
            boolean isPortalMaterial = false;
            for (LocalMaterialData portalMaterial : portalMaterials) {
                if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                isPortalMaterial = true;
            }
            return !isQuartz && block == Blocks.field_150343_Z || isQuartz && isPortalMaterial ? i : 0;
        }

        public int getHeight() {
            return this.height;
        }

        public int getWidth() {
            return this.width;
        }

        protected int calculatePortalHeight(ArrayList<LocalMaterialData> portalMaterials, boolean isQuartz) {
            Block block;
            this.height = 0;
            block0: while (this.height < 21) {
                for (int i = 0; i < this.width; ++i) {
                    boolean isPortalMaterial;
                    ForgeMaterialData material;
                    IBlockState blockState;
                    BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i).func_177981_b(this.height);
                    block = this.world.func_180495_p(blockpos).func_177230_c();
                    if (!this.isEmptyBlock(block)) break block0;
                    if (block == Blocks.field_150427_aO) {
                        ++this.portalBlockCount;
                    }
                    if (i == 0) {
                        blockState = this.world.func_180495_p(blockpos.func_177972_a(this.leftDir));
                        block = blockState.func_177230_c();
                        material = ForgeMaterialData.ofMinecraftBlockState(blockState);
                        isPortalMaterial = false;
                        for (LocalMaterialData portalMaterial : portalMaterials) {
                            if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                            isPortalMaterial = true;
                        }
                        if (!isQuartz && block == Blocks.field_150343_Z || isQuartz && isPortalMaterial) continue;
                        break block0;
                    }
                    if (i != this.width - 1) continue;
                    blockState = this.world.func_180495_p(blockpos.func_177972_a(this.rightDir));
                    block = blockState.func_177230_c();
                    material = ForgeMaterialData.ofMinecraftBlockState(blockState);
                    isPortalMaterial = false;
                    for (LocalMaterialData portalMaterial : portalMaterials) {
                        if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                        isPortalMaterial = true;
                    }
                    if (!(!isQuartz && block == Blocks.field_150343_Z || isQuartz && isPortalMaterial)) break block0;
                }
                ++this.height;
            }
            for (int j = 0; j < this.width; ++j) {
                IBlockState blockState = this.world.func_180495_p(this.bottomLeft.func_177967_a(this.rightDir, j).func_177981_b(this.height));
                block = blockState.func_177230_c();
                ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
                boolean isPortalMaterial = false;
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                    isPortalMaterial = true;
                }
                if (!isQuartz && block == Blocks.field_150343_Z || isQuartz && isPortalMaterial) continue;
                this.height = 0;
                break;
            }
            if (this.height <= 21 && this.height >= 3) {
                return this.height;
            }
            this.bottomLeft = null;
            this.width = 0;
            this.height = 0;
            return 0;
        }

        protected boolean isEmptyBlock(Block blockIn) {
            return blockIn.func_149688_o(null) == Material.field_151579_a || blockIn == Blocks.field_150480_ab || blockIn == Blocks.field_150427_aO;
        }

        public boolean isValid() {
            return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
        }

        public void placePortalBlocks() {
            for (int i = 0; i < this.width; ++i) {
                BlockPos blockpos = this.bottomLeft.func_177967_a(this.rightDir, i);
                for (int j = 0; j < this.height; ++j) {
                    this.world.func_180501_a(blockpos.func_177981_b(j), Blocks.field_150427_aO.func_176223_P().func_177226_a((IProperty)BlockPortal.field_176550_a, (Comparable)this.axis), 2);
                }
            }
        }
    }
}

