/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.dimensions.OTGBlockPortal;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.forge.generator.Cartographer;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class EntityTravelToDimensionListener {
    @SubscribeEvent
    public void entityTravelToDimension(EntityTravelToDimensionEvent e) {
        boolean cartographerEnabled = ((ForgeEngine)OTG.getEngine()).getCartographerEnabled();
        if (e.getDimension() == -1) {
            if (!ForgeMaterialData.ofMinecraftBlockState(e.getEntity().func_130014_f_().func_180495_p(e.getEntity().func_180425_c())).toDefaultMaterial().equals((Object)DefaultMaterial.PORTAL)) {
                e.getEntity().field_71088_bW = 0;
                e.setCanceled(true);
                return;
            }
            Entity sender = e.getEntity();
            BlockPos playerPos = new BlockPos((Vec3i)sender.func_180425_c());
            World world = sender.func_130014_f_();
            BlockPos pos = new BlockPos((Vec3i)sender.func_180425_c());
            IBlockState blockState = world.func_180495_p(pos);
            while (!blockState.func_185904_a().func_76220_a() && pos.func_177956_o() > 0) {
                pos = new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p());
                blockState = world.func_180495_p(pos);
            }
            ArrayList<LocalWorld> forgeWorlds = ((ForgeEngine)OTG.getEngine()).getAllWorlds();
            int destinationDim = 0;
            boolean bPortalMaterialFound = false;
            ForgeMaterialData material = ForgeMaterialData.ofMinecraftBlockState(blockState);
            for (LocalWorld localWorld : forgeWorlds) {
                ForgeWorld forgeWorld = (ForgeWorld)localWorld;
                ArrayList<LocalMaterialData> portalMaterials = forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials;
                boolean bIsPortalMaterial = false;
                for (LocalMaterialData portalMaterial : portalMaterials) {
                    if (!material.toDefaultMaterial().equals((Object)portalMaterial.toDefaultMaterial()) || material.getBlockData() != portalMaterial.getBlockData()) continue;
                    bIsPortalMaterial = true;
                    bPortalMaterialFound = true;
                    break;
                }
                if (!bIsPortalMaterial) continue;
                if (forgeWorld.getWorld().field_73011_w.getDimension() != e.getEntity().field_71093_bK) {
                    destinationDim = forgeWorld.getWorld().field_73011_w.getDimension();
                    break;
                }
                destinationDim = 0;
            }
            if (!bPortalMaterialFound && !material.toDefaultMaterial().equals((Object)DefaultMaterial.OBSIDIAN)) {
                e.getEntity().func_130014_f_().func_175698_g(e.getEntity().func_180425_c());
                e.setCanceled(true);
                return;
            }
            if (pos.func_177956_o() > 0 && bPortalMaterialFound) {
                boolean isCartographerPortal;
                e.setCanceled(true);
                int originDimension = e.getEntity().field_71093_bK;
                int newDimension = destinationDim;
                boolean bl = isCartographerPortal = cartographerEnabled && blockState.func_177230_c() == Blocks.field_150371_ca && (byte)blockState.func_177230_c().func_176201_c(blockState) == 1;
                if (isCartographerPortal) {
                    newDimension = Cartographer.CartographerDimension;
                }
                if (newDimension == 0 && e.getEntity().field_71093_bK == 0) {
                    e.getEntity().func_130014_f_().func_175698_g(e.getEntity().func_180425_c());
                    return;
                }
                OTGBlockPortal.placeInExistingPortal(originDimension, playerPos);
                if (e.getEntity() instanceof EntityPlayerMP) {
                    OTGTeleporter.changeDimension(newDimension, (EntityPlayerMP)e.getEntity());
                } else {
                    OTGTeleporter.changeDimension(newDimension, e.getEntity());
                }
                if (originDimension == 0 && cartographerEnabled) {
                    Cartographer.CreateBlockWorldMapAtSpawn(ChunkCoordinate.fromBlockCoords(playerPos.func_177958_n(), playerPos.func_177952_p()), true);
                }
            }
        }
    }
}

