/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.BiomeIds;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.forge.ForgeBiome;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.ForgeWorldSession;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.OTGWorldType;
import com.pg85.otg.forge.dimensions.OTGDimensionManager;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.forge.events.PlayerTracker;
import com.pg85.otg.forge.generator.Pregenerator;
import com.pg85.otg.forge.util.CommandHelper;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraftTypes.MobNames;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.registry.GameData;

public final class OTGCommandHandler
implements ICommand {
    private final List<String> aliases = Arrays.asList("otg");
    public static final TextFormatting ERROR_COLOR = TextFormatting.RED;
    public static final TextFormatting MESSAGE_COLOR = TextFormatting.GREEN;
    public static final TextFormatting VALUE_COLOR = TextFormatting.DARK_GREEN;

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] argString) {
        World mcWorld = sender.func_130014_f_();
        boolean isOp = sender.func_70003_b(2, this.func_71517_b());
        if (!mcWorld.field_72995_K) {
            int radius;
            ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(mcWorld);
            if (world == null && (argString.length == 0 || !argString[0].equals("dimension") && !argString[0].equals("dim") || argString.length >= 3)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "OpenTerrainGenerator is not enabled for this world.", new Object[0]));
                return;
            }
            BlockPos pos = sender.func_180425_c();
            int playerX = pos.func_177958_n();
            int playerY = pos.func_177956_o();
            int playerZ = pos.func_177952_p();
            if (argString != null && argString.length > 0 && argString[0].equals("summon")) {
                radius = 1;
                if (argString.length > 1) {
                    radius = Integer.parseInt(argString[1]);
                }
                if (radius > 50) {
                    radius = 50;
                    OTG.log(LogMarker.INFO, "Error in summon call: Parameter radius can be no higher than 50. Radius was set to 50.", new Object[0]);
                }
                argString = new String[]{"GetModData", "OTG", radius + ""};
            }
            if (argString == null || argString.length == 0) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("-- OpenTerrainGenerator --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Commands:"));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg worldinfo " + VALUE_COLOR + "Show author and description information for this world."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg biome <-f, -s, -d, -m> " + VALUE_COLOR + "Show biome information for the biome at the player's coordinates."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg bo3 " + VALUE_COLOR + "Show author and description information for any structure at the player's coordinates."));
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg tp <biome name or id / dimension name> " + VALUE_COLOR + "Teleport to the given dimension or to the nearest biome with the given name or id (max distance 16000 blocks)."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg pregen " + VALUE_COLOR + "Shows the status of any currently active pre-generators. Same as /otg pregenerator."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg pregen <radius> " + VALUE_COLOR + "Sets the pre-generation radius for the curren world to <radius> chunks. Same as /otg pregenerator <radius>."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg pregen <radius> <dimension id> " + VALUE_COLOR + "Sets the pre-generation radius for dimension <dimension id> to <radius> chunks. Same as /otg pregenerator <radius> <dimension id>."));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim " + VALUE_COLOR + "Shows the name and id of the dimension the player is currently in. Same as /otg dimension."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -l " + VALUE_COLOR + "Shows a list of all dimensions. Same as /otg dimension -l."));
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -c <dimension name> " + VALUE_COLOR + "Creates a dimension using world and biome configs from mods/OpenTerrainGenerator/worlds/<dimension name>. Custom dimensions can be accessed via a quartz portal. Biome names must be unique across dimensions. Same as /otg dimension -c <dimension name>"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg dim -d <dimension name> " + VALUE_COLOR + "Deletes the specified dimension. Dimension must be unloaded (dimensions unload automatically when no players are inside, this may take a minute). Same as /otg dimension -d <dimension name>"));
                }
                if (isOp) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg blocks " + VALUE_COLOR + "Show a list of block names that can be spawned inside BO3's with the Block() tag and used in biome- and world-configs."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg entities " + VALUE_COLOR + "Show a list of entities that can be spawned inside BO3's using the Entity() tag."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg unloadbo3s " + VALUE_COLOR + "Unloads all loaded BO2/BO3 files, use this to refresh BO2's/BO3's after editing them."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg GetModData <ModName> <Radius> " + VALUE_COLOR + "Sends any ModData() tags in BO3's within the specified <Radius> in chunks to the specified <ModName>. Some OTG mob spawning commands can be used this way. Be sure to set up ModData() tags in your BO3 to make this work."));
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "/otg summon <Radius> " + VALUE_COLOR + "Shorthand for /mcw GetModData OTG <Radius>. Used to summon mobs and entities that are configured to spawn inside BO3's."));
                }
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("Tips:"));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- Check out OTG.ini and each world's WorldConfig.ini for optional features."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- When using the pre-generator in single player open the chat window so you can background MC without pausing the game."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- When using the pre-generator in single player press F3 to toggle the pre-generator HUD showing the pre-generator status."));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- When using the pre-generator in multiplayer use the /otg pregen command to see the pre-generator status."));
            } else if (argString[0].equals("blocks") && isOp) {
                OTG.log(LogMarker.INFO, "-- Blocks List --", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("-- Blocks List --"));
                Set as = GameData.getBlockRegistry().getKeys();
                for (ResourceLocation blockAlias : as) {
                    OTG.log(LogMarker.INFO, blockAlias + "", new Object[0]);
                    sender.func_145747_a((ITextComponent)new TextComponentString(blockAlias + ""));
                }
                OTG.log(LogMarker.INFO, "----", new Object[0]);
            } else if (argString[0].equals("unloadbo3s") && isOp) {
                OTG.log(LogMarker.INFO, "Unloading BO3's", new Object[0]);
                OTG.getEngine().ReloadCustomObjectFiles();
                OTG.log(LogMarker.INFO, "BO3's unloaded", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("BO3's unloaded"));
            } else if (isOp && argString[0].equals("tp") && argString.length > 1) {
                String biomeName = "";
                for (int i = 1; i < argString.length; ++i) {
                    biomeName = biomeName + argString[i] + " ";
                }
                if (biomeName != null && biomeName.length() > 0) {
                    int biomeId = -1;
                    try {
                        biomeId = Integer.parseInt(biomeName.replace(" ", ""));
                    }
                    catch (NumberFormatException blockAlias) {
                        // empty catch block
                    }
                    for (int i = -1; i < 1024; ++i) {
                        DimensionType dimensionType;
                        if (!DimensionManager.isDimensionRegistered((int)i) || !(dimensionType = DimensionManager.getProviderType((int)i)).func_186065_b().toLowerCase().trim().equals(biomeName.toLowerCase().trim())) continue;
                        OTGTeleporter.changeDimension(i, (EntityPlayerMP)sender.func_174793_f(), true);
                        return;
                    }
                    ChunkCoordinate playerChunk = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                    int maxRadius = 1000;
                    for (int cycle = 1; cycle < maxRadius; ++cycle) {
                        for (int x1 = playerX - cycle; x1 <= playerX + cycle; ++x1) {
                            for (int i = playerZ - cycle; i <= playerZ + cycle; ++i) {
                                ChunkCoordinate chunkCoord;
                                ForgeBiome biome;
                                if (x1 != playerX - cycle && x1 != playerX + cycle || i != playerZ - cycle && i != playerZ + cycle || (biome = (ForgeBiome)world.getBiome((chunkCoord = ChunkCoordinate.fromChunkCoords(playerChunk.getChunkX() + (x1 - playerX), playerChunk.getChunkZ() + (i - playerZ))).getBlockXCenter(), chunkCoord.getBlockZCenter())) == null || (biomeId != -1 || !biome.getName().toLowerCase().replace(" ", "").equals(biomeName.toLowerCase().replace(" ", ""))) && (biomeId == -1 || biome.getIds().getGenerationId() != biomeId)) continue;
                                ((Entity)sender).func_70634_a((double)chunkCoord.getBlockXCenter(), (double)world.getHighestBlockYAt(chunkCoord.getBlockXCenter(), chunkCoord.getBlockZCenter(), true, true, false, false), (double)chunkCoord.getBlockZCenter());
                                return;
                            }
                        }
                    }
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not find biome \"" + biomeName + "\".", new Object[0]));
                }
            } else if (argString[0].equals("worldinfo") || argString[0].equals("world")) {
                WorldConfig worldConfig = world.getConfigs().getWorldConfig();
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString("-- World info --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Name: " + VALUE_COLOR + world.getName()));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Author: " + VALUE_COLOR + worldConfig.author));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Description: " + VALUE_COLOR + worldConfig.description));
            } else if (isOp && (argString[0].equals("pregenerator") || argString[0].equals("pregen"))) {
                if (argString.length == 1) {
                    boolean isRunningAndNotDone = false;
                    ArrayList<Pregenerator> pregenerators = new ArrayList<Pregenerator>();
                    for (LocalWorld localWorld : OTG.getAllWorlds()) {
                        ForgeWorld forgeWorld = (ForgeWorld)localWorld;
                        Pregenerator pregenerator = ((ForgeWorldSession)forgeWorld.GetWorldSession()).getPregenerator();
                        if (!pregenerator.getPregeneratorIsRunning() || pregenerator.preGeneratorProgressStatus == "Done") continue;
                        isRunningAndNotDone = true;
                        pregenerators.add(pregenerator);
                    }
                    if (isRunningAndNotDone) {
                        for (Pregenerator pregenerator : pregenerators) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Generating \"" + VALUE_COLOR + pregenerator.pregenerationWorld + "\" " + MESSAGE_COLOR + (pregenerator.progressScreenWorldSizeInBlocks > 0 ? "(" + pregenerator.progressScreenWorldSizeInBlocks + "x" + pregenerator.progressScreenWorldSizeInBlocks + " blocks)" : "")));
                            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Progress: " + VALUE_COLOR + pregenerator.preGeneratorProgress + "%"));
                            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Chunks: " + VALUE_COLOR + pregenerator.preGeneratorProgressStatus));
                            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Elapsed: " + VALUE_COLOR + pregenerator.progressScreenElapsedTime));
                            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Estimated: " + VALUE_COLOR + pregenerator.progressScreenEstimatedTime));
                            sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "---"));
                        }
                        long i = Runtime.getRuntime().maxMemory();
                        long j = Runtime.getRuntime().totalMemory();
                        long l = Runtime.getRuntime().freeMemory();
                        long l2 = j - l;
                        sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Memory: " + VALUE_COLOR + Long.valueOf(OTGCommandHandler.BytesToMb(l2)) + "/" + Long.valueOf(OTGCommandHandler.BytesToMb(i)) + " MB"));
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "No pre-generator is currently running."));
                    }
                }
                if (argString.length > 1) {
                    radius = 0;
                    try {
                        radius = Integer.parseInt(argString[1]);
                    }
                    catch (NumberFormatException ex) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "\"" + argString[1] + "\" could not be parsed as a number.", new Object[0]));
                        return;
                    }
                    int dimensionId = 0;
                    if (argString.length > 2) {
                        try {
                            dimensionId = Integer.parseInt(argString[2]);
                        }
                        catch (NumberFormatException ex) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "\"" + argString[1] + "\" could not be parsed as a number.", new Object[0]));
                            return;
                        }
                    }
                    ForgeWorld targetWorld = world;
                    if (!DimensionManager.isDimensionRegistered((int)dimensionId)) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Dimension with id \"" + dimensionId + "\" does not exist.", new Object[0]));
                        return;
                    }
                    targetWorld = ((ForgeEngine)OTG.getEngine()).getWorldByDimId(dimensionId);
                    if (targetWorld == null) {
                        DimensionManager.initDimension((int)dimensionId);
                        targetWorld = ((ForgeEngine)OTG.getEngine()).getWorldByDimId(dimensionId);
                    }
                    if (targetWorld == null) {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not find OTG world for dimension with id \"" + dimensionId + "\".", new Object[0]));
                        return;
                    }
                    targetWorld.GetWorldSession().setPregenerationRadius(radius);
                    int newRadius = targetWorld.getConfigs().getWorldConfig().PreGenerationRadius = targetWorld.GetWorldSession().getPregenerationRadius();
                    ((ServerConfigProvider)targetWorld.getConfigs()).saveWorldConfig();
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Pre-generator radius set to " + VALUE_COLOR + newRadius + MESSAGE_COLOR + ".", new Object[0]));
                    return;
                }
            } else if (argString[0].equals("entities")) {
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                OTG.log(LogMarker.INFO, "-- Entities List --", new Object[0]);
                sender.func_145747_a((ITextComponent)new TextComponentString("-- Entities List --"));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "Some of these, like ThrownPotion, FallingSand, Mob and Painting may crash the game so be sure to test your BO3 in single player."));
                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                EnumCreatureType[] aenumcreaturetype = EnumCreatureType.values();
                for (ResourceLocation entry : EntityList.func_180124_b()) {
                    if (EntityList.getClass((ResourceLocation)entry) == null) continue;
                    String msg = entry.func_110623_a();
                    for (int k3 = 0; k3 < aenumcreaturetype.length; ++k3) {
                        EnumCreatureType enumcreaturetype = aenumcreaturetype[k3];
                        if (!enumcreaturetype.func_75598_a().isAssignableFrom(EntityList.getClass((ResourceLocation)entry))) continue;
                        msg = msg + VALUE_COLOR + " (" + enumcreaturetype.name() + ")";
                    }
                    OTG.log(LogMarker.INFO, msg.replace("\u00ef\u00bf\u00bd2", "").replace("\u00ef\u00bf\u00bd", "").replace("\u00ef\u00bf\u00bda", ""), new Object[0]);
                    sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- " + msg));
                }
                OTG.log(LogMarker.INFO, "----", new Object[0]);
            } else if (argString[0].equals("dimension") || argString[0].equals("dim")) {
                int dimId;
                if (argString.length < 2) {
                    dimId = sender.func_130014_f_().field_73011_w.getDimension();
                    DimensionType dimension = DimensionManager.getProviderType((int)dimId);
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Currently in dimension " + VALUE_COLOR + dimension.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + dimId + MESSAGE_COLOR + ".", new Object[0]));
                } else if (CommandHelper.containsArgument(argString, "-l")) {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentString("-- Dimensions --"));
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    dimId = sender.func_130014_f_().field_73011_w.getDimension();
                    DimensionType dimension = DimensionManager.getProviderType((int)dimId);
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Currently in dimension " + VALUE_COLOR + dimension.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + dimId + MESSAGE_COLOR + ".", new Object[0]));
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    for (int i = -1; i < 1024; ++i) {
                        if (!DimensionManager.isDimensionRegistered((int)i)) continue;
                        DimensionType dimensionType = DimensionManager.getProviderType((int)i);
                        LocalWorld forgeWorld = null;
                        if (i == 0) {
                            forgeWorld = ((ForgeEngine)OTG.getEngine()).getOverWorld();
                        } else {
                            forgeWorld = OTG.getWorld(dimensionType.func_186065_b());
                            if (forgeWorld == null) {
                                forgeWorld = OTG.getUnloadedWorld(dimensionType.func_186065_b());
                            }
                        }
                        String materials = "";
                        if (forgeWorld != null && forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials != null && forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials.size() > 0) {
                            materials = materials + MESSAGE_COLOR + " (";
                            for (LocalMaterialData material : forgeWorld.getConfigs().getWorldConfig().DimensionPortalMaterials) {
                                materials = materials + VALUE_COLOR + material.toString() + MESSAGE_COLOR + ", ";
                            }
                            materials = materials.substring(0, materials.length() - 2);
                            materials = materials + MESSAGE_COLOR + ")";
                        }
                        String string = VALUE_COLOR + dimensionType.func_186065_b() + MESSAGE_COLOR + " at id " + VALUE_COLOR + i + (OTG.getUnloadedWorld(dimensionType.func_186065_b()) == null ? MESSAGE_COLOR + " (loaded)" : VALUE_COLOR + " (unloaded)") + materials;
                        sender.func_145747_a((ITextComponent)new TextComponentString(MESSAGE_COLOR + "- " + string));
                    }
                } else if (isOp && argString.length > 2) {
                    WorldServer overWorld;
                    String mainWorldName;
                    String dimName = argString[2];
                    if (argString.length > 3) {
                        for (int i = 3; i < argString.length; ++i) {
                            dimName = dimName + " " + argString[i];
                        }
                    }
                    if ((mainWorldName = (overWorld = DimensionManager.getWorld((int)0)).func_72912_H().func_76065_j()).toLowerCase().trim().equals(dimName.toLowerCase().trim())) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Dimension name cannot be the same as world name.", new Object[0]));
                        return;
                    }
                    int existingDim = 0;
                    for (int i = 2; i < 1024; ++i) {
                        DimensionType dimensionType;
                        if (!DimensionManager.isDimensionRegistered((int)i) || (dimensionType = DimensionManager.getProviderType((int)i)).func_186067_c() == null || !dimensionType.func_186067_c().equals("OTG") || !dimensionType.func_186065_b().equals(dimName)) continue;
                        existingDim = i;
                        if (!CommandHelper.containsArgument(argString, "-c")) continue;
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Dimension '" + dimName + "' already exists.", new Object[0]));
                        return;
                    }
                    if (CommandHelper.containsArgument(argString, "-d")) {
                        if (existingDim > 1) {
                            if (((ForgeEngine)OTG.getEngine()).getWorldLoader().isWorldUnloaded(dimName)) {
                                ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(dimName);
                                OTGDimensionManager.DeleteDimension(existingDim, forgeWorld, server, true);
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Deleted dimension " + VALUE_COLOR + dimName + MESSAGE_COLOR + " at id " + VALUE_COLOR + existingDim + MESSAGE_COLOR + ".", new Object[0]));
                                PlayerTracker.SendAllWorldAndBiomeConfigsToAllPlayers(sender.func_184102_h());
                            } else {
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Cannot delete dimension " + VALUE_COLOR + dimName + ERROR_COLOR + ", it is currently loaded. Dimensions are unloaded automatically if no players are inside (this may take a minute).", new Object[0]));
                            }
                        }
                    } else if (CommandHelper.containsArgument(argString, "-c")) {
                        File worldConfigFile = new File(OTG.getEngine().getTCDataFolder().getAbsolutePath() + "/worlds/" + dimName + "/WorldConfig.ini");
                        if (!worldConfigFile.exists()) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Could not create dimension, mods/OpenTerrainGenerator/worlds/" + dimName + " could not be found or does not contain a WorldConfig.ini file.", new Object[0]));
                        } else {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Creating new dimension...", new Object[0]));
                            int newDimId = OTGDimensionManager.createDimension(dimName, false, true, true);
                            ForgeWorld forgeWorld = (ForgeWorld)OTG.getWorld(dimName);
                            DimensionManager.unloadWorld((int)forgeWorld.getWorld().field_73011_w.getDimension());
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "Created dimension " + VALUE_COLOR + dimName + MESSAGE_COLOR + " at id " + VALUE_COLOR + newDimId + MESSAGE_COLOR + ".", new Object[0]));
                            PlayerTracker.SendAllWorldAndBiomeConfigsToAllPlayers(sender.func_184102_h());
                        }
                    }
                }
            } else {
                if (argString[0].equals("biome")) {
                    LocalBiome savedBiome;
                    if (!(sender.func_130014_f_().func_72912_H().func_76067_t() instanceof OTGWorldType)) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "Biome information is not available for this dimension.", new Object[0]));
                        return;
                    }
                    LocalBiome biome = world.getBiome(playerX, playerZ);
                    BiomeIds biomeIds = biome.getIds();
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to the biome generator, you are in the " + VALUE_COLOR + biome.getName() + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + biomeIds.getGenerationId(), new Object[0]));
                    if (CommandHelper.containsArgument(argString, "-f")) {
                        sender.func_145747_a((ITextComponent)new TextComponentString(""));
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "The base temperature of this biome is " + VALUE_COLOR + biome.getBiomeConfig().biomeTemperature + MESSAGE_COLOR + ", \n" + MESSAGE_COLOR + " at your height it is " + VALUE_COLOR + biome.getTemperatureAt(playerX, playerY, playerZ), new Object[0]));
                    }
                    if (CommandHelper.containsArgument(argString, "-s")) {
                        try {
                            savedBiome = world.getSavedBiome(playerX, playerZ);
                            BiomeIds savedIds = savedBiome.getIds();
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "According to the world save files, you are in the " + VALUE_COLOR + savedBiome.getName() + MESSAGE_COLOR + " biome, with id " + VALUE_COLOR + savedIds.getSavedId(), new Object[0]));
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    if (CommandHelper.containsArgument(argString, "-d")) {
                        try {
                            savedBiome = (ForgeBiome)world.getSavedBiome(playerX, playerZ);
                            EnumCreatureType[] types = BiomeDictionary.getTypes((Biome)((ForgeBiome)savedBiome).biomeBase);
                            String typesString = "";
                            for (BiomeDictionary.Type type : types) {
                                if (typesString.length() == 0) {
                                    typesString = typesString + type.getName();
                                    continue;
                                }
                                typesString = typesString + ", " + type.getName();
                            }
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + "BiomeDict: " + VALUE_COLOR + typesString, new Object[0]));
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    if (CommandHelper.containsArgument(argString, "-m")) {
                        try {
                            ForgeBiome calculatedBiome = (ForgeBiome)world.getCalculatedBiome(playerX, playerZ);
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation("-- Biome mob spawning settings --", new Object[0]));
                            for (EnumCreatureType enumCreatureType : EnumCreatureType.values()) {
                                sender.func_145747_a((ITextComponent)new TextComponentString(""));
                                sender.func_145747_a((ITextComponent)new TextComponentTranslation(MESSAGE_COLOR + enumCreatureType.name() + ": ", new Object[0]));
                                ArrayList creatureList = (ArrayList)calculatedBiome.biomeBase.func_76747_a(enumCreatureType);
                                if (creatureList == null || creatureList.size() <= 0) continue;
                                for (Biome.SpawnListEntry spawnListEntry : creatureList) {
                                    sender.func_145747_a((ITextComponent)new TextComponentTranslation(VALUE_COLOR + "{\"mob\": \"" + MobNames.toInternalName(spawnListEntry.field_76300_b.getSimpleName()) + "\", \"weight\": " + spawnListEntry.field_76292_a + ", \"min\": " + spawnListEntry.field_76301_c + ", \"max\": " + spawnListEntry.field_76299_d + "}", new Object[0]));
                                }
                            }
                        }
                        catch (BiomeNotFoundException e) {
                            sender.func_145747_a((ITextComponent)new TextComponentString(""));
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(ERROR_COLOR + "An unknown biome (" + e.getBiomeName() + ") was saved to the save files here.", new Object[0]));
                        }
                    }
                    return;
                }
                if (argString[0].toLowerCase().trim().equals("bo3") || argString[0].toLowerCase().trim().equals("bo3info")) {
                    String structureInfo = world.GetWorldSession().GetStructureInfoAt(sender.func_180425_c().func_177958_n(), sender.func_180425_c().func_177952_p());
                    if (structureInfo.length() > 0) {
                        for (String messagePart : structureInfo.split("\r\n")) {
                            sender.func_145747_a((ITextComponent)new TextComponentTranslation(messagePart, new Object[0]));
                        }
                    } else {
                        sender.func_145747_a((ITextComponent)new TextComponentTranslation("There's nothing here.", new Object[0]));
                    }
                } else if (argString[0].equals("GetModData") && argString.length > 1) {
                    if (!(sender instanceof EntityPlayer) || isOp) {
                        if (argString.length == 2) {
                            ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                            FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.instance, (String)argString[1], (String)"GetModData", (String)(sender.func_130014_f_().func_72912_H().func_76065_j() + "," + chunkCoord.getChunkX() + "," + chunkCoord.getChunkZ()));
                        } else if (argString.length == 3) {
                            try {
                                ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(playerX, playerZ);
                                int radius2 = Integer.parseInt(argString[2]);
                                if (radius2 > 50) {
                                    radius2 = 50;
                                    OTG.log(LogMarker.INFO, "Error in GetModData call: Parameter radius can be no higher than 50. Radius was set to 50.", new Object[0]);
                                }
                                for (int x = -radius2; x <= radius2; ++x) {
                                    for (int z = -radius2; z <= radius2; ++z) {
                                        ChunkCoordinate chunkCoord2 = ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + x, chunkCoord.getChunkZ() + z);
                                        FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.instance, (String)argString[1], (String)"GetModData", (String)(sender.func_130014_f_().func_72912_H().func_76065_j() + "," + chunkCoord2.getChunkX() + "," + chunkCoord2.getChunkZ()));
                                    }
                                }
                            }
                            catch (NumberFormatException ex) {
                                OTG.log(LogMarker.INFO, "Error in GetModData call: value \"" + argString[2] + "\" was expected to be a number", new Object[0]);
                            }
                        }
                    }
                } else {
                    sender.func_145747_a((ITextComponent)new TextComponentString(""));
                    sender.func_145747_a((ITextComponent)new TextComponentString("Unknown command. Type /otg for a list of commands."));
                }
            }
        }
    }

    private static long BytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public boolean func_82358_a(String[] var1, int var2) {
        return false;
    }

    public String func_71517_b() {
        return "otg";
    }

    public String func_71518_a(ICommandSender sender) {
        return "otg";
    }

    public List<String> func_71514_a() {
        return this.aliases;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, BlockPos targetPos) {
        return null;
    }

    public int compareTo(ICommand o) {
        return 0;
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }
}

