/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.google.common.collect.ImmutableList;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.customobjects.bo3.EntityFunction;
import com.pg85.otg.customobjects.bo3.ModDataFunction;
import com.pg85.otg.customobjects.bo3.ParticleFunction;
import com.pg85.otg.customobjects.bo3.SpawnerFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.OTGWorldType;
import com.pg85.otg.forge.dimensions.OTGTeleporter;
import com.pg85.otg.forge.generator.Cartographer;
import com.pg85.otg.forge.network.PacketDispatcher;
import com.pg85.otg.forge.network.ParticlesPacket;
import com.pg85.otg.forge.util.MobSpawnGroupHelper;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Stack;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ServerEventListener {
    private HashMap<ChunkCoordinate, Boolean> eligibleChunksForSpawning = new HashMap();
    int currentTimeInSeconds = 0;
    int lastSpawnedTimeInSeconds = 0;

    public void findChunksForSpawning(ForgeWorld world, boolean spawnHostileMobs, boolean spawnPeacefulMobs) {
        WorldServer worldServer = (WorldServer)world.getWorld();
        if (!spawnHostileMobs && !spawnPeacefulMobs) {
            return;
        }
        this.eligibleChunksForSpawning.clear();
        for (int i = 0; i < worldServer.field_73010_i.size(); ++i) {
            EntityPlayer entityplayer = (EntityPlayer)worldServer.field_73010_i.get(i);
            int playerPosChunkX = MathHelper.func_76128_c((double)(entityplayer.field_70165_t / 16.0));
            int playerPosChunkZ = MathHelper.func_76128_c((double)(entityplayer.field_70161_v / 16.0));
            int radius = 8;
            for (int l = -radius; l <= radius; ++l) {
                for (int i1 = -radius; i1 <= radius; ++i1) {
                    boolean flag3 = l == -radius || l == radius || i1 == -radius || i1 == radius;
                    ChunkCoordinate chunkcoordintpair = ChunkCoordinate.fromChunkCoords(l + playerPosChunkX, i1 + playerPosChunkZ);
                    if (flag3) continue;
                    this.eligibleChunksForSpawning.put(chunkcoordintpair, false);
                }
            }
        }
        Stack<Object[]> playerCoords = new Stack<Object[]>();
        for (int a = 0; a < worldServer.field_73010_i.size(); ++a) {
            EntityPlayer player = (EntityPlayer)worldServer.field_73010_i.get(a);
            playerCoords.add(new Object[]{player.field_70165_t, player.field_70163_u, player.field_70161_v, player});
        }
        double maxDistToClosestPlayer = 33.0;
        double maxDistToClosestPlayerSq = maxDistToClosestPlayer * maxDistToClosestPlayer;
        for (int x = 0; x < worldServer.field_72996_f.size(); ++x) {
            Entity entity = (Entity)worldServer.field_72996_f.get(x);
            NBTTagCompound entityData = entity.getEntityData();
            if (!entityData.func_74764_b("OTG")) continue;
            boolean playerInRange = false;
            for (int a = 0; a < playerCoords.size(); ++a) {
                float f2;
                float f1;
                float f = (float)((Double)((Object[])playerCoords.get(a))[0] - entity.field_70165_t);
                double distance = f * f + (f1 = (float)((Double)((Object[])playerCoords.get(a))[1] - entity.field_70163_u)) * f1 + (f2 = (float)((Double)((Object[])playerCoords.get(a))[2] - entity.field_70161_v)) * f2;
                if (!(distance < maxDistToClosestPlayerSq)) continue;
                playerInRange = true;
                break;
            }
            if (playerInRange) continue;
            int despawnTimer = entityData.func_74762_e("OTGDT");
            if (despawnTimer <= 1) {
                entity.func_70106_y();
                continue;
            }
            entityData.func_74768_a("OTGDT", despawnTimer - 1);
        }
        Random random = new Random();
        Stack<SpawnerFunction> spawnerDataSortedByDistance = new Stack<SpawnerFunction>();
        Stack<Object[]> spawnerDatasWithDistance = new Stack<Object[]>();
        for (ChunkCoordinate chunkcoordintpair1 : this.eligibleChunksForSpawning.keySet()) {
            ArrayList<SpawnerFunction> spawnerDataForOTG;
            if (this.eligibleChunksForSpawning.get(chunkcoordintpair1).booleanValue() || (spawnerDataForOTG = world.GetWorldSession().GetSpawnersForChunk(ChunkCoordinate.fromChunkCoords(chunkcoordintpair1.getChunkX(), chunkcoordintpair1.getChunkZ()))) == null || spawnerDataForOTG.size() <= 0) continue;
            block21: for (SpawnerFunction spawnerData : spawnerDataForOTG) {
                double distToClosestPlayer = maxDistToClosestPlayerSq;
                for (int a = 0; a < playerCoords.size(); ++a) {
                    float f2;
                    float f1;
                    float f = (float)((Double)((Object[])playerCoords.get(a))[0] - (double)spawnerData.x);
                    double distance = f * f + (f1 = (float)((Double)((Object[])playerCoords.get(a))[1] - (double)spawnerData.y)) * f1 + (f2 = (float)((Double)((Object[])playerCoords.get(a))[2] - (double)spawnerData.z)) * f2;
                    if (!(distance < distToClosestPlayer)) continue;
                    distToClosestPlayer = distance;
                }
                if (!(distToClosestPlayer > 0.0) || !(distToClosestPlayer < maxDistToClosestPlayerSq)) continue;
                if (spawnerDatasWithDistance.size() == 0) {
                    spawnerDatasWithDistance.add(new Object[]{distToClosestPlayer, spawnerData});
                    continue;
                }
                for (int r = 0; r < spawnerDatasWithDistance.size(); ++r) {
                    if (distToClosestPlayer < (Double)((Object[])spawnerDatasWithDistance.get(r))[0]) {
                        spawnerDatasWithDistance.add(r, new Object[]{distToClosestPlayer, spawnerData});
                        continue block21;
                    }
                    if (r != spawnerDatasWithDistance.size() - 1) continue;
                    spawnerDatasWithDistance.add(new Object[]{distToClosestPlayer, spawnerData});
                    continue block21;
                }
            }
        }
        for (Object[] spawnerDataWithDistance : spawnerDatasWithDistance) {
            spawnerDataSortedByDistance.add((SpawnerFunction)spawnerDataWithDistance[1]);
        }
        block25: for (SpawnerFunction spawnerData : spawnerDataSortedByDistance) {
            boolean b5;
            boolean b3;
            double velocityZ;
            double velocityX;
            double velocityY;
            NBTTagCompound nbttagcompound;
            Entity entityliving;
            Class<? extends EntityLiving> entityClass;
            int rngRoll;
            int despawnTime;
            int max;
            int spawnChance;
            int groupSize;
            block55: {
                String mobTypeName = spawnerData.mobName;
                groupSize = spawnerData.groupSize;
                int interval = spawnerData.interval;
                spawnChance = spawnerData.spawnChance;
                max = spawnerData.maxCount;
                despawnTime = spawnerData.despawnTime;
                rngRoll = random.nextInt(100);
                if ((this.currentTimeInSeconds - spawnerData.intervalOffset) % interval != 0 && !spawnerData.firstSpawn.booleanValue()) continue;
                if (spawnerData.firstSpawn.booleanValue()) {
                    spawnerData.intervalOffset = this.currentTimeInSeconds;
                }
                spawnerData.firstSpawn = false;
                entityClass = MobSpawnGroupHelper.toMinecraftClass(mobTypeName);
                if (entityClass == null) {
                    OTG.log(LogMarker.INFO, "Could not find entity: " + mobTypeName, new Object[0]);
                    continue;
                }
                entityliving = null;
                nbttagcompound = null;
                if (spawnerData.getMetaData() == null) {
                    try {
                        entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(worldServer);
                        break block55;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        continue;
                    }
                }
                nbttagcompound = new NBTTagCompound();
                try {
                    NBTTagCompound nbtbase = JsonToNBT.func_180713_a((String)spawnerData.getMetaData());
                    if (!(nbtbase instanceof NBTTagCompound)) {
                        throw new RuntimeException();
                    }
                    nbttagcompound = nbtbase;
                }
                catch (NBTException nbtexception) {
                    OTG.log(LogMarker.INFO, "Invalid NBT tag for mob in SpawnerFunction: " + spawnerData.getMetaData() + ". Skipping mob.", new Object[0]);
                    continue;
                }
                nbttagcompound.func_74778_a("id", spawnerData.mobName);
                entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldServer);
            }
            if (entityliving == null) {
                throw new RuntimeException();
            }
            int worldMobCount = 0;
            int mobCountRadius = 32;
            for (int x = 0; x < worldServer.field_72996_f.size(); ++x) {
                Entity entity = (Entity)worldServer.field_72996_f.get(x);
                if (entity.getClass() != entityClass || !entity.getEntityData().func_74764_b("OTG") || !(entity.field_70165_t >= (double)(spawnerData.x - mobCountRadius)) || !(entity.field_70165_t <= (double)(spawnerData.x + mobCountRadius)) || !(entity.field_70163_u >= (double)(spawnerData.y - mobCountRadius)) || !(entity.field_70163_u <= (double)(spawnerData.y + mobCountRadius)) || !(entity.field_70161_v >= (double)(spawnerData.z - mobCountRadius)) || !(entity.field_70161_v <= (double)(spawnerData.z + mobCountRadius))) continue;
                ++worldMobCount;
            }
            if (worldMobCount >= max) continue;
            int j1 = spawnerData.x;
            int k1 = spawnerData.y;
            int l1 = spawnerData.z;
            float x = (float)j1 + 0.5f;
            float y = k1;
            float z = (float)l1 + 0.5f;
            float yaw = spawnerData.yaw;
            float pitch = spawnerData.pitch;
            entityliving.getEntityData().func_74757_a("OTG", true);
            if (despawnTime > 0) {
                entityliving.getEntityData().func_74768_a("OTGDT", despawnTime - 1);
            }
            if (entityliving instanceof EntityLiving) {
                velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.0;
                velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
                velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
                entityliving.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
                entityliving.func_70024_g(velocityX, velocityY, velocityZ);
                Event.Result canSpawn = ForgeEventFactory.canEntitySpawn((EntityLiving)((EntityLiving)entityliving), (World)worldServer, (float)x, (float)y, (float)z);
                boolean entityCanSpawnHere = false;
                if (canSpawn == Event.Result.DEFAULT) {
                    boolean b32;
                    int ia = MathHelper.func_76128_c((double)entityliving.field_70165_t);
                    int ja = MathHelper.func_76128_c((double)entityliving.func_174813_aQ().field_72338_b);
                    int ka = MathHelper.func_76128_c((double)entityliving.field_70161_v);
                    boolean b1 = entityliving.field_70170_p.func_72855_b(entityliving.func_174813_aQ());
                    boolean b2 = entityliving.field_70170_p.func_184144_a(entityliving, entityliving.func_174813_aQ()).isEmpty();
                    boolean bl = b32 = !entityliving.field_70170_p.func_72953_d(entityliving.func_174813_aQ());
                    boolean b52 = entityliving instanceof EntityCreature ? ((EntityCreature)entityliving).func_180484_a(new BlockPos(ia, ja, ka)) >= 0.0f : true;
                    boolean bl2 = entityCanSpawnHere = b1 && b2 && b32 && b52;
                }
                if (canSpawn != Event.Result.ALLOW && (canSpawn != Event.Result.DEFAULT || !entityCanSpawnHere)) continue;
                for (int r = 0; r < groupSize && worldMobCount < max; ++r) {
                    rngRoll = random.nextInt(100);
                    if (spawnChance <= rngRoll) continue;
                    if (r != 0) {
                        block56: {
                            if (spawnerData.getMetaData() == null) {
                                try {
                                    entityliving = entityClass.getConstructor(World.class).newInstance(worldServer);
                                    break block56;
                                }
                                catch (Exception exception) {
                                    exception.printStackTrace();
                                    continue block25;
                                }
                            }
                            entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldServer);
                        }
                        velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.0;
                        velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
                        velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
                        entityliving.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
                        entityliving.func_70024_g(velocityX, velocityY, velocityZ);
                        entityliving.getEntityData().func_74757_a("OTG", true);
                        entityliving.getEntityData().func_74768_a("OTGDT", despawnTime);
                    }
                    if (spawnerData.getMetaData() == null) {
                        ((EntityLiving)entityliving).func_180482_a(worldServer.func_175649_E(new BlockPos((double)x, (double)y, (double)z)), (IEntityLivingData)null);
                    }
                    worldServer.func_72838_d(entityliving);
                    if (nbttagcompound != null) {
                        Entity entity2 = entityliving;
                        NBTTagCompound nbttagcompound1 = nbttagcompound;
                        while (entity2 != null && nbttagcompound1.func_150297_b("Riding", 10)) {
                            Entity entity = EntityList.func_75615_a((NBTTagCompound)nbttagcompound1.func_74775_l("Riding"), (World)worldServer);
                            if (entity != null) {
                                entity.func_70012_b((double)x, (double)y, (double)z, entity.field_70177_z, entity.field_70125_A);
                                worldServer.func_72838_d(entity);
                                entity2.func_184220_m(entity);
                            }
                            entity2 = entity;
                            nbttagcompound1 = nbttagcompound1.func_74775_l("Riding");
                        }
                    }
                    ++worldMobCount;
                }
                continue;
            }
            velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.1;
            velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
            velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
            entityliving.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
            if (!(entityliving instanceof EntityHanging)) {
                entityliving.func_70024_g(velocityX, velocityY, velocityZ);
            }
            boolean entityCanSpawnHere = false;
            int ia = MathHelper.func_76128_c((double)entityliving.field_70165_t);
            int ja = MathHelper.func_76128_c((double)entityliving.func_174813_aQ().field_72338_b);
            int ka = MathHelper.func_76128_c((double)entityliving.field_70161_v);
            boolean b1 = entityliving.field_70170_p.func_72855_b(entityliving.func_174813_aQ());
            boolean b2 = entityliving.field_70170_p.func_184144_a(entityliving, entityliving.func_174813_aQ()).isEmpty();
            boolean bl = b3 = !entityliving.field_70170_p.func_72953_d(entityliving.func_174813_aQ());
            boolean bl3 = entityliving instanceof EntityLiving ? ((EntityCreature)entityliving).func_180484_a(new BlockPos(ia, ja, ka)) >= 0.0f : (b5 = true);
            entityCanSpawnHere = b1 && b2 && b3 && b5;
            if (!entityCanSpawnHere) continue;
            for (int r = 0; r < groupSize && worldMobCount < max; ++r) {
                rngRoll = random.nextInt(100);
                if (spawnChance <= rngRoll) continue;
                if (r != 0) {
                    block57: {
                        if (spawnerData.getMetaData() == null) {
                            try {
                                entityliving = (Entity)entityClass.getConstructor(World.class).newInstance(worldServer);
                                break block57;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                continue block25;
                            }
                        }
                        entityliving = EntityList.func_75615_a((NBTTagCompound)nbttagcompound, (World)worldServer);
                    }
                    velocityX = spawnerData.velocityXSet ? spawnerData.velocityX : Math.random() * 0.2 - 0.1;
                    velocityY = spawnerData.velocityYSet ? spawnerData.velocityY : 0.1;
                    velocityZ = spawnerData.velocityZSet ? spawnerData.velocityZ : Math.random() * 0.2 - 0.1;
                    entityliving.func_70012_b((double)x, (double)y, (double)z, yaw, pitch);
                    entityliving.func_70024_g(velocityX, velocityY, velocityZ);
                    entityliving.getEntityData().func_74757_a("OTG", true);
                    entityliving.getEntityData().func_74768_a("OTGDT", despawnTime);
                }
                worldServer.func_72838_d(entityliving);
                ++worldMobCount;
            }
        }
        for (int a = 0; a < playerCoords.size(); ++a) {
            EntityPlayer player = (EntityPlayer)((Object[])playerCoords.get(a))[3];
            ArrayList<ParticleFunction> particleDataForOTGPerPlayer = new ArrayList<ParticleFunction>();
            for (ChunkCoordinate chunkcoordintpair1 : this.eligibleChunksForSpawning.keySet()) {
                if (this.eligibleChunksForSpawning.get(chunkcoordintpair1).booleanValue()) continue;
                ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkcoordintpair1.getChunkX(), chunkcoordintpair1.getChunkZ());
                ArrayList<ParticleFunction> particleDataForOTG = world.GetWorldSession().GetParticlesForChunk(chunkCoord);
                if (particleDataForOTG == null || particleDataForOTG.size() <= 0) continue;
                for (ParticleFunction particleData : particleDataForOTG) {
                    float f2;
                    float f1;
                    float f = (float)((Double)((Object[])playerCoords.get(a))[0] - (double)particleData.x);
                    double distance = f * f + (f1 = (float)((Double)((Object[])playerCoords.get(a))[1] - (double)particleData.y)) * f1 + (f2 = (float)((Double)((Object[])playerCoords.get(a))[2] - (double)particleData.z)) * f2;
                    if (!(distance > 0.0) || !(distance < maxDistToClosestPlayerSq)) continue;
                    if (!worldServer.func_180495_p(new BlockPos(particleData.x, particleData.y, particleData.z)).func_185904_a().func_76220_a()) {
                        particleDataForOTGPerPlayer.add(particleData);
                        continue;
                    }
                    world.GetWorldSession().RemoveParticles(chunkCoord, particleData);
                }
            }
            if (particleDataForOTGPerPlayer.size() <= 0) continue;
            ByteBuf nettyBuffer = Unpooled.buffer();
            ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
            try {
                stream.writeInt(5);
                stream.writeInt(1);
            }
            catch (IOException e) {
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
            StringBuilder sb = new StringBuilder();
            for (ParticleFunction particleData : particleDataForOTGPerPlayer) {
                sb.append(particleData.makeStringForPacket());
            }
            try {
                String value = sb.toString();
                byte[] bytes = value.getBytes();
                stream.writeShort(bytes.length);
                stream.write(bytes);
            }
            catch (IOException e) {
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
            try {
                stream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PacketDispatcher.sendTo((IMessage)new ParticlesPacket(nettyBuffer), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            boolean cartographerEnabled;
            ((ForgeEngine)OTG.getEngine()).ProcessPregeneratorTick();
            if (((ForgeEngine)OTG.getEngine()).getOverWorld() != null && (cartographerEnabled = ((ForgeEngine)OTG.getEngine()).getCartographerEnabled())) {
                Cartographer.UpdateWorldMap();
            }
            this.TeleportPlayers();
        }
        if (event.phase == TickEvent.Phase.END) {
            ImmutableList messages;
            this.currentTimeInSeconds = (int)Math.ceil(System.currentTimeMillis() / 1000L);
            if (this.currentTimeInSeconds != this.lastSpawnedTimeInSeconds) {
                this.lastSpawnedTimeInSeconds = this.currentTimeInSeconds;
                for (LocalWorld forgeWorld : ((ForgeEngine)OTG.getEngine()).getWorldLoader().getAllLoadedWorlds()) {
                    this.findChunksForSpawning((ForgeWorld)forgeWorld, true, true);
                }
            }
            if ((messages = FMLInterModComms.fetchRuntimeMessages((Object)OTGPlugin.instance)).size() > 0) {
                for (FMLInterModComms.IMCMessage imcMessage : messages) {
                    String[] paramString;
                    if (imcMessage.key.equalsIgnoreCase("GetModData") && imcMessage.isStringMessage()) {
                        paramString = imcMessage.getStringValue().split(",");
                        if (paramString.length == 3) {
                            int chunkZ;
                            int chunkX;
                            String worldName = paramString[0];
                            ForgeWorld forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldName);
                            if (forgeWorld == null) {
                                forgeWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldName);
                            }
                            try {
                                chunkX = Integer.parseInt(paramString[1]);
                                chunkZ = Integer.parseInt(paramString[2]);
                            }
                            catch (NumberFormatException ex) {
                                OTG.log(LogMarker.INFO, "The mod " + imcMessage.getSender() + " has sent the following message: " + imcMessage.key + ", however the parameters were invalid: " + imcMessage.getStringValue() + ". Should be: MyWorldName,MyChunkX,MyChunkZ", new Object[0]);
                                return;
                            }
                            String messageString = "";
                            HashMap<String, ArrayList<ModDataFunction>> modDataInChunk = forgeWorld.GetWorldSession().GetModDataForChunk(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
                            if (modDataInChunk != null) {
                                for (Map.Entry<String, ArrayList<ModDataFunction>> modNameAndData : modDataInChunk.entrySet()) {
                                    if (!modNameAndData.getKey().equalsIgnoreCase(imcMessage.getSender())) continue;
                                    for (ModDataFunction modData : modNameAndData.getValue()) {
                                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                                    }
                                }
                                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.instance, (String)imcMessage.getSender(), (String)"ModData", (String)("[[" + worldName + "," + chunkX + "," + chunkZ + "]" + (messageString.length() > 0 ? messageString : "[]") + "]"));
                            } else {
                                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.instance, (String)imcMessage.getSender(), (String)"ModData", (String)("[[" + worldName + "," + chunkX + "," + chunkZ + "]]"));
                            }
                        } else {
                            OTG.log(LogMarker.INFO, "The mod " + imcMessage.getSender() + " has sent the following message: " + imcMessage.key + ", however the parameters were invalid: " + imcMessage.getStringValue() + ". Should be: MyWorldName,MyChunkX,MyChunkZ", new Object[0]);
                        }
                    }
                    if (!imcMessage.key.equalsIgnoreCase("ModData")) continue;
                    paramString = imcMessage.getStringValue().replace("[[", "").replace("]]", "").split("\\]\\[");
                    String[] chunkCoordString = paramString[0].split(",");
                    String worldName = chunkCoordString[0];
                    if (paramString.length < 2) continue;
                    for (int i = 1; i < paramString.length; ++i) {
                        if (paramString[i].length() <= 0) continue;
                        String[] modDataString = paramString[i].split(",");
                        int modDataBlockX = Integer.parseInt(modDataString[0]);
                        int modDataBlockY = Integer.parseInt(modDataString[1]);
                        int modDataBlockZ = Integer.parseInt(modDataString[2]);
                        String modDataText = modDataString[3];
                        ForgeWorld world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldName);
                        if (world == null) {
                            world = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldName);
                        }
                        if (world == null) {
                            OTG.log(LogMarker.INFO, "Error: Failed to load LocalWorld for world \"" + worldName + "\"", new Object[0]);
                            throw new RuntimeException();
                        }
                        if (world.getConfigs() == null) {
                            OTG.log(LogMarker.INFO, "Error: Failed to load world settings for world \"" + worldName + "\"", new Object[0]);
                            throw new RuntimeException();
                        }
                        if (world.getConfigs().getWorldConfig() == null) {
                            OTG.log(LogMarker.INFO, "Error: Failed to load worldConfig for world \"" + worldName + "\"", new Object[0]);
                            throw new RuntimeException();
                        }
                        String[] paramString2 = modDataText.split("\\/");
                        if (paramString2.length <= 1) continue;
                        if (paramString2[0].equals("mob")) {
                            try {
                                EntityFunction entityFunc = new EntityFunction();
                                entityFunc.x = modDataBlockX;
                                entityFunc.y = modDataBlockY;
                                entityFunc.z = modDataBlockZ;
                                entityFunc.mobName = paramString2[1];
                                entityFunc.groupSize = paramString2.length > 2 ? Integer.parseInt(paramString2[2]) : 1;
                                entityFunc.originalNameTagOrNBTFileName = entityFunc.nameTagOrNBTFileName = paramString2.length > 5 ? paramString2[5] : null;
                                world.SpawnEntity(entityFunc);
                            }
                            catch (NumberFormatException ex) {
                                OTG.log(LogMarker.INFO, "Error in ModData: " + modDataText + " parameter count was not a number", new Object[0]);
                            }
                            continue;
                        }
                        if (!paramString2[0].equals("block")) continue;
                        try {
                            LocalMaterialData material = OTG.readMaterial(paramString2[1]);
                            world.setBlock(modDataBlockX, modDataBlockY, modDataBlockZ, material, null, true);
                            continue;
                        }
                        catch (InvalidConfigException e) {
                            e.printStackTrace();
                            OTG.log(LogMarker.INFO, "Error in ModData: " + modDataText + " parameter material was not a valid material", new Object[0]);
                        }
                    }
                }
            }
        }
    }

    private void TeleportPlayers() {
        MinecraftServer mcServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        for (WorldServer worldServer : mcServer.field_71305_c) {
            if (!(worldServer.func_72912_H().func_76067_t() instanceof OTGWorldType)) continue;
            ArrayList players = new ArrayList(worldServer.field_73010_i);
            for (EntityPlayer player : players) {
                this.tryTeleportPlayer(player);
            }
        }
    }

    public void tryTeleportPlayer(EntityPlayer player) {
        ForgeWorld destinationWorld;
        ForgeWorld playerWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(player.field_70170_p);
        WorldConfig worldConfig = playerWorld.getConfigs().getWorldConfig();
        if (playerWorld != null && worldConfig.dimensionBelow != null && worldConfig.dimensionBelow.trim().length() > 0 && player.func_180425_c().func_177956_o() < worldConfig.dimensionBelowHeight) {
            destinationWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldConfig.dimensionBelow);
            if (destinationWorld == null) {
                destinationWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldConfig.dimensionBelow);
            }
            if (destinationWorld != null) {
                if (destinationWorld == playerWorld) {
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 254, player.func_180425_c().func_177952_p()));
                    player.field_70170_p.func_175698_g(new BlockPos(player.func_180425_c().func_177958_n(), 255, player.func_180425_c().func_177952_p()));
                    player.func_70634_a((double)player.func_180425_c().func_177958_n(), 254.0, (double)player.func_180425_c().func_177952_p());
                } else {
                    this.TeleportPlayerToDimension(playerWorld.getWorld().field_73011_w.getDimension(), destinationWorld.getWorld().field_73011_w.getDimension(), player);
                    return;
                }
            }
        }
        if (playerWorld != null && worldConfig.dimensionAbove != null && worldConfig.dimensionAbove.trim().length() > 0 && player.func_180425_c().func_177956_o() > worldConfig.dimensionAboveHeight) {
            destinationWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(worldConfig.dimensionAbove);
            if (destinationWorld == null) {
                destinationWorld = (ForgeWorld)((ForgeEngine)OTG.getEngine()).getUnloadedWorld(worldConfig.dimensionAbove);
            }
            if (destinationWorld != null && destinationWorld != playerWorld) {
                this.TeleportPlayerToDimension(playerWorld.getWorld().field_73011_w.getDimension(), destinationWorld.getWorld().field_73011_w.getDimension(), player);
            }
        }
    }

    private void TeleportPlayerToDimension(int originDimension, int newDimension, EntityPlayer e) {
        boolean cartographerEnabled = ((ForgeEngine)OTG.getEngine()).getCartographerEnabled();
        if (e instanceof EntityPlayerMP) {
            OTGTeleporter.changeDimension(newDimension, (EntityPlayerMP)e, false);
        }
        if (originDimension == 0 && cartographerEnabled) {
            Cartographer.CreateBlockWorldMapAtSpawn(ChunkCoordinate.fromBlockCoords(e.func_180425_c().func_177958_n(), e.func_180425_c().func_177952_p()), true);
        }
    }
}

