/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.customobjects.bo3.BlockFunction;
import com.pg85.otg.customobjects.bo3.ModDataFunction;
import com.pg85.otg.forge.ForgeMaterialData;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.OTGPlugin;
import com.pg85.otg.forge.generator.ForgeChunkBuffer;
import com.pg85.otg.generator.ChunkProviderOTG;
import com.pg85.otg.generator.ObjectSpawner;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.BlockGravel;
import net.minecraft.block.BlockSand;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class OTGChunkGenerator
implements IChunkGenerator {
    public ArrayList<Object[]> PopulatedChunks;
    int lastx2 = 0;
    int lastz2 = 0;
    int chunkCacheSize = 256;
    LinkedHashMap<ChunkCoordinate, Object[]> chunkCache = new LinkedHashMap();
    private ForgeWorld world;
    private World worldHandle;
    private boolean TestMode = false;
    private ChunkProviderOTG generator;
    public ObjectSpawner spawner;
    private int[] biomeIntArray;
    boolean firstRun = true;
    ArrayList<LocalMaterialData> originalBlocks = new ArrayList();
    ChunkCoordinate spawnChunk;
    boolean spawnChunkFixed = false;
    ForgeChunkBuffer chunkBuffer;

    public OTGChunkGenerator(ForgeWorld _world) {
        this.world = _world;
        this.worldHandle = _world.getWorld();
        this.TestMode = this.world.getConfigs().getWorldConfig().ModeTerrain == WorldConfig.TerrainMode.TerrainTest;
        this.generator = new ChunkProviderOTG(this.world.getConfigs(), this.world);
        this.spawner = new ObjectSpawner(this.world.getConfigs(), this.world);
        this.PopulatedChunks = new ArrayList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Chunk func_185932_a(int chunkX, int chunkZ) {
        Chunk chunk;
        ChunkCoordinate chunkCoords = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        boolean bFound = false;
        ArrayList<Object[]> arrayList = this.PopulatedChunks;
        synchronized (arrayList) {
            for (Object[] chunkCoord : this.PopulatedChunks) {
                if ((Integer)chunkCoord[0] != chunkX || (Integer)chunkCoord[1] != chunkZ) continue;
                bFound = true;
            }
            if (!bFound) {
                this.PopulatedChunks.add(new Object[]{chunkX, chunkZ});
            }
        }
        if (bFound) {
            chunk = this.world.getChunk(chunkCoords.getBlockX(), chunkCoords.getBlockZ(), true);
            if (chunk == null && this.world.IsInsideWorldBorder(chunkCoords, false)) {
                chunk = this.world.getWorld().func_72964_e(chunkX, chunkZ);
                if (chunk == null) {
                    throw new RuntimeException();
                }
                OTG.log(LogMarker.INFO, "Double population prevented", new Object[0]);
            }
            if (chunk != null) {
                OTG.log(LogMarker.INFO, "Double population prevented", new Object[0]);
                return chunk;
            }
            OTG.log(LogMarker.INFO, "Double population could not be prevented for chunk X" + chunkX + " Z" + chunkZ, new Object[0]);
        }
        chunk = this.getBlocks(chunkX, chunkZ, true);
        return chunk;
    }

    private void fillBiomeArray(Chunk chunk) {
        byte[] chunkBiomeArray = chunk.func_76605_m();
        ConfigProvider configProvider = this.world.getConfigs();
        this.biomeIntArray = this.world.getBiomeGenerator().getBiomes(this.biomeIntArray, chunk.field_76635_g * 16, chunk.field_76647_h * 16, 16, 16, OutputType.DEFAULT_FOR_WORLD);
        for (int i = 0; i < chunkBiomeArray.length; ++i) {
            int generationId = this.biomeIntArray[i];
            LocalBiome biome = OTG.isForge ? OTG.getBiomeAllWorlds(generationId) : configProvider.getBiomeByIdOrNull(generationId);
            chunkBiomeArray[i] = (byte)biome.getIds().getSavedId();
        }
    }

    public void func_185931_b(int chunkX, int chunkZ) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
        if (this.TestMode || !this.world.IsInsideWorldBorder(chunkCoord, false)) {
            this.world.ClearChunkCache();
            return;
        }
        BlockSand.field_149832_M = true;
        BlockGravel.field_149832_M = true;
        if (!this.spawner.processing) {
            this.spawner.populatingX = chunkX;
            this.spawner.populatingZ = chunkZ;
        }
        this.fixSpawnChunk();
        if (this.world.getConfigs().getWorldConfig().spawnPointSet) {
            this.world.getWorld().field_73011_w.setSpawnPoint(new BlockPos(this.world.getConfigs().getWorldConfig().spawnPointX, this.world.getConfigs().getWorldConfig().spawnPointY, this.world.getConfigs().getWorldConfig().spawnPointZ));
            this.world.getConfigs().getWorldConfig().spawnPointSet = false;
        }
        this.spawner.populate(chunkCoord);
        BlockSand.field_149832_M = false;
        BlockGravel.field_149832_M = false;
        HashMap<String, ArrayList<ModDataFunction>> MessagesPerMod = this.world.GetWorldSession().GetModDataForChunk(chunkCoord);
        if (MessagesPerMod == null && this.world.getConfigs().getWorldConfig().IsOTGPlus) {
            if (!this.world.getStructureCache().structureCache.containsKey(chunkCoord) && !this.world.getStructureCache().worldInfoChunks.containsKey(chunkCoord)) {
                throw new RuntimeException();
            }
            OTG.log(LogMarker.INFO, "This exception seems to be a fluke and occurs rarely. If you find a way to re-create it please tell me!", new Object[0]);
            throw new RuntimeException();
        }
        if (MessagesPerMod != null && MessagesPerMod.entrySet().size() > 0) {
            for (Map.Entry<String, ArrayList<ModDataFunction>> modNameAndData : MessagesPerMod.entrySet()) {
                String messageString = "";
                if (modNameAndData.getKey().equals("OTG")) {
                    for (ModDataFunction modData : modNameAndData.getValue()) {
                        boolean autoSpawn;
                        String[] paramString2 = modData.modData.split("\\/");
                        if (paramString2.length <= 1 || !paramString2[0].equals("mob") || !(autoSpawn = paramString2.length > 4 ? Boolean.parseBoolean(paramString2[4]) : false)) continue;
                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                    }
                } else {
                    for (ModDataFunction modData : modNameAndData.getValue()) {
                        messageString = messageString + "[" + modData.x + "," + modData.y + "," + modData.z + "," + modData.modData + "]";
                    }
                }
                if (messageString.length() <= 0) continue;
                FMLInterModComms.sendRuntimeMessage((Object)OTGPlugin.instance, (String)modNameAndData.getKey(), (String)"ModData", (String)("[[" + this.world.getName() + "," + chunkX + "," + chunkZ + "]" + messageString + "]"));
            }
        }
        Runtime runtime = Runtime.getRuntime();
        long maxMemory = runtime.maxMemory();
        long allocatedMemory = runtime.totalMemory();
        long freeMemory = runtime.freeMemory();
        if (!this.world.GetWorldSession().getPreGeneratorIsRunning() && this.chunkCache.entrySet().size() > this.chunkCacheSize || (double)(freeMemory + (maxMemory - allocatedMemory)) <= (double)maxMemory * 0.25) {
            OTG.log(LogMarker.DEBUG, "Clearing ChunkProvider cache", new Object[0]);
            this.chunkCache.clear();
        }
        this.world.ClearChunkCache();
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType paramaca, BlockPos blockPos) {
        WorldConfig worldConfig = this.world.getConfigs().getWorldConfig();
        Biome biomeBase = this.worldHandle.getBiomeForCoordsBody(blockPos);
        if (worldConfig.rareBuildingsEnabled && paramaca == EnumCreatureType.MONSTER && this.world.rareBuildingGen.isSwampHutAtLocation(blockPos)) {
            return this.world.rareBuildingGen.getMonsterSpawnList();
        }
        if (worldConfig.oceanMonumentsEnabled && paramaca == EnumCreatureType.MONSTER && this.world.oceanMonumentGen.func_175796_a(this.worldHandle, blockPos)) {
            return this.world.oceanMonumentGen.getMonsterSpawnList();
        }
        return biomeBase.func_76747_a(paramaca);
    }

    public void func_180514_a(Chunk chunkIn, int chunkX, int chunkZ) {
        WorldConfig worldConfig = this.world.getConfigs().getWorldConfig();
        if (worldConfig.mineshaftsEnabled) {
            this.world.mineshaftGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.villagesEnabled) {
            this.world.villageGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.strongholdsEnabled) {
            this.world.strongholdGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.rareBuildingsEnabled) {
            this.world.rareBuildingGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.netherFortressesEnabled) {
            this.world.netherFortressGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.oceanMonumentsEnabled) {
            this.world.oceanMonumentGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
        if (worldConfig.woodLandMansionsEnabled) {
            this.world.woodLandMansionGen.func_186125_a(this.world.getWorld(), chunkX, chunkZ, null);
        }
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos blockPos, boolean p_180513_4_) {
        if ("Stronghold".equals(structureName) && this.world.strongholdGen != null) {
            return this.world.strongholdGen.func_180706_b(worldIn, blockPos, p_180513_4_);
        }
        if ("Mansion".equals(structureName) && this.world.woodLandMansionGen != null) {
            return this.world.woodLandMansionGen.func_180706_b(worldIn, blockPos, p_180513_4_);
        }
        if ("Monument".equals(structureName) && this.world.oceanMonumentGen != null) {
            return this.world.oceanMonumentGen.func_180706_b(worldIn, blockPos, p_180513_4_);
        }
        if ("Village".equals(structureName) && this.world.villageGen != null) {
            return this.world.villageGen.func_180706_b(worldIn, blockPos, p_180513_4_);
        }
        if ("Mineshaft".equals(structureName) && this.world.mineshaftGen != null) {
            return this.world.mineshaftGen.func_180706_b(worldIn, blockPos, p_180513_4_);
        }
        if ("Temple".equals(structureName) && this.world.rareBuildingGen != null) {
            return this.world.rareBuildingGen.func_180706_b(worldIn, blockPos, p_180513_4_);
        }
        return null;
    }

    public BlockFunction[] getBlockColumnInUnloadedChunk(int x, int z) {
        this.lastx2 = x;
        this.lastz2 = z;
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        int chunkX = chunkCoord.getChunkX();
        int chunkZ = chunkCoord.getChunkZ();
        Object[] chunkCacheEntry = this.chunkCache.get(chunkCoord);
        Chunk chunk = null;
        LinkedHashMap<ChunkCoordinate, BlockFunction[]> blockColumnCache = null;
        BlockFunction[] cachedColumn = null;
        if (chunkCacheEntry != null) {
            chunk = (Chunk)chunkCacheEntry[0];
            blockColumnCache = (LinkedHashMap<ChunkCoordinate, BlockFunction[]>)chunkCacheEntry[1];
            cachedColumn = (BlockFunction[])blockColumnCache.get(ChunkCoordinate.fromChunkCoords(x, z));
        }
        if (cachedColumn != null) {
            return cachedColumn;
        }
        if (chunk == null) {
            chunk = new Chunk(this.worldHandle, chunkX, chunkZ);
            if (this.world.IsInsideWorldBorder(chunkCoord, true)) {
                ForgeChunkBuffer chunkBuffer = new ForgeChunkBuffer(chunkCoord);
                this.generator.generate(chunkBuffer);
                chunk = chunkBuffer.toChunk(this.worldHandle);
            }
            blockColumnCache = new LinkedHashMap<ChunkCoordinate, BlockFunction[]>();
            this.chunkCache.put(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), new Object[]{chunk, blockColumnCache});
        }
        int blockX = x &= 0xF;
        int blockZ = z &= 0xF;
        BlockFunction[] blocksInColumn = new BlockFunction[256];
        for (int y = 0; y < 256; ++y) {
            BlockFunction block = new BlockFunction();
            block.x = x;
            block.y = y;
            block.z = z;
            IBlockState blockInChunk = chunk.func_177435_g(new BlockPos(blockX, y, blockZ));
            if (blockInChunk == null) break;
            block.material = ForgeMaterialData.ofMinecraftBlockState(blockInChunk);
            blocksInColumn[y] = block;
        }
        blockColumnCache.put(ChunkCoordinate.fromChunkCoords(this.lastx2, this.lastz2), blocksInColumn);
        return blocksInColumn;
    }

    public LocalMaterialData getMaterialInUnloadedChunk(int x, int y, int z) {
        BlockFunction[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        return blockColumn[y].material;
    }

    public int getHighestBlockYInUnloadedChunk(int x, int z, boolean findSolid, boolean findLiquid, boolean ignoreLiquid, boolean ignoreSnow) {
        int height = -1;
        BlockFunction[] blockColumn = this.getBlockColumnInUnloadedChunk(x, z);
        for (int y = 255; y > -1; --y) {
            boolean isSolid;
            ForgeMaterialData material = (ForgeMaterialData)blockColumn[y].material;
            boolean isLiquid = material.isLiquid();
            boolean bl = isSolid = material.isSolid() || !ignoreSnow && material.toDefaultMaterial().equals((Object)DefaultMaterial.SNOW);
            if (isLiquid && ignoreLiquid) continue;
            if (findSolid && isSolid || findLiquid && isLiquid) {
                return y;
            }
            if ((!findSolid || !isLiquid) && (!findLiquid || !isSolid)) continue;
            return -1;
        }
        return height;
    }

    public void fixSpawnChunk() {
        if (!this.spawnChunkFixed && !this.firstRun) {
            this.world.setAllowSpawningOutsideBounds(true);
            this.spawnChunkFixed = true;
            int i = 0;
            for (int x = 0; x < 15; ++x) {
                for (int z = 0; z < 15; ++z) {
                    if (!this.originalBlocks.get(i).toDefaultMaterial().equals((Object)DefaultMaterial.AIR) || !this.originalBlocks.get(i + 1).toDefaultMaterial().equals((Object)DefaultMaterial.AIR)) {
                        this.world.setBlock(this.spawnChunk.getBlockX() + x, 63, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i), null, true);
                        this.world.setBlock(this.spawnChunk.getBlockX() + x, 64, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i + 1), null, true);
                    } else {
                        for (int h = 62; h > 0; ++h) {
                            if (this.world.getMaterial(this.spawnChunk.getBlockX() + x, h, this.spawnChunk.getBlockZ() + z, true).toDefaultMaterial().equals((Object)DefaultMaterial.AIR)) continue;
                            this.world.setBlock(this.spawnChunk.getBlockX() + x, 63, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i), null, true);
                            this.world.setBlock(this.spawnChunk.getBlockX() + x, 64, this.spawnChunk.getBlockZ() + z, this.originalBlocks.get(i + 1), null, true);
                            break;
                        }
                    }
                    i += 2;
                }
            }
            this.world.setAllowSpawningOutsideBounds(false);
        }
    }

    public Chunk getBlocks(int chunkX, int chunkZ, boolean provideChunk) {
        Object[] chunkCacheEntry = this.chunkCache.get(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        Chunk chunk = null;
        if (chunkCacheEntry != null) {
            chunk = (Chunk)chunkCacheEntry[0];
        }
        if (chunk == null) {
            chunk = new Chunk(this.worldHandle, chunkX, chunkZ);
            if (this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), false)) {
                ChunkCoordinate chunkCoord = ChunkCoordinate.fromChunkCoords(chunkX, chunkZ);
                this.chunkBuffer = new ForgeChunkBuffer(chunkCoord);
                this.generator.generate(this.chunkBuffer);
                if (this.firstRun) {
                    this.firstRun = false;
                    this.spawnChunk = chunkCoord;
                    for (int x = 0; x < 15; ++x) {
                        for (int z = 0; z < 15; ++z) {
                            this.originalBlocks.add(this.chunkBuffer.getBlock(x, 63, z));
                            this.originalBlocks.add(this.chunkBuffer.getBlock(x, 64, z));
                            this.chunkBuffer.setBlock(x, 63, z, OTG.toLocalMaterialData(DefaultMaterial.GRASS, 0));
                            this.chunkBuffer.setBlock(x, 64, z, OTG.toLocalMaterialData(DefaultMaterial.AIR, 0));
                        }
                    }
                }
                chunk = this.chunkBuffer.toChunk(this.worldHandle);
                this.fillBiomeArray(chunk);
                chunk.func_76603_b();
                this.chunkBuffer = null;
            }
        } else {
            if (this.world.IsInsideWorldBorder(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ), false)) {
                this.fillBiomeArray(chunk);
                chunk.func_76603_b();
            }
            this.chunkCache.remove(ChunkCoordinate.fromChunkCoords(chunkX, chunkZ));
        }
        return chunk;
    }

    public int getHighestBlockInCurrentlyPopulatingChunk(int x, int z) {
        for (int i = 255; i > 0; --i) {
            if (this.chunkBuffer.getBlock(x, i, z).isAir()) continue;
            return i;
        }
        return 0;
    }
}

