/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator;

import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.storage.RegionFileCache;
import net.minecraft.world.gen.ChunkProviderServer;

public class Pregenerator {
    ForgeWorld world;
    boolean processing = false;
    ChunkCoordinate preGeneratorCenterPoint;
    int currentX;
    int currentZ;
    long startTime = System.currentTimeMillis();
    int pregenerationRadius;
    int cycle = 0;
    int left = 0;
    int right = 0;
    int top = 0;
    int bottom = 0;
    int iLeft = Integer.MIN_VALUE;
    int iRight = Integer.MIN_VALUE;
    int iTop = Integer.MIN_VALUE;
    int iBottom = Integer.MIN_VALUE;
    int spawned = 1;
    double total;
    int spawnedThisTick = 0;
    boolean pregeneratorIsRunning;
    int maxSpawnPerTick;
    public String pregenerationWorld = "";
    public String preGeneratorProgressStatus = "";
    public String preGeneratorProgress = "";
    public String progressScreenElapsedTime = "";
    public String progressScreenEstimatedTime = "";
    public int progressScreenWorldSizeInBlocks;
    long lastMessage = System.currentTimeMillis();

    public Pregenerator(LocalWorld world) {
        this.world = (ForgeWorld)world;
        this.LoadPregeneratorData();
        this.maxSpawnPerTick = OTG.getPluginConfig().PregeneratorMaxChunksPerTick;
        this.pregenerationWorld = world.getConfigs().getWorldConfig().getName();
    }

    public int getPregenerationRadius() {
        return this.pregenerationRadius;
    }

    public int setPregenerationRadius(int radius) {
        this.pregenerationRadius = radius > this.cycle && radius > 0 ? radius : this.cycle;
        if (this.world != null) {
            this.SavePregeneratorData();
        }
        this.total = (this.pregenerationRadius * 2 + 1) * (this.pregenerationRadius * 2 + 1);
        return this.pregenerationRadius;
    }

    public int getPregenerationBorderLeft() {
        return this.left;
    }

    public int getPregenerationBorderRight() {
        return this.right;
    }

    public int getPregenerationBorderTop() {
        return this.top;
    }

    public int getPregenerationBorderBottom() {
        return this.bottom;
    }

    public ChunkCoordinate getPregenerationCenterPoint() {
        return this.preGeneratorCenterPoint;
    }

    public boolean getPregeneratorIsRunning() {
        return this.pregeneratorIsRunning;
    }

    public void ProcessTick() {
        if (!this.processing) {
            this.processing = true;
            this.Pregenerate();
            this.processing = false;
        }
    }

    void Pregenerate() {
        if ((double)this.spawned < this.total && this.pregenerationRadius > 0) {
            this.pregeneratorIsRunning = true;
            this.currentX = -this.pregenerationRadius;
            this.currentZ = -this.pregenerationRadius;
            boolean leftEdgeFound = false;
            boolean rightEdgeFound = false;
            boolean topEdgeFound = false;
            boolean bottomEdgeFound = false;
            this.spawnedThisTick = 0;
            int spawnChunkX = this.preGeneratorCenterPoint.getChunkX();
            int spawnChunkZ = this.preGeneratorCenterPoint.getChunkZ();
            while (!(leftEdgeFound && rightEdgeFound && topEdgeFound && bottomEdgeFound)) {
                int i;
                boolean bSpawned;
                ++this.cycle;
                if (this.right >= this.pregenerationRadius) {
                    rightEdgeFound = true;
                }
                if (!rightEdgeFound && this.iLeft == Integer.MIN_VALUE && this.iTop == Integer.MIN_VALUE && this.iBottom == Integer.MIN_VALUE) {
                    bSpawned = false;
                    for (i = -this.top; i <= this.bottom; ++i) {
                        this.currentX = spawnChunkX + this.cycle;
                        this.currentZ = spawnChunkZ + i;
                        if (i <= this.iRight) continue;
                        bSpawned = true;
                        this.iRight = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.bottom) {
                            ++this.right;
                        }
                        this.Pause();
                        return;
                    }
                    if (bSpawned) {
                        ++this.right;
                    }
                }
                if (this.left >= this.pregenerationRadius) {
                    leftEdgeFound = true;
                }
                if (!leftEdgeFound && this.iTop == Integer.MIN_VALUE && this.iBottom == Integer.MIN_VALUE) {
                    bSpawned = false;
                    for (i = -this.top; i <= this.bottom; ++i) {
                        this.currentX = spawnChunkX - this.cycle;
                        this.currentZ = spawnChunkZ + i;
                        if (i <= this.iLeft) continue;
                        bSpawned = true;
                        this.iLeft = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.bottom) {
                            ++this.left;
                        }
                        this.Pause();
                        return;
                    }
                    if (bSpawned) {
                        ++this.left;
                    }
                }
                if (this.bottom >= this.pregenerationRadius) {
                    bottomEdgeFound = true;
                }
                if (!bottomEdgeFound && this.iTop == Integer.MIN_VALUE) {
                    bSpawned = false;
                    for (i = -this.left; i <= this.right; ++i) {
                        this.currentX = spawnChunkX + i;
                        this.currentZ = spawnChunkZ + this.cycle;
                        if (i <= this.iBottom) continue;
                        bSpawned = true;
                        this.iBottom = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.right) {
                            ++this.bottom;
                        }
                        this.Pause();
                        return;
                    }
                    if (bSpawned) {
                        ++this.bottom;
                    }
                }
                if (this.top >= this.pregenerationRadius) {
                    topEdgeFound = true;
                }
                if (!topEdgeFound) {
                    bSpawned = false;
                    for (i = -this.left; i <= this.right; ++i) {
                        this.currentX = spawnChunkX + i;
                        this.currentZ = spawnChunkZ - this.cycle;
                        if (i <= this.iTop) continue;
                        bSpawned = true;
                        this.iTop = i;
                        ++this.spawned;
                        this.PreGenerateChunk(this.currentX, this.currentZ);
                        if (this.spawnedThisTick < this.maxSpawnPerTick) continue;
                        if (i == this.right) {
                            ++this.top;
                        }
                        this.Pause();
                        return;
                    }
                    if (bSpawned) {
                        ++this.top;
                    }
                }
                this.iLeft = Integer.MIN_VALUE;
                this.iBottom = Integer.MIN_VALUE;
                this.iRight = Integer.MIN_VALUE;
                this.iTop = Integer.MIN_VALUE;
            }
            this.SavePregeneratorData();
        }
        this.pregeneratorIsRunning = false;
    }

    void Pause() {
        if ((double)this.spawned == this.total) {
            this.iLeft = Integer.MIN_VALUE;
            this.iBottom = Integer.MIN_VALUE;
            this.iRight = Integer.MIN_VALUE;
            this.iTop = Integer.MIN_VALUE;
            this.SavePregeneratorData();
        } else {
            --this.cycle;
            this.processing = false;
        }
    }

    void PreGenerateChunk(int currentX, int currentZ) {
        this.UpdateProgressMessage(true);
        ChunkProviderServer chunkProvider = (ChunkProviderServer)this.world.getWorld().func_72863_F();
        if (!chunkProvider.func_73149_a(currentX, currentZ) && !RegionFileCache.func_76550_a((File)((WorldServer)this.world.getWorld()).getChunkSaveLocation(), (int)currentX, (int)currentZ).chunkExists(currentX & 0x1F, currentZ & 0x1F) || !chunkProvider.func_186025_d(currentX, currentZ).func_150802_k()) {
            ++this.spawnedThisTick;
            chunkProvider.func_186025_d(currentX, currentZ).func_76601_a(true);
            chunkProvider.func_186025_d(currentX, currentZ + 1).func_76601_a(true);
            chunkProvider.func_186025_d(currentX + 1, currentZ).func_76601_a(true);
            chunkProvider.func_186025_d(currentX + 1, currentZ + 1).func_76601_a(true);
        }
    }

    void UpdateProgressMessage(boolean loggingCanBeIgnored) {
        if ((double)this.spawned < this.total) {
            boolean dontLog = false;
            loggingCanBeIgnored = System.currentTimeMillis() - this.lastMessage < 1000L;
            if (loggingCanBeIgnored) {
                dontLog = true;
            } else {
                this.lastMessage = System.currentTimeMillis();
            }
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            int hours = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0 / 60.0);
            int minutes = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0) - hours * 60;
            int seconds = (int)Math.floor((double)elapsedTime / 1000.0) - minutes * 60 - hours * 60 * 60;
            String sElapsedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
            double eTA = this.total / (double)this.spawned * (double)elapsedTime - (double)elapsedTime;
            hours = (int)Math.floor(eTA / 1000.0 / 60.0 / 60.0);
            minutes = (int)Math.floor(eTA / 1000.0 / 60.0) - hours * 60;
            seconds = (int)Math.floor(eTA / 1000.0) - minutes * 60 - hours * 60 * 60;
            String estimatedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
            long i = Runtime.getRuntime().maxMemory();
            long j = Runtime.getRuntime().totalMemory();
            long k = Runtime.getRuntime().freeMemory();
            long l = j - k;
            String memoryUsage = " Mem: " + Long.valueOf(l * 100L / i) + "% " + Long.valueOf(this.BytesToMb(l)) + " / " + Long.valueOf(this.BytesToMb(i)) + " MB ";
            this.progressScreenWorldSizeInBlocks = (this.pregenerationRadius * 2 + 1) * 16;
            this.preGeneratorProgressStatus = this.spawned + "/" + (int)this.total;
            this.preGeneratorProgress = (int)Math.round((double)this.spawned / this.total * 100.0) + "";
            this.progressScreenElapsedTime = sElapsedTime;
            this.progressScreenEstimatedTime = estimatedTime;
            if (!dontLog) {
                OTG.log(LogMarker.INFO, "Pre-generating world \"" + this.pregenerationWorld + "\" chunk X" + this.currentX + " Z" + this.currentZ + ". Radius: " + this.pregenerationRadius + " Spawned: " + this.spawned + "/" + (int)this.total + " " + (int)Math.round((double)this.spawned / this.total * 100.0) + "% done. Elapsed: " + sElapsedTime + " ETA: " + estimatedTime + memoryUsage, new Object[0]);
            }
        } else {
            long elapsedTime = System.currentTimeMillis() - this.startTime;
            int hours = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0 / 60.0);
            int minutes = (int)Math.floor((double)elapsedTime / 1000.0 / 60.0) - hours * 60;
            int seconds = (int)Math.floor((double)elapsedTime / 1000.0) - minutes * 60 - hours * 60 * 60;
            String sElapsedTime = (hours < 10 ? "0" + hours : Integer.valueOf(hours)) + ":" + (minutes < 10 ? "0" + minutes : Integer.valueOf(minutes)) + ":" + (seconds < 10 ? "0" + seconds : Integer.valueOf(seconds));
            this.preGeneratorProgressStatus = "Done";
            this.preGeneratorProgress = "";
            this.progressScreenElapsedTime = "";
            this.progressScreenEstimatedTime = "";
            this.progressScreenWorldSizeInBlocks = 0;
            OTG.log(LogMarker.INFO, "Pre-generating chunks done for world " + this.pregenerationWorld + ", " + this.spawned + " chunks spawned in " + sElapsedTime, new Object[0]);
        }
    }

    private long BytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public void shutDown() {
        if (this.pregeneratorIsRunning) {
            this.SavePregeneratorData();
            this.pregeneratorIsRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void SavePregeneratorData() {
        if (this.pregeneratorIsRunning) {
            int dimensionId = this.world.getDimensionId();
            File pregeneratedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + "PregeneratedChunks.txt");
            if (pregeneratedChunksFile.exists()) {
                pregeneratedChunksFile.delete();
            }
            StringBuilder stringbuilder = new StringBuilder();
            stringbuilder.append(this.spawned + "," + this.left + "," + this.top + "," + this.right + "," + this.bottom + "," + this.cycle + "," + (System.currentTimeMillis() - this.startTime) + "," + this.iTop + "," + this.iBottom + "," + this.iLeft + "," + this.iRight + "," + this.pregenerationRadius + "," + this.preGeneratorCenterPoint.getChunkX() + "," + this.preGeneratorCenterPoint.getChunkZ());
            BufferedWriter writer = null;
            try {
                pregeneratedChunksFile.getParentFile().mkdirs();
                writer = new BufferedWriter(new FileWriter(pregeneratedChunksFile));
                writer.write(stringbuilder.toString());
                OTG.log(LogMarker.TRACE, "Pre-generator data saved", new Object[0]);
            }
            catch (IOException e) {
                OTG.log(LogMarker.ERROR, "Could not save pre-generator data.", new Object[0]);
                e.printStackTrace();
            }
            finally {
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void LoadPregeneratorData() {
        int dimensionId = this.world.getDimensionId();
        File pregeneratedChunksFile = new File(this.world.getWorldSaveDir().getAbsolutePath() + "/OpenTerrainGenerator/" + (dimensionId != 0 ? "DIM-" + dimensionId + "/" : "") + "PregeneratedChunks.txt");
        String[] pregeneratedChunksFileValues = new String[]{};
        if (pregeneratedChunksFile.exists()) {
            try {
                StringBuilder stringbuilder = new StringBuilder();
                BufferedReader reader = new BufferedReader(new FileReader(pregeneratedChunksFile));
                try {
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                    if (stringbuilder.length() > 0) {
                        pregeneratedChunksFileValues = stringbuilder.toString().split(",");
                    }
                    OTG.log(LogMarker.TRACE, "Pre-generator data loaded", new Object[0]);
                }
                finally {
                    reader.close();
                }
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        if (pregeneratedChunksFileValues.length > 0) {
            this.spawned = Integer.parseInt(pregeneratedChunksFileValues[0]);
            this.left = Integer.parseInt(pregeneratedChunksFileValues[1]);
            this.top = Integer.parseInt(pregeneratedChunksFileValues[2]);
            this.right = Integer.parseInt(pregeneratedChunksFileValues[3]);
            this.bottom = Integer.parseInt(pregeneratedChunksFileValues[4]);
            this.cycle = Integer.parseInt(pregeneratedChunksFileValues[5]);
            this.startTime = System.currentTimeMillis() - Long.parseLong(pregeneratedChunksFileValues[6]);
            this.iTop = Integer.parseInt(pregeneratedChunksFileValues[7]);
            this.iBottom = Integer.parseInt(pregeneratedChunksFileValues[8]);
            this.iLeft = Integer.parseInt(pregeneratedChunksFileValues[9]);
            this.iRight = Integer.parseInt(pregeneratedChunksFileValues[10]);
            this.pregenerationRadius = Integer.parseInt(pregeneratedChunksFileValues[11]);
            this.preGeneratorCenterPoint = ChunkCoordinate.fromChunkCoords(Integer.parseInt(pregeneratedChunksFileValues[12]), Integer.parseInt(pregeneratedChunksFileValues[13]));
            this.total = (this.pregenerationRadius * 2 + 1) * (this.pregenerationRadius * 2 + 1);
        } else {
            this.spawned = 1;
            this.left = 0;
            this.top = 0;
            this.right = 0;
            this.bottom = 0;
            this.cycle = 0;
            this.startTime = System.currentTimeMillis();
            this.iTop = Integer.MIN_VALUE;
            this.iBottom = Integer.MIN_VALUE;
            this.iLeft = Integer.MIN_VALUE;
            this.iRight = Integer.MIN_VALUE;
            this.preGeneratorCenterPoint = this.world.getSpawnChunk();
            WorldConfig worldConfig = this.world.getConfigs().getWorldConfig();
            this.setPregenerationRadius(worldConfig.PreGenerationRadius);
            this.SavePregeneratorData();
        }
    }
}

