/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.google.common.collect.Iterables;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ServerConfigProvider;
import com.pg85.otg.forge.ForgeBiome;
import com.pg85.otg.forge.generator.structure.OTGRareBuildingStart;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.monster.EntityWitch;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.ComponentScatteredFeaturePieces;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;

public class OTGRareBuildingGen
extends MapGenStructure {
    public List<Biome> biomeList = new ArrayList<Biome>();
    private List<Biome.SpawnListEntry> scatteredFeatureSpawnList;
    private int maxDistanceBetweenScatteredFeatures;
    private int minDistanceBetweenScatteredFeatures;

    public OTGRareBuildingGen(ServerConfigProvider configs) {
        for (LocalBiome biome : configs.getBiomeArray()) {
            if (biome == null || biome.getBiomeConfig().rareBuildingType == BiomeConfig.RareBuildingType.disabled) continue;
            this.biomeList.add(((ForgeBiome)biome).getHandle());
        }
        this.scatteredFeatureSpawnList = new ArrayList<Biome.SpawnListEntry>();
        this.maxDistanceBetweenScatteredFeatures = configs.getWorldConfig().maximumDistanceBetweenRareBuildings;
        this.minDistanceBetweenScatteredFeatures = configs.getWorldConfig().minimumDistanceBetweenRareBuildings - 1;
        this.scatteredFeatureSpawnList.add(new Biome.SpawnListEntry(EntityWitch.class, 1, 1, 1));
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        Biome biomeAtPosition;
        int var3 = chunkX;
        int var4 = chunkZ;
        if (chunkX < 0) {
            chunkX -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        if (chunkZ < 0) {
            chunkZ -= this.maxDistanceBetweenScatteredFeatures - 1;
        }
        int var5 = chunkX / this.maxDistanceBetweenScatteredFeatures;
        int var6 = chunkZ / this.maxDistanceBetweenScatteredFeatures;
        Random random = this.field_75039_c.func_72843_D(var5, var6, 14357617);
        var5 *= this.maxDistanceBetweenScatteredFeatures;
        var6 *= this.maxDistanceBetweenScatteredFeatures;
        return var3 == (var5 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && var4 == (var6 += random.nextInt(this.maxDistanceBetweenScatteredFeatures - this.minDistanceBetweenScatteredFeatures)) && this.biomeList.contains(biomeAtPosition = this.field_75039_c.func_72959_q().func_180631_a(new BlockPos(var3 * 16 + 8, 0, var4 * 16 + 8)));
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new OTGRareBuildingStart(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    public List<Biome.SpawnListEntry> getMonsterSpawnList() {
        return this.scatteredFeatureSpawnList;
    }

    public boolean isSwampHutAtLocation(BlockPos blockPos) {
        StructureStart structurestart = this.func_175797_c(blockPos);
        if (structurestart != null && structurestart instanceof MapGenScatteredFeature.Start && !structurestart.func_186161_c().isEmpty()) {
            StructureComponent structurecomponent = (StructureComponent)Iterables.getFirst((Iterable)structurestart.func_186161_c(), null);
            return structurecomponent instanceof ComponentScatteredFeaturePieces.SwampHut;
        }
        return false;
    }

    public String func_143025_a() {
        return "OTGTemple";
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean p_180706_3_) {
        this.field_75039_c = worldIn;
        return OTGRareBuildingGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.maxDistanceBetweenScatteredFeatures, (int)8, (int)14357617, (boolean)false, (int)100, (boolean)p_180706_3_);
    }
}

