/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.generator.structure;

import com.google.common.collect.Lists;
import com.pg85.otg.LocalBiome;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.forge.ForgeBiome;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.logging.LogMarker;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.StructureStart;
import net.minecraft.world.gen.structure.WoodlandMansionPieces;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class OTGWoodLandMansionGen
extends MapGenStructure {
    private int spacing = 80;
    private int separation = 20;
    private final List<Biome> woodLandMansionSpawnBiomes = new ArrayList<Biome>();

    public OTGWoodLandMansionGen(ConfigProvider settings) {
        for (LocalBiome biome : settings.getBiomeArray()) {
            if (biome == null || !biome.getBiomeConfig().woodLandMansionsEnabled) continue;
            this.woodLandMansionSpawnBiomes.add(((ForgeBiome)biome).getHandle());
        }
    }

    protected boolean func_75047_a(int chunkX, int chunkZ) {
        boolean flag;
        int i = chunkX;
        int j = chunkZ;
        if (chunkX < 0) {
            i = chunkX - 79;
        }
        if (chunkZ < 0) {
            j = chunkZ - 79;
        }
        int k = i / 80;
        int l = j / 80;
        Random random = this.field_75039_c.func_72843_D(k, l, 10387319);
        k *= 80;
        l *= 80;
        if (chunkX == (k += (random.nextInt(60) + random.nextInt(60)) / 2) && chunkZ == (l += (random.nextInt(60) + random.nextInt(60)) / 2) && (flag = this.field_75039_c.func_72959_q().func_76940_a(chunkX * 16 + 8, chunkZ * 16 + 8, 32, this.woodLandMansionSpawnBiomes))) {
            OTG.log(LogMarker.INFO, "SPAWNING MANSION AT " + (chunkX * 16 + 8) + " 100 " + (chunkZ * 16 + 8), new Object[0]);
            return true;
        }
        return false;
    }

    public BlockPos func_180706_b(World worldIn, BlockPos pos, boolean findUnexplored) {
        this.field_75039_c = worldIn;
        BiomeProvider biomeprovider = worldIn.func_72959_q();
        return biomeprovider.func_190944_c() && !this.woodLandMansionSpawnBiomes.contains(biomeprovider.func_190943_d()) ? null : OTGWoodLandMansionGen.func_191069_a((World)worldIn, (MapGenStructure)this, (BlockPos)pos, (int)this.spacing, (int)this.separation, (int)10387319, (boolean)true, (int)100, (boolean)findUnexplored);
    }

    public String func_143025_a() {
        return "Mansion";
    }

    protected StructureStart func_75049_b(int chunkX, int chunkZ) {
        return new Start(this.field_75039_c, this.field_75038_b, chunkX, chunkZ);
    }

    static {
        MapGenStructureIO.func_143034_b(Start.class, (String)"MansionOTG");
    }

    public static class Start
    extends StructureStart {
        private boolean isValid;

        public Start() {
        }

        public Start(World p_i47235_1_, Random p_i47235_3_, int p_i47235_4_, int p_i47235_5_) {
            super(p_i47235_4_, p_i47235_5_);
            this.create(p_i47235_1_, p_i47235_3_, p_i47235_4_, p_i47235_5_);
        }

        private void create(World world, Random p_191092_3_, int chunkX, int chunkZ) {
            Rotation rotation = Rotation.values()[p_191092_3_.nextInt(Rotation.values().length)];
            int i = 5;
            int j = 5;
            if (rotation == Rotation.CLOCKWISE_90) {
                i = -5;
            } else if (rotation == Rotation.CLOCKWISE_180) {
                i = -5;
                j = -5;
            } else if (rotation == Rotation.COUNTERCLOCKWISE_90) {
                j = -5;
            }
            int k = ((ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(world)).getChunkGenerator().getHighestBlockInCurrentlyPopulatingChunk(7, 7);
            int l = ((ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(world)).getChunkGenerator().getHighestBlockInCurrentlyPopulatingChunk(7, 7 + j);
            int i1 = ((ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(world)).getChunkGenerator().getHighestBlockInCurrentlyPopulatingChunk(7 + i, 7);
            int j1 = ((ForgeWorld)((ForgeEngine)OTG.getEngine()).getWorld(world)).getChunkGenerator().getHighestBlockInCurrentlyPopulatingChunk(7 + i, 7 + j);
            int k1 = Math.min(Math.min(k, l), Math.min(i1, j1));
            if (k1 <= 0 || k1 > 255) {
                this.isValid = false;
            } else {
                BlockPos blockpos = new BlockPos(chunkX * 16 + 8, k1 + 1, chunkZ * 16 + 8);
                LinkedList list = Lists.newLinkedList();
                WoodlandMansionPieces.func_191152_a((TemplateManager)world.func_72860_G().func_186340_h(), (BlockPos)blockpos, (Rotation)rotation, (List)list, (Random)p_191092_3_);
                this.field_75075_a.addAll(list);
                this.func_75072_c();
                this.isValid = true;
            }
        }

        public void func_75068_a(World worldIn, Random rand, StructureBoundingBox structurebb) {
            super.func_75068_a(worldIn, rand, structurebb);
            int i = this.field_75074_b.field_78895_b;
            for (int j = structurebb.field_78897_a; j <= structurebb.field_78893_d; ++j) {
                for (int k = structurebb.field_78896_c; k <= structurebb.field_78892_f; ++k) {
                    BlockPos blockpos1;
                    BlockPos blockpos = new BlockPos(j, i, k);
                    if (worldIn.func_175623_d(blockpos) || !this.field_75074_b.func_175898_b((Vec3i)blockpos)) continue;
                    boolean flag = false;
                    for (StructureComponent structurecomponent : this.field_75075_a) {
                        if (!structurecomponent.func_74874_b().func_175898_b((Vec3i)blockpos)) continue;
                        flag = true;
                        break;
                    }
                    if (!flag) continue;
                    for (int l = i - 1; l > 1 && (worldIn.func_175623_d(blockpos1 = new BlockPos(j, l, k)) || worldIn.func_180495_p(blockpos1).func_185904_a().func_76224_d()); --l) {
                        worldIn.func_180501_a(blockpos1, Blocks.field_150347_e.func_176223_P(), 2);
                    }
                }
            }
        }

        public boolean func_75069_d() {
            return this.isValid;
        }
    }
}

