/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.gui;

import com.google.common.base.Strings;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.forge.ForgeWorldSession;
import com.pg85.otg.forge.generator.Pregenerator;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class PregeneratorUI {
    private static boolean menuOpen = true;

    public static void ShowInGameUI() {
        if (menuOpen) {
            boolean isRunningAndNotDone = false;
            ArrayList<Object> pregenerators = new ArrayList<Object>();
            for (LocalWorld world : OTG.getAllWorlds()) {
                ForgeWorld forgeWorld = (ForgeWorld)world;
                Pregenerator pregenerator = ((ForgeWorldSession)forgeWorld.GetWorldSession()).getPregenerator();
                if (!pregenerator.getPregeneratorIsRunning() || pregenerator.preGeneratorProgressStatus == "Done") continue;
                isRunningAndNotDone = true;
                pregenerators.add(pregenerator);
            }
            Minecraft mc = Minecraft.func_71410_x();
            mc.field_71474_y.field_74330_P = false;
            if (isRunningAndNotDone) {
                FontRenderer fontRenderer = mc.field_71466_p;
                GlStateManager.func_179094_E();
                ArrayList<String> list = new ArrayList<String>();
                for (Pregenerator pregenerator : pregenerators) {
                    list.add("Generating \"" + pregenerator.pregenerationWorld + "\" " + (pregenerator.progressScreenWorldSizeInBlocks > 0 ? "(" + pregenerator.progressScreenWorldSizeInBlocks + "x" + pregenerator.progressScreenWorldSizeInBlocks + " blocks)" : ""));
                    list.add("Progress: " + pregenerator.preGeneratorProgress + "%");
                    list.add("Chunks: " + pregenerator.preGeneratorProgressStatus);
                    list.add("Elapsed: " + pregenerator.progressScreenElapsedTime);
                    list.add("Estimated: " + pregenerator.progressScreenEstimatedTime);
                    list.add("---");
                }
                long i = Runtime.getRuntime().maxMemory();
                long j = Runtime.getRuntime().totalMemory();
                long k = Runtime.getRuntime().freeMemory();
                long l = j - k;
                list.add("Memory: " + Long.valueOf(PregeneratorUI.BytesToMb(l)) + "/" + Long.valueOf(PregeneratorUI.BytesToMb(i)) + " MB");
                for (int zi = 0; zi < list.size(); ++zi) {
                    String s = (String)list.get(zi);
                    if (Strings.isNullOrEmpty((String)s)) continue;
                    int zj = fontRenderer.field_78288_b;
                    int zk = fontRenderer.func_78256_a(s);
                    int zi1 = 2 + zj * zi;
                    Gui.func_73734_a((int)1, (int)(zi1 - 1), (int)(2 + zk + 1), (int)(zi1 + zj - 1), (int)-1873784752);
                    fontRenderer.func_78276_b(s, 2, zi1, 0xE0E0E0);
                }
                GlStateManager.func_179121_F();
            }
        }
    }

    public static void ResetIngameUI() {
        menuOpen = true;
    }

    private static long BytesToMb(long bytes) {
        return bytes / 1024L / 1024L;
    }

    public static void ToggleIngameUI() {
        boolean isRunningAndNotDone = false;
        ArrayList<Pregenerator> pregenerators = new ArrayList<Pregenerator>();
        for (LocalWorld world : OTG.getAllWorlds()) {
            ForgeWorld forgeWorld = (ForgeWorld)world;
            Pregenerator pregenerator = ((ForgeWorldSession)forgeWorld.GetWorldSession()).getPregenerator();
            if (!pregenerator.getPregeneratorIsRunning() || pregenerator.preGeneratorProgressStatus == "Done") continue;
            isRunningAndNotDone = true;
            pregenerators.add(pregenerator);
        }
        if (isRunningAndNotDone || menuOpen) {
            if (menuOpen) {
                Minecraft.func_71410_x().field_71474_y.field_74330_P = false;
                menuOpen = false;
            } else if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                menuOpen = true;
            }
        }
    }
}

