/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import com.pg85.otg.OTG;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.network.AbstractClientMessageHandler;
import com.pg85.otg.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.InputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class DimensionSyncPacket
implements IMessage {
    ByteBuf data = Unpooled.buffer();
    DataInputStream wrappedStream;

    public DimensionSyncPacket() {
    }

    public DimensionSyncPacket(ByteBuf data) {
        this.data = data;
    }

    public void fromBytes(ByteBuf data) {
        int clientProtocolVersion;
        int serverProtocolVersion = data.readInt();
        if (serverProtocolVersion != (clientProtocolVersion = 5)) {
            throw new RuntimeException("Client is using a different version of OTG than server!");
        }
        this.wrappedStream = new DataInputStream((InputStream)new ByteBufInputStream(data));
    }

    public void toBytes(ByteBuf data) {
        data.writeBytes(this.data);
    }

    public static class Handler
    extends AbstractClientMessageHandler<DimensionSyncPacket> {
        @Override
        public IMessage handleClientMessage(EntityPlayer player, DimensionSyncPacket message, MessageContext ctx) {
            try {
                int packetType = message.wrappedStream.readInt();
                if (packetType != 0) {
                    throw new RuntimeException();
                }
                ((ForgeEngine)OTG.getEngine()).getWorldLoader().registerClientWorld(message.wrappedStream);
            }
            catch (Exception e) {
                OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
            return null;
        }
    }
}

