/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.network;

import com.pg85.otg.OTG;
import com.pg85.otg.customobjects.bo3.ParticleFunction;
import com.pg85.otg.forge.client.events.ClientTickHandler;
import com.pg85.otg.forge.network.AbstractClientMessageHandler;
import com.pg85.otg.logging.LogMarker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class ParticlesPacket
implements IMessage {
    ByteBuf data = Unpooled.buffer();
    DataInputStream wrappedStream;

    public ParticlesPacket() {
        ByteBuf nettyBuffer = Unpooled.buffer();
        ByteBufOutputStream stream = new ByteBufOutputStream(nettyBuffer);
        try {
            stream.writeInt(5);
            stream.writeInt(1);
        }
        catch (IOException e) {
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        StringBuilder sb = new StringBuilder();
        try {
            String value = sb.toString();
            byte[] bytes = value.getBytes();
            stream.writeShort(bytes.length);
            stream.write(bytes);
        }
        catch (IOException e) {
            OTG.printStackTrace(LogMarker.FATAL, e);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.data = nettyBuffer;
    }

    public ParticlesPacket(ByteBuf data) {
        this.data = data;
    }

    public void fromBytes(ByteBuf data) {
        int clientProtocolVersion;
        int serverProtocolVersion = data.readInt();
        if (serverProtocolVersion != (clientProtocolVersion = 5)) {
            throw new RuntimeException("Client is using a different version of OTG than server!");
        }
        this.wrappedStream = new DataInputStream((InputStream)new ByteBufInputStream(data));
    }

    public void toBytes(ByteBuf data) {
        data.writeBytes(this.data);
    }

    public static class Handler
    extends AbstractClientMessageHandler<ParticlesPacket> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public IMessage handleClientMessage(EntityPlayer player, ParticlesPacket message, MessageContext ctx) {
            try {
                String particleFunctionString;
                int packetType = message.wrappedStream.readInt();
                if (packetType != 1) throw new RuntimeException();
                ArrayList<ParticleFunction> particleFunctions = new ArrayList<ParticleFunction>();
                short msgLength = message.wrappedStream.readShort();
                byte[] chars = new byte[msgLength];
                if (message.wrappedStream.read(chars, 0, chars.length) == chars.length && (particleFunctionString = new String(chars)) != null && particleFunctionString.length() > 0 && particleFunctionString.startsWith("Particle(")) {
                    String[] particleStrings;
                    for (String particleString : particleStrings = particleFunctionString.replace(")", "").replace("Particle(", "'").split("'")) {
                        String[] parameters = particleString.split(",");
                        if (parameters.length != 11) continue;
                        ParticleFunction particle = new ParticleFunction();
                        particle.x = Integer.parseInt(parameters[0]);
                        particle.y = Integer.parseInt(parameters[1]);
                        particle.z = Integer.parseInt(parameters[2]);
                        particle.particleName = parameters[3];
                        particle.interval = Double.parseDouble(parameters[4]);
                        particle.velocityX = Double.parseDouble(parameters[5]);
                        particle.velocityY = Double.parseDouble(parameters[6]);
                        particle.velocityZ = Double.parseDouble(parameters[7]);
                        particle.velocityXSet = Boolean.parseBoolean(parameters[8]);
                        particle.velocityYSet = Boolean.parseBoolean(parameters[9]);
                        particle.velocityZSet = Boolean.parseBoolean(parameters[10]);
                        particleFunctions.add(particle);
                    }
                }
                ArrayList<ParticleFunction> existingParticleFunctions = new ArrayList<ParticleFunction>();
                ArrayList<ParticleFunction> newParticleFunctions = new ArrayList<ParticleFunction>();
                String[] stringArray = ClientTickHandler.ClientParticleFunctions;
                synchronized (ClientTickHandler.ClientParticleFunctions) {
                    existingParticleFunctions.addAll(ClientTickHandler.ClientParticleFunctions);
                    ClientTickHandler.ClientParticleFunctions.clear();
                    for (ParticleFunction particleFunction : particleFunctions) {
                        boolean bFound = false;
                        for (ParticleFunction existingParticleFunction : existingParticleFunctions) {
                            if (particleFunction.x != existingParticleFunction.x || particleFunction.y != existingParticleFunction.y || particleFunction.z != existingParticleFunction.z) continue;
                            bFound = true;
                            if (newParticleFunctions.contains(existingParticleFunction)) continue;
                            newParticleFunctions.add(existingParticleFunction);
                        }
                        if (bFound) continue;
                        newParticleFunctions.add(particleFunction);
                    }
                    ClientTickHandler.ClientParticleFunctions.addAll(newParticleFunctions);
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    return null;
                }
            }
            catch (Exception e) {
                OTG.log(LogMarker.FATAL, "Failed to receive packet", new Object[0]);
                OTG.printStackTrace(LogMarker.FATAL, e);
            }
            return null;
        }
    }
}

