/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.MathHelper;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;

public class FrozenSurfaceHelper {
    private final LocalWorld world;
    private final WorldConfig worldConfig;
    private int decreaseFactor = 0;
    private final int maxPropagationSize = 15;
    private int currentPropagationSize = 0;

    public FrozenSurfaceHelper(LocalWorld world) {
        this.world = world;
        this.worldConfig = world.getConfigs().getWorldConfig();
    }

    protected void freezeChunk(ChunkCoordinate chunkCoord) {
        int x = chunkCoord.getBlockXCenter();
        int z = chunkCoord.getBlockZCenter();
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                int blockToFreezeX = x + i;
                int blockToFreezeZ = z + j;
                this.freezeColumn(blockToFreezeX, blockToFreezeZ);
            }
        }
    }

    protected void freezeColumn(int x, int z) {
        LocalBiome biome = this.world.getBiome(x, z);
        if (biome != null) {
            int blockToFreezeY = this.world.getHighestBlockYAt(x, z);
            float tempAtBlockToFreeze = biome.getTemperatureAt(x, blockToFreezeY, z);
            if (blockToFreezeY > 0 && tempAtBlockToFreeze < 0.15f) {
                this.currentPropagationSize = 0;
                if (!this.freezeLiquid(x, blockToFreezeY - 1, z)) {
                    this.startSnowFall(x, blockToFreezeY, z, biome);
                }
            }
        }
    }

    private boolean freezeLiquid(int x, int y, int z) {
        LocalMaterialData materialToFreeze;
        LocalBiome biome = this.world.getBiome(x, z);
        if (biome != null && (materialToFreeze = this.world.getMaterial(x, y, z, false)).isLiquid()) {
            this.freezeType(x, y, z, materialToFreeze, biome.getBiomeConfig().iceBlock, DefaultMaterial.WATER, DefaultMaterial.STATIONARY_WATER);
            this.freezeType(x, y, z, materialToFreeze, biome.getBiomeConfig().cooledLavaBlock, DefaultMaterial.LAVA, DefaultMaterial.STATIONARY_LAVA);
            return true;
        }
        return false;
    }

    private void freezeType(int x, int y, int z, LocalMaterialData thawedMaterial, LocalMaterialData frozenMaterial, DefaultMaterial check1, DefaultMaterial check2) {
        if ((thawedMaterial.isMaterial(check1) || thawedMaterial.isMaterial(check2)) && !frozenMaterial.isMaterial(check1) && !frozenMaterial.isMaterial(check2)) {
            this.world.setBlock(x, y, z, frozenMaterial, null, false);
            if (this.worldConfig.fullyFreezeLakes && this.currentPropagationSize < this.maxPropagationSize) {
                this.propagateFreeze(x, y, z);
                ++this.currentPropagationSize;
            }
        }
    }

    private void startSnowFall(int x, int y, int z, LocalBiome biome) {
        this.decreaseFactor = 0;
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        float tempAtBlockToFreeze = biome.getTemperatureAt(x, y, z);
        int snowHeight = biomeConfig.getSnowHeight(tempAtBlockToFreeze);
        LocalMaterialData materialToSnowAt = this.world.getMaterial(x, y, z, false);
        LocalMaterialData materialToSnowOn = this.world.getMaterial(x, y - 1, z, false);
        if (materialToSnowAt.isAir() && materialToSnowOn.canSnowFallOn()) {
            this.setSnowFallAtLocation(x, y--, z, snowHeight, materialToSnowOn);
        }
        if (this.worldConfig.betterSnowFall) {
            do {
                materialToSnowAt = this.world.getMaterial(x, --y, z, false);
                materialToSnowOn = this.world.getMaterial(x, y - 1, z, false);
                if (materialToSnowAt.isAir() && materialToSnowOn.canSnowFallOn()) {
                    this.setSnowFallAtLocation(x, y--, z, snowHeight, materialToSnowOn);
                    continue;
                }
                if (materialToSnowAt.isAir()) continue;
                ++this.decreaseFactor;
            } while (!materialToSnowAt.isSolid() && y > 0);
        }
    }

    private void setSnowFallAtLocation(int x, int y, int z, int baseSnowHeight, LocalMaterialData materialToSnowOn) {
        int snowHeightOnLeaves = MathHelper.clamp(MathHelper.ceil(MathHelper.sqrt(baseSnowHeight)), 0, baseSnowHeight);
        LocalMaterialData snowMass = this.worldConfig.betterSnowFall && (materialToSnowOn.isMaterial(DefaultMaterial.LEAVES) || materialToSnowOn.isMaterial(DefaultMaterial.LEAVES_2)) ? OTG.toLocalMaterialData(DefaultMaterial.SNOW, MathHelper.clamp(snowHeightOnLeaves, 0, 8)) : OTG.toLocalMaterialData(DefaultMaterial.SNOW, MathHelper.clamp(baseSnowHeight - this.decreaseFactor, 0, 8));
        this.world.setBlock(x, y, z, snowMass, null, false);
    }

    private void propagateFreeze(int x, int y, int z) {
        this.propagationHelper(x + 1, y, z);
        this.propagationHelper(x + 1, y, z + 1);
        this.propagationHelper(x, y, z + 1);
        this.propagationHelper(x - 1, y, z + 1);
        this.propagationHelper(x - 1, y, z);
        this.propagationHelper(x - 1, y, z - 1);
        this.propagationHelper(x, y, z - 1);
        this.propagationHelper(x + 1, y, z - 1);
    }

    private void propagationHelper(int x, int y, int z) {
        if (this.world.getHighestBlockYAt(x, z) - 1 > y && this.currentPropagationSize < this.maxPropagationSize) {
            this.freezeLiquid(x, y, z);
        }
    }
}

