/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator;

import com.pg85.otg.LocalBiome;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.configuration.ConfigFunction;
import com.pg85.otg.configuration.ConfigProvider;
import com.pg85.otg.configuration.WorldConfig;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.CustomObjectStructure;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.generator.FrozenSurfaceHelper;
import com.pg85.otg.generator.resource.AboveWaterGen;
import com.pg85.otg.generator.resource.BoulderGen;
import com.pg85.otg.generator.resource.CactusGen;
import com.pg85.otg.generator.resource.CustomObjectGen;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.generator.resource.DungeonGen;
import com.pg85.otg.generator.resource.FossilGen;
import com.pg85.otg.generator.resource.GrassGen;
import com.pg85.otg.generator.resource.IceSpikeGen;
import com.pg85.otg.generator.resource.LiquidGen;
import com.pg85.otg.generator.resource.OreGen;
import com.pg85.otg.generator.resource.PlantGen;
import com.pg85.otg.generator.resource.ReedGen;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.generator.resource.SmallLakeGen;
import com.pg85.otg.generator.resource.SurfacePatchGen;
import com.pg85.otg.generator.resource.TreeGen;
import com.pg85.otg.generator.resource.UnderWaterOreGen;
import com.pg85.otg.generator.resource.UndergroundLakeGen;
import com.pg85.otg.generator.resource.VeinGen;
import com.pg85.otg.generator.resource.VinesGen;
import com.pg85.otg.generator.resource.WellGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.Rotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;

public class ObjectSpawner {
    public boolean populating;
    public boolean saving;
    public boolean saveRequired;
    public int populatingX = 0;
    public int populatingZ = 0;
    public Object lockingObject = new Object();
    private final ConfigProvider configProvider;
    private final Random rand;
    private final LocalWorld world;
    public boolean StructurePlottedAtSpawn = false;
    public boolean processing = false;

    public ObjectSpawner(ConfigProvider configProvider, LocalWorld localWorld) {
        this.configProvider = configProvider;
        this.rand = new Random();
        this.world = localWorld;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populate(ChunkCoordinate chunkCoord) {
        WorldConfig worldConfig;
        Object object;
        while (true) {
            object = this.lockingObject;
            synchronized (object) {
                if (!this.saving) {
                    this.populating = true;
                    break;
                }
            }
        }
        object = this.lockingObject;
        synchronized (object) {
            this.saveRequired = true;
        }
        if (this.world.getConfigs().getWorldConfig().IsOTGPlus && !this.StructurePlottedAtSpawn) {
            this.world.getStructureCache().PlotStructures(this.world.getSpawnChunk(), true);
        }
        this.StructurePlottedAtSpawn = true;
        if (!this.processing) {
            this.processing = true;
            if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
                this.world.getStructureCache().PlotStructures(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ()), false);
                this.world.getStructureCache().PlotStructures(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ() + 1), false);
                this.world.getStructureCache().PlotStructures(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ() + 1), false);
                this.world.getStructureCache().PlotStructures(chunkCoord, false);
                ChunkCoordinate spawnChunk = this.world.getSpawnChunk();
                boolean hasVillage = false;
                if (spawnChunk.equals(chunkCoord) && this.world.getConfigs().getWorldConfig().BO3AtSpawn != null && this.world.getConfigs().getWorldConfig().BO3AtSpawn.trim().length() > 0) {
                    CustomObject customObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.world.getConfigs().getWorldConfig().BO3AtSpawn, this.world.getConfigs().getWorldConfig().getName());
                    if (customObject != null && customObject instanceof BO3) {
                        int y = 1;
                        if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
                            y = this.world.getHighestBlockYAt(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter()) - 1;
                        } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
                            y = this.world.getSolidHeight(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter()) - 1;
                        } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                            y = (int)((double)((BO3)customObject).getSettings().minHeight + Math.random() * (double)(((BO3)customObject).getSettings().maxHeight - ((BO3)customObject).getSettings().minHeight));
                        }
                        boolean populationBoundsCheck = this.world.getConfigs().getWorldConfig().populationBoundsCheck;
                        this.world.getConfigs().getWorldConfig().populationBoundsCheck = false;
                        this.world.setAllowSpawningOutsideBounds(true);
                        ((BO3)customObject).spawnForced(this.world, this.rand, Rotation.NORTH, spawnChunk.getBlockXCenter(), y += ((BO3)customObject).getSettings().spawnHeightOffset, spawnChunk.getBlockZCenter());
                        this.world.setAllowSpawningOutsideBounds(false);
                        this.world.getConfigs().getWorldConfig().populationBoundsCheck = populationBoundsCheck;
                    }
                } else {
                    hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
                }
                WorldConfig worldConfig2 = this.configProvider.getWorldConfig();
                long resourcesSeed = worldConfig2.resourcesSeed != 0L ? worldConfig2.resourcesSeed : this.world.getSeed();
                this.rand.setSeed(resourcesSeed);
                long l1 = this.rand.nextLong() / 2L * 2L + 1L;
                long l2 = this.rand.nextLong() / 2L * 2L + 1L;
                this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
                OTG.firePopulationStartEvent(this.world, this.rand, hasVillage, chunkCoord);
                this.processResourcesPhase2(chunkCoord);
                this.SpawnBO3s(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ()));
                this.SpawnBO3s(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ() + 1));
                this.SpawnBO3s(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX() + 1, chunkCoord.getChunkZ() + 1));
                this.SpawnBO3s(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ()));
                this.processResourcesPhase3(chunkCoord, hasVillage);
                OTG.firePopulationEndEvent(this.world, this.rand, hasVillage, chunkCoord);
            } else {
                int z;
                int x = chunkCoord.getChunkX() * 16;
                LocalBiome biome = this.world.getBiome(x + 15, (z = chunkCoord.getChunkZ() * 16) + 15);
                if (biome == null) {
                    OTG.log(LogMarker.WARN, "Unknown biome at {},{}  (chunk {}). Could not populate chunk.", x + 15, z + 15, chunkCoord);
                    return;
                }
                BiomeConfig biomeConfig = biome.getBiomeConfig();
                WorldConfig worldConfig3 = this.configProvider.getWorldConfig();
                long resourcesSeed = worldConfig3.resourcesSeed != 0L ? worldConfig3.resourcesSeed : this.world.getSeed();
                this.rand.setSeed(resourcesSeed);
                long l1 = this.rand.nextLong() / 2L * 2L + 1L;
                long l2 = this.rand.nextLong() / 2L * 2L + 1L;
                this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
                ChunkCoordinate spawnChunk = this.world.getSpawnChunk();
                boolean hasVillage = false;
                if (spawnChunk.equals(chunkCoord) && this.world.getConfigs().getWorldConfig().BO3AtSpawn != null && this.world.getConfigs().getWorldConfig().BO3AtSpawn.trim().length() > 0) {
                    CustomObject customObject = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.world.getConfigs().getWorldConfig().BO3AtSpawn, this.world.getConfigs().getWorldConfig().getName());
                    if (customObject != null && customObject instanceof BO3) {
                        int y = 1;
                        if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock) {
                            y = this.world.getHighestBlockYAt(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter()) - 1;
                        } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
                            y = this.world.getSolidHeight(spawnChunk.getBlockXCenter(), spawnChunk.getBlockZCenter()) - 1;
                        } else if (((BO3)customObject).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.randomY) {
                            y = (int)((double)((BO3)customObject).getSettings().minHeight + Math.random() * (double)(((BO3)customObject).getSettings().maxHeight - ((BO3)customObject).getSettings().minHeight));
                        }
                        boolean populationBoundsCheck = this.world.getConfigs().getWorldConfig().populationBoundsCheck;
                        this.world.getConfigs().getWorldConfig().populationBoundsCheck = false;
                        this.world.setAllowSpawningOutsideBounds(true);
                        ((BO3)customObject).spawnForced(this.world, this.rand, Rotation.NORTH, spawnChunk.getBlockXCenter(), y += ((BO3)customObject).getSettings().spawnHeightOffset, spawnChunk.getBlockZCenter());
                        this.world.setAllowSpawningOutsideBounds(false);
                        this.world.getConfigs().getWorldConfig().populationBoundsCheck = populationBoundsCheck;
                    }
                } else {
                    hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
                }
                this.world.startPopulation(chunkCoord);
                OTG.firePopulationStartEvent(this.world, this.rand, hasVillage, chunkCoord);
                for (ConfigFunction<BiomeConfig> res : biomeConfig.resourceSequence) {
                    if (!(res instanceof Resource)) continue;
                    ((Resource)res).process(this.world, this.rand, hasVillage, chunkCoord);
                }
                this.world.placePopulationMobs(biome, this.rand, chunkCoord);
                new FrozenSurfaceHelper(this.world).freezeChunk(chunkCoord);
                this.world.replaceBlocks(chunkCoord);
                OTG.firePopulationEndEvent(this.world, this.rand, hasVillage, chunkCoord);
                this.world.endPopulation();
            }
            this.processing = false;
        } else if (this.world.getConfigs().getWorldConfig().IsOTGPlus) {
            this.world.getStructureCache().PlotStructures(chunkCoord, false);
            this.SpawnBO3s(ChunkCoordinate.fromChunkCoords(chunkCoord.getChunkX(), chunkCoord.getChunkZ()));
            worldConfig = this.configProvider.getWorldConfig();
            long resourcesSeed = worldConfig.resourcesSeed != 0L ? worldConfig.resourcesSeed : this.world.getSeed();
            this.rand.setSeed(resourcesSeed);
            long l1 = this.rand.nextLong() / 2L * 2L + 1L;
            long l2 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
            this.world.startPopulation(chunkCoord);
            OTG.firePopulationStartEvent(this.world, this.rand, false, chunkCoord);
            int x = chunkCoord.getChunkX() * 16;
            int z = chunkCoord.getChunkZ() * 16;
            LocalBiome biome = this.world.getBiome(x + 8, z + 8);
            boolean hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
            this.world.placePopulationMobs(biome, this.rand, chunkCoord);
            OTG.firePopulationEndEvent(this.world, this.rand, false, chunkCoord);
            this.world.endPopulation();
            OTG.log(LogMarker.INFO, "Error, minecraft engine attempted to populate two chunks at once! Chunk X" + chunkCoord.getChunkX() + " Z" + chunkCoord.getChunkZ() + ". This is probably caused by a mod spawning blocks in unloaded chunks and can cause lag as well as missing trees, ores and other TC/OTG resources. Please try to find out which mod causes this, disable the feature causing it and alert the mod creator. Set the log level to TRACE in mods/OpenTerrainGenerator/OTG.ini file for a stack trace.", new Object[0]);
            OTG.log(LogMarker.TRACE, Arrays.toString(Thread.currentThread().getStackTrace()), new Object[0]);
        } else {
            OTG.log(LogMarker.TRACE, "Error, minecraft engine attempted to populate two chunks at once! Chunk X" + chunkCoord.getChunkX() + " Z" + chunkCoord.getChunkZ() + ". This is probably caused by a mod spawning blocks in unloaded chunks and can cause lag as well as missing trees, ores and other OTG resources. Please try to find out which mod causes this, disable the feature causing it and alert the mod creator. Set the log level to Trace in mods/OpenTerrainGenerator/OTG.ini file for a stack trace. (Update: The recently added multi-dimension features may be causing this log message occasionally, will fix a.s.a.p).", new Object[0]);
            OTG.log(LogMarker.TRACE, Arrays.toString(Thread.currentThread().getStackTrace()), new Object[0]);
            worldConfig = this.configProvider.getWorldConfig();
            long resourcesSeed = worldConfig.resourcesSeed != 0L ? worldConfig.resourcesSeed : this.world.getSeed();
            this.rand.setSeed(resourcesSeed);
            long l1 = this.rand.nextLong() / 2L * 2L + 1L;
            long l2 = this.rand.nextLong() / 2L * 2L + 1L;
            this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
            this.world.startPopulation(chunkCoord);
            OTG.firePopulationStartEvent(this.world, this.rand, false, chunkCoord);
            boolean hasVillage = this.world.placeDefaultStructures(this.rand, chunkCoord);
            OTG.firePopulationEndEvent(this.world, this.rand, false, chunkCoord);
            this.world.endPopulation();
        }
        Object object2 = this.lockingObject;
        synchronized (object2) {
            this.populating = false;
        }
    }

    public void processResourcesPhase2(ChunkCoordinate chunkCoord) {
        LocalBiome biome = this.world.getBiome(chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 8);
        if (biome == null) {
            OTG.log(LogMarker.DEBUG, "Unknown biome at {},{}  (chunk {}). Population failed.", chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 8, chunkCoord);
            throw new RuntimeException();
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        ArrayList<Resource> miscResources = new ArrayList<Resource>();
        for (ConfigFunction<BiomeConfig> configFunction : biomeConfig.resourceSequence) {
            if (configFunction instanceof CustomObjectGen || configFunction instanceof CustomStructureGen) continue;
            miscResources.add((Resource)configFunction);
        }
        for (Resource resource : miscResources) {
            if (!(resource instanceof OreGen) && !(resource instanceof SmallLakeGen) && !(resource instanceof UndergroundLakeGen) && !(resource instanceof UnderWaterOreGen) && !(resource instanceof VeinGen) && !(resource instanceof SurfacePatchGen)) continue;
            resource.process(this.world, this.rand, false, chunkCoord);
        }
    }

    public void processResourcesPhase3(ChunkCoordinate chunkCoord, boolean hasGeneratedAVillage) {
        WorldConfig worldConfig = this.configProvider.getWorldConfig();
        long resourcesSeed = worldConfig.resourcesSeed != 0L ? worldConfig.resourcesSeed : this.world.getSeed();
        this.rand.setSeed(resourcesSeed);
        long l1 = this.rand.nextLong() / 2L * 2L + 1L;
        long l2 = this.rand.nextLong() / 2L * 2L + 1L;
        this.rand.setSeed((long)chunkCoord.getChunkX() * l1 + (long)chunkCoord.getChunkZ() * l2 ^ resourcesSeed);
        int x = chunkCoord.getChunkX() * 16;
        int z = chunkCoord.getChunkZ() * 16;
        LocalBiome biome = this.world.getBiome(x + 8, z + 8);
        if (biome == null) {
            OTG.log(LogMarker.DEBUG, "Unknown biome at {},{}  (chunk {}). Population failed.", chunkCoord.getBlockX() + 8, chunkCoord.getBlockZ() + 8, chunkCoord);
            throw new RuntimeException();
        }
        BiomeConfig biomeConfig = biome.getBiomeConfig();
        ArrayList<Resource> customObjects = new ArrayList<Resource>();
        ArrayList<Resource> miscResources = new ArrayList<Resource>();
        for (ConfigFunction<BiomeConfig> configFunction : biomeConfig.resourceSequence) {
            if (configFunction instanceof CustomObjectGen) {
                customObjects.add((Resource)configFunction);
                continue;
            }
            if (configFunction instanceof CustomStructureGen) continue;
            miscResources.add((Resource)configFunction);
        }
        for (Resource resource : customObjects) {
            resource.process(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        }
        for (Resource resource : miscResources) {
            if (!(resource instanceof DungeonGen) && !(resource instanceof AboveWaterGen) && !(resource instanceof PlantGen) && !(resource instanceof GrassGen) && !(resource instanceof TreeGen) && !(resource instanceof ReedGen) && !(resource instanceof LiquidGen) && !(resource instanceof BoulderGen) && !(resource instanceof CactusGen) && !(resource instanceof IceSpikeGen) && !(resource instanceof WellGen) && !(resource instanceof VinesGen) && !(resource instanceof FossilGen)) continue;
            resource.process(this.world, this.rand, hasGeneratedAVillage, chunkCoord);
        }
        this.world.placePopulationMobs(biome, this.rand, chunkCoord);
        new FrozenSurfaceHelper(this.world).freezeChunk(chunkCoord);
        this.world.replaceBlocks(chunkCoord);
    }

    public void SpawnBO3s(ChunkCoordinate chunkCoord) {
        int z;
        int x = chunkCoord.getChunkX() * 16;
        LocalBiome biome = this.world.getBiome(x + 15, (z = chunkCoord.getChunkZ() * 16) + 15);
        if (biome == null) {
            OTG.log(LogMarker.DEBUG, "Unknown biome at {},{}  (chunk {}). Population failed.", x + 15, z + 15, chunkCoord);
            return;
        }
        CustomObjectStructure structureStart = this.world.getStructureCache().structureCache.get(chunkCoord);
        if (structureStart != null && structureStart.Start != null) {
            structureStart.SpawnForChunk(chunkCoord);
            if (!this.world.IsInsidePregeneratedRegion(chunkCoord, true)) {
                this.world.getStructureCache().structureCache.put(chunkCoord, null);
            } else {
                this.world.getStructureCache().structureCache.remove(chunkCoord);
            }
        } else if (structureStart != null) {
            if (!this.world.IsInsidePregeneratedRegion(chunkCoord, true)) {
                this.world.getStructureCache().structureCache.put(chunkCoord, null);
            } else {
                this.world.getStructureCache().structureCache.remove(chunkCoord);
            }
        }
    }
}

