/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.biome;

import com.pg85.otg.generator.biome.BiomeGenerator;
import com.pg85.otg.generator.biome.OutputType;
import com.pg85.otg.util.ChunkCoordinate;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

class CachedBiomeGenerator
extends BiomeGenerator {
    private Map<ChunkCoordinate, Block> cacheMap = new HashMap<ChunkCoordinate, Block>();
    private final BiomeGenerator generator;
    private long lastCleanupTime;

    private CachedBiomeGenerator(BiomeGenerator generator) {
        super(generator.world);
        this.generator = generator;
    }

    static BiomeGenerator makeCached(BiomeGenerator generator) {
        if (generator.isCached()) {
            return generator;
        }
        return new CachedBiomeGenerator(generator);
    }

    @Override
    public void cleanupCache() {
        long currentTime = System.currentTimeMillis();
        long timeSinceLastCleanup = currentTime - this.lastCleanupTime;
        if (timeSinceLastCleanup < 7500L && timeSinceLastCleanup > 0L) {
            return;
        }
        this.lastCleanupTime = currentTime;
        Iterator<Map.Entry<ChunkCoordinate, Block>> it = this.cacheMap.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<ChunkCoordinate, Block> entry = it.next();
            Block block = entry.getValue();
            long timeSinceLastAccessed = currentTime - block.lastAccessTime;
            if (timeSinceLastAccessed <= 30000L && timeSinceLastAccessed >= 0L) continue;
            it.remove();
        }
    }

    @Override
    public int getBiome(int x, int z) {
        ChunkCoordinate chunkCoord = ChunkCoordinate.fromBlockCoords(x, z);
        Block cacheBlock = this.getBiomeCacheBlock(chunkCoord);
        return cacheBlock.getCalculatedBiomeId(x, z);
    }

    private Block getBiomeCacheBlock(ChunkCoordinate chunkCoord) {
        Block block = this.cacheMap.get(chunkCoord);
        if (block == null) {
            block = new Block(this.generator, chunkCoord);
            this.cacheMap.put(chunkCoord, block);
        }
        block.lastAccessTime = System.currentTimeMillis();
        return block;
    }

    @Override
    public int[] getBiomes(int[] biomeArray, int x, int z, int xSize, int zSize, OutputType type) {
        if (xSize == 16 && zSize == 16 && (x & 0xF) == 0 && (z & 0xF) == 0) {
            if (biomeArray == null || biomeArray.length < xSize * zSize) {
                biomeArray = new int[xSize * zSize];
            }
            int[] cachedBiomes = this.getCachedBiomes(ChunkCoordinate.fromBlockCoords(x, z));
            System.arraycopy(cachedBiomes, 0, biomeArray, 0, xSize * zSize);
            return biomeArray;
        }
        return this.generator.getBiomes(biomeArray, x, z, xSize, zSize, type);
    }

    @Override
    public int[] getBiomesUnZoomed(int[] biomeArray, int x, int z, int xSize, int zSize, OutputType type) {
        return this.generator.getBiomesUnZoomed(biomeArray, x, z, xSize, zSize, type);
    }

    @Override
    public boolean canGenerateUnZoomed() {
        return this.generator.canGenerateUnZoomed();
    }

    public int[] getCachedBiomes(ChunkCoordinate chunkCoord) {
        return this.getBiomeCacheBlock(chunkCoord).biomes;
    }

    @Override
    public boolean isCached() {
        return true;
    }

    @Override
    public BiomeGenerator unwrap() {
        return this.generator.unwrap();
    }

    private static class Block {
        private int[] biomes = new int[256];
        private long lastAccessTime;

        Block(BiomeGenerator generator, ChunkCoordinate chunkCoord) {
            this.biomes = generator.getBiomes(this.biomes, chunkCoord.getBlockX(), chunkCoord.getBlockZ(), 16, 16, OutputType.DEFAULT_FOR_WORLD);
        }

        int getCalculatedBiomeId(int blockX, int blockZ) {
            return this.biomes[blockX & 0xF | (blockZ & 0xF) << 4];
        }
    }
}

