/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.OTG;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.minecraftTypes.DefaultMaterial;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class PlantType {
    private static final Map<String, PlantType> LOOKUP_MAP = new TreeMap<String, PlantType>(String.CASE_INSENSITIVE_ORDER);
    public static final PlantType Allium = PlantType.register(new PlantType("Allium", DefaultMaterial.RED_ROSE, 2));
    public static final PlantType AzureBluet = PlantType.register(new PlantType("AzureBluet", DefaultMaterial.RED_ROSE, 3));
    public static final PlantType BlueOrchid = PlantType.register(new PlantType("BlueOrchid", DefaultMaterial.RED_ROSE, 1));
    public static final PlantType BrownMushroom = PlantType.register(new PlantType("BrownMushroom", DefaultMaterial.BROWN_MUSHROOM, 0));
    public static final PlantType Dandelion = PlantType.register(new PlantType("Dandelion", DefaultMaterial.YELLOW_FLOWER, 0));
    public static final PlantType DeadBush = PlantType.register(new PlantType("DeadBush", DefaultMaterial.DEAD_BUSH, 0));
    public static final PlantType DoubleTallgrass = PlantType.register(new PlantType("DoubleTallgrass", DefaultMaterial.DOUBLE_PLANT, 2, 8));
    public static final PlantType Fern = PlantType.register(new PlantType("Fern", DefaultMaterial.LONG_GRASS, 2));
    public static final PlantType LargeFern = PlantType.register(new PlantType("LargeFern", DefaultMaterial.DOUBLE_PLANT, 3, 8));
    public static final PlantType Lilac = PlantType.register(new PlantType("Lilac", DefaultMaterial.DOUBLE_PLANT, 1, 8));
    public static final PlantType OrangeTulip = PlantType.register(new PlantType("OrangeTulip", DefaultMaterial.RED_ROSE, 5));
    public static final PlantType OxeyeDaisy = PlantType.register(new PlantType("OxeyeDaisy", DefaultMaterial.RED_ROSE, 8));
    public static final PlantType Peony = PlantType.register(new PlantType("Peony", DefaultMaterial.DOUBLE_PLANT, 5, 8));
    public static final PlantType PinkTulip = PlantType.register(new PlantType("PinkTulip", DefaultMaterial.RED_ROSE, 7));
    public static final PlantType Poppy = PlantType.register(new PlantType("Poppy", DefaultMaterial.RED_ROSE, 0));
    public static final PlantType RedMushroom = PlantType.register(new PlantType("RedMushroom", DefaultMaterial.RED_MUSHROOM, 0));
    public static final PlantType RedTulip = PlantType.register(new PlantType("RedTulip", DefaultMaterial.RED_ROSE, 4));
    public static final PlantType RoseBush = PlantType.register(new PlantType("RoseBush", DefaultMaterial.DOUBLE_PLANT, 4, 8));
    public static final PlantType Sunflower = PlantType.register(new PlantType("Sunflower", DefaultMaterial.DOUBLE_PLANT, 0, 8));
    public static final PlantType Tallgrass = PlantType.register(new PlantType("Tallgrass", DefaultMaterial.LONG_GRASS, 1));
    public static final PlantType WhiteTulip = PlantType.register(new PlantType("WhiteTulip", DefaultMaterial.RED_ROSE, 6));
    private final String name;
    private final LocalMaterialData topBlock;
    private final LocalMaterialData bottomBlock;

    public static PlantType getPlant(String name) throws InvalidConfigException {
        PlantType plantType = LOOKUP_MAP.get(name);
        if (plantType == null) {
            LocalMaterialData material = OTG.readMaterial(name);
            plantType = new PlantType(material);
        }
        return plantType;
    }

    public static Collection<PlantType> values() {
        return LOOKUP_MAP.values();
    }

    public static PlantType register(PlantType plantType) {
        LOOKUP_MAP.put(plantType.toString(), plantType);
        return plantType;
    }

    protected PlantType(String name, DefaultMaterial material, int data) {
        this.name = name;
        this.topBlock = null;
        this.bottomBlock = OTG.toLocalMaterialData(material, data);
    }

    protected PlantType(LocalMaterialData material) {
        this.name = material.toString();
        this.topBlock = null;
        this.bottomBlock = material;
    }

    protected PlantType(String name, DefaultMaterial material, int bottomData, int topData) {
        this.name = name;
        this.topBlock = OTG.toLocalMaterialData(material, topData);
        this.bottomBlock = OTG.toLocalMaterialData(material, bottomData);
    }

    public String getName() {
        return this.name;
    }

    public void spawn(LocalWorld world, int x, int y, int z) {
        world.setBlock(x, y, z, this.bottomBlock, null, false);
        if (this.topBlock != null) {
            world.setBlock(x, y + 1, z, this.topBlock, null, false);
        }
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bottomBlock == null ? 0 : this.bottomBlock.hashCode());
        result = 31 * result + (this.topBlock == null ? 0 : this.topBlock.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PlantType)) {
            return false;
        }
        PlantType other = (PlantType)obj;
        if (this.bottomBlock == null ? other.bottomBlock != null : !this.bottomBlock.equals(other.bottomBlock)) {
            return false;
        }
        return !(this.topBlock == null ? other.topBlock != null : !this.topBlock.equals(other.topBlock));
    }

    public LocalMaterialData getBottomMaterial() {
        return this.bottomBlock;
    }

    public LocalMaterialData getTopMaterial() {
        return this.topBlock;
    }
}

