/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.generator.resource;

import com.pg85.otg.LocalMaterialData;
import com.pg85.otg.LocalWorld;
import com.pg85.otg.configuration.BiomeConfig;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.Resource;
import com.pg85.otg.util.MaterialSet;
import java.util.List;
import java.util.Random;

public class UnderWaterOreGen
extends Resource {
    private final int size;
    private final MaterialSet sourceBlocks;

    public UnderWaterOreGen(BiomeConfig biomeConfig, List<String> args) throws InvalidConfigException {
        super(biomeConfig);
        this.assureSize(5, args);
        this.material = this.readMaterial(args.get(0));
        this.size = this.readInt(args.get(1), 1, 8);
        this.frequency = this.readInt(args.get(2), 1, 100);
        this.rarity = this.readRarity(args.get(3));
        this.sourceBlocks = this.readMaterials(args, 4);
    }

    @Override
    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        UnderWaterOreGen compare = (UnderWaterOreGen)other;
        return (this.sourceBlocks == null ? this.sourceBlocks == compare.sourceBlocks : this.sourceBlocks.equals(compare.sourceBlocks)) && this.size == compare.size;
    }

    @Override
    public int getPriority() {
        return -12;
    }

    @Override
    public int hashCode() {
        int hash = 5;
        hash = 47 * hash + super.hashCode();
        hash = 47 * hash + (this.sourceBlocks != null ? this.sourceBlocks.hashCode() : 0);
        hash = 47 * hash + this.size;
        return hash;
    }

    @Override
    public String toString() {
        return "UnderWaterOre(" + this.material + "," + this.size + "," + this.frequency + "," + this.rarity + this.makeMaterials(this.sourceBlocks) + ")";
    }

    @Override
    public void spawn(LocalWorld world, Random rand, boolean villageInChunk, int x, int z) {
        int firstSolidBlock = world.getSolidHeight(x, z) - 1;
        if (world.getLiquidHeight(x, z) < firstSolidBlock || firstSolidBlock == -1) {
            return;
        }
        int currentSize = rand.nextInt(this.size);
        int two = 2;
        for (int currentX = x - currentSize; currentX <= x + currentSize; ++currentX) {
            for (int currentZ = z - currentSize; currentZ <= z + currentSize; ++currentZ) {
                int deltaX = currentX - x;
                int deltaZ = currentZ - z;
                if (deltaX * deltaX + deltaZ * deltaZ > currentSize * currentSize) continue;
                for (int y = firstSolidBlock - two; y <= firstSolidBlock + two; ++y) {
                    LocalMaterialData sourceBlock = world.getMaterial(currentX, y, currentZ, false);
                    if (!this.sourceBlocks.contains(sourceBlock)) continue;
                    world.setBlock(currentX, y, currentZ, this.material, null, false);
                }
            }
        }
    }
}

