/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.util;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class NamedBinaryTag {
    private final Type type;
    private Type listType = null;
    private final String name;
    private Object value;

    public NamedBinaryTag(Type type, String name, NamedBinaryTag[] value) {
        this(type, name, (Object)value);
    }

    public NamedBinaryTag(String name, Type listType) {
        this(Type.TAG_List, name, (Object)listType);
    }

    public NamedBinaryTag(Type type, String name, Object value) {
        switch (type) {
            case TAG_End: {
                if (value == null) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte: {
                if (value instanceof Byte) break;
                throw new IllegalArgumentException();
            }
            case TAG_Short: {
                if (value instanceof Short) break;
                throw new IllegalArgumentException();
            }
            case TAG_Int: {
                if (value instanceof Integer) break;
                throw new IllegalArgumentException();
            }
            case TAG_Long: {
                if (value instanceof Long) break;
                throw new IllegalArgumentException();
            }
            case TAG_Float: {
                if (value instanceof Float) break;
                throw new IllegalArgumentException();
            }
            case TAG_Double: {
                if (value instanceof Double) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte_Array: {
                if (value instanceof byte[]) break;
                throw new IllegalArgumentException();
            }
            case TAG_String: {
                if (value instanceof String) break;
                throw new IllegalArgumentException();
            }
            case TAG_List: {
                if (value instanceof Type) {
                    this.listType = (Type)value;
                    value = new NamedBinaryTag[]{};
                    break;
                }
                if (!(value instanceof NamedBinaryTag[])) {
                    throw new IllegalArgumentException();
                }
                this.listType = ((NamedBinaryTag[])value)[0].getType();
                break;
            }
            case TAG_Compound: {
                if (value instanceof NamedBinaryTag[]) break;
                throw new IllegalArgumentException();
            }
            case TAG_Int_Array: {
                if (value instanceof int[]) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.type = type;
        this.name = name == null ? "" : name;
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        switch (this.type) {
            case TAG_End: {
                if (this.value == null) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte: {
                if (this.value instanceof Byte) break;
                throw new IllegalArgumentException();
            }
            case TAG_Short: {
                if (this.value instanceof Short) break;
                throw new IllegalArgumentException();
            }
            case TAG_Int: {
                if (this.value instanceof Integer) break;
                throw new IllegalArgumentException();
            }
            case TAG_Long: {
                if (this.value instanceof Long) break;
                throw new IllegalArgumentException();
            }
            case TAG_Float: {
                if (this.value instanceof Float) break;
                throw new IllegalArgumentException();
            }
            case TAG_Double: {
                if (this.value instanceof Double) break;
                throw new IllegalArgumentException();
            }
            case TAG_Byte_Array: {
                if (!(this.value instanceof byte[])) {
                    throw new IllegalArgumentException();
                }
            }
            case TAG_String: {
                if (this.value instanceof String) break;
                throw new IllegalArgumentException();
            }
            case TAG_List: {
                if (this.value instanceof Type) {
                    this.listType = (Type)((Object)this.value);
                    this.value = new NamedBinaryTag[0];
                    break;
                }
                if (!(this.value instanceof NamedBinaryTag[])) {
                    throw new IllegalArgumentException();
                }
                this.listType = ((NamedBinaryTag[])this.value)[0].getType();
                break;
            }
            case TAG_Compound: {
                if (this.value instanceof NamedBinaryTag[]) break;
                throw new IllegalArgumentException();
            }
            case TAG_Int_Array: {
                if (this.value instanceof int[]) break;
                throw new IllegalArgumentException();
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.value = newValue;
    }

    public Type getListType() {
        return this.listType;
    }

    public void addTag(NamedBinaryTag tag) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        NamedBinaryTag[] subtags = (NamedBinaryTag[])this.value;
        int index = subtags.length;
        if (this.type == Type.TAG_Compound) {
            --index;
        }
        this.insertTag(tag, index);
    }

    public void insertTag(NamedBinaryTag tag, int index) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        NamedBinaryTag[] subtags = (NamedBinaryTag[])this.value;
        if (subtags.length > 0 && this.type == Type.TAG_List && tag.getType() != this.getListType()) {
            throw new IllegalArgumentException();
        }
        if (index > subtags.length) {
            throw new IndexOutOfBoundsException();
        }
        NamedBinaryTag[] newValue = new NamedBinaryTag[subtags.length + 1];
        System.arraycopy(subtags, 0, newValue, 0, index);
        newValue[index] = tag;
        System.arraycopy(subtags, index, newValue, index + 1, subtags.length - index);
        this.value = newValue;
    }

    public NamedBinaryTag removeTag(int index) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        NamedBinaryTag[] subtags = (NamedBinaryTag[])this.value;
        NamedBinaryTag victim = subtags[index];
        NamedBinaryTag[] newValue = new NamedBinaryTag[subtags.length - 1];
        System.arraycopy(subtags, 0, newValue, 0, index);
        System.arraycopy(subtags, ++index, newValue, index - 1, subtags.length - index);
        this.value = newValue;
        return victim;
    }

    public void removeSubTag(NamedBinaryTag tag) {
        if (this.type != Type.TAG_List && this.type != Type.TAG_Compound) {
            throw new RuntimeException();
        }
        if (tag == null) {
            return;
        }
        NamedBinaryTag[] subtags = (NamedBinaryTag[])this.value;
        for (int i = 0; i < subtags.length; ++i) {
            if (subtags[i] == tag) {
                this.removeTag(i);
                return;
            }
            if (subtags[i].type != Type.TAG_List && subtags[i].type != Type.TAG_Compound) continue;
            subtags[i].removeSubTag(tag);
        }
    }

    public NamedBinaryTag getTag(String name) {
        if (this.type != Type.TAG_Compound) {
            return null;
        }
        if (name == null) {
            name = "";
        }
        for (NamedBinaryTag subTag : this.values()) {
            if (!subTag.name.equals(name)) continue;
            return subTag;
        }
        return null;
    }

    public NamedBinaryTag[] values() {
        if (this.type != Type.TAG_Compound && this.type != Type.TAG_List) {
            return new NamedBinaryTag[0];
        }
        return (NamedBinaryTag[])this.value;
    }

    public static NamedBinaryTag readFrom(InputStream is, boolean compressed) throws IOException {
        DataInputStream dis = null;
        dis = compressed ? new DataInputStream(new GZIPInputStream(is)) : new DataInputStream(is);
        byte type = dis.readByte();
        NamedBinaryTag tag = null;
        if (type == 0) {
            tag = new NamedBinaryTag(Type.TAG_End, null, null);
        } else {
            try {
                tag = new NamedBinaryTag(Type.values()[type], dis.readUTF(), NamedBinaryTag.readPayload(dis, type));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        dis.close();
        return tag;
    }

    private static Object readPayload(DataInputStream dis, byte type) throws IOException {
        switch (type) {
            case 0: {
                return null;
            }
            case 1: {
                return dis.readByte();
            }
            case 2: {
                return dis.readShort();
            }
            case 3: {
                return dis.readInt();
            }
            case 4: {
                return dis.readLong();
            }
            case 5: {
                return Float.valueOf(dis.readFloat());
            }
            case 6: {
                return dis.readDouble();
            }
            case 7: {
                int length = dis.readInt();
                byte[] ba = new byte[length];
                dis.readFully(ba);
                return ba;
            }
            case 8: {
                return dis.readUTF();
            }
            case 9: {
                byte lt = dis.readByte();
                int ll = dis.readInt();
                NamedBinaryTag[] lo = new NamedBinaryTag[ll];
                for (int i = 0; i < ll; ++i) {
                    lo[i] = new NamedBinaryTag(Type.values()[lt], null, NamedBinaryTag.readPayload(dis, lt));
                }
                if (lo.length == 0) {
                    return Type.values()[lt];
                }
                return lo;
            }
            case 10: {
                byte stt;
                NamedBinaryTag[] tags = new NamedBinaryTag[]{};
                do {
                    stt = dis.readByte();
                    String name = null;
                    if (stt != 0) {
                        name = dis.readUTF();
                    }
                    NamedBinaryTag[] newTags = new NamedBinaryTag[tags.length + 1];
                    System.arraycopy(tags, 0, newTags, 0, tags.length);
                    newTags[tags.length] = new NamedBinaryTag(Type.values()[stt], name, NamedBinaryTag.readPayload(dis, stt));
                    tags = newTags;
                } while (stt != 0);
                return tags;
            }
            case 11: {
                int len = dis.readInt();
                int[] ia = new int[len];
                for (int i = 0; i < len; ++i) {
                    ia[i] = dis.readInt();
                }
                return ia;
            }
        }
        return null;
    }

    public void writeTo(OutputStream os) throws IOException {
        GZIPOutputStream gzos = new GZIPOutputStream(os);
        DataOutputStream dos = new DataOutputStream(gzos);
        dos.writeByte(this.type.ordinal());
        if (this.type != Type.TAG_End) {
            dos.writeUTF(this.name);
            this.writePayload(dos);
        }
        gzos.flush();
        gzos.close();
    }

    private void writePayload(DataOutputStream dos) throws IOException {
        switch (this.type) {
            case TAG_End: {
                break;
            }
            case TAG_Byte: {
                dos.writeByte(((Byte)this.value).byteValue());
                break;
            }
            case TAG_Short: {
                dos.writeShort(((Short)this.value).shortValue());
                break;
            }
            case TAG_Int: {
                dos.writeInt((Integer)this.value);
                break;
            }
            case TAG_Long: {
                dos.writeLong((Long)this.value);
                break;
            }
            case TAG_Float: {
                dos.writeFloat(((Float)this.value).floatValue());
                break;
            }
            case TAG_Double: {
                dos.writeDouble((Double)this.value);
                break;
            }
            case TAG_Byte_Array: {
                byte[] ba = (byte[])this.value;
                dos.writeInt(ba.length);
                dos.write(ba);
                break;
            }
            case TAG_String: {
                dos.writeUTF((String)this.value);
                break;
            }
            case TAG_List: {
                NamedBinaryTag[] list = (NamedBinaryTag[])this.value;
                dos.writeByte(this.getListType().ordinal());
                dos.writeInt(list.length);
                for (NamedBinaryTag tt : list) {
                    tt.writePayload(dos);
                }
                break;
            }
            case TAG_Compound: {
                NamedBinaryTag[] subtags;
                for (NamedBinaryTag st : subtags = (NamedBinaryTag[])this.value) {
                    Type type = st.getType();
                    dos.writeByte(type.ordinal());
                    if (type == Type.TAG_End) continue;
                    dos.writeUTF(st.getName());
                    st.writePayload(dos);
                }
                break;
            }
            case TAG_Int_Array: {
                int[] ia = (int[])this.value;
                dos.writeInt(ia.length);
                for (int anIa : ia) {
                    dos.writeInt(anIa);
                }
                break;
            }
        }
    }

    public void print() {
        this.print(this, 0);
    }

    private String getTypeString(Type type) {
        switch (type) {
            case TAG_End: {
                return "TAG_End";
            }
            case TAG_Byte: {
                return "TAG_Byte";
            }
            case TAG_Short: {
                return "TAG_Short";
            }
            case TAG_Int: {
                return "TAG_Int";
            }
            case TAG_Long: {
                return "TAG_Long";
            }
            case TAG_Float: {
                return "TAG_Float";
            }
            case TAG_Double: {
                return "TAG_Double";
            }
            case TAG_Byte_Array: {
                return "TAG_Byte_Array";
            }
            case TAG_String: {
                return "TAG_String";
            }
            case TAG_List: {
                return "TAG_List";
            }
            case TAG_Compound: {
                return "TAG_Compound";
            }
            case TAG_Int_Array: {
                return "TAG_Int_Array";
            }
        }
        return null;
    }

    private void indent(int indent) {
        for (int i = 0; i < indent; ++i) {
            System.out.print("   ");
        }
    }

    private void print(NamedBinaryTag t, int indent) {
        Type type = t.getType();
        if (type == Type.TAG_End) {
            return;
        }
        String name = t.getName();
        this.indent(indent);
        System.out.print(this.getTypeString(t.getType()));
        if (name != null) {
            System.out.print("(\"" + t.getName() + "\")");
        }
        if (type == Type.TAG_Byte_Array) {
            byte[] b = (byte[])t.getValue();
            System.out.println(": [" + b.length + " bytes]");
        } else if (type == Type.TAG_List) {
            NamedBinaryTag[] subtags = (NamedBinaryTag[])t.getValue();
            System.out.println(": " + subtags.length + " entries of type " + this.getTypeString(t.getListType()));
            for (NamedBinaryTag st : subtags) {
                this.print(st, indent + 1);
            }
            this.indent(indent);
            System.out.println("}");
        } else if (type == Type.TAG_Compound) {
            NamedBinaryTag[] subtags = (NamedBinaryTag[])t.getValue();
            System.out.println(": " + (subtags.length - 1) + " entries");
            this.indent(indent);
            System.out.println("{");
            for (NamedBinaryTag st : subtags) {
                this.print(st, indent + 1);
            }
            this.indent(indent);
            System.out.println("}");
        } else if (type == Type.TAG_Int_Array) {
            int[] i = (int[])t.getValue();
            System.out.println(": [" + i.length * 4 + " bytes]");
        } else {
            System.out.println(": " + t.getValue());
        }
    }

    public static enum Type {
        TAG_End,
        TAG_Byte,
        TAG_Short,
        TAG_Int,
        TAG_Long,
        TAG_Float,
        TAG_Double,
        TAG_Byte_Array,
        TAG_String,
        TAG_List,
        TAG_Compound,
        TAG_Int_Array;

    }
}

