/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.bukkit;

import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.util.helpers.BlockHelper;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import net.minecraft.server.v1_12_R1.Block;
import net.minecraft.server.v1_12_R1.BlockFalling;
import net.minecraft.server.v1_12_R1.IBlockData;
import net.minecraft.server.v1_12_R1.MinecraftKey;

public final class BukkitMaterialData
implements LocalMaterialData {
    private final int combinedBlockId;

    public static BukkitMaterialData ofIds(int id, int data) {
        return new BukkitMaterialData(id, data);
    }

    static BukkitMaterialData ofDefaultMaterial(DefaultMaterial material, int data) {
        return BukkitMaterialData.ofIds(material.id, data);
    }

    static BukkitMaterialData ofMinecraftBlock(Block block) {
        return BukkitMaterialData.ofIds(Block.getId((Block)block), block.toLegacyData(block.getBlockData()));
    }

    static BukkitMaterialData ofMinecraftBlockData(IBlockData blockData) {
        Block block = blockData.getBlock();
        return new BukkitMaterialData(Block.getId((Block)block), block.toLegacyData(blockData));
    }

    private BukkitMaterialData(int blockId, int blockData) {
        this.combinedBlockId = blockId << 4 | blockData;
    }

    @Override
    public boolean canSnowFallOn() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return defaultMaterial.canSnowFallOn();
        }
        return this.internalBlock().getMaterial().isSolid();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BukkitMaterialData)) {
            return false;
        }
        BukkitMaterialData other = (BukkitMaterialData)obj;
        return this.combinedBlockId == other.combinedBlockId;
    }

    @Override
    public byte getBlockData() {
        return (byte)(this.combinedBlockId & 0xF);
    }

    @Override
    public int getBlockId() {
        return this.combinedBlockId >> 4;
    }

    @Override
    public String getName() {
        boolean nonDefaultData;
        Block block = Block.getById((int)this.getBlockId());
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        byte data = this.getBlockData();
        boolean bl = nonDefaultData = block.toLegacyData(block.getBlockData()) != data;
        if (defaultMaterial == DefaultMaterial.UNKNOWN_BLOCK) {
            if (nonDefaultData) {
                return Block.REGISTRY.b((Object)block) + ":" + data;
            }
            return ((MinecraftKey)Block.REGISTRY.b((Object)block)).toString();
        }
        if (nonDefaultData) {
            return defaultMaterial.name() + ":" + this.getBlockData();
        }
        return defaultMaterial.name();
    }

    @Override
    public int hashCode() {
        return 65535 + this.combinedBlockId;
    }

    @Override
    public int hashCodeWithoutBlockData() {
        return this.getBlockId();
    }

    @Override
    public boolean isLiquid() {
        return this.internalBlock().getMaterial().isLiquid();
    }

    @Override
    public boolean isMaterial(DefaultMaterial material) {
        return material.id == this.getBlockId();
    }

    @Override
    public boolean isSolid() {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            return defaultMaterial.isSolid();
        }
        return this.internalBlock().getMaterial().isSolid();
    }

    @Override
    public DefaultMaterial toDefaultMaterial() {
        return DefaultMaterial.getMaterial(this.getBlockId());
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public LocalMaterialData withBlockData(int i) {
        if (i == this.getBlockData()) {
            return this;
        }
        Block block = Block.getById((int)this.getBlockId());
        return BukkitMaterialData.ofMinecraftBlockData(block.fromLegacyData(i));
    }

    @Override
    public LocalMaterialData withDefaultBlockData() {
        Block block = Block.getById((int)this.getBlockId());
        byte defaultData = (byte)block.toLegacyData(block.getBlockData());
        return this.withBlockData(defaultData);
    }

    IBlockData internalBlock() {
        return Block.getById((int)this.getBlockId()).fromLegacyData((int)this.getBlockData());
    }

    @Override
    public LocalMaterialData rotate() {
        byte blockDataByte;
        int newData;
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK && (newData = BlockHelper.rotateData(defaultMaterial, blockDataByte = this.getBlockData())) != blockDataByte) {
            return BukkitMaterialData.ofDefaultMaterial(defaultMaterial, newData);
        }
        return this;
    }

    @Override
    public LocalMaterialData rotate(int rotateTimes) {
        DefaultMaterial defaultMaterial = this.toDefaultMaterial();
        if (defaultMaterial != DefaultMaterial.UNKNOWN_BLOCK) {
            int blockDataByte = 0;
            int newData = 0;
            for (int i = 0; i < rotateTimes; ++i) {
                blockDataByte = this.getBlockData();
                newData = BlockHelper.rotateData(defaultMaterial, blockDataByte);
            }
            if (newData != blockDataByte) {
                return BukkitMaterialData.ofDefaultMaterial(defaultMaterial, newData);
            }
        }
        return this;
    }

    @Override
    public boolean isAir() {
        return this.combinedBlockId == 0;
    }

    @Override
    public boolean canFall() {
        return Block.getById((int)this.getBlockId()) instanceof BlockFalling;
    }

    @Override
    public boolean isSmoothAreaAnchor(boolean allowWood, boolean ignoreWater) {
        return false;
    }
}

