/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo3.checks;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3Config;
import com.pg85.otg.customobjects.bo3.checks.BO3Check;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.util.materials.MaterialSet;
import java.util.List;

public class BlockCheck
extends BO3Check {
    MaterialSet toCheck;

    @Override
    public boolean preventsSpawn(LocalWorld world, int x, int y, int z) {
        return y > 0 && y < 256 && !this.toCheck.contains(world.getMaterial(x, y, z, false));
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(4, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -100, 100);
        this.z = this.readInt(args.get(2), -100, 100);
        this.toCheck = this.readMaterials(args, 3);
    }

    @Override
    public String makeString() {
        return this.makeString("BlockCheck");
    }

    protected String makeString(String name) {
        return name + '(' + this.x + ',' + this.y + ',' + this.z + this.makeMaterials(this.toCheck) + ')';
    }

    @Override
    public BO3Check rotate() {
        BlockCheck rotatedCheck = new BlockCheck();
        rotatedCheck.x = this.z;
        rotatedCheck.y = this.y;
        rotatedCheck.z = -this.x;
        rotatedCheck.toCheck = this.toCheck.rotate();
        return rotatedCheck;
    }

    @Override
    public Class<BO3Config> getHolderType() {
        return BO3Config.class;
    }
}

