/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bo4.bo4function;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.customobjects.bo4.bo4function.BO4BranchNode;
import com.pg85.otg.customobjects.bofunctions.BranchFunction;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.bo3.Rotation;
import com.pg85.otg.util.helpers.StreamHelper;
import com.pg85.otg.util.helpers.StringHelper;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public class BO4BranchFunction
extends BranchFunction<BO4Config> {
    ArrayList<BO4BranchNode> branchesOTGPlus;
    String branchGroup = "";
    boolean isRequiredBranch = false;

    public BO4BranchFunction() {
    }

    public BO4BranchFunction(BO4Config holder) {
        this.holder = holder;
    }

    public BO4BranchFunction rotate(Rotation rotation) {
        BO4BranchFunction rotatedBranch = new BO4BranchFunction((BO4Config)this.getHolder());
        rotatedBranch.x = this.x;
        rotatedBranch.y = this.y;
        rotatedBranch.z = this.z;
        rotatedBranch.totalChance = this.totalChance;
        rotatedBranch.totalChanceSet = this.totalChanceSet;
        rotatedBranch.branchGroup = this.branchGroup;
        rotatedBranch.isRequiredBranch = this.isRequiredBranch;
        rotatedBranch.branchesOTGPlus = this.branchesOTGPlus;
        rotatedBranch.holder = this.holder;
        rotatedBranch.valid = this.valid;
        rotatedBranch.inputName = this.inputName;
        rotatedBranch.inputArgs = this.inputArgs;
        rotatedBranch.error = this.error;
        int newX = rotatedBranch.x;
        int newZ = rotatedBranch.z;
        for (int i = 0; i < rotation.getRotationId(); ++i) {
            newX = rotatedBranch.z;
            newZ = -rotatedBranch.x;
            rotatedBranch.x = newX;
            rotatedBranch.y = rotatedBranch.y;
            rotatedBranch.z = newZ;
            ArrayList<BO4BranchNode> rotatedBranchBranches = new ArrayList<BO4BranchNode>();
            for (BO4BranchNode holder : rotatedBranch.branchesOTGPlus) {
                rotatedBranchBranches.add(new BO4BranchNode(holder.branchDepth, holder.isRequiredBranch, holder.isWeightedBranch, holder.getRotation().next(), holder.getChance(), holder.getCustomObject(false, null), holder.customObjectName, holder.branchGroup));
            }
            rotatedBranch.branchesOTGPlus = rotatedBranchBranches;
        }
        return rotatedBranch;
    }

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.branchesOTGPlus = new ArrayList();
        this.readArgs(args, false);
    }

    @Override
    protected double readArgs(List<String> args, boolean accumulateChances) throws InvalidConfigException {
        String totalChanceOrBranchGroup;
        int i;
        double cumulativeChance = 0.0;
        this.assureSize(8, args);
        this.x = this.readInt(args.get(0), -32, 32);
        this.y = this.readInt(args.get(1), -255, 255);
        this.z = this.readInt(args.get(2), -32, 32);
        this.isRequiredBranch = this.readBoolean(args.get(3));
        for (i = 4; i < args.size() - 3; i += 4) {
            double branchChance = this.readDouble(args.get(i + 2), 0.0, Double.MAX_VALUE);
            if (this.isRequiredBranch && args.size() > 9) {
                if (OTG.getPluginConfig().spawnLog) {
                    String branchString = "";
                    for (String arg : args) {
                        branchString = branchString + ", " + arg;
                    }
                    OTG.log(LogMarker.WARN, "isRequired:true branches cannot have multiple BO3's with a rarity, only one BO3 per isRequired:true branch is allowed and the branch automatically has a 100% chance to spawn. Using only the first BO3 for branch: Branch(" + branchString.substring(0, branchString.length() - 1) + ")", new Object[0]);
                }
                this.branchesOTGPlus.add(new BO4BranchNode(this.readInt(args.get(i + 3), -32, 32), this.isRequiredBranch, false, Rotation.getRotation(args.get(i + 1)), 100.0, null, args.get(i), null));
                break;
            }
            this.branchesOTGPlus.add(new BO4BranchNode(this.readInt(args.get(i + 3), -32, 32), this.isRequiredBranch, false, Rotation.getRotation(args.get(i + 1)), branchChance, null, args.get(i), null));
        }
        if (!this.isRequiredBranch && i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
            try {
                Double.parseDouble(totalChanceOrBranchGroup);
                this.totalChanceSet = true;
                this.totalChance = this.readDouble(args.get(i), 0.0, Double.MAX_VALUE);
                ++i;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (i < args.size() && (totalChanceOrBranchGroup = args.get(i)) != null && totalChanceOrBranchGroup.length() > 0) {
            this.branchGroup = args.get(i);
            for (BO4BranchNode branch : this.branchesOTGPlus) {
                branch.branchGroup = this.branchGroup;
            }
        }
        return cumulativeChance;
    }

    @Override
    public String makeString() {
        StringBuilder output = new StringBuilder(this.getConfigName()).append('(').append(this.x).append(',').append(this.y).append(',').append(this.z).append(',');
        output.append(this.isRequiredBranch);
        Iterator<BO4BranchNode> it = this.branchesOTGPlus.iterator();
        while (it.hasNext()) {
            output.append(it.next().toBranchString());
        }
        if (this.totalChanceSet) {
            output.append(',').append(this.totalChance);
        }
        if (this.branchGroup != null) {
            output.append(',').append(this.branchGroup);
        }
        return output.append(')').toString();
    }

    @Override
    public CustomStructureCoordinate toCustomObjectCoordinate(LocalWorld world, Random random, Rotation rotation, int x, int y, int z, String startBO3Name) {
        for (BO4BranchNode branch : this.branchesOTGPlus) {
            double randomChance = random.nextDouble() * this.totalChance;
            if (!(randomChance <= branch.getChance())) continue;
            BO4CustomStructureCoordinate rotatedCoords = BO4CustomStructureCoordinate.getRotatedCoord(this.x, this.y, this.z, rotation);
            Rotation newRotation = Rotation.getRotation((rotation.getRotationId() + branch.getRotation().getRotationId()) % 4);
            return new BO4CustomStructureCoordinate(world, branch.getCustomObject(false, world), branch.customObjectName, newRotation, x + rotatedCoords.getX(), (short)(y + rotatedCoords.getY()), z + rotatedCoords.getZ(), branch.branchDepth, branch.isRequiredBranch, branch.isWeightedBranch, branch.branchGroup);
        }
        return null;
    }

    @Override
    public Class<BO4Config> getHolderType() {
        return BO4Config.class;
    }

    public void writeToStream(DataOutput stream) throws IOException {
        StreamHelper.writeStringToStream(stream, this.makeString());
    }

    public static BO4BranchFunction fromStream(BO4Config holder, ByteBuffer buffer) throws IOException {
        BO4BranchFunction branchFunction = new BO4BranchFunction(holder);
        String configFunctionString = StreamHelper.readStringFromBuffer(buffer);
        int bracketIndex = configFunctionString.indexOf(40);
        String parameters = configFunctionString.substring(bracketIndex + 1, configFunctionString.length() - 1);
        List<String> args = Arrays.asList(StringHelper.readCommaSeperatedString(parameters));
        try {
            branchFunction.load(args);
        }
        catch (InvalidConfigException e) {
            e.printStackTrace();
        }
        return branchFunction;
    }
}

