/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.bofunctions;

import com.pg85.otg.OTG;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFile;
import com.pg85.otg.configuration.customobjects.CustomObjectConfigFunction;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.logging.LogMarker;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.List;

public abstract class SpawnerFunction<T extends CustomObjectConfigFile>
extends CustomObjectConfigFunction<T> {
    public int x;
    public int y;
    public int z;
    public Boolean firstSpawn = true;
    public String mobName = "";
    public String nbtFileName = "";
    public String originalnbtFileName = "";
    public int groupSize = 1;
    public int interval = 40;
    public int intervalOffset = 0;
    public int spawnChance = 100;
    public int maxCount = 0;
    public int despawnTime = 0;
    public double velocityX = 0.0;
    public double velocityY = 0.0;
    public double velocityZ = 0.0;
    public float yaw = 0.0f;
    public float pitch = 0.0f;
    public boolean velocityXSet = false;
    public boolean velocityYSet = false;
    public boolean velocityZSet = false;
    protected String metaDataTag;
    protected boolean metaDataProcessed = false;

    @Override
    public void load(List<String> args) throws InvalidConfigException {
        this.assureSize(8, args);
        this.x = this.readInt(args.get(0), -100, 100);
        this.y = this.readInt(args.get(1), -1000, 1000);
        this.z = this.readInt(args.get(2), -100, 100);
        this.mobName = args.get(3);
        boolean param4isNBT = false;
        try {
            this.groupSize = (int)Double.parseDouble(args.get(4));
        }
        catch (NumberFormatException ex) {
            this.originalnbtFileName = args.get(4);
            param4isNBT = true;
        }
        if (this.originalnbtFileName != null && this.originalnbtFileName.toLowerCase().trim().endsWith(".txt")) {
            this.nbtFileName = ((CustomObjectConfigFile)this.getHolder()).getFile().getParentFile().getAbsolutePath() + File.separator + this.originalnbtFileName;
        }
        if (param4isNBT) {
            this.groupSize = this.readInt(args.get(5), 0, Integer.MAX_VALUE);
        }
        this.interval = !param4isNBT ? this.readInt(args.get(5), 0, Integer.MAX_VALUE) : this.readInt(args.get(6), 0, Integer.MAX_VALUE);
        this.spawnChance = !param4isNBT ? this.readInt(args.get(6), 0, Integer.MAX_VALUE) : this.readInt(args.get(7), 0, Integer.MAX_VALUE);
        this.maxCount = !param4isNBT ? this.readInt(args.get(7), 0, Integer.MAX_VALUE) : this.readInt(args.get(8), 0, Integer.MAX_VALUE);
        if (!param4isNBT) {
            if (args.size() > 8) {
                this.despawnTime = this.readInt(args.get(8), 0, Integer.MAX_VALUE);
            }
        } else if (args.size() > 9) {
            this.despawnTime = this.readInt(args.get(9), 0, Integer.MAX_VALUE);
        }
        if (!param4isNBT) {
            if (args.size() > 9) {
                this.velocityX = this.readDouble(args.get(9), -2.147483648E9, 2.147483647E9);
                this.velocityXSet = true;
            }
        } else if (args.size() > 10) {
            this.velocityX = this.readDouble(args.get(10), -2.147483648E9, 2.147483647E9);
            this.velocityXSet = true;
        }
        if (!param4isNBT) {
            if (args.size() > 10) {
                this.velocityY = this.readDouble(args.get(10), -2.147483648E9, 2.147483647E9);
                this.velocityYSet = true;
            }
        } else if (args.size() > 11) {
            this.velocityY = this.readDouble(args.get(11), -2.147483648E9, 2.147483647E9);
            this.velocityYSet = true;
        }
        if (!param4isNBT) {
            if (args.size() > 11) {
                this.velocityZ = this.readDouble(args.get(11), -2.147483648E9, 2.147483647E9);
                this.velocityZSet = true;
            }
        } else if (args.size() > 12) {
            this.velocityZ = this.readDouble(args.get(12), -2.147483648E9, 2.147483647E9);
            this.velocityZSet = true;
        }
        if (!param4isNBT) {
            if (args.size() > 12) {
                this.yaw = (float)this.readDouble(args.get(12), 0.0, 2.147483647E9);
            }
        } else if (args.size() > 13) {
            this.yaw = (float)this.readDouble(args.get(13), 0.0, 2.147483647E9);
        }
        if (!param4isNBT) {
            if (args.size() > 13) {
                this.pitch = (float)this.readDouble(args.get(13), 0.0, 2.147483647E9);
            }
        } else if (args.size() > 14) {
            this.pitch = (float)this.readDouble(args.get(14), 0.0, 2.147483647E9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMetaData() {
        if (this.nbtFileName != null && this.nbtFileName.length() > 0 && this.metaDataTag == null && !this.metaDataProcessed) {
            this.metaDataProcessed = true;
            File metaDataFile = new File(this.nbtFileName);
            StringBuilder stringbuilder = new StringBuilder();
            if (metaDataFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(metaDataFile));){
                    String line = reader.readLine();
                    while (line != null) {
                        stringbuilder.append(line);
                        line = reader.readLine();
                    }
                }
                catch (FileNotFoundException e1) {
                    e1.printStackTrace();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            } else if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.WARN, "Could not find file \"" + this.nbtFileName + "\" for Spawner: " + this.makeString(), new Object[0]);
            }
            this.metaDataTag = stringbuilder.length() > 0 ? stringbuilder.toString() : null;
        }
        this.metaDataProcessed = true;
        return this.metaDataTag;
    }

    @Override
    public String makeString() {
        return "Spawner(" + this.x + ',' + this.y + ',' + this.z + ',' + this.mobName + (this.originalnbtFileName != null && this.originalnbtFileName.length() > 0 ? "," + this.originalnbtFileName : "") + ',' + this.groupSize + ',' + this.interval + ',' + this.spawnChance + ',' + this.maxCount + ',' + this.despawnTime + ',' + this.velocityX + ',' + this.velocityY + ',' + this.velocityZ + ',' + this.yaw + ',' + this.pitch + ')';
    }

    @Override
    public boolean isAnalogousTo(CustomObjectConfigFunction<T> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        SpawnerFunction block = (SpawnerFunction)other;
        return block.x == this.x && block.y == this.y && block.z == this.z && block.mobName.equalsIgnoreCase(this.mobName) && block.originalnbtFileName.equalsIgnoreCase(this.originalnbtFileName) && block.groupSize == this.groupSize && block.interval == this.interval && block.spawnChance == this.spawnChance && block.maxCount == this.maxCount && block.despawnTime == this.despawnTime && block.velocityX == this.velocityX && block.velocityY == this.velocityY && block.velocityZ == this.velocityZ && block.yaw == this.yaw && block.pitch == this.pitch;
    }

    public abstract SpawnerFunction<T> getNewInstance();
}

