/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo3;

import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.bo3.BO3;
import com.pg85.otg.customobjects.bo3.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.BoundingBox;
import com.pg85.otg.util.bo3.Rotation;
import java.util.Random;

public class BO3CustomStructureCoordinate
extends CustomStructureCoordinate {
    public BO3CustomStructureCoordinate(LocalWorld world, StructuredCustomObject object, String customObjectName, Rotation rotation, int x, short y, int z) {
        this.worldName = world.getName();
        this.object = object;
        this.bo3Name = object != null ? object.getName() : (customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        this.rotation = rotation;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    @Override
    public boolean spawnWithChecks(CustomStructure structure, LocalWorld world, StructurePartSpawnHeight height, Random random) {
        return ((BO3)this.object).trySpawnAt(false, structure, world, random, this.rotation, this.x, height.getCorrectY(world, this.x, this.y, this.z), this.z, ((BO3)this.object).getSettings().minHeight, ((BO3)this.object).getSettings().maxHeight);
    }

    public ChunkCoordinate getPopulatingChunk() {
        StructuredCustomObject object = this.getObject();
        if (object == null) {
            return null;
        }
        BoundingBox box = object.getBoundingBox(this.rotation);
        int centerX = this.x + box.getMinX() + box.getWidth() / 2;
        int centerZ = this.z + box.getMinZ() + box.getDepth() / 2;
        return ChunkCoordinate.getPopulatingChunk(centerX, centerZ);
    }
}

