/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.customobjects.bo3.BO3Settings;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.bo4.BO4Config;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.customobjects.structures.bo4.BO4CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.bo4.BranchDataItem;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaGenerator;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaLine;
import com.pg85.otg.customobjects.structures.bo4.SmoothingAreaLineDiagonal;
import com.pg85.otg.exception.InvalidConfigException;
import com.pg85.otg.generator.resource.CustomStructureGen;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.helpers.RandomHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Stack;

public class BO4CustomStructure
extends CustomStructure {
    private Random worldRandom;
    private SmoothingAreaGenerator smoothingAreaManager = new SmoothingAreaGenerator();
    public Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn = new HashMap<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>>();
    public Map<ChunkCoordinate, String> ObjectsToSpawnInfo = new HashMap<ChunkCoordinate, String>();
    boolean IsSpawned;
    private boolean isStructureAtSpawn = false;
    private int minY;
    public Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
    private int branchesTried = 0;
    public boolean startChunkBlockChecksDone = false;
    private Stack<BranchDataItem> AllBranchesBranchData = new Stack();
    private HashMap<ChunkCoordinate, ArrayList<BranchDataItem>> AllBranchesBranchDataByChunk = new HashMap();
    private HashMap<String, ArrayList<ChunkCoordinate>> AllBranchesBranchDataByName = new HashMap();
    private HashMap<String, HashMap<ChunkCoordinate, ArrayList<Integer>>> AllBranchesBranchDataByGroup = new HashMap();
    private HashSet<Integer> AllBranchesBranchDataHash = new HashSet();
    private boolean SpawningCanOverrideBranches = false;
    private int Cycle = 0;
    private BranchDataItem currentSpawningRequiredChildrenForOptionalBranch;
    private boolean spawningRequiredChildrenForOptionalBranch = false;
    private boolean spawnedBranchThisCycle = false;
    private boolean spawnedBranchLastCycle = false;

    public BO4CustomStructure(BO4CustomStructureCoordinate start) {
        this.start = start;
    }

    public BO4CustomStructure(LocalWorld world, BO4CustomStructureCoordinate structureStart, Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectsToSpawn, Map<ChunkCoordinate, ArrayList<SmoothingAreaLine>> smoothingAreasToSpawn, int minY) {
        this(world, structureStart, false, false);
        this.objectsToSpawn = objectsToSpawn;
        this.smoothingAreasToSpawn = smoothingAreasToSpawn;
        this.minY = minY;
    }

    BO4CustomStructure(LocalWorld world, BO4CustomStructureCoordinate start, boolean spawn, boolean isStructureAtSpawn) {
        this.isStructureAtSpawn = isStructureAtSpawn;
        if (start == null) {
            return;
        }
        if (!(start.getObject() instanceof StructuredCustomObject)) {
            throw new IllegalArgumentException("Start object must be a structure!");
        }
        this.start = start;
        this.random = RandomHelper.getRandomForCoords(start.getX() + 8, start.getY(), start.getZ() + 7, world.getSeed());
        if (spawn) {
            CustomStructure existingObject;
            this.branchesTried = 0;
            long startTime = System.currentTimeMillis();
            if (!this.doStartChunkBlockChecks(world)) {
                return;
            }
            if (!((BO4)this.start.getObject()).getSettings().canSpawnOnWater) {
                int highestBlocky = world.getHighestBlockYAt(this.start.getX() + 8, this.start.getZ() + 7, true, true, false, true);
                if (this.start.y - 1 > 0 && this.start.y - 1 < 256 && world.getMaterial(this.start.getX() + 8, highestBlocky, this.start.getZ() + 7, true).isLiquid()) {
                    return;
                }
            }
            if (!(!((BO4)this.start.getObject()).getSettings().spawnOnWaterOnly || world.getMaterial(this.start.getX(), this.start.y - 1, this.start.getZ(), true).isLiquid() && world.getMaterial(this.start.getX(), this.start.y - 1, this.start.getZ() + 15, true).isLiquid() && world.getMaterial(this.start.getX() + 15, this.start.y - 1, this.start.getZ(), true).isLiquid() && world.getMaterial(this.start.getX() + 15, this.start.y - 1, this.start.getZ() + 15, true).isLiquid())) {
                return;
            }
            try {
                this.calculateBranches(false, world);
            }
            catch (InvalidConfigException ex) {
                OTG.log(LogMarker.FATAL, "An unknown error occurred while calculating branches for BO3 " + this.start.bo3Name + ". This is probably an error in the BO3's branch configuration, not a bug. If you can track this down, please tell me what caused it!", new Object[0]);
                throw new RuntimeException();
            }
            for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> chunkCoordSet : this.objectsToSpawn.entrySet()) {
                Object structureInfo = "";
                for (CustomStructureCoordinate customStructureCoordinate : chunkCoordSet.getValue()) {
                    structureInfo = (String)structureInfo + customStructureCoordinate.getObject().getName() + ":" + (Object)((Object)customStructureCoordinate.getRotation()) + ", ";
                }
                if (((String)structureInfo).length() <= 0) continue;
                structureInfo = ((String)structureInfo).substring(0, ((String)structureInfo).length() - 2);
                this.ObjectsToSpawnInfo.put(chunkCoordSet.getKey(), "Branches in chunk X" + chunkCoordSet.getKey().getChunkX() + " Z" + chunkCoordSet.getKey().getChunkZ() + " : " + (String)structureInfo);
            }
            for (Map.Entry<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> chunkCoordSet : this.objectsToSpawn.entrySet()) {
                for (CustomStructureCoordinate customStructureCoordinate : chunkCoordSet.getValue()) {
                    BO4Config bO4Config = ((BO4)customStructureCoordinate.getObject()).getSettings();
                    if (bO4Config.replacesBO3Branches.size() <= 0) continue;
                    for (String BO3ToReplace : bO4Config.replacesBO3Branches) {
                        for (BO4CustomStructureCoordinate coordObjectToReplace : chunkCoordSet.getValue()) {
                            if (!((BO4)coordObjectToReplace.getObject()).getName().equals(BO3ToReplace) || !this.checkCollision(customStructureCoordinate, coordObjectToReplace)) continue;
                            coordObjectToReplace.isSpawned = true;
                        }
                    }
                }
            }
            this.smoothingAreasToSpawn = this.smoothingAreaManager.calculateSmoothingAreas(this.objectsToSpawn, (BO4CustomStructureCoordinate)this.start, world);
            this.smoothingAreaManager.customObjectStructureSpawn(this.smoothingAreasToSpawn);
            for (ChunkCoordinate chunkCoord : this.objectsToSpawn.keySet()) {
                world.getStructureCache().bo4StructureCache.put(chunkCoord, this);
                world.getStructureCache().getPlotter().addToStructuresPerChunkCache(chunkCoord, new ArrayList<String>());
                if (world.getStructureCache().worldInfoChunks.containsKey(chunkCoord)) {
                    existingObject = world.getStructureCache().worldInfoChunks.get(chunkCoord);
                    this.modDataManager.modData.addAll(existingObject.modDataManager.modData);
                    this.particlesManager.particleData.addAll(existingObject.particlesManager.particleData);
                    this.spawnerManager.spawnerData.addAll(existingObject.spawnerManager.spawnerData);
                }
                world.getStructureCache().worldInfoChunks.put(chunkCoord, this);
            }
            for (ChunkCoordinate chunkCoord : this.smoothingAreasToSpawn.keySet()) {
                world.getStructureCache().bo4StructureCache.put(chunkCoord, this);
                world.getStructureCache().getPlotter().addToStructuresPerChunkCache(chunkCoord, new ArrayList<String>());
                if (world.getStructureCache().worldInfoChunks.containsKey(chunkCoord)) {
                    existingObject = world.getStructureCache().worldInfoChunks.get(chunkCoord);
                    this.modDataManager.modData.addAll(existingObject.modDataManager.modData);
                    this.particlesManager.particleData.addAll(existingObject.particlesManager.particleData);
                    this.spawnerManager.spawnerData.addAll(existingObject.spawnerManager.spawnerData);
                }
                world.getStructureCache().worldInfoChunks.put(chunkCoord, this);
            }
            if (this.objectsToSpawn.size() > 0) {
                this.IsSpawned = true;
                if (OTG.getPluginConfig().spawnLog) {
                    int totalBO3sSpawned = 0;
                    for (ChunkCoordinate entry : this.objectsToSpawn.keySet()) {
                        totalBO3sSpawned += this.objectsToSpawn.get(entry).size();
                    }
                    OTG.log(LogMarker.INFO, this.start.getObject().getName() + " " + totalBO3sSpawned + " object(s) plotted in " + (System.currentTimeMillis() - startTime) + " Ms and " + this.Cycle + " cycle(s), " + (this.branchesTried + 1) + " object(s) tried.", new Object[0]);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean doStartChunkBlockChecks(LocalWorld world) {
        if (this.startChunkBlockChecksDone) return true;
        this.startChunkBlockChecksDone = true;
        short startY = 0;
        if (((BO4)this.start.getObject()).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestBlock || ((BO4)this.start.getObject()).getSettings().spawnHeight == BO3Settings.SpawnHeightEnum.highestSolidBlock) {
            if (((BO4)this.start.getObject()).getSettings().spawnAtWaterLevel) {
                LocalBiome biome = world.getBiome(this.start.getX() + 8, this.start.getZ() + 7);
                startY = (short)(biome.getBiomeConfig().useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biome.getBiomeConfig().waterLevelMax);
            } else {
                int highestBlock = 0;
                highestBlock = !((BO4)this.start.getObject()).getSettings().spawnUnderWater ? world.getHighestBlockYAt(this.start.getX() + 8, this.start.getZ() + 7, true, true, false, true) : world.getHighestBlockYAt(this.start.getX() + 8, this.start.getZ() + 7, true, false, true, true);
                if (highestBlock < 1) {
                    if (((BO4)this.start.getObject()).getSettings().heightOffset <= 0) return false;
                    highestBlock = ((BO4)this.start.getObject()).getSettings().heightOffset;
                } else {
                    startY = (short)(highestBlock + 1);
                }
            }
        } else {
            startY = ((BO4)this.start.getObject()).getSettings().maxHeight != ((BO4)this.start.getObject()).getSettings().minHeight ? (short)(((BO4)this.start.getObject()).getSettings().minHeight + new Random().nextInt(((BO4)this.start.getObject()).getSettings().maxHeight - ((BO4)this.start.getObject()).getSettings().minHeight)) : (short)((BO4)this.start.getObject()).getSettings().minHeight;
        }
        if (startY < ((BO4)this.start.getObject()).getSettings().minHeight || startY > ((BO4)this.start.getObject()).getSettings().maxHeight) {
            return false;
        }
        if ((startY = (short)(startY + ((BO4)this.start.getObject()).getSettings().heightOffset)) < 0 || startY >= 256) {
            return false;
        }
        for (ChunkCoordinate chunkCoord : this.objectsToSpawn.keySet()) {
            for (CustomStructureCoordinate customStructureCoordinate : this.objectsToSpawn.get(chunkCoord)) {
                customStructureCoordinate.y = (short)(customStructureCoordinate.y + startY);
            }
        }
        HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>> SmoothingAreasToSpawn2 = new HashMap<ChunkCoordinate, ArrayList<SmoothingAreaLine>>();
        SmoothingAreasToSpawn2.putAll(this.smoothingAreasToSpawn);
        this.smoothingAreasToSpawn.clear();
        for (ChunkCoordinate chunkCoord2 : SmoothingAreasToSpawn2.keySet()) {
            ArrayList<SmoothingAreaLine> arrayList = new ArrayList<SmoothingAreaLine>();
            for (SmoothingAreaLine coord : (ArrayList)SmoothingAreasToSpawn2.get(chunkCoord2)) {
                SmoothingAreaLine coordToAdd;
                if (coord instanceof SmoothingAreaLineDiagonal) {
                    coordToAdd = new SmoothingAreaLineDiagonal(coord.beginPointX, (short)(coord.beginPointY + this.start.getY()), coord.beginPointZ, coord.endPointX, (short)(coord.endPointY + this.start.getY()), coord.endPointZ, coord.originPointX, -1, coord.originPointZ, coord.finalDestinationPointX, -1, coord.finalDestinationPointZ, ((SmoothingAreaLineDiagonal)coord).diagonalLineOriginPointX, (short)(((SmoothingAreaLineDiagonal)coord).diagonalLineoriginPointY + this.start.getY()), ((SmoothingAreaLineDiagonal)coord).diagonalLineOriginPointZ, ((SmoothingAreaLineDiagonal)coord).diagonalLineFinalDestinationPointX, -1, ((SmoothingAreaLineDiagonal)coord).diagonalLineFinalDestinationPointZ);
                    arrayList.add(coordToAdd);
                    continue;
                }
                coordToAdd = new SmoothingAreaLine(coord.beginPointX, (short)(coord.beginPointY + this.start.getY()), coord.beginPointZ, coord.endPointX, (short)(coord.endPointY + this.start.getY()), coord.endPointZ, coord.originPointX, (short)(coord.originPointY + this.start.getY()), coord.originPointZ, coord.finalDestinationPointX, -1, coord.finalDestinationPointZ);
                arrayList.add(coordToAdd);
            }
            this.smoothingAreasToSpawn.put(ChunkCoordinate.fromChunkCoords(chunkCoord2.getChunkX(), chunkCoord2.getChunkZ()), arrayList);
        }
        this.start.y = startY;
        return true;
    }

    Object[] getMinimumSize(LocalWorld world) throws InvalidConfigException {
        ChunkCoordinate startChunk;
        if (((BO4)this.start.getObject()).getSettings().minimumSizeTop != -1 && ((BO4)this.start.getObject()).getSettings().minimumSizeBottom != -1 && ((BO4)this.start.getObject()).getSettings().minimumSizeLeft != -1 && ((BO4)this.start.getObject()).getSettings().minimumSizeRight != -1) {
            Object[] returnValue = new Object[]{((BO4)this.start.getObject()).getSettings().minimumSizeTop, ((BO4)this.start.getObject()).getSettings().minimumSizeRight, ((BO4)this.start.getObject()).getSettings().minimumSizeBottom, ((BO4)this.start.getObject()).getSettings().minimumSizeLeft};
            return returnValue;
        }
        this.calculateBranches(true, world);
        ChunkCoordinate top = startChunk = ChunkCoordinate.fromBlockCoords(this.start.getX(), this.start.getZ());
        ChunkCoordinate left = startChunk;
        ChunkCoordinate bottom = startChunk;
        ChunkCoordinate right = startChunk;
        for (ChunkCoordinate chunkCoord : this.objectsToSpawn.keySet()) {
            if (chunkCoord.getChunkX() > right.getChunkX()) {
                right = chunkCoord;
            }
            if (chunkCoord.getChunkZ() > bottom.getChunkZ()) {
                bottom = chunkCoord;
            }
            if (chunkCoord.getChunkX() < left.getChunkX()) {
                left = chunkCoord;
            }
            if (chunkCoord.getChunkZ() < top.getChunkZ()) {
                top = chunkCoord;
            }
            for (CustomStructureCoordinate customStructureCoordinate : this.objectsToSpawn.get(chunkCoord)) {
                if (customStructureCoordinate.getY() >= this.minY) continue;
                this.minY = customStructureCoordinate.getY();
            }
        }
        this.minY += ((BO4)this.start.getObject()).getSettings().heightOffset;
        int smoothingRadiusInChunks = (int)Math.ceil((double)((BO4)this.start.getObject()).getSettings().smoothRadius / 16.0);
        ((BO4)this.start.getObject()).getSettings().minimumSizeTop = Math.abs(startChunk.getChunkZ() - top.getChunkZ()) + smoothingRadiusInChunks;
        ((BO4)this.start.getObject()).getSettings().minimumSizeRight = Math.abs(startChunk.getChunkX() - right.getChunkX()) + smoothingRadiusInChunks;
        ((BO4)this.start.getObject()).getSettings().minimumSizeBottom = Math.abs(startChunk.getChunkZ() - bottom.getChunkZ()) + smoothingRadiusInChunks;
        ((BO4)this.start.getObject()).getSettings().minimumSizeLeft = Math.abs(startChunk.getChunkX() - left.getChunkX()) + smoothingRadiusInChunks;
        Object[] returnValue = new Object[]{((BO4)this.start.getObject()).getSettings().minimumSizeTop, ((BO4)this.start.getObject()).getSettings().minimumSizeRight, ((BO4)this.start.getObject()).getSettings().minimumSizeBottom, ((BO4)this.start.getObject()).getSettings().minimumSizeLeft};
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.INFO, "", new Object[0]);
            OTG.log(LogMarker.INFO, this.start.getObject().getName() + " minimum size: Width " + ((Integer)returnValue[1] + (Integer)returnValue[3] + 1) + " Length " + ((Integer)returnValue[0] + (Integer)returnValue[2] + 1) + " top " + (Integer)returnValue[0] + " right " + (Integer)returnValue[1] + " bottom " + (Integer)returnValue[2] + " left " + (Integer)returnValue[3], new Object[0]);
        }
        this.objectsToSpawn.clear();
        return returnValue;
    }

    private void calculateBranches(boolean minimumSize, LocalWorld world) throws InvalidConfigException {
        if (OTG.getPluginConfig().spawnLog) {
            String sminimumSize = minimumSize ? " (minimumSize)" : "";
            OTG.log(LogMarker.INFO, "", new Object[0]);
            OTG.log(LogMarker.INFO, "-------- CalculateBranches " + this.start.bo3Name + sminimumSize + " --------", new Object[0]);
        }
        BranchDataItem branchData = new BranchDataItem(this.random, null, (BO4CustomStructureCoordinate)this.start, null, 0, 0, minimumSize);
        if (OTG.getPluginConfig().spawnLog) {
            OTG.log(LogMarker.INFO, "", new Object[0]);
            OTG.log(LogMarker.INFO, "---- Cycle 0 ----", new Object[0]);
            OTG.log(LogMarker.INFO, "Plotted X" + branchData.chunkCoordinate.getChunkX() + " Z" + branchData.chunkCoordinate.getChunkZ() + " - " + branchData.branch.getObject().getName(), new Object[0]);
        }
        this.addToCaches(branchData, (BO4)branchData.branch.getObject());
        this.Cycle = 0;
        boolean canOverrideBranchesSpawned = false;
        this.SpawningCanOverrideBranches = false;
        boolean processingDone = false;
        while (!processingDone) {
            this.spawnedBranchLastCycle = this.spawnedBranchThisCycle;
            this.spawnedBranchThisCycle = false;
            ++this.Cycle;
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.INFO, "", new Object[0]);
                OTG.log(LogMarker.INFO, "---- Cycle " + this.Cycle + " ----", new Object[0]);
            }
            this.traverseAndSpawnChildBranches(branchData, minimumSize, true, world);
            if (OTG.getPluginConfig().spawnLog) {
                OTG.log(LogMarker.INFO, "All branch groups with required branches only have been processed for cycle " + this.Cycle + ", plotting branch groups with optional branches.", new Object[0]);
            }
            this.traverseAndSpawnChildBranches(branchData, minimumSize, false, world);
            processingDone = true;
            for (BranchDataItem branchDataItem3 : this.AllBranchesBranchData) {
                if (branchDataItem3.doneSpawning) continue;
                processingDone = false;
                break;
            }
            if (processingDone && !canOverrideBranchesSpawned) {
                canOverrideBranchesSpawned = true;
                this.SpawningCanOverrideBranches = true;
                processingDone = false;
                for (BranchDataItem branchDataItem3 : this.AllBranchesBranchData) {
                    for (BranchDataItem childBranch : branchDataItem3.getChildren(false, world)) {
                        if (childBranch.branch.isRequiredBranch || !((BO4)childBranch.branch.getObject()).getSettings().canOverride) continue;
                        branchDataItem3.doneSpawning = false;
                        childBranch.doneSpawning = false;
                        childBranch.cannotSpawn = false;
                        if (branchDataItem3.wasDeleted) {
                            throw new RuntimeException();
                        }
                        if (!childBranch.wasDeleted) continue;
                        throw new RuntimeException();
                    }
                }
            }
            if (!branchData.cannotSpawn) continue;
            if (minimumSize) {
                if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Error: Branching BO4 " + this.start.bo3Name + " could not be spawned in minimum configuration (isRequiredBranch branches only).", new Object[0]);
                }
                throw new InvalidConfigException("Error: Branching BO4 " + this.start.bo3Name + " could not be spawned in minimum configuration (isRequiredBranch branches only).");
            }
            this.AllBranchesBranchData.clear();
            this.AllBranchesBranchDataByChunk.clear();
            this.AllBranchesBranchDataByName.clear();
            this.AllBranchesBranchDataByGroup.clear();
            this.AllBranchesBranchDataHash.clear();
            return;
        }
        for (BranchDataItem branchToAdd : this.AllBranchesBranchData) {
            if (branchToAdd.cannotSpawn) continue;
            if (branchToAdd.branch == null) {
                throw new RuntimeException();
            }
            this.addToChunk(branchToAdd.branch, branchToAdd.chunkCoordinate, this.objectsToSpawn);
        }
        this.AllBranchesBranchData.clear();
        this.AllBranchesBranchDataByChunk.clear();
        this.AllBranchesBranchDataByName.clear();
        this.AllBranchesBranchDataByGroup.clear();
        this.AllBranchesBranchDataHash.clear();
    }

    private void traverseAndSpawnChildBranches(BranchDataItem branchData, boolean minimumSize, boolean spawningRequiredBranchesOnly, LocalWorld world) {
        if (!branchData.doneSpawning) {
            this.addBranches(branchData, minimumSize, false, spawningRequiredBranchesOnly, world);
        } else if (!branchData.cannotSpawn) {
            for (BranchDataItem branchDataItem2 : branchData.getChildren(false, world)) {
                if (branchDataItem2.cannotSpawn || !branchData.doneSpawning) continue;
                this.traverseAndSpawnChildBranches(branchDataItem2, minimumSize, spawningRequiredBranchesOnly, world);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void addBranches(BranchDataItem branchDataItem, boolean minimumSize, boolean traverseOnlySpawnedChildren, boolean spawningRequiredBranchesOnly, LocalWorld world) {
        if (!this.SpawningCanOverrideBranches) {
            for (BranchDataItem branchDataItem2 : branchDataItem.getChildren(false, world)) {
                if (branchDataItem2.cannotSpawn && branchDataItem2.doneSpawning || !((BO4)branchDataItem2.branch.getObject()).getSettings().canOverride || branchDataItem2.branch.isRequiredBranch) continue;
                branchDataItem2.cannotSpawn = true;
                branchDataItem2.doneSpawning = true;
            }
        }
        if (this.spawningRequiredChildrenForOptionalBranch && traverseOnlySpawnedChildren) {
            throw new RuntimeException();
        }
        if (!spawningRequiredBranchesOnly) {
            branchDataItem.doneSpawning = true;
        } else {
            boolean hasOnlyRequiredBranches = true;
            for (BranchDataItem branchDataItem3 : branchDataItem.getChildren(false, world)) {
                if (branchDataItem3.branch.isRequiredBranch || branchDataItem3.doneSpawning || branchDataItem3.cannotSpawn) continue;
                hasOnlyRequiredBranches = false;
                break;
            }
            if (hasOnlyRequiredBranches) {
                branchDataItem.doneSpawning = true;
            }
        }
        if (!branchDataItem.cannotSpawn) {
            for (BranchDataItem branchDataItem3 : branchDataItem.getChildren(false, world)) {
                if (!this.AllBranchesBranchDataHash.contains(branchDataItem3.branchNumber) && !branchDataItem3.spawnDelayed) {
                    void var23_46;
                    int smoothRadius;
                    boolean canSpawn = true;
                    boolean collidedWithParentOrSibling = false;
                    boolean wasntBelowOther = false;
                    boolean wasntInsideOther = false;
                    boolean cannotSpawnInsideOther = false;
                    boolean wasntOnWater = false;
                    boolean wasOnWater = false;
                    boolean spaceIsOccupied = false;
                    boolean chunkIsIneligible = false;
                    boolean startChunkBlockChecksPassed = true;
                    boolean branchFrequencyNotPassed = false;
                    boolean branchFrequencyGroupsNotPassed = false;
                    BO4 bo3 = (BO4)branchDataItem3.branch.getObject();
                    if (bo3 == null || bo3.isInvalidConfig) {
                        branchDataItem3.doneSpawning = true;
                        branchDataItem3.cannotSpawn = true;
                        if (bo3 == null && OTG.getPluginConfig().spawnLog) {
                            OTG.log(LogMarker.WARN, "Error: Could not find BO3 file: " + branchDataItem3.branch.bo3Name + ".BO3 which is a branch of " + branchDataItem.branch.bo3Name + ".BO3", new Object[0]);
                        }
                    }
                    if (branchDataItem3.doneSpawning || branchDataItem3.cannotSpawn) continue;
                    if (spawningRequiredBranchesOnly) {
                        if (!branchDataItem3.branch.isRequiredBranch) continue;
                        boolean hasOnlyRequiredBranches = true;
                        if (branchDataItem3.branch.branchGroup != null && branchDataItem3.branch.branchGroup.length() > 0) {
                            for (BranchDataItem branchDataItem4 : branchDataItem.getChildren(false, world)) {
                                if (branchDataItem4.branch.isRequiredBranch || branchDataItem4.branch.branchGroup == null || branchDataItem4.branch.branchGroup.length() <= 0 || !branchDataItem3.branch.branchGroup.equals(branchDataItem4.branch.branchGroup) || branchDataItem4.wasDeleted || branchDataItem4.cannotSpawn || branchDataItem4.doneSpawning) continue;
                                hasOnlyRequiredBranches = false;
                                break;
                            }
                        }
                        if (!hasOnlyRequiredBranches) continue;
                    }
                    if (canSpawn && (branchDataItem3.maxDepth == 0 || branchDataItem3.currentDepth > branchDataItem3.maxDepth) && !branchDataItem3.branch.isRequiredBranch) {
                        canSpawn = false;
                    }
                    ++this.branchesTried;
                    if (minimumSize && branchDataItem3.branch.isWeightedBranch) {
                        branchDataItem3.doneSpawning = true;
                        branchDataItem3.cannotSpawn = true;
                        continue;
                    }
                    int n = smoothRadius = ((BO4)this.start.getObject()).getSettings().overrideChildSettings && bo3.getSettings().overrideChildSettings ? ((BO4)this.start.getObject()).getSettings().smoothRadius : bo3.getSettings().smoothRadius;
                    if (smoothRadius == -1 || bo3.getSettings().smoothRadius == -1) {
                        smoothRadius = 0;
                    }
                    if (!this.doStartChunkBlockChecks(world)) {
                        canSpawn = false;
                        startChunkBlockChecksPassed = false;
                    } else if (branchDataItem3.branch.getY() < 0 && !minimumSize) {
                        canSpawn = false;
                    }
                    Stack<BranchDataItem> collidingObjects = null;
                    if (canSpawn) {
                        if (!minimumSize && world.chunkHasDefaultStructure(this.worldRandom, branchDataItem3.chunkCoordinate)) {
                            chunkIsIneligible = true;
                            canSpawn = false;
                        }
                        if (!(!canSpawn || minimumSize || !bo3.getSettings().spawnOnWaterOnly || world.getMaterial(branchDataItem3.chunkCoordinate.getBlockX(), world.getHighestBlockYAt(branchDataItem3.chunkCoordinate.getBlockX(), branchDataItem3.chunkCoordinate.getBlockZ(), true, true, false, true), branchDataItem3.chunkCoordinate.getBlockZ(), true).isLiquid() && world.getMaterial(branchDataItem3.chunkCoordinate.getBlockX(), world.getHighestBlockYAt(branchDataItem3.chunkCoordinate.getBlockX(), branchDataItem3.chunkCoordinate.getBlockZ() + 15, true, true, false, true), branchDataItem3.chunkCoordinate.getBlockZ() + 15, true).isLiquid() && world.getMaterial(branchDataItem3.chunkCoordinate.getBlockX() + 15, world.getHighestBlockYAt(branchDataItem3.chunkCoordinate.getBlockX() + 15, branchDataItem3.chunkCoordinate.getBlockZ(), true, true, false, true), branchDataItem3.chunkCoordinate.getBlockZ(), true).isLiquid() && world.getMaterial(branchDataItem3.chunkCoordinate.getBlockX() + 15, world.getHighestBlockYAt(branchDataItem3.chunkCoordinate.getBlockX() + 15, branchDataItem3.chunkCoordinate.getBlockZ() + 15, true, true, false, true), branchDataItem3.chunkCoordinate.getBlockZ() + 15, true).isLiquid())) {
                            wasntOnWater = true;
                            canSpawn = false;
                        }
                        if (canSpawn && !minimumSize && !bo3.getSettings().canSpawnOnWater && world.getMaterial(branchDataItem3.chunkCoordinate.getBlockX() + 8, world.getHighestBlockYAt(branchDataItem3.chunkCoordinate.getBlockX() + 8, branchDataItem3.chunkCoordinate.getBlockZ() + 7, true, true, false, true), branchDataItem3.chunkCoordinate.getBlockZ() + 7, true).isLiquid()) {
                            wasOnWater = true;
                            canSpawn = false;
                        }
                        if (canSpawn && bo3.getSettings().mustBeBelowOther && !(canSpawn = this.checkMustBeBelowOther(branchDataItem3))) {
                            wasntBelowOther = true;
                        }
                        if (canSpawn && bo3.getSettings().mustBeInsideBranches.size() > 0 && !(canSpawn = this.checkMustBeInside(branchDataItem3, bo3))) {
                            wasntInsideOther = true;
                        }
                        if (canSpawn && bo3.getSettings().cannotBeInsideBranches.size() > 0 && !(canSpawn = this.checkCannotBeInside(branchDataItem3, bo3))) {
                            cannotSpawnInsideOther = true;
                        }
                        if (canSpawn && bo3.getSettings().branchFrequency > 0 && !(canSpawn = this.checkBranchFrequency(branchDataItem3, bo3))) {
                            branchFrequencyNotPassed = true;
                        }
                        if (canSpawn && bo3.getSettings().branchFrequencyGroups.size() > 0 && !(canSpawn = this.checkBranchFrequencyGroups(branchDataItem3, bo3))) {
                            branchFrequencyGroupsNotPassed = true;
                        }
                        if (canSpawn && (collidingObjects = this.checkSpawnRequirementsAndCollisions(branchDataItem3, minimumSize, world)).size() > 0) {
                            canSpawn = false;
                            collidedWithParentOrSibling = true;
                            for (BranchDataItem collidingObject : collidingObjects) {
                                if (collidingObject == null) {
                                    chunkIsIneligible = true;
                                    collidedWithParentOrSibling = false;
                                    break;
                                }
                                if (branchDataItem.parent != null && collidingObject.branch == branchDataItem.parent.branch || ((BO4)collidingObject.branch.getObject()).getSettings().canOverride) continue;
                                boolean siblingFound = false;
                                if (branchDataItem.parent != null) {
                                    for (BranchDataItem parentSibling : branchDataItem.parent.getChildren(false, world)) {
                                        if (collidingObject.branch != parentSibling.branch) continue;
                                        siblingFound = true;
                                        break;
                                    }
                                }
                                if (!siblingFound) {
                                    for (BranchDataItem sibling : branchDataItem.getChildren(false, world)) {
                                        if (collidingObject.branch != sibling.branch) continue;
                                        siblingFound = true;
                                        break;
                                    }
                                }
                                if (siblingFound) continue;
                                spaceIsOccupied = true;
                                collidedWithParentOrSibling = false;
                                break;
                            }
                        }
                    }
                    if (canSpawn) {
                        if (OTG.getPluginConfig().spawnLog) {
                            void var23_37;
                            String string = "";
                            BranchDataItem tempBranch = branchDataItem3;
                            while (tempBranch.parent != null) {
                                String string2 = (String)var23_37 + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                                tempBranch = tempBranch.parent;
                            }
                            OTG.log(LogMarker.INFO, "Plotted X" + branchDataItem3.chunkCoordinate.getChunkX() + " Z" + branchDataItem3.chunkCoordinate.getChunkZ() + (minimumSize ? "" : " Y" + branchDataItem3.branch.getY()) + " " + branchDataItem3.branch.bo3Name + ":" + (Object)((Object)branchDataItem3.branch.getRotation()) + (branchDataItem3.branch.isRequiredBranch ? " required" : " optional") + " cycle " + this.Cycle + (String)var23_37, new Object[0]);
                        }
                        if (branchDataItem3.getChildren(false, world).size() == 0) {
                            branchDataItem3.doneSpawning = true;
                        }
                        for (BranchDataItem childBranchDataItem2 : branchDataItem.getChildren(false, world)) {
                            if (childBranchDataItem2 == branchDataItem3 || branchDataItem3.branch.branchGroup == null || branchDataItem3.branch.branchGroup.length() < 0 || !branchDataItem3.branch.branchGroup.equals(childBranchDataItem2.branch.branchGroup) || !childBranchDataItem2.branch.isRequiredBranch) continue;
                            childBranchDataItem2.doneSpawning = true;
                            childBranchDataItem2.cannotSpawn = true;
                        }
                        this.spawnedBranchThisCycle = true;
                        this.addToCaches(branchDataItem3, bo3);
                        if (!this.spawningRequiredChildrenForOptionalBranch && !branchDataItem3.branch.isRequiredBranch) {
                            boolean bl;
                            if (OTG.getPluginConfig().spawnLog) {
                                OTG.log(LogMarker.INFO, "Plotting all required child branches that are not in a branch group with optional branches.", new Object[0]);
                            }
                            this.spawningRequiredChildrenForOptionalBranch = true;
                            this.currentSpawningRequiredChildrenForOptionalBranch = branchDataItem3;
                            this.traverseAndSpawnChildBranches(branchDataItem3, minimumSize, true, world);
                            this.spawningRequiredChildrenForOptionalBranch = false;
                            boolean bl2 = false;
                            ArrayList<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(branchDataItem3.chunkCoordinate);
                            if (branchDataItemStack != null) {
                                for (BranchDataItem b : branchDataItemStack) {
                                    if (b != branchDataItem3) continue;
                                    bl = true;
                                    break;
                                }
                            }
                            canSpawn = bl;
                            if (OTG.getPluginConfig().spawnLog) {
                                OTG.log(LogMarker.INFO, "Done spawning required children for optional branch X" + branchDataItem3.chunkCoordinate.getChunkX() + " Z" + branchDataItem3.chunkCoordinate.getChunkZ() + (minimumSize ? "" : " Y" + branchDataItem3.branch.getY()) + " " + branchDataItem3.branch.bo3Name + ":" + (Object)((Object)branchDataItem3.branch.getRotation()), new Object[0]);
                            }
                        } else if (traverseOnlySpawnedChildren && !this.spawningRequiredChildrenForOptionalBranch && branchDataItem3.branch.isRequiredBranch) {
                            this.traverseAndSpawnChildBranches(branchDataItem3, minimumSize, true, world);
                        }
                    }
                    if (canSpawn || branchDataItem3.doneSpawning || branchDataItem3.cannotSpawn) continue;
                    if (!wasntBelowOther || !this.spawnedBranchLastCycle) {
                        branchDataItem3.doneSpawning = true;
                        branchDataItem3.cannotSpawn = true;
                    } else {
                        branchDataItem.doneSpawning = false;
                        if (branchDataItem.wasDeleted) {
                            throw new RuntimeException();
                        }
                    }
                    boolean bl = false;
                    boolean branchGroupFailedSpawning = false;
                    if (branchDataItem3.branch.isRequiredBranch) {
                        branchGroupFailedSpawning = true;
                        for (BranchDataItem childBranchDataItem2 : branchDataItem.getChildren(false, world)) {
                            if (childBranchDataItem2 == branchDataItem3 || branchDataItem3.branch.branchGroup == null || branchDataItem3.branch.branchGroup.length() < 0 || !branchDataItem3.branch.branchGroup.equals(childBranchDataItem2.branch.branchGroup) || !childBranchDataItem2.branch.isRequiredBranch || childBranchDataItem2.doneSpawning || childBranchDataItem2.cannotSpawn) continue;
                            branchGroupFailedSpawning = false;
                            break;
                        }
                    }
                    if (!(collidedWithParentOrSibling || wasntBelowOther && this.spawnedBranchLastCycle || !branchGroupFailedSpawning)) {
                        if (OTG.getPluginConfig().spawnLog) {
                            String allParentsString = "";
                            BranchDataItem tempBranch = branchDataItem;
                            while (tempBranch.parent != null) {
                                allParentsString = allParentsString + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                                tempBranch = tempBranch.parent;
                            }
                            Object occupiedByObjectsString = "";
                            if (spaceIsOccupied) {
                                for (BranchDataItem collidingObject : collidingObjects) {
                                    Object occupiedByObjectString = collidingObject.branch.bo3Name + ":" + (Object)((Object)collidingObject.branch.getRotation()) + " X" + collidingObject.branch.getChunkX() + " Z" + collidingObject.branch.getChunkZ() + " Y" + collidingObject.branch.getY();
                                    tempBranch = collidingObject;
                                    while (tempBranch.parent != null) {
                                        occupiedByObjectString = (String)occupiedByObjectString + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                                        tempBranch = tempBranch.parent;
                                    }
                                    occupiedByObjectsString = (String)occupiedByObjectsString + " " + (String)occupiedByObjectString;
                                }
                            }
                            String reason = (branchFrequencyGroupsNotPassed ? "BranchFrequencyGroupNotPassed " : "") + (branchFrequencyNotPassed ? "BranchFrequencyNotPassed " : "") + (!startChunkBlockChecksPassed ? "StartChunkBlockChecksNotPassed " : "") + (collidedWithParentOrSibling ? "CollidedWithParentOrSibling " : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (wasntInsideOther ? "WasntInsideOther " : "") + (cannotSpawnInsideOther ? "CannotSpawnInsideOther " : "") + (wasntOnWater ? "WasntOnWater " : "") + (wasOnWater ? "WasOnWater " : "") + (!branchFrequencyGroupsNotPassed && !branchFrequencyNotPassed && startChunkBlockChecksPassed && !wasntBelowOther && !cannotSpawnInsideOther && !wasntOnWater && !wasOnWater && !wasntBelowOther && !chunkIsIneligible && spaceIsOccupied ? "SpaceIsOccupied by" + (String)occupiedByObjectsString : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (chunkIsIneligible ? "TerrainIsUnsuitable (StartChunkBlockChecks (height or material) not passed or Y < 0 or Frequency/BO3Group checks not passed or BO3 collided with other CustomStructure or smoothing area collided with other CustomStructure or BO3 not in allowed Biome or Smoothing area not in allowed Biome)" : "");
                            OTG.log(LogMarker.INFO, "Rolling back X" + branchDataItem.branch.getChunkX() + " Z" + branchDataItem.branch.getChunkZ() + " Y" + branchDataItem.branch.getY() + " " + branchDataItem.branch.bo3Name + ":" + (Object)((Object)branchDataItem.branch.getRotation()) + allParentsString + " because required branch " + branchDataItem3.branch.bo3Name + " couldn't spawn. Reason: " + reason, new Object[0]);
                        }
                        this.rollBackBranch(branchDataItem, minimumSize, spawningRequiredBranchesOnly, world);
                        boolean bl3 = true;
                    } else {
                        for (BranchDataItem childBranchDataItem2 : branchDataItem.getChildren(false, world)) {
                            if (wasntBelowOther && this.spawnedBranchLastCycle || branchDataItem3 != childBranchDataItem2 && (childBranchDataItem2.cannotSpawn || childBranchDataItem2.doneSpawning || !(branchDataItem3.branch.getY() < 0 || chunkIsIneligible || wasntBelowOther && ((BO4)childBranchDataItem2.branch.getObject()).getSettings().mustBeBelowOther || wasntOnWater && ((BO4)childBranchDataItem2.branch.getObject()).getSettings().spawnOnWaterOnly) && (!wasOnWater || ((BO4)childBranchDataItem2.branch.getObject()).getSettings().canSpawnOnWater) || branchDataItem3.branch.getX() != childBranchDataItem2.branch.getX() || branchDataItem3.branch.getY() != childBranchDataItem2.branch.getY() || branchDataItem3.branch.getZ() != childBranchDataItem2.branch.getZ())) continue;
                            childBranchDataItem2.doneSpawning = true;
                            childBranchDataItem2.cannotSpawn = true;
                            branchGroupFailedSpawning = false;
                            if (childBranchDataItem2.branch.isRequiredBranch) {
                                branchGroupFailedSpawning = true;
                                for (BranchDataItem childBranchDataItem3 : branchDataItem.getChildren(false, world)) {
                                    if (childBranchDataItem3 == childBranchDataItem2 || childBranchDataItem2.branch.branchGroup == null || childBranchDataItem2.branch.branchGroup.length() < 0 || !childBranchDataItem2.branch.branchGroup.equals(childBranchDataItem3.branch.branchGroup) || !childBranchDataItem3.branch.isRequiredBranch || childBranchDataItem3.doneSpawning || childBranchDataItem3.cannotSpawn) continue;
                                    branchGroupFailedSpawning = false;
                                    break;
                                }
                            }
                            if (!branchGroupFailedSpawning || collidedWithParentOrSibling) continue;
                            if (OTG.getPluginConfig().spawnLog) {
                                String allParentsString = "";
                                BranchDataItem tempBranch = branchDataItem;
                                while (tempBranch.parent != null) {
                                    allParentsString = allParentsString + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                                    tempBranch = tempBranch.parent;
                                }
                                String occupiedByObjectsString = "";
                                if (spaceIsOccupied) {
                                    for (BranchDataItem collidingObject : collidingObjects) {
                                        String occupiedByObjectString = collidingObject.branch.bo3Name + ":" + (Object)((Object)collidingObject.branch.getRotation()) + " X" + collidingObject.branch.getChunkX() + " Z" + collidingObject.branch.getChunkZ() + " Y" + collidingObject.branch.getY();
                                        tempBranch = collidingObject;
                                        while (tempBranch.parent != null) {
                                            occupiedByObjectString = occupiedByObjectString + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                                            tempBranch = tempBranch.parent;
                                        }
                                        occupiedByObjectsString = occupiedByObjectsString + " " + occupiedByObjectString;
                                    }
                                }
                                String reason = (branchFrequencyGroupsNotPassed ? "BranchFrequencyGroupNotPassed " : "") + (branchFrequencyNotPassed ? "BranchFrequencyNotPassed " : "") + (!startChunkBlockChecksPassed ? "StartChunkBlockChecksNotPassed " : "") + (collidedWithParentOrSibling ? "CollidedWithParentOrSibling " : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (wasntInsideOther ? "WasntInsideOther " : "") + (cannotSpawnInsideOther ? "CannotSpawnInsideOther " : "") + (wasntOnWater ? "WasntOnWater " : "") + (wasOnWater ? "WasOnWater " : "") + (branchDataItem3.branch.getY() < 0 ? " WasBelowY0 " : "") + (!branchFrequencyGroupsNotPassed && !branchFrequencyNotPassed && startChunkBlockChecksPassed && !wasntBelowOther && !cannotSpawnInsideOther && !wasntOnWater && !wasOnWater && !wasntBelowOther && !chunkIsIneligible && spaceIsOccupied ? "SpaceIsOccupied by" + occupiedByObjectsString : "") + (wasntBelowOther ? "WasntBelowOther " : "") + (chunkIsIneligible ? "ChunkIsIneligible: Either the chunk is occupied by another structure or a default structure, or the BO3/smoothing area is not allowed in the Biome)" : "");
                                OTG.log(LogMarker.INFO, "Rolling back X" + branchDataItem.branch.getChunkX() + " Z" + branchDataItem.branch.getChunkZ() + " Y" + branchDataItem.branch.getY() + " " + branchDataItem.branch.bo3Name + ":" + (Object)((Object)branchDataItem.branch.getRotation()) + allParentsString + " because required branch " + branchDataItem3.branch.bo3Name + " couldn't spawn. Reason: " + reason, new Object[0]);
                            }
                            this.rollBackBranch(branchDataItem, minimumSize, spawningRequiredBranchesOnly, world);
                            boolean bl4 = true;
                            break;
                        }
                    }
                    if (var23_46 == false) continue;
                    break;
                }
                if (!branchDataItem3.spawnDelayed) continue;
                branchDataItem3.spawnDelayed = false;
            }
            if (!(traverseOnlySpawnedChildren || spawningRequiredBranchesOnly || branchDataItem.cannotSpawn)) {
                for (BranchDataItem branchDataItem5 : branchDataItem.getChildren(false, world)) {
                    if (!this.AllBranchesBranchDataHash.contains(branchDataItem5.branchNumber) || !branchDataItem5.branch.isRequiredBranch && (!this.SpawningCanOverrideBranches || ((BO4)branchDataItem5.branch.getObject()).getSettings().canOverride) || branchDataItem5.cannotSpawn || branchDataItem5.spawnDelayed && this.spawnedBranchLastCycle) continue;
                    this.traverseAndSpawnChildBranches(branchDataItem5, minimumSize, spawningRequiredBranchesOnly, world);
                }
            }
            if (!traverseOnlySpawnedChildren && spawningRequiredBranchesOnly && !branchDataItem.cannotSpawn) {
                for (BranchDataItem branchDataItem6 : branchDataItem.getChildren(false, world)) {
                    if (!this.AllBranchesBranchDataHash.contains(branchDataItem6.branchNumber) || !branchDataItem6.branch.isRequiredBranch) continue;
                    this.traverseAndSpawnChildBranches(branchDataItem6, minimumSize, spawningRequiredBranchesOnly, world);
                }
            }
        }
    }

    private boolean checkBranchFrequency(BranchDataItem childBranchDataItem, BO4 bo3) {
        boolean branchFrequencyPassed = true;
        int radius = bo3.getSettings().branchFrequency;
        if (radius > 0) {
            float distanceBetweenBranches = 0.0f;
            ArrayList<ChunkCoordinate> chunkCoords = this.AllBranchesBranchDataByName.get(bo3.getName());
            if (chunkCoords != null) {
                for (ChunkCoordinate cachedChunk : chunkCoords) {
                    distanceBetweenBranches = (int)Math.floor(Math.sqrt(Math.pow(childBranchDataItem.chunkCoordinate.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(childBranchDataItem.chunkCoordinate.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                    if (!(distanceBetweenBranches <= (float)radius)) continue;
                    branchFrequencyPassed = false;
                    break;
                }
            }
        }
        return branchFrequencyPassed;
    }

    private boolean checkBranchFrequencyGroups(BranchDataItem childBranchDataItem, BO4 bo3) {
        boolean branchFrequencyGroupsPassed = true;
        if (bo3.getSettings().branchFrequencyGroups.size() > 0) {
            int radius = bo3.getSettings().branchFrequency;
            float distanceBetweenStructures = 0.0f;
            int cachedChunkRadius = 0;
            ChunkCoordinate cachedChunk = null;
            for (Map.Entry<String, Integer> entry : bo3.getSettings().branchFrequencyGroups.entrySet()) {
                HashMap<ChunkCoordinate, ArrayList<Integer>> spawnedStructure = this.AllBranchesBranchDataByGroup.get(entry.getKey());
                if (spawnedStructure == null) continue;
                for (Map.Entry<ChunkCoordinate, ArrayList<Integer>> cachedChunkEntry : spawnedStructure.entrySet()) {
                    cachedChunk = cachedChunkEntry.getKey();
                    cachedChunkRadius = 0;
                    for (Integer integer : cachedChunkEntry.getValue()) {
                        if (integer <= cachedChunkRadius) continue;
                        cachedChunkRadius = integer;
                    }
                    int n = radius = entry.getValue() >= cachedChunkRadius ? entry.getValue() : cachedChunkRadius;
                    distanceBetweenStructures = (int)Math.floor(Math.sqrt(Math.pow(childBranchDataItem.chunkCoordinate.getChunkX() - cachedChunk.getChunkX(), 2.0) + Math.pow(childBranchDataItem.chunkCoordinate.getChunkZ() - cachedChunk.getChunkZ(), 2.0)));
                    if (!(distanceBetweenStructures <= (float)radius)) continue;
                    branchFrequencyGroupsPassed = false;
                    break;
                }
                if (branchFrequencyGroupsPassed) continue;
                break;
            }
        }
        return branchFrequencyGroupsPassed;
    }

    private boolean checkMustBeBelowOther(BranchDataItem childBranchDataItem) {
        boolean bFoundOther = false;
        if (this.AllBranchesBranchDataByChunk.containsKey(childBranchDataItem.chunkCoordinate)) {
            for (BranchDataItem branchDataItem2 : this.AllBranchesBranchDataByChunk.get(childBranchDataItem.chunkCoordinate)) {
                if (!branchDataItem2.chunkCoordinate.equals(childBranchDataItem.chunkCoordinate) || ((BO4)branchDataItem2.branch.getObject()).getSettings().canOverride || branchDataItem2.branch.getY() < childBranchDataItem.branch.getY()) continue;
                bFoundOther = true;
                break;
            }
        }
        return bFoundOther;
    }

    private boolean checkCannotBeInside(BranchDataItem childBranchDataItem, BO4 bo3) {
        boolean foundSpawnBlocker = false;
        if (this.AllBranchesBranchDataByChunk.containsKey(childBranchDataItem.chunkCoordinate)) {
            ArrayList<BranchDataItem> branchDataInChunk = this.AllBranchesBranchDataByChunk.get(childBranchDataItem.chunkCoordinate);
            for (String cantBeInsideBO3 : bo3.getSettings().cannotBeInsideBranches) {
                for (BranchDataItem branchDataItem3 : branchDataInChunk) {
                    if (branchDataItem3 == childBranchDataItem || branchDataItem3 == childBranchDataItem.parent) continue;
                    for (String branchName : ((BO4)branchDataItem3.branch.getObject()).getSettings().getInheritedBO3s()) {
                        if (!branchName.equals(cantBeInsideBO3) || !this.checkCollision(childBranchDataItem.branch, branchDataItem3.branch)) continue;
                        if (OTG.getPluginConfig().spawnLog) {
                            OTG.log(LogMarker.INFO, "CannotBeInside branch " + childBranchDataItem.branch.bo3Name + " was blocked by " + branchDataItem3.branch.bo3Name, new Object[0]);
                        }
                        foundSpawnBlocker = true;
                        break;
                    }
                    if (!foundSpawnBlocker) continue;
                    break;
                }
                if (!foundSpawnBlocker) continue;
                break;
            }
        }
        return !foundSpawnBlocker;
    }

    private boolean checkMustBeInside(BranchDataItem childBranchDataItem, BO4 bo3) {
        if (this.AllBranchesBranchDataByChunk.containsKey(childBranchDataItem.chunkCoordinate)) {
            ArrayList<BranchDataItem> branchDataInChunk = this.AllBranchesBranchDataByChunk.get(childBranchDataItem.chunkCoordinate);
            for (String mustBeInsideBO3 : bo3.getSettings().mustBeInsideBranches) {
                boolean foundSpawnRequirement = true;
                String[] andSwitch = mustBeInsideBO3.split(" ");
                boolean bFoundPart = false;
                for (String mustBeInsideBO3Name : andSwitch) {
                    bFoundPart = false;
                    for (BranchDataItem branchDataItem3 : branchDataInChunk) {
                        if (branchDataItem3 == childBranchDataItem || branchDataItem3 == childBranchDataItem.parent) continue;
                        for (String branchName : ((BO4)branchDataItem3.branch.getObject()).getSettings().getInheritedBO3s()) {
                            if (!branchName.equals(mustBeInsideBO3Name) || !this.checkCollision(childBranchDataItem.branch, branchDataItem3.branch)) continue;
                            bFoundPart = true;
                            break;
                        }
                        if (!bFoundPart) continue;
                        break;
                    }
                    if (bFoundPart) continue;
                    foundSpawnRequirement = false;
                }
                if (!foundSpawnRequirement) continue;
                return true;
            }
        }
        return false;
    }

    private void rollBackBranch(BranchDataItem branchData, boolean minimumSize, boolean spawningRequiredBranchesOnly, LocalWorld world) {
        ArrayList<BranchDataItem> branchDataByChunk;
        ArrayList<BranchDataItem> allBranchesBranchData2;
        if (this.spawningRequiredChildrenForOptionalBranch && this.currentSpawningRequiredChildrenForOptionalBranch.parent == branchData) {
            return;
        }
        branchData.cannotSpawn = true;
        branchData.doneSpawning = true;
        branchData.wasDeleted = true;
        branchData.isBeingRolledBack = true;
        this.deleteBranchChildren(branchData, minimumSize, spawningRequiredBranchesOnly, world);
        if (this.AllBranchesBranchDataHash.contains(branchData.branchNumber)) {
            if (OTG.getPluginConfig().spawnLog) {
                String allParentsString = "";
                BranchDataItem tempBranch = branchData;
                while (tempBranch.parent != null) {
                    allParentsString = allParentsString + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                    tempBranch = tempBranch.parent;
                }
                OTG.log(LogMarker.INFO, "Deleted X" + branchData.branch.getChunkX() + " Z" + branchData.branch.getChunkZ() + " Y" + branchData.branch.getY() + " " + branchData.branch.bo3Name + ":" + (Object)((Object)branchData.branch.getRotation()) + (branchData.branch.isRequiredBranch ? " required" : " optional") + " cycle " + this.Cycle + allParentsString, new Object[0]);
            }
            this.removeFromCaches(branchData);
        }
        if (!((BO4)branchData.branch.getObject()).getSettings().canOverride) {
            allBranchesBranchData2 = new ArrayList<BranchDataItem>();
            branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchData.chunkCoordinate);
            if (branchDataByChunk != null) {
                allBranchesBranchData2.addAll(branchDataByChunk);
                for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                    if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchData || !((BO4)branchDataItem2.branch.getObject()).getSettings().mustBeBelowOther || !branchDataItem2.chunkCoordinate.equals(branchData.chunkCoordinate)) continue;
                    boolean branchAboveFound = false;
                    for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(branchDataItem2.chunkCoordinate)) {
                        if (branchDataItem3 == branchData || ((BO4)branchDataItem3.branch.getObject()).getSettings().mustBeBelowOther || ((BO4)branchDataItem3.branch.getObject()).getSettings().canOverride || !branchDataItem3.chunkCoordinate.equals(branchDataItem2.chunkCoordinate) || branchDataItem3.branch.getY() < branchDataItem2.branch.getY()) continue;
                        branchAboveFound = true;
                        break;
                    }
                    if (branchAboveFound) continue;
                    this.rollBackBranch(branchDataItem2, minimumSize, spawningRequiredBranchesOnly, world);
                }
            }
        }
        allBranchesBranchData2 = new ArrayList();
        branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchData.chunkCoordinate);
        if (branchDataByChunk != null) {
            allBranchesBranchData2.addAll(branchDataByChunk);
            for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchData || ((BO4)branchDataItem2.branch.getObject()).getSettings().mustBeInsideBranches.size() <= 0 || !branchDataItem2.chunkCoordinate.equals(branchData.chunkCoordinate)) continue;
                boolean currentBO3Found = false;
                for (String mustBeInsideBO3Name : ((BO4)branchDataItem2.branch.getObject()).getSettings().mustBeInsideBranches) {
                    for (String branchName : ((BO4)branchData.branch.getObject()).getSettings().getInheritedBO3s()) {
                        if (!branchName.equals(mustBeInsideBO3Name)) continue;
                        currentBO3Found = true;
                        break;
                    }
                    if (!currentBO3Found) continue;
                    break;
                }
                if (!currentBO3Found || this.checkMustBeInside(branchDataItem2, (BO4)branchDataItem2.branch.getObject())) continue;
                this.rollBackBranch(branchDataItem2, minimumSize, spawningRequiredBranchesOnly, world);
            }
        }
        if (branchData.parent != null && !branchData.parent.isBeingRolledBack) {
            if (branchData.branch.isRequiredBranch) {
                this.rollBackBranch(branchData.parent, minimumSize, spawningRequiredBranchesOnly, world);
            } else {
                boolean parentDoneSpawning = true;
                boolean currentBranchFound = false;
                for (BranchDataItem branchDataItem2 : branchData.parent.getChildren(false, world)) {
                    if (currentBranchFound && branchData.branch.branchGroup != null && branchData.branch.branchGroup.length() >= 0 && branchData.branch.branchGroup.equals(branchDataItem2.branch.branchGroup) && !branchDataItem2.wasDeleted && !this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber)) {
                        branchDataItem2.cannotSpawn = false;
                        branchDataItem2.doneSpawning = false;
                    }
                    if (branchDataItem2 == branchData) {
                        currentBranchFound = true;
                    }
                    if (branchDataItem2.doneSpawning || branchDataItem2.cannotSpawn) continue;
                    parentDoneSpawning = false;
                }
                if (!(parentDoneSpawning || this.spawningRequiredChildrenForOptionalBranch && this.currentSpawningRequiredChildrenForOptionalBranch == branchData)) {
                    branchData.parent.doneSpawning = false;
                    if (!this.spawningRequiredChildrenForOptionalBranch) {
                        if (spawningRequiredBranchesOnly) {
                            this.addBranches(branchData.parent, minimumSize, false, spawningRequiredBranchesOnly, world);
                        } else {
                            this.addBranches(branchData.parent, minimumSize, true, spawningRequiredBranchesOnly, world);
                        }
                    } else {
                        if (!spawningRequiredBranchesOnly) {
                            throw new RuntimeException();
                        }
                        this.spawningRequiredChildrenForOptionalBranch = false;
                        this.addBranches(branchData.parent, minimumSize, false, spawningRequiredBranchesOnly, world);
                        this.spawningRequiredChildrenForOptionalBranch = true;
                    }
                }
            }
        }
        branchData.isBeingRolledBack = false;
    }

    private void deleteBranchChildren(BranchDataItem branchData, boolean minimumSize, boolean spawningRequiredBranchesOnly, LocalWorld world) {
        Stack<BranchDataItem> children = branchData.getChildren(true, world);
        for (BranchDataItem branchDataItem : children) {
            ArrayList<BranchDataItem> branchDataByChunk;
            ArrayList<BranchDataItem> allBranchesBranchData2;
            branchDataItem.cannotSpawn = true;
            branchDataItem.doneSpawning = true;
            branchDataItem.wasDeleted = true;
            if (branchDataItem.getChildren(true, world).size() > 0) {
                this.deleteBranchChildren(branchDataItem, minimumSize, spawningRequiredBranchesOnly, world);
            }
            if (!this.AllBranchesBranchDataHash.contains(branchDataItem.branchNumber)) continue;
            if (OTG.getPluginConfig().spawnLog) {
                String allParentsString = "";
                BranchDataItem tempBranch = branchDataItem;
                while (tempBranch.parent != null) {
                    allParentsString = allParentsString + " <-- X" + tempBranch.parent.branch.getChunkX() + " Z" + tempBranch.parent.branch.getChunkZ() + " Y" + tempBranch.parent.branch.getY() + " " + tempBranch.parent.branch.bo3Name + ":" + (Object)((Object)tempBranch.parent.branch.getRotation());
                    tempBranch = tempBranch.parent;
                }
                OTG.log(LogMarker.INFO, "Deleted X" + branchDataItem.branch.getChunkX() + " Z" + branchDataItem.branch.getChunkZ() + " Y" + branchDataItem.branch.getY() + " " + branchDataItem.branch.bo3Name + ":" + (Object)((Object)branchDataItem.branch.getRotation()) + (branchDataItem.branch.isRequiredBranch ? " required" : " optional") + " cycle " + this.Cycle + allParentsString, new Object[0]);
            }
            this.removeFromCaches(branchDataItem);
            if (!((BO4)branchDataItem.branch.getObject()).getSettings().canOverride) {
                allBranchesBranchData2 = new ArrayList<BranchDataItem>();
                branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchDataItem.chunkCoordinate);
                if (branchDataByChunk != null) {
                    allBranchesBranchData2.addAll(branchDataByChunk);
                    for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                        if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchDataItem || !((BO4)branchDataItem2.branch.getObject()).getSettings().mustBeBelowOther || !branchDataItem2.chunkCoordinate.equals(branchDataItem.chunkCoordinate)) continue;
                        boolean branchAboveFound = false;
                        for (BranchDataItem branchDataItem3 : this.AllBranchesBranchDataByChunk.get(branchDataItem2.chunkCoordinate)) {
                            if (branchDataItem3 == branchDataItem || ((BO4)branchDataItem3.branch.getObject()).getSettings().mustBeBelowOther || ((BO4)branchDataItem3.branch.getObject()).getSettings().canOverride || !branchDataItem3.chunkCoordinate.equals(branchDataItem2.chunkCoordinate) || branchDataItem3.branch.getY() < branchDataItem2.branch.getY()) continue;
                            branchAboveFound = true;
                            break;
                        }
                        if (branchAboveFound) continue;
                        this.rollBackBranch(branchDataItem2, minimumSize, spawningRequiredBranchesOnly, world);
                    }
                }
            }
            allBranchesBranchData2 = new ArrayList();
            branchDataByChunk = this.AllBranchesBranchDataByChunk.get(branchDataItem.chunkCoordinate);
            if (branchDataByChunk == null) continue;
            allBranchesBranchData2.addAll(branchDataByChunk);
            for (BranchDataItem branchDataItem2 : allBranchesBranchData2) {
                if (!this.AllBranchesBranchDataHash.contains(branchDataItem2.branchNumber) || branchDataItem2 == branchDataItem || ((BO4)branchDataItem2.branch.getObject()).getSettings().mustBeInsideBranches.size() <= 0 || !branchDataItem2.chunkCoordinate.equals(branchDataItem.chunkCoordinate)) continue;
                boolean currentBO3Found = false;
                for (String mustBeInsideBO3Name : ((BO4)branchDataItem2.branch.getObject()).getSettings().mustBeInsideBranches) {
                    for (String branchName : ((BO4)branchDataItem.branch.getObject()).getSettings().getInheritedBO3s()) {
                        if (!branchName.equals(mustBeInsideBO3Name)) continue;
                        currentBO3Found = true;
                        break;
                    }
                    if (!currentBO3Found) continue;
                    break;
                }
                if (!currentBO3Found || this.checkMustBeInside(branchDataItem2, (BO4)branchDataItem2.branch.getObject())) continue;
                this.rollBackBranch(branchDataItem2, minimumSize, spawningRequiredBranchesOnly, world);
            }
        }
    }

    private void addToCaches(BranchDataItem branchData, BO4 bo3) {
        this.AllBranchesBranchData.add(branchData);
        this.AllBranchesBranchDataHash.add(branchData.branchNumber);
        ArrayList<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(branchData.chunkCoordinate);
        if (branchDataItemStack != null) {
            branchDataItemStack.add(branchData);
        } else {
            branchDataItemStack = new ArrayList();
            branchDataItemStack.add(branchData);
            this.AllBranchesBranchDataByChunk.put(branchData.chunkCoordinate, branchDataItemStack);
        }
        ArrayList<ChunkCoordinate> sameNameBo3s = this.AllBranchesBranchDataByName.get(branchData.branch.bo3Name);
        if (sameNameBo3s == null) {
            sameNameBo3s = new ArrayList();
            this.AllBranchesBranchDataByName.put(branchData.branch.bo3Name, sameNameBo3s);
        }
        sameNameBo3s.add(branchData.chunkCoordinate);
        for (Map.Entry<String, Integer> entry : bo3.getSettings().branchFrequencyGroups.entrySet()) {
            ArrayList<Integer> branchGroupFrequency;
            HashMap<ChunkCoordinate, ArrayList<Integer>> branchGroupInfo = this.AllBranchesBranchDataByGroup.get(entry.getKey());
            if (branchGroupInfo == null) {
                branchGroupInfo = new HashMap();
                this.AllBranchesBranchDataByGroup.put(entry.getKey(), branchGroupInfo);
            }
            if ((branchGroupFrequency = branchGroupInfo.get(branchData.chunkCoordinate)) == null) {
                branchGroupFrequency = new ArrayList();
                branchGroupFrequency.add(entry.getValue());
                branchGroupInfo.put(branchData.chunkCoordinate, branchGroupFrequency);
                continue;
            }
            branchGroupFrequency.add(entry.getValue());
        }
    }

    private void removeFromCaches(BranchDataItem branchDataItem) {
        this.AllBranchesBranchData.remove(branchDataItem);
        this.AllBranchesBranchDataHash.remove(branchDataItem.branchNumber);
        ArrayList<BranchDataItem> branchDataItemStack = this.AllBranchesBranchDataByChunk.get(branchDataItem.chunkCoordinate);
        if (branchDataItemStack != null) {
            branchDataItemStack.remove(branchDataItem);
            if (branchDataItemStack.size() == 0) {
                this.AllBranchesBranchDataByChunk.remove(branchDataItem.chunkCoordinate);
            }
            ArrayList<ChunkCoordinate> allCoordsForBo3 = this.AllBranchesBranchDataByName.get(branchDataItem.branch.bo3Name);
            allCoordsForBo3.remove(branchDataItem.chunkCoordinate);
            if (allCoordsForBo3.size() == 0) {
                this.AllBranchesBranchDataByName.remove(branchDataItem.branch.bo3Name);
            }
            for (Map.Entry<String, Integer> entry : ((BO4)branchDataItem.branch.getObject()).getSettings().branchFrequencyGroups.entrySet()) {
                HashMap<ChunkCoordinate, ArrayList<Integer>> branchesByGroup = this.AllBranchesBranchDataByGroup.get(entry.getKey());
                ArrayList<Integer> frequenciesForGroupAtChunk = branchesByGroup.get(branchDataItem.chunkCoordinate);
                frequenciesForGroupAtChunk.remove(entry.getValue());
                if (frequenciesForGroupAtChunk.size() != 0) continue;
                branchesByGroup.remove(branchDataItem.chunkCoordinate);
                if (branchesByGroup.size() != 0) continue;
                this.AllBranchesBranchDataByGroup.remove(entry.getKey());
            }
        }
    }

    private Stack<BranchDataItem> checkSpawnRequirementsAndCollisions(BranchDataItem branchData, boolean minimumSize, LocalWorld world) {
        Stack<BranchDataItem> collidingObjects = new Stack<BranchDataItem>();
        boolean bFound = false;
        BO4CustomStructureCoordinate coordObject = branchData.branch;
        if (!minimumSize) {
            int smoothRadius;
            if (!bFound && (world.isInsidePregeneratedRegion(branchData.chunkCoordinate) || world.getStructureCache().bo4StructureCache.containsKey(branchData.chunkCoordinate))) {
                collidingObjects.add(null);
                bFound = true;
            }
            if (!bFound && !this.isStructureAtSpawn) {
                LocalBiome biome3 = world.getBiome(branchData.chunkCoordinate.getChunkX() * 16 + 8, branchData.chunkCoordinate.getChunkZ() * 16 + 7);
                BiomeConfig biomeConfig3 = biome3.getBiomeConfig();
                ArrayList<String> structuresToSpawn = new ArrayList<String>();
                for (CustomStructureGen res : biomeConfig3.getCustomStructures()) {
                    for (String bo3Name : res.objectNames) {
                        structuresToSpawn.add(bo3Name);
                    }
                }
                ArrayList<String> biomeStructures = structuresToSpawn;
                boolean canSpawnHere = false;
                for (String structureToSpawn : biomeStructures) {
                    if (!structureToSpawn.equals(this.start.getObject().getName())) continue;
                    canSpawnHere = true;
                    break;
                }
                if (!canSpawnHere) {
                    collidingObjects.add(null);
                    bFound = true;
                }
            }
            if ((smoothRadius = ((BO4)this.start.getObject()).getSettings().smoothRadius) == -1 || ((BO4)((CustomStructureCoordinate)coordObject).getObject()).getSettings().smoothRadius == -1) {
                smoothRadius = 0;
            }
            if (smoothRadius > 0 && !bFound) {
                double radiusInChunks = Math.ceil((double)smoothRadius / 16.0);
                int x = branchData.chunkCoordinate.getChunkX() - (int)radiusInChunks;
                while ((double)x <= (double)branchData.chunkCoordinate.getChunkX() + radiusInChunks) {
                    int z = branchData.chunkCoordinate.getChunkZ() - (int)radiusInChunks;
                    while ((double)z <= (double)branchData.chunkCoordinate.getChunkZ() + radiusInChunks) {
                        double distanceBetweenStructures = Math.floor((float)Math.sqrt(Math.pow(branchData.chunkCoordinate.getChunkX() - x, 2.0) + Math.pow(branchData.chunkCoordinate.getChunkZ() - z, 2.0)));
                        if (distanceBetweenStructures <= radiusInChunks) {
                            if (world.isInsidePregeneratedRegion(ChunkCoordinate.fromChunkCoords(x, z)) || world.getStructureCache().bo4StructureCache.containsKey(ChunkCoordinate.fromChunkCoords(x, z))) {
                                collidingObjects.add(null);
                                bFound = true;
                                break;
                            }
                            if (!this.isStructureAtSpawn) {
                                LocalBiome biome3 = world.getBiome(x * 16 + 8, z * 16 + 7);
                                BiomeConfig biomeConfig3 = biome3.getBiomeConfig();
                                ArrayList<String> structuresToSpawn = new ArrayList<String>();
                                for (CustomStructureGen res : biomeConfig3.getCustomStructures()) {
                                    for (String bo3Name : res.objectNames) {
                                        structuresToSpawn.add(bo3Name);
                                    }
                                }
                                ArrayList<String> biomeStructures = structuresToSpawn;
                                boolean canSpawnHere = false;
                                for (String structureToSpawn : biomeStructures) {
                                    if (!structureToSpawn.equals(this.start.getObject().getName())) continue;
                                    canSpawnHere = true;
                                    break;
                                }
                                if (!canSpawnHere) {
                                    collidingObjects.add(null);
                                    bFound = true;
                                    break;
                                }
                            }
                        }
                        ++z;
                    }
                    if (bFound) break;
                    ++x;
                }
            }
        }
        if (!bFound && !((BO4)((CustomStructureCoordinate)coordObject).getObject()).getSettings().canOverride) {
            Stack<BranchDataItem> existingBranches = new Stack<BranchDataItem>();
            if (this.AllBranchesBranchDataByChunk.containsKey(branchData.chunkCoordinate)) {
                for (BranchDataItem existingBranchData : this.AllBranchesBranchDataByChunk.get(branchData.chunkCoordinate)) {
                    if (!branchData.chunkCoordinate.equals(existingBranchData.chunkCoordinate) || ((BO4)existingBranchData.branch.getObject()).getSettings().canOverride) continue;
                    existingBranches.add(existingBranchData);
                }
            }
            if (existingBranches.size() > 0) {
                for (BranchDataItem cachedBranch : existingBranches) {
                    if (!this.checkCollision(coordObject, cachedBranch.branch)) continue;
                    collidingObjects.add(cachedBranch);
                }
            }
        }
        return collidingObjects;
    }

    private boolean checkCollision(CustomStructureCoordinate branchData1Branch, CustomStructureCoordinate branchData2Branch) {
        if (!((BO4)branchData1Branch.getObject()).isCollidable() || !((BO4)branchData2Branch.getObject()).isCollidable()) {
            return false;
        }
        BO4CustomStructureCoordinate branchData1BranchMinRotated = BO4CustomStructureCoordinate.getRotatedBO3CoordsJustified(((BO4)branchData1Branch.getObject()).getSettings().getminX(), ((BO4)branchData1Branch.getObject()).getSettings().getminY(), ((BO4)branchData1Branch.getObject()).getSettings().getminZ(), branchData1Branch.getRotation());
        BO4CustomStructureCoordinate branchData1BranchMaxRotated = BO4CustomStructureCoordinate.getRotatedBO3CoordsJustified(((BO4)branchData1Branch.getObject()).getSettings().getmaxX(), ((BO4)branchData1Branch.getObject()).getSettings().getmaxY(), ((BO4)branchData1Branch.getObject()).getSettings().getmaxZ(), branchData1Branch.getRotation());
        int startX = branchData1Branch.getX() + Math.min(branchData1BranchMinRotated.getX(), branchData1BranchMaxRotated.getX());
        int endX = branchData1Branch.getX() + Math.max(branchData1BranchMinRotated.getX(), branchData1BranchMaxRotated.getX());
        int startY = branchData1Branch.getY() + Math.min(branchData1BranchMinRotated.getY(), branchData1BranchMaxRotated.getY());
        int endY = branchData1Branch.getY() + Math.max(branchData1BranchMinRotated.getY(), branchData1BranchMaxRotated.getY());
        int startZ = branchData1Branch.getZ() + Math.min(branchData1BranchMinRotated.getZ(), branchData1BranchMaxRotated.getZ());
        int endZ = branchData1Branch.getZ() + Math.max(branchData1BranchMinRotated.getZ(), branchData1BranchMaxRotated.getZ());
        BO4CustomStructureCoordinate branchData2BranchMinRotated = BO4CustomStructureCoordinate.getRotatedBO3CoordsJustified(((BO4)branchData2Branch.getObject()).getSettings().getminX(), ((BO4)branchData2Branch.getObject()).getSettings().getminY(), ((BO4)branchData2Branch.getObject()).getSettings().getminZ(), branchData2Branch.getRotation());
        BO4CustomStructureCoordinate branchData2BranchMaxRotated = BO4CustomStructureCoordinate.getRotatedBO3CoordsJustified(((BO4)branchData2Branch.getObject()).getSettings().getmaxX(), ((BO4)branchData2Branch.getObject()).getSettings().getmaxY(), ((BO4)branchData2Branch.getObject()).getSettings().getmaxZ(), branchData2Branch.getRotation());
        int cachedBranchStartX = branchData2Branch.getX() + Math.min(branchData2BranchMinRotated.getX(), branchData2BranchMaxRotated.getX());
        int cachedBranchEndX = branchData2Branch.getX() + Math.max(branchData2BranchMinRotated.getX(), branchData2BranchMaxRotated.getX());
        int cachedBranchStartY = branchData2Branch.getY() + Math.min(branchData2BranchMinRotated.getY(), branchData2BranchMaxRotated.getY());
        int cachedBranchEndY = branchData2Branch.getY() + Math.max(branchData2BranchMinRotated.getY(), branchData2BranchMaxRotated.getY());
        int cachedBranchStartZ = branchData2Branch.getZ() + Math.min(branchData2BranchMinRotated.getZ(), branchData2BranchMaxRotated.getZ());
        int cachedBranchEndZ = branchData2Branch.getZ() + Math.max(branchData2BranchMinRotated.getZ(), branchData2BranchMaxRotated.getZ());
        return cachedBranchEndX >= startX && cachedBranchStartX <= endX && cachedBranchEndY >= startY && cachedBranchStartY <= endY && cachedBranchEndZ >= startZ && cachedBranchStartZ <= endZ;
    }

    private void addToChunk(BO4CustomStructureCoordinate coordObject, ChunkCoordinate chunkCoordinate, Map<ChunkCoordinate, Stack<BO4CustomStructureCoordinate>> objectList) {
        Stack<BO4CustomStructureCoordinate> objectsInChunk = objectList.get(chunkCoordinate);
        if (objectsInChunk == null) {
            objectsInChunk = new Stack();
        }
        objectsInChunk.add(coordObject);
        objectList.put(chunkCoordinate, objectsInChunk);
    }

    public boolean spawnForChunkOTGPlus(ChunkCoordinate chunkCoordinate, LocalWorld world) {
        if (this.start == null) {
            throw new RuntimeException();
        }
        if (!this.objectsToSpawn.containsKey(chunkCoordinate) && !this.smoothingAreasToSpawn.containsKey(chunkCoordinate)) {
            return true;
        }
        this.doStartChunkBlockChecks(world);
        Stack<BO4CustomStructureCoordinate> objectsInChunk = this.objectsToSpawn.get(chunkCoordinate);
        if (objectsInChunk != null) {
            BO4Config objectConfig;
            BO4 bo3;
            BO4Config config = ((BO4)this.start.getObject()).getSettings();
            LocalBiome biome = null;
            BiomeConfig biomeConfig = null;
            if (config.spawnUnderWater && (biomeConfig = (biome = world.getBiome(this.start.getX() + 8, this.start.getZ() + 7)).getBiomeConfig()) == null) {
                throw new RuntimeException();
            }
            for (BO4CustomStructureCoordinate coordObject : objectsInChunk) {
                if (coordObject.isSpawned) continue;
                bo3 = (BO4)coordObject.getObject();
                if (bo3 == null) {
                    throw new RuntimeException();
                }
                objectConfig = bo3.getSettings();
                if (coordObject.spawnWithChecks(chunkCoordinate, world, this.random, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceAbove : objectConfig.replaceAbove, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceBelow : objectConfig.replaceBelow, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithBiomeBlocks : objectConfig.replaceWithBiomeBlocks, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithSurfaceBlock : objectConfig.replaceWithSurfaceBlock, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithGroundBlock : objectConfig.replaceWithGroundBlock, config.spawnUnderWater, !config.spawnUnderWater ? -1 : (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax), false, true)) continue;
                OTG.log(LogMarker.FATAL, "Could not spawn chunk " + coordObject.bo3Name + " for structure " + this.start.getObject().getName(), new Object[0]);
                throw new RuntimeException("Could not spawn chunk " + coordObject.bo3Name + " for structure " + this.start.getObject().getName());
            }
            if (!this.smoothingAreaManager.spawnSmoothAreas(chunkCoordinate, this.smoothingAreasToSpawn, this.start, world)) {
                BO4.OriginalTopBlocks.clear();
                return false;
            }
            for (BO4CustomStructureCoordinate coordObject : objectsInChunk) {
                if (coordObject.isSpawned) continue;
                bo3 = (BO4)coordObject.getObject();
                if (bo3 == null) {
                    throw new RuntimeException();
                }
                objectConfig = bo3.getSettings();
                if (!coordObject.spawnWithChecks(chunkCoordinate, world, this.random, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceAbove : objectConfig.replaceAbove, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceBelow : objectConfig.replaceBelow, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithBiomeBlocks : objectConfig.replaceWithBiomeBlocks, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithSurfaceBlock : objectConfig.replaceWithSurfaceBlock, config.overrideChildSettings && objectConfig.overrideChildSettings ? config.replaceWithGroundBlock : objectConfig.replaceWithGroundBlock, config.spawnUnderWater, !config.spawnUnderWater ? -1 : (biomeConfig.useWorldWaterLevel ? world.getConfigs().getWorldConfig().waterLevelMax : biomeConfig.waterLevelMax), false, false)) {
                    OTG.log(LogMarker.FATAL, "Could not spawn chunk " + coordObject.bo3Name + " for structure " + this.start.getObject().getName(), new Object[0]);
                    throw new RuntimeException("Could not spawn chunk " + coordObject.bo3Name + " for structure " + this.start.getObject().getName());
                }
                this.modDataManager.spawnModData(objectConfig.getModData(), coordObject, chunkCoordinate);
                this.spawnerManager.spawnSpawners(objectConfig.getSpawnerData(), coordObject, chunkCoordinate);
                this.particlesManager.spawnParticles(objectConfig.getParticleData(), coordObject, chunkCoordinate);
                this.entitiesManager.spawnEntities(world, objectConfig.getEntityData(), coordObject, chunkCoordinate);
                coordObject.isSpawned = true;
            }
        } else if (!this.smoothingAreaManager.spawnSmoothAreas(chunkCoordinate, this.smoothingAreasToSpawn, this.start, world)) {
            BO4.OriginalTopBlocks.clear();
            return false;
        }
        this.objectsToSpawn.remove(chunkCoordinate);
        this.smoothingAreasToSpawn.remove(chunkCoordinate);
        BO4.OriginalTopBlocks.clear();
        return true;
    }
}

