/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.customobjects.structures.bo4;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.customobjects.CustomObject;
import com.pg85.otg.customobjects.bo3.StructurePartSpawnHeight;
import com.pg85.otg.customobjects.bo4.BO4;
import com.pg85.otg.customobjects.structures.CustomStructure;
import com.pg85.otg.customobjects.structures.CustomStructureCoordinate;
import com.pg85.otg.customobjects.structures.StructuredCustomObject;
import com.pg85.otg.logging.LogMarker;
import com.pg85.otg.util.ChunkCoordinate;
import com.pg85.otg.util.bo3.Rotation;
import java.util.Random;

public class BO4CustomStructureCoordinate
extends CustomStructureCoordinate {
    boolean isSpawned;
    int branchDepth;
    boolean isRequiredBranch;
    boolean isWeightedBranch;
    String branchGroup;

    public BO4CustomStructureCoordinate(LocalWorld world, StructuredCustomObject object, String customObjectName, Rotation rotation, int x, short y, int z, int branchDepth, boolean isRequiredBranch, boolean isWeightedBranch, String branchGroup) {
        String string = this.worldName = world != null ? world.getName() : null;
        String string2 = object != null ? object.getName() : (this.bo3Name = customObjectName != null && customObjectName.length() > 0 ? customObjectName : null);
        if (object != null && ((BO4)object).getSettings() == null) {
            throw new RuntimeException();
        }
        this.object = object;
        this.rotation = rotation != null ? rotation : Rotation.NORTH;
        this.x = x;
        this.y = y;
        if (y >= 256) {
            throw new RuntimeException();
        }
        this.z = z;
        this.branchDepth = branchDepth;
        this.isRequiredBranch = isRequiredBranch;
        this.isWeightedBranch = isWeightedBranch;
        this.branchGroup = branchGroup;
    }

    @Override
    public StructuredCustomObject getObject() {
        if (this.object == null) {
            if (this.worldName == null) {
                throw new RuntimeException();
            }
            CustomObject object = OTG.getCustomObjectManager().getGlobalObjects().getObjectByName(this.bo3Name, this.worldName);
            if (object == null || !(object instanceof StructuredCustomObject)) {
                object = null;
                if (OTG.getPluginConfig().spawnLog) {
                    OTG.log(LogMarker.WARN, "Could not find BO2/BO3 " + this.bo3Name + " in GlobalObjects or WorldObjects directory.", new Object[0]);
                }
            }
            String string = this.bo3Name = object != null ? object.getName() : this.bo3Name;
            if (object != null && ((BO4)object).getSettings() == null) {
                throw new RuntimeException();
            }
            this.object = (StructuredCustomObject)object;
            return this.object;
        }
        return this.object;
    }

    public StructuredCustomObject getStructuredObject() {
        return this.getObject();
    }

    @Override
    public int hashCode() {
        return this.x >> 13 ^ this.y >> 7 ^ this.z ^ this.object.getName().hashCode() ^ this.rotation.toString().hashCode();
    }

    @Override
    public boolean equals(Object otherObject) {
        if (otherObject == null) {
            return false;
        }
        if (!(otherObject instanceof BO4CustomStructureCoordinate)) {
            return false;
        }
        BO4CustomStructureCoordinate otherCoord = (BO4CustomStructureCoordinate)otherObject;
        if (otherCoord.x != this.x) {
            return false;
        }
        if (otherCoord.y != this.y) {
            return false;
        }
        if (otherCoord.z != this.z) {
            return false;
        }
        if (!otherCoord.rotation.equals((Object)this.rotation)) {
            return false;
        }
        return otherCoord.object.getName().equals(this.object.getName());
    }

    public static BO4CustomStructureCoordinate getRotatedBO3CoordsJustified(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        if (rotations < 0) {
            throw new RuntimeException();
        }
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = 15 - rotatedZ;
            newZ = rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, rotatedX, (short)y, rotatedZ, 0, false, false, null);
    }

    public static BO4CustomStructureCoordinate getRotatedCoord(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        if (rotations < 0) {
            throw new RuntimeException();
        }
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = rotatedZ;
            newZ = -rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, rotatedX, (short)y, rotatedZ, 0, false, false, null);
    }

    @Override
    public boolean spawnWithChecks(CustomStructure structure, LocalWorld world, StructurePartSpawnHeight height, Random random) {
        return false;
    }

    boolean spawnWithChecks(ChunkCoordinate chunkCoord, LocalWorld world, Random random, String replaceAbove, String replaceBelow, boolean replaceWithBiomeBlocks, String replaceWithSurfaceBlock, String replaceWithGroundBlock, boolean spawnUnderWater, int waterLevel, boolean isStructureAtSpawn, boolean doReplaceAboveBelowOnly) {
        if (this.getObject() == null) {
            throw new RuntimeException();
        }
        if (this.getObject() instanceof BO4) {
            return ((BO4)this.getObject()).trySpawnAt(world, random, this.rotation, chunkCoord, this.x, this.y, this.z, replaceAbove, replaceBelow, replaceWithBiomeBlocks, replaceWithSurfaceBlock, replaceWithGroundBlock, spawnUnderWater, waterLevel, isStructureAtSpawn, doReplaceAboveBelowOnly);
        }
        throw new RuntimeException();
    }

    public static BO4CustomStructureCoordinate getRotatedBO3Coords(int x, int y, int z, Rotation newRotation) {
        int rotations = newRotation.getRotationId();
        if (rotations < 0) {
            throw new RuntimeException();
        }
        int rotatedX = x;
        int rotatedZ = z;
        int newX = x;
        int newZ = z;
        for (int i = 0; i < rotations; ++i) {
            newX = rotatedZ - 1;
            newZ = -rotatedX;
            rotatedX = newX;
            rotatedZ = newZ;
        }
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, rotatedX, (short)y, rotatedZ, 0, false, false, null);
    }

    static BO4CustomStructureCoordinate getRotatedSmoothingCoords(int x, short y, int z, Rotation newRotation) {
        int newX = 0;
        short newY = 0;
        int newZ = 0;
        int rotations = 0;
        if (newRotation == Rotation.WEST) {
            rotations = 1;
        } else if (newRotation == Rotation.SOUTH) {
            rotations = 2;
        } else if (newRotation == Rotation.EAST) {
            rotations = 3;
        }
        if (rotations == 0) {
            newX = x;
            newZ = z;
        }
        if (rotations == 1) {
            newX = z;
            newZ = -x + 15;
        }
        if (rotations == 2) {
            newX = -x + 15;
            newZ = -z + 15;
        }
        if (rotations == 3) {
            newX = -z + 15;
            newZ = x;
        }
        newY = y;
        return new BO4CustomStructureCoordinate(null, null, null, newRotation, newX, newY, newZ, 0, false, false, null);
    }
}

