/*
 * Decompiled with CFR 0.152.
 */
package com.pg85.otg.forge.events;

import com.pg85.otg.OTG;
import com.pg85.otg.common.LocalBiome;
import com.pg85.otg.common.LocalMaterialData;
import com.pg85.otg.common.LocalWorld;
import com.pg85.otg.configuration.biome.BiomeConfig;
import com.pg85.otg.exception.BiomeNotFoundException;
import com.pg85.otg.forge.ForgeEngine;
import com.pg85.otg.forge.ForgeWorld;
import com.pg85.otg.generator.resource.SaplingGen;
import com.pg85.otg.generator.resource.SaplingType;
import com.pg85.otg.util.minecraft.defaults.DefaultMaterial;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.terraingen.SaplingGrowTreeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class SaplingListener {
    @SubscribeEvent
    public void onSaplingGrow(SaplingGrowTreeEvent event) {
        World world = event.getWorld();
        ForgeWorld localWorld = ((ForgeEngine)OTG.getEngine()).getWorld(world);
        BlockPos blockPos = event.getPos();
        if (localWorld == null) {
            return;
        }
        SaplingGrower saplingGrower = new SaplingGrower(localWorld, blockPos);
        if (saplingGrower.saplingType == null) {
            return;
        }
        SaplingGen saplingGen = this.getSaplingGen(localWorld, saplingGrower.saplingType, saplingGrower.blockPos);
        if (saplingGen == null) {
            return;
        }
        event.setResult(Event.Result.DENY);
        IBlockState air = Blocks.field_150350_a.func_176223_P();
        boolean wideTrunk = saplingGrower.saplingType.requiresFourSaplings();
        if (wideTrunk) {
            world.func_175656_a(saplingGrower.blockPos, air);
            world.func_175656_a(saplingGrower.blockPos.func_177982_a(1, 0, 0), air);
            world.func_175656_a(saplingGrower.blockPos.func_177982_a(0, 0, 1), air);
            world.func_175656_a(saplingGrower.blockPos.func_177982_a(1, 0, 1), air);
        } else {
            world.func_175656_a(saplingGrower.blockPos, air);
        }
        boolean saplingGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!saplingGen.growSapling(localWorld, random, wideTrunk, saplingGrower.blockPos.func_177958_n(), saplingGrower.blockPos.func_177956_o(), saplingGrower.blockPos.func_177952_p())) continue;
            saplingGrown = true;
            break;
        }
        if (!saplingGrown) {
            int saplingX = saplingGrower.blockPos.func_177958_n();
            int saplingY = saplingGrower.blockPos.func_177956_o();
            int saplingZ = saplingGrower.blockPos.func_177952_p();
            if (saplingGrower.saplingType.requiresFourSaplings()) {
                localWorld.setBlock(saplingX, saplingY, saplingZ, saplingGrower.material, null, false);
                localWorld.setBlock(saplingX + 1, saplingY, saplingZ, saplingGrower.material, null, false);
                localWorld.setBlock(saplingX, saplingY, saplingZ + 1, saplingGrower.material, null, false);
                localWorld.setBlock(saplingX + 1, saplingY, saplingZ + 1, saplingGrower.material, null, false);
            } else {
                localWorld.setBlock(saplingX, saplingY, saplingZ, saplingGrower.material, null, false);
            }
        }
    }

    @SubscribeEvent
    public void onBonemealUse(BonemealEvent event) {
        ForgeWorld localWorld = ((ForgeEngine)OTG.getEngine()).getWorld(event.getWorld());
        if (localWorld == null) {
            return;
        }
        SaplingGen gen = null;
        if (event.getBlock() == Blocks.field_150419_aX) {
            gen = this.getSaplingGen(localWorld, SaplingType.RedMushroom, event.getPos());
        } else if (event.getBlock() == Blocks.field_150420_aW) {
            gen = this.getSaplingGen(localWorld, SaplingType.BrownMushroom, event.getPos());
        }
        if (gen == null) {
            return;
        }
        event.setResult(Event.Result.ALLOW);
        event.getWorld().func_175656_a(event.getPos(), Blocks.field_150350_a.func_176223_P());
        boolean mushroomGrown = false;
        Random random = new Random();
        for (int i = 0; i < 10; ++i) {
            if (!gen.growSapling(localWorld, random, false, event.getPos().func_177958_n(), event.getPos().func_177956_o(), event.getPos().func_177952_p())) continue;
            mushroomGrown = true;
            break;
        }
        if (!mushroomGrown) {
            event.getWorld().func_175656_a(event.getPos(), event.getBlock());
        }
    }

    private SaplingGen getSaplingGen(LocalWorld world, SaplingType type, BlockPos blockPos) {
        LocalBiome biome = null;
        BiomeConfig biomeConfig = null;
        SaplingGen gen = null;
        try {
            biome = world.getBiome(blockPos.func_177958_n(), blockPos.func_177952_p());
            biomeConfig = biome.getBiomeConfig();
            gen = biomeConfig.getSaplingGen(type);
        }
        catch (BiomeNotFoundException e) {
            return null;
        }
        if (gen == null && biomeConfig.inheritSaplingResource && biomeConfig.replaceToBiomeName != null && biomeConfig.replaceToBiomeName.trim().length() > 0) {
            biome = world.getBiomeByNameOrNull(biomeConfig.replaceToBiomeName);
            if (biome != null) {
                gen = biome.getBiomeConfig().getSaplingGen(type);
            } else {
                return null;
            }
        }
        return gen;
    }

    private static class SaplingGrower {
        private final LocalWorld world;
        private final LocalMaterialData material;
        private final SaplingType saplingType;
        private BlockPos blockPos;

        private SaplingGrower(LocalWorld world, BlockPos blockPos) {
            this.world = world;
            this.material = world.getMaterial(blockPos.func_177958_n(), blockPos.func_177956_o(), blockPos.func_177952_p(), true);
            this.blockPos = blockPos;
            if (this.material == null || !this.material.isMaterial(DefaultMaterial.SAPLING)) {
                this.saplingType = null;
                return;
            }
            SaplingType bigSaplingType = this.getBigSaplingType(this.material.getBlockData());
            if (bigSaplingType != null && this.findFourSaplings()) {
                this.saplingType = bigSaplingType;
                return;
            }
            this.saplingType = this.getSmallSaplingType(this.material.getBlockData());
        }

        private boolean findFourSaplings() {
            int x = this.blockPos.func_177958_n();
            int y = this.blockPos.func_177956_o();
            int z = this.blockPos.func_177952_p();
            for (int treeOffsetX = 0; treeOffsetX >= -1; --treeOffsetX) {
                for (int treeOffsetZ = 0; treeOffsetZ >= -1; --treeOffsetZ) {
                    if (!this.isSameSapling(this.material, this.world.getMaterial(x + treeOffsetX, y, z + treeOffsetZ, false)) || !this.isSameSapling(this.material, this.world.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ, false)) || !this.isSameSapling(this.material, this.world.getMaterial(x + treeOffsetX, y, z + treeOffsetZ + 1, false)) || !this.isSameSapling(this.material, this.world.getMaterial(x + treeOffsetX + 1, y, z + treeOffsetZ + 1, false))) continue;
                    this.blockPos = this.blockPos.func_177982_a(treeOffsetX, 0, treeOffsetZ);
                    return true;
                }
            }
            return false;
        }

        private boolean isSameSapling(LocalMaterialData sapling1, LocalMaterialData sapling2) {
            return sapling1 != null && sapling2 != null && sapling1.isMaterial(DefaultMaterial.SAPLING) && sapling2.isMaterial(DefaultMaterial.SAPLING) && sapling1.getBlockData() % 8 == sapling2.getBlockData() % 8;
        }

        private SaplingType getSmallSaplingType(int data) {
            switch (data % 8) {
                case 0: {
                    return SaplingType.Oak;
                }
                case 1: {
                    return SaplingType.Redwood;
                }
                case 2: {
                    return SaplingType.Birch;
                }
                case 3: {
                    return SaplingType.SmallJungle;
                }
                case 4: {
                    return SaplingType.Acacia;
                }
            }
            return null;
        }

        private SaplingType getBigSaplingType(int data) {
            switch (data % 8) {
                case 1: {
                    return SaplingType.HugeRedwood;
                }
                case 3: {
                    return SaplingType.BigJungle;
                }
                case 5: {
                    return SaplingType.DarkOak;
                }
            }
            return null;
        }
    }
}

